/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.security.webservices.ClientPipeCloser;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.security.auth.callback.CallbackHandler;
import javax.swing.SwingUtilities;
import javax.transaction.TransactionManager;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.glassfish.appclient.client.acc.AppClientContainerBuilder;
import org.glassfish.appclient.client.acc.AppClientContainerSecurityHelper;
import org.glassfish.appclient.client.acc.AppClientInfo;
import org.glassfish.appclient.client.acc.Launchable;
import org.glassfish.appclient.client.acc.ProviderContainerContractInfoImpl;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.client.acc.config.AuthRealm;
import org.glassfish.appclient.client.acc.config.ClientCredential;
import org.glassfish.appclient.client.acc.config.MessageSecurityConfig;
import org.glassfish.appclient.client.acc.config.Property;
import org.glassfish.appclient.client.acc.config.TargetServer;
import org.glassfish.persistence.jpa.PersistenceUnitLoader;
import org.glassfish.persistence.jpa.ProviderContainerContractInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PerLookup;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class AppClientContainer {
    public static final String APPCLIENT_RETAIN_TEMP_FILES_PROPERTYNAME = "com.sun.aas.jws.retainTempFiles";
    private static Logger logger = LogDomains.getLogger(AppClientContainer.class, (String)"javax.enterprise.system.container.appclient");
    @Inject
    private AppClientContainerSecurityHelper secHelper;
    @Inject
    private InjectionManager injectionManager;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private ComponentEnvManager componentEnvManager;
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    private Habitat habitat;
    private Builder builder;
    private Cleanup cleanup = null;
    private State state = State.INSTANTIATED;
    private ClientMainClassSetting clientMainClassSetting = null;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private Collection<EntityManagerFactory> emfs = null;
    private Launchable client = null;
    private CallbackHandler callerSuppliedCallbackHandler = null;
    private String componentId = null;

    public static Builder newBuilder(TargetServer[] targetServers) {
        return new AppClientContainerBuilder(targetServers);
    }

    public void startClient(String[] args) throws Exception {
        this.launch(args);
    }

    void prepareSecurity(TargetServer[] targetServers, List<MessageSecurityConfig> msgSecConfigs, Properties containerProperties, ClientCredential clientCredential, CallbackHandler callerSuppliedCallbackHandler, ClassLoader classLoader) throws InstantiationException, IllegalAccessException, InjectionException, ClassNotFoundException, IOException, SAXParseException {
        this.secHelper.init(targetServers, msgSecConfigs, containerProperties, clientCredential, callerSuppliedCallbackHandler, classLoader, this.client.getDescriptor(classLoader));
    }

    void setCallbackHandler(CallbackHandler callerSuppliedCallbackHandler) {
        this.callerSuppliedCallbackHandler = callerSuppliedCallbackHandler;
    }

    void setBuilder(Builder builder) {
        this.builder = builder;
    }

    public void prepare(Instrumentation inst) throws NamingException, IOException, InstantiationException, IllegalAccessException, InjectionException, ClassNotFoundException, SAXParseException, NoSuchMethodException {
        this.completePreparation(inst);
    }

    void setClient(Launchable client) throws ClassNotFoundException {
        this.client = client;
        this.clientMainClassSetting = ClientMainClassSetting.set(client.getMainClass());
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, this.classLoader);
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void completePreparation(Instrumentation inst) throws NamingException, IOException, InstantiationException, IllegalAccessException, InjectionException, ClassNotFoundException, SAXParseException, NoSuchMethodException {
        if (this.state != State.INSTANTIATED) {
            throw new IllegalStateException();
        }
        this.client.validateDescriptor();
        ApplicationClientDescriptor desc = this.client.getDescriptor(this.classLoader);
        this.componentId = this.componentEnvManager.bindToComponentNamespace((JndiNameEnvironment)desc);
        this.cleanup = Cleanup.arrangeForShutdownCleanup(logger, this.habitat);
        Collection referencedPUs = desc.findReferencedPUs();
        if (referencedPUs != null && !referencedPUs.isEmpty()) {
            ProviderContainerContractInfoImpl pcci = new ProviderContainerContractInfoImpl((ACCClassLoader)this.getClassLoader(), inst, this.client.getAnchorDir(), this.connectorRuntime);
            for (PersistenceUnitDescriptor puDesc : referencedPUs) {
                PersistenceUnitLoader pul = new PersistenceUnitLoader(puDesc, (ProviderContainerContractInfo)pcci);
                desc.addEntityManagerFactory(puDesc.getName(), pul.getEMF());
            }
            this.cleanup.setEMFs(pcci.emfs());
        }
        this.cleanup.setConnectorRuntime(this.connectorRuntime);
        AppClientContainer.prepareURLStreamHandling();
        System.setProperty("javax.xml.ws.spi.Provider", "com.sun.enterprise.webservice.spi.ProviderImpl");
        this.getMainMethod();
        this.state = State.PREPARED;
    }

    public void launch(String[] args) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException, SAXParseException, InjectionException {
        if (this.state != State.PREPARED) {
            throw new IllegalStateException();
        }
        Method mainMethod = this.getMainMethod();
        Object[] params = new Object[]{args};
        if (logger.isLoggable(Level.FINE)) {
            this.dumpLoaderURLs();
        }
        mainMethod.invoke(null, params);
        this.state = State.STARTED;
        this.cleanupWhenSafe();
    }

    private boolean isEDTRunning() {
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        logger.fine("Checking for EDT thread...");
        for (Map.Entry<Thread, StackTraceElement[]> entry : threads.entrySet()) {
            StackTraceElement last;
            logger.fine("  " + entry.getKey().toString());
            StackTraceElement[] frames = entry.getValue();
            if (frames.length > 0 && (last = frames[frames.length - 1]).getClassName().equals("java.awt.EventDispatchThread") && last.getMethodName().equals("run")) {
                logger.fine("Thread " + entry.getKey().toString() + " seems to be the EDT");
                return true;
            }
            logger.fine("Did not recognize any thread as the EDT");
        }
        return false;
    }

    private void cleanupWhenSafe() {
        if (this.isEDTRunning()) {
            final AtomicReference edt = new AtomicReference();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        edt.set(Thread.currentThread());
                    }
                });
                ((Thread)edt.get()).join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stop();
    }

    private void dumpLoaderURLs() {
        String sep = System.getProperty("line.separator");
        ClassLoader ldr = Thread.currentThread().getContextClassLoader();
        if (ldr instanceof ACCClassLoader) {
            ACCClassLoader loader = (ACCClassLoader)ldr;
            URL[] urls = loader.getURLs();
            StringBuilder sb = new StringBuilder("Class loader URLs:");
            for (URL url : urls) {
                sb.append("  ").append(url.toExternalForm()).append(sep);
            }
            sb.append(sep);
            logger.fine(sb.toString());
        }
    }

    private Method getMainMethod() throws NoSuchMethodException, ClassNotFoundException, IOException, SAXParseException, InjectionException {
        Method result = null;
        result = ClientMainClassSetting.getClientMainClass(this.classLoader, this.injectionManager, this.invocationManager, this.componentId, this, this.client.getDescriptor(this.classLoader)).getMethod("main", String[].class);
        int modifiers = result.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
            String err = MessageFormat.format(logger.getResourceBundle().getString("appclient.notPublicOrNotStatic"), null);
            throw new NoSuchMethodException(err);
        }
        if (!result.getReturnType().equals(Void.TYPE)) {
            String err = MessageFormat.format(logger.getResourceBundle().getString("appclient.notVoid"), null);
            throw new NoSuchMethodException(err);
        }
        return result;
    }

    public void stop() {
        if (this.state != State.STARTED) {
            throw new IllegalStateException();
        }
        this.cleanup.start();
        this.state = State.STOPPED;
    }

    public void setClientMainClassName(String clientMainClassName) throws ClassNotFoundException {
        this.clientMainClassSetting = ClientMainClassSetting.set(clientMainClassName);
    }

    void setClientMainClass(Class clientMainClass) {
        this.clientMainClassSetting = ClientMainClassSetting.set(clientMainClass);
    }

    private static void prepareURLStreamHandling() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new DirContextURLStreamHandlerFactory());
                return null;
            }
        });
    }

    void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Builder {
        public AppClientContainer newContainer(URI var1) throws Exception, UserError;

        public AppClientContainer newContainer(URI var1, CallbackHandler var2, String var3, String var4) throws Exception, UserError;

        public AppClientContainer newContainer(Class var1) throws Exception, UserError;

        public TargetServer[] getTargetServers();

        public Builder addMessageSecurityConfig(MessageSecurityConfig var1);

        public List<MessageSecurityConfig> getMessageSecurityConfig();

        public Builder authRealm(String var1);

        public AuthRealm getAuthRealm();

        public Builder clientCredentials(String var1, char[] var2);

        public ClientCredential getClientCredential();

        public Builder clientCredentials(String var1, char[] var2, String var3);

        public Builder containerProperties(Properties var1);

        public Builder containerProperties(List<Property> var1);

        public Properties getContainerProperties();

        public Builder logger(Logger var1);

        public Logger getLogger();

        public Builder sendPassword(boolean var1);

        public boolean getSendPassword();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cleanup
    implements Runnable {
        private AppClientInfo appClientInfo = null;
        private boolean cleanedUp = false;
        private InjectionManager injectionMgr = null;
        private ApplicationClientDescriptor appClient = null;
        private Class cls = null;
        private final Logger logger;
        private Thread cleanupThread = null;
        private Collection<EntityManagerFactory> emfs = null;
        private final Habitat habitat;
        private ConnectorRuntime connectorRuntime;

        static Cleanup arrangeForShutdownCleanup(Logger logger, Habitat habitat) {
            Cleanup cu = new Cleanup(logger, habitat);
            cu.enable();
            return cu;
        }

        private Cleanup(Logger logger, Habitat habitat) {
            this.logger = logger;
            this.habitat = habitat;
        }

        void setAppClientInfo(AppClientInfo info) {
            this.appClientInfo = info;
        }

        void setInjectionManager(InjectionManager injMgr, Class cls, ApplicationClientDescriptor appDesc) {
            this.injectionMgr = injMgr;
            this.cls = cls;
            this.appClient = appDesc;
        }

        void setEMFs(Collection<EntityManagerFactory> emfs) {
            this.emfs = emfs;
        }

        void setConnectorRuntime(ConnectorRuntime connectorRuntime) {
            this.connectorRuntime = connectorRuntime;
        }

        void enable() {
            this.cleanupThread = new Thread((Runnable)this, "Cleanup");
            Runtime.getRuntime().addShutdownHook(this.cleanupThread);
        }

        void disable() {
            Runtime.getRuntime().removeShutdownHook(this.cleanupThread);
        }

        void start() {
            this.disable();
            this.run();
        }

        @Override
        public void run() {
            this.logger.fine("Clean-up starting");
            this.cleanUp();
            this.logger.fine("Clean-up complete");
        }

        void cleanUp() {
            if (!this.cleanedUp) {
                this.cleanupEMFs();
                this.cleanupInfo();
                this.cleanupInjection();
                this.cleanupServiceReferences();
                this.cleanupTransactions();
                this.cleanupConnectorRuntime();
                this.cleanedUp = true;
            }
        }

        private void cleanupEMFs() {
            try {
                if (this.emfs != null) {
                    for (EntityManagerFactory emf : this.emfs) {
                        emf.close();
                    }
                    this.emfs.clear();
                    this.emfs = null;
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "cleanupEMFs", t);
            }
        }

        private void cleanupInfo() {
            try {
                if (this.appClientInfo != null) {
                    this.appClientInfo.close();
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "cleanupInfo", t);
            }
        }

        private void cleanupInjection() {
            try {
                if (this.injectionMgr != null) {
                    this.injectionMgr.invokeClassPreDestroy(this.cls, (JndiNameEnvironment)this.appClient);
                    this.injectionMgr = null;
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "cleanupInjection", t);
            }
        }

        private void cleanupServiceReferences() {
            try {
                if (this.appClient != null && this.appClient.getServiceReferenceDescriptors() != null) {
                    for (Object desc : this.appClient.getServiceReferenceDescriptors()) {
                        ClientPipeCloser.getInstance().cleanupClientPipe((ServiceReferenceDescriptor)desc);
                    }
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "cleanupServiceReferences", t);
            }
        }

        private void cleanupTransactions() {
            try {
                Inhabitant inhabitant = this.habitat.getInhabitantByType(TransactionManager.class);
                if (inhabitant != null && inhabitant.isInstantiated()) {
                    TransactionManager txmgr = (TransactionManager)inhabitant.get();
                    txmgr.rollback();
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "cleanupTransactions", t);
            }
        }

        private void cleanupConnectorRuntime() {
            try {
                this.connectorRuntime.cleanUpResourcesAndShutdownAllActiveRAs();
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "cleanupConnectorRuntime", t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ClientMainClassSetting {
        BY_NAME,
        BY_CLASS;

        protected static String clientMainClassName;
        protected static Class clientMainClass;
        protected static boolean isInjected;

        static ClientMainClassSetting set(String name) {
            clientMainClassName = name;
            clientMainClass = null;
            return BY_NAME;
        }

        static ClientMainClassSetting set(Class cl) {
            clientMainClass = cl;
            clientMainClassName = null;
            return BY_CLASS;
        }

        static Class getClientMainClass(ClassLoader loader, InjectionManager injectionManager, InvocationManager invocationManager, String componentId, AppClientContainer container, ApplicationClientDescriptor acDesc) throws ClassNotFoundException, InjectionException {
            if (clientMainClass == null) {
                if (clientMainClassName == null) {
                    throw new IllegalStateException("neither client main class nor its class name has been set");
                }
                clientMainClass = Class.forName(clientMainClassName, true, loader);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Loaded client main class " + clientMainClassName);
                }
            }
            ComponentInvocation ci = new ComponentInvocation(componentId, ComponentInvocation.ComponentInvocationType.APP_CLIENT_INVOCATION, (Object)container);
            invocationManager.preInvoke(ci);
            if (!isInjected) {
                injectionManager.injectClass(clientMainClass, (JndiNameEnvironment)acDesc);
                isInjected = true;
            }
            return clientMainClass;
        }

        static {
            isInjected = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INSTANTIATED,
        PREPARED,
        STARTED,
        STOPPED;

    }
}

