/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bootstrap.BeanDeployer;
import org.jboss.webbeans.literal.BindingTypeLiteral;
import org.jboss.webbeans.literal.InterceptorBindingTypeLiteral;
import org.jboss.webbeans.literal.ScopeTypeLiteral;
import org.jboss.webbeans.metadata.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeforeBeanDiscoveryImpl
implements BeforeBeanDiscovery {
    private final TypeStore typeStore;
    private final BeanDeployer beanDeployer;

    public BeforeBeanDiscoveryImpl(BeanManagerImpl manager, BeanDeployer beanDeployer) {
        this.typeStore = manager.getServices().get(TypeStore.class);
        this.beanDeployer = beanDeployer;
    }

    @Override
    public void addBindingType(Class<? extends Annotation> bindingType) {
        this.typeStore.add(bindingType, new BindingTypeLiteral());
    }

    @Override
    public void addInterceptorBindingType(Class<? extends Annotation> bindingType) {
        this.typeStore.add(bindingType, new InterceptorBindingTypeLiteral());
    }

    @Override
    public void addScopeType(Class<? extends Annotation> scopeType, boolean normal, boolean passivating) {
        this.typeStore.add(scopeType, new ScopeTypeLiteral(normal, passivating));
    }

    @Override
    public void addStereotype(Class<? extends Annotation> stereotype, Annotation ... stereotypeDef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAnnotatedType(AnnotatedType<?> type) {
        this.beanDeployer.addClass(type);
    }
}

