/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.jsf;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Conversation;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpSession;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.context.ConversationContext;
import org.jboss.webbeans.context.SessionContext;
import org.jboss.webbeans.conversation.ConversationManager;
import org.jboss.webbeans.jsf.PhaseHelper;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.ConversationBeanStore;
import org.jboss.webbeans.servlet.HttpSessionManager;

public class WebBeansPhaseListener
implements PhaseListener {
    private static LogProvider log = Logging.getLogProvider(WebBeansPhaseListener.class);

    public void beforePhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            this.beforeRestoreView();
        }
    }

    public void afterPhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) {
            this.afterRenderResponse();
        } else if (phaseEvent.getFacesContext().getResponseComplete()) {
            this.afterResponseComplete(phaseEvent.getPhaseId());
        }
    }

    private void beforeRestoreView() {
        log.trace("Initiating the session and conversation before the Restore View phase");
        this.initiateSessionAndConversation();
    }

    private void afterRenderResponse() {
        if (SessionContext.instance().isActive()) {
            log.trace("Cleaning up the conversation after the Render Response phase");
            CurrentManager.rootManager().getInstanceByType(ConversationManager.class, new Annotation[0]).cleanupConversation();
            ConversationContext.instance().setActive(false);
        } else {
            log.trace("Skipping conversation cleanup after the Render Response phase because session has been terminated.");
        }
    }

    private void afterResponseComplete(PhaseId phaseId) {
        if (SessionContext.instance().isActive()) {
            log.trace("Cleaning up the conversation after the " + phaseId + " phase as the response has been marked complete");
            CurrentManager.rootManager().getInstanceByType(ConversationManager.class, new Annotation[0]).cleanupConversation();
        } else {
            log.trace("Skipping conversation cleanup after the response has been marked complete because the session has been terminated.");
        }
    }

    private void initiateSessionAndConversation() {
        HttpSession session = PhaseHelper.getHttpSession();
        CurrentManager.rootManager().getInstanceByType(HttpSessionManager.class, new Annotation[0]).setSession(session);
        CurrentManager.rootManager().getInstanceByType(ConversationManager.class, new Annotation[0]).beginOrRestoreConversation(PhaseHelper.getConversationId());
        String cid = CurrentManager.rootManager().getInstanceByType(Conversation.class, new Annotation[0]).getId();
        ConversationContext.instance().setBeanStore(new ConversationBeanStore(session, cid));
        ConversationContext.instance().setActive(true);
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

