/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import com.sun.java.help.impl.HeaderParser;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;

public final class XmlReader
extends Reader {
    private boolean closed;
    private InputStreamReader in;
    private InputStream raw;
    private byte[] buffer;
    private boolean isASCII;
    private boolean isLatin1;
    private int offset;
    private int length;
    private char nextChar;
    private int switchover;
    private String encodingAssigned;
    private static boolean debug = false;

    public static Reader createReader(URLConnection uc) throws IOException {
        String encoding = XmlReader.getEncodingFromContentType(uc.getContentType());
        if (encoding == null) {
            return XmlReader.createReader(uc.getInputStream());
        }
        return XmlReader.createReader(uc.getInputStream(), encoding);
    }

    private static String getEncodingFromContentType(String type) {
        XmlReader.debug("type=" + type);
        if (type == null) {
            return null;
        }
        int parm = type.indexOf(";");
        if (parm > -1) {
            String paramList = type.substring(parm);
            if ((type = type.substring(0, parm).trim()).compareTo("text/xml") == 0) {
                return XmlReader.getCharsetFromContentTypeParameters(paramList);
            }
        }
        return null;
    }

    private static String getCharsetFromContentTypeParameters(String paramlist) {
        String charset = null;
        try {
            int semi = paramlist.indexOf(59);
            if (semi > -1 && semi < paramlist.length() - 1) {
                paramlist = paramlist.substring(semi + 1);
            }
            if (paramlist.length() > 0) {
                HeaderParser hdrParser = new HeaderParser(paramlist);
                charset = hdrParser.findValue("charset");
                return charset;
            }
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
        }
        catch (Exception e) {
            System.err.println("Indexer.getCharsetFromContentTypeParameters failed on: " + paramlist);
            e.printStackTrace();
        }
        return charset;
    }

    public static Reader createReader(InputStream in) throws IOException {
        return new XmlReader(in);
    }

    public static Reader createReader(InputStream in, String encoding) throws IOException {
        if (encoding == null) {
            return new XmlReader(in);
        }
        if ("UTF-16".equalsIgnoreCase(encoding) || "ISO-106460-UCS-2".equalsIgnoreCase(encoding)) {
            encoding = "Unicode";
        } else {
            if ("UTF-8".equalsIgnoreCase(encoding)) {
                return new XmlReader(in, "UTF-8");
            }
            if ("EUC-JP".equalsIgnoreCase(encoding)) {
                encoding = "EUCJIS";
            } else {
                if (XmlReader.isAsciiName(encoding)) {
                    return new XmlReader(in, "US-ASCII");
                }
                if (XmlReader.isLatinName(encoding)) {
                    return new XmlReader(in, "ISO-8859-1");
                }
            }
        }
        return new InputStreamReader(in, encoding);
    }

    private XmlReader(InputStream in, String encoding) throws IOException {
        this.buffer = new byte[8192];
        this.length = 0;
        this.raw = in;
        if ("US-ASCII".equals(encoding)) {
            this.setASCII();
        } else if ("ISO-8859-1".equals(encoding)) {
            this.setLatin1();
        } else {
            if (!"UTF-8".equals(encoding)) {
                throw new UnsupportedEncodingException(encoding);
            }
            this.setUTF8();
        }
    }

    private static boolean isAsciiName(String encoding) {
        return "US-ASCII".equalsIgnoreCase(encoding) || "ASCII".equalsIgnoreCase(encoding);
    }

    private static boolean isLatinName(String encoding) {
        return "ISO-8859-1".equalsIgnoreCase(encoding) || "Latin1".equalsIgnoreCase(encoding) || "8859_1".equalsIgnoreCase(encoding);
    }

    private void setASCII() {
        this.encodingAssigned = "US-ASCII";
        this.isASCII = true;
        this.isLatin1 = false;
        this.offset = 0;
    }

    private void setLatin1() {
        this.encodingAssigned = "ISO-8859-1";
        this.isASCII = false;
        this.isLatin1 = true;
        this.offset = 0;
    }

    private void setUTF8() {
        this.encodingAssigned = "UTF-8";
        this.isASCII = false;
        this.isLatin1 = false;
        this.offset = 0;
    }

    public String getEncoding() {
        return this.encodingAssigned;
    }

    private XmlReader(InputStream in) throws IOException {
        this.raw = in;
        this.switchover = -1;
        this.buffer = new byte[8192];
        this.length = 0;
        this.offset = 0;
        this.isLatin1 = true;
        int c = this.read();
        block0 : switch (c) {
            case 0: {
                c = this.read();
                if (c == 60 && (c = this.read()) == 0 && (c = this.read()) == 63) {
                    this.setSwitchover("UnicodeBig");
                    return;
                }
                throw new UnsupportedEncodingException("UCS-4 (?)");
            }
            case 60: {
                c = this.read();
                switch (c) {
                    default: {
                        break block0;
                    }
                    case 0: {
                        if (this.read() == 63 && this.read() == 0) {
                            this.setSwitchover("UnicodeLittle");
                            return;
                        }
                        throw new UnsupportedEncodingException("UCS-4");
                    }
                    case 63: 
                }
                if (this.read() != 120 || this.read() != 109 || this.read() != 108 || this.read() != 32) break;
                this.guessEncoding();
                return;
            }
            case 254: {
                c = this.read();
                if (c != 255) break;
                this.setSwitchover("UnicodeBig");
                this.offset = 2;
                return;
            }
            case 255: {
                c = this.read();
                if (c != 254) break;
                this.setSwitchover("UnicodeLittle");
                this.offset = 2;
                return;
            }
            case -1: {
                return;
            }
        }
        this.setUTF8();
    }

    private void setSwitchover(String encoding) throws IOException {
        this.switchover = this.offset;
        this.encodingAssigned = encoding;
        this.offset = 0;
    }

    private void doSwitchover() throws IOException {
        if (this.offset != this.switchover) {
            throw new InternalError();
        }
        this.in = new InputStreamReader(this.raw, this.encodingAssigned);
        this.buffer = null;
        this.switchover = -1;
    }

    private void guessEncoding() throws IOException {
        StringBuffer buf = new StringBuffer();
        StringBuffer keyBuf = null;
        String key = null;
        boolean sawEq = false;
        char quoteChar = '\u0000';
        boolean sawQuestion = false;
        block0: for (int i = 0; i < 100; ++i) {
            int c = this.read();
            if (c == -1) {
                this.setASCII();
                return;
            }
            if (Character.isWhitespace((char)c)) continue;
            if (c == 63) {
                sawQuestion = true;
            } else if (sawQuestion) {
                if (c == 62) break;
                sawQuestion = false;
            }
            if (key == null || !sawEq) {
                if (keyBuf == null) {
                    if (Character.isWhitespace((char)c)) continue;
                    keyBuf = buf;
                    buf.setLength(0);
                    buf.append((char)c);
                    sawEq = false;
                    continue;
                }
                if (Character.isWhitespace((char)c)) {
                    key = keyBuf.toString();
                    continue;
                }
                if (c == 61) {
                    if (key == null) {
                        key = keyBuf.toString();
                    }
                    sawEq = true;
                    keyBuf = null;
                    quoteChar = '\u0000';
                    continue;
                }
                keyBuf.append((char)c);
                continue;
            }
            if (Character.isWhitespace((char)c)) continue;
            if (c == 34 || c == 39) {
                if (quoteChar == '\u0000') {
                    quoteChar = (char)c;
                    buf.setLength(0);
                    continue;
                }
                if (c == quoteChar) {
                    if ("encoding".equals(key)) {
                        String encoding = buf.toString();
                        for (i = 0; i < encoding.length(); ++i) {
                            c = encoding.charAt(i);
                            if (!(c >= 65 && c <= 90 || c >= 97 && c <= 122) && (i <= 0 || c != 45 && (c < 48 || c > 57) && c != 46 && c != 95)) break block0;
                        }
                        if (XmlReader.isAsciiName(encoding)) {
                            this.setASCII();
                            return;
                        }
                        if (XmlReader.isLatinName(encoding)) {
                            this.setLatin1();
                            return;
                        }
                        if ("UTF-8".equalsIgnoreCase(encoding) || "UTF8".equalsIgnoreCase(encoding)) break;
                        if ("EUC-JP".equalsIgnoreCase(encoding)) {
                            encoding = "EUCJIS";
                        }
                        this.setSwitchover(encoding);
                        return;
                    }
                    key = null;
                    continue;
                }
            }
            buf.append((char)c);
        }
        this.setUTF8();
    }

    private char utf8char() throws IOException {
        int character;
        int off;
        char retval;
        block12: {
            if (this.nextChar != '\u0000') {
                char retval2 = this.nextChar;
                this.nextChar = '\u0000';
                return retval2;
            }
            retval = (char)this.buffer[this.offset];
            if ((retval & 0x80) == 0) {
                ++this.offset;
                return retval;
            }
            if (this.isASCII) {
                throw new CharConversionException("Not US-ASCII:  0x" + Integer.toHexString(retval & 0xFF));
            }
            off = this.offset;
            try {
                if ((this.buffer[off] & 0xE0) == 192) {
                    character = (this.buffer[off++] & 0x1F) << 6;
                    retval = (char)(character += this.buffer[off++] & 0x3F);
                    character = 0;
                    break block12;
                }
                if ((this.buffer[off] & 0xF0) == 224) {
                    character = (this.buffer[off++] & 0xF) << 12;
                    character += (this.buffer[off++] & 0x3F) << 6;
                    retval = (char)(character += this.buffer[off++] & 0x3F);
                    character = 0;
                    break block12;
                }
                if ((this.buffer[off] & 0xF8) == 240) {
                    character = (this.buffer[off++] & 7) << 18;
                    character += (this.buffer[off++] & 0x3F) << 12;
                    character += (this.buffer[off++] & 0x3F) << 6;
                    character += this.buffer[off++] & 0x3F;
                    retval = (char)(55296 + ((character -= 65536) >> 10));
                    character = 56320 + (character & 0x3FF);
                    break block12;
                }
                throw new CharConversionException("Illegal XML character 0x" + Integer.toHexString(this.buffer[this.offset] & 0xFF));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                retval = '\u0000';
                character = 0;
            }
        }
        if (off > this.length) {
            System.arraycopy(this.buffer, this.offset, this.buffer, 0, this.length - this.offset);
            this.length -= this.offset;
            this.offset = 0;
            off = this.raw.read(this.buffer, this.length, this.buffer.length - this.length);
            if (off < 0) {
                throw new CharConversionException("Partial UTF-8 char");
            }
            this.length += off;
            return this.utf8char();
        }
        ++this.offset;
        while (this.offset < off) {
            if ((this.buffer[this.offset] & 0xC0) != 128) {
                throw new CharConversionException("Malformed UTF-8 char");
            }
            ++this.offset;
        }
        this.nextChar = (char)character;
        return retval;
    }

    public int read(char[] buf, int off, int len) throws IOException {
        int i;
        if (this.closed) {
            return -1;
        }
        if (this.switchover > 0 && this.offset == this.switchover) {
            this.doSwitchover();
        }
        if (this.in != null) {
            return this.in.read(buf, off, len);
        }
        if (this.offset >= this.length) {
            this.offset = 0;
            this.length = this.raw.read(this.buffer, 0, this.buffer.length);
        }
        if (this.length <= 0) {
            return -1;
        }
        if (this.encodingAssigned == null || this.isLatin1) {
            for (i = 0; i < len && this.offset < this.length; ++i) {
                buf[off++] = (char)(this.buffer[this.offset++] & 0xFF);
            }
        } else {
            for (i = 0; i < len && this.offset < this.length; ++i) {
                buf[off++] = this.utf8char();
            }
        }
        return i;
    }

    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.switchover > 0 && this.offset == this.switchover) {
            this.doSwitchover();
        }
        if (this.in != null) {
            return this.in.read();
        }
        if (this.offset >= this.length) {
            if (this.encodingAssigned == null) {
                if (this.length == this.buffer.length) {
                    throw new InternalError("too much peekahead");
                }
                int len = this.raw.read(this.buffer, this.offset, 1);
                if (len <= 0) {
                    return -1;
                }
                this.length += len;
            } else {
                this.offset = 0;
                this.length = this.raw.read(this.buffer, 0, this.buffer.length);
                if (this.length <= 0) {
                    return -1;
                }
            }
        }
        if (this.isLatin1 || this.encodingAssigned == null) {
            return this.buffer[this.offset++] & 0xFF;
        }
        return this.utf8char();
    }

    public boolean markSupported() {
        return this.in != null && this.in.markSupported();
    }

    public void mark(int value) throws IOException {
        if (this.in != null) {
            this.in.mark(value);
        }
    }

    public void reset() throws IOException {
        if (this.in != null) {
            this.in.reset();
        }
    }

    public long skip(long value) throws IOException {
        if (value < 0L) {
            return 0L;
        }
        if (this.in != null) {
            return this.in.skip(value);
        }
        long avail = this.length - this.offset;
        if (avail >= value) {
            this.offset += (int)value;
            return value;
        }
        this.offset = (int)((long)this.offset + avail);
        return avail + this.raw.skip(value - avail);
    }

    public boolean ready() throws IOException {
        if (this.in != null) {
            return this.in.ready();
        }
        return this.length > this.offset || this.raw.available() != 0;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.in != null) {
            this.in.close();
        } else {
            this.raw.close();
        }
        this.closed = true;
    }

    private static void debug(String str) {
        if (debug) {
            System.out.println("XmlReader: " + str);
        }
    }
}

