/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.RangeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="jsp-mon", group="monitoring")
@ManagedObject
@Description(value="Web Container JSP Statistics")
public class JspStatsProvider {
    private static final Logger logger = LogDomains.getLogger(JspStatsProvider.class, (String)"javax.enterprise.system.container.web");
    private static final String ACTIVE_JSPS_LOADED_DESCRIPTION = "Number of active JSP pages";
    private static final String TOTAL_JSPS_LOADED_DESCRIPTION = "Total number of JSP pages ever loaded";
    private String moduleName;
    private String vsName;
    private RangeStatisticImpl activeJspsLoadedCount;
    private CountStatisticImpl totalJspsLoadedCount;

    public JspStatsProvider(String moduleName, String vsName) {
        this.moduleName = moduleName;
        this.vsName = vsName;
        long curTime = System.currentTimeMillis();
        this.activeJspsLoadedCount = new RangeStatisticImpl(0L, 0L, 0L, "ActiveJspsLoaded", "count", ACTIVE_JSPS_LOADED_DESCRIPTION, curTime, curTime);
        this.totalJspsLoadedCount = new CountStatisticImpl("TotalJspsLoaded", "count", TOTAL_JSPS_LOADED_DESCRIPTION);
    }

    @ManagedAttribute(id="activejspsloadedcount")
    @Description(value="Number of active JSP pages")
    public RangeStatistic getActiveJspsLoaded() {
        return this.activeJspsLoadedCount;
    }

    @ManagedAttribute(id="totaljspsloadedcount")
    @Description(value="Total number of JSP pages ever loaded")
    public CountStatistic getTotalJspsLoaded() {
        return this.totalJspsLoadedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:web:jsp:jspLoadedEvent")
    public void jspLoadedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (this.isValidEvent(appName, hostName)) {
            RangeStatisticImpl rangeStatisticImpl = this.activeJspsLoadedCount;
            synchronized (rangeStatisticImpl) {
                this.activeJspsLoadedCount.setCurrent(this.activeJspsLoadedCount.getCurrent() + 1L);
                if (this.activeJspsLoadedCount.getCurrent() > this.activeJspsLoadedCount.getHighWaterMark()) {
                    this.activeJspsLoadedCount.setHighWaterMark(this.activeJspsLoadedCount.getCurrent());
                }
            }
            this.totalJspsLoadedCount.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:web:jsp:jspDestroyedEvent")
    public void jspDestroyedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (this.isValidEvent(appName, hostName)) {
            RangeStatisticImpl rangeStatisticImpl = this.activeJspsLoadedCount;
            synchronized (rangeStatisticImpl) {
                this.activeJspsLoadedCount.setCurrent(this.activeJspsLoadedCount.getCurrent() - 1L);
            }
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.vsName;
    }

    private boolean isValidEvent(String mName, String hostName) {
        if (this.moduleName == null || this.vsName == null) {
            return true;
        }
        return this.moduleName.equals(mName) && this.vsName.equals(hostName);
    }

    private void resetStats() {
        this.activeJspsLoadedCount.setCurrent(0L);
        this.activeJspsLoadedCount.setLowWaterMark(0L);
        this.activeJspsLoadedCount.setHighWaterMark(0L);
        this.totalJspsLoadedCount.setCount(0L);
    }
}

