/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.flashlight.client.ProbeClientInvoker;
import org.glassfish.flashlight.client.ProbeClientInvokerFactory;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.impl.client.BtraceClientGenerator;
import org.glassfish.flashlight.impl.client.FlashLightBTracePrintWriter;
import org.glassfish.flashlight.impl.client.NullStream;
import org.glassfish.flashlight.impl.client.ProbeClientMethodHandleImpl;
import org.glassfish.flashlight.impl.core.FlashlightProbeProvider;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class FlashlightProbeClientMediator
implements ProbeClientMediator,
PostConstruct {
    private static final ProbeRegistry probeRegistry = ProbeRegistry.getInstance();
    private static boolean btraceAgentAttached = false;
    private static final Logger logger = LogDomains.getLogger(FlashlightProbeClientMediator.class, (String)"javax.enterprise.system.tools.monitor");
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(FlashlightProbeClientMediator.class);
    private static final PrintWriter fpw = new FlashLightBTracePrintWriter((OutputStream)new NullStream(), logger);
    private static FlashlightProbeClientMediator _me = new FlashlightProbeClientMediator();
    private static AtomicBoolean agentInitialized = new AtomicBoolean(false);
    private AtomicInteger clientIdGenerator = new AtomicInteger(0);
    private static ConcurrentHashMap<Integer, Object> clients = new ConcurrentHashMap();
    Instrumentation inst = null;

    @Override
    public void postConstruct() {
        _me = this;
    }

    public static FlashlightProbeClientMediator getInstance() {
        return _me;
    }

    public static Object getClient(int id) {
        return clients.get(id);
    }

    public static void setAgentInitialized(boolean b) {
        agentInitialized.set(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAgentAttached() {
        if (agentInitialized.get()) {
            return btraceAgentAttached;
        }
        AtomicBoolean atomicBoolean = agentInitialized;
        synchronized (atomicBoolean) {
            if (agentInitialized.get()) {
                return btraceAgentAttached;
            }
            try {
                agentInitialized.getClass().getClassLoader();
                ClassLoader scl = ClassLoader.getSystemClassLoader();
                Class<?> agentMainClass = scl.loadClass("com.sun.btrace.agent.Main");
                btraceAgentAttached = true;
            }
            catch (Exception e) {
                btraceAgentAttached = false;
            }
            agentInitialized.set(true);
        }
        return btraceAgentAttached;
    }

    @Override
    public Collection<ProbeClientMethodHandle> registerListener(Object listener) {
        ArrayList<ProbeClientMethodHandle> pcms = new ArrayList<ProbeClientMethodHandle>();
        ArrayList<FlashlightProbe> probesRequiringClassTransformation = new ArrayList<FlashlightProbe>();
        this.registerJavaListener(listener, pcms, probesRequiringClassTransformation);
        this.transformProbes(listener, probesRequiringClassTransformation);
        return pcms;
    }

    public Collection<ProbeClientMethodHandle> registerDTraceListener(FlashlightProbeProvider propro) {
        ArrayList<ProbeClientMethodHandle> pcms = new ArrayList<ProbeClientMethodHandle>();
        ArrayList<FlashlightProbe> probesRequiringClassTransformation = new ArrayList<FlashlightProbe>();
        Object listener = this.registerDTraceListener(propro, pcms, probesRequiringClassTransformation);
        this.transformProbes(listener, probesRequiringClassTransformation);
        return pcms;
    }

    private void registerJavaListener(Object listener, List<ProbeClientMethodHandle> pcms, List<FlashlightProbe> probesRequiringClassTransformation) {
        List<MethodProbe> methodProbePairs = this.handleListenerAnnotations(listener.getClass());
        if (methodProbePairs.isEmpty()) {
            return;
        }
        for (MethodProbe mp : methodProbePairs) {
            FlashlightProbe probe = mp.probe;
            ProbeClientInvoker invoker = ProbeClientInvokerFactory.createInvoker(listener, mp.method, probe);
            ProbeClientMethodHandleImpl hi = new ProbeClientMethodHandleImpl(invoker.getId(), invoker, probe);
            pcms.add(hi);
            if (!probe.addInvoker(invoker)) continue;
            probesRequiringClassTransformation.add(probe);
        }
    }

    private Object registerDTraceListener(FlashlightProbeProvider propro, List<ProbeClientMethodHandle> pcms, List<FlashlightProbe> probesRequiringClassTransformation) {
        Collection<FlashlightProbe> probes = propro.getProbes();
        Object listener = null;
        for (FlashlightProbe probe : probes) {
            ProbeClientInvoker invoker = ProbeClientInvokerFactory.createDTraceInvoker(probe);
            ProbeClientMethodHandleImpl hi = new ProbeClientMethodHandleImpl(invoker.getId(), invoker, probe);
            pcms.add(hi);
            if (probe.addInvoker(invoker)) {
                probesRequiringClassTransformation.add(probe);
            }
            if (listener != null) continue;
            listener = probe.getDTraceProviderImpl();
        }
        return listener;
    }

    @Override
    public void transformProbes(Object listener, List<FlashlightProbe> probes) {
        int clientID = this.clientIdGenerator.incrementAndGet();
        clients.put(clientID, listener);
        if (probes.isEmpty()) {
            return;
        }
        byte[] bArr = BtraceClientGenerator.generateBtraceClientClassData(clientID, probes);
        if (bArr == null) {
            String errStr = localStrings.getLocalString("btraceClientGeneratorError", "Internal Error: BtraceClientGenerator.generateBtraceClientClassData() returned null");
            throw new RuntimeException(errStr);
        }
        if (FlashlightProbeClientMediator.isAgentAttached()) {
            this.submit2BTrace(bArr);
        }
    }

    private List<MethodProbe> handleListenerAnnotations(Class listenerClass) {
        LinkedList<MethodProbe> mp = new LinkedList<MethodProbe>();
        for (Method method : listenerClass.getMethods()) {
            Annotation[] anns = method.getAnnotations();
            ProbeListener probeAnn = method.getAnnotation(ProbeListener.class);
            if (probeAnn == null) continue;
            String probeString = probeAnn.value();
            FlashlightProbe probe = probeRegistry.getProbe(probeString);
            if (probe == null) {
                String errStr = localStrings.getLocalString("probeNotRegistered", "Probe is not registered: {0}", new Object[]{probeString});
                throw new RuntimeException(errStr);
            }
            mp.add(new MethodProbe(method, probe));
        }
        return mp;
    }

    private void submit2BTrace(byte[] bArr) {
        try {
            this.getClass().getClassLoader();
            ClassLoader scl = ClassLoader.getSystemClassLoader();
            Class<?> agentMainClass = scl.loadClass("com.sun.btrace.agent.Main");
            Class[] params = new Class[]{new byte[0].getClass(), PrintWriter.class};
            Method mthd = agentMainClass.getMethod("handleFlashLightClient", params);
            mthd.invoke(null, bArr, fpw);
        }
        catch (Exception e) {
            throw new RuntimeException("BTrace Error");
        }
    }

    private static class MethodProbe {
        Method method;
        FlashlightProbe probe;

        MethodProbe(Method m, FlashlightProbe p) {
            this.method = m;
            this.probe = p;
        }
    }
}

