/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.stereotype.Stereotype;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.interceptor.InterceptorBinding;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.log.Log;
import org.jboss.weld.log.Logging;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.collections.Arrays2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeModel<T extends Annotation>
extends AnnotationModel<T> {
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = Arrays2.asSet(Stereotype.class);
    private static final Log log = Logging.getLog(StereotypeModel.class);
    private boolean policy;
    private Annotation defaultScopeType;
    private boolean beanNameDefaulted;
    private Set<Annotation> interceptorBindings;
    private Set<Annotation> inheritedSterotypes;
    private Set<Annotation> metaAnnotations;

    public StereotypeModel(Class<T> sterotype, ClassTransformer transformer) {
        super(sterotype, transformer);
        this.initPolicy();
        this.initDefaultScopeType();
        this.initBeanNameDefaulted();
        this.initInterceptorBindings();
        this.initInheritedStereotypes();
        this.checkBindings();
        this.metaAnnotations = this.getAnnotatedAnnotation().getAnnotations();
    }

    private void checkBindings() {
        Set<Annotation> bindings = this.getAnnotatedAnnotation().getMetaAnnotations(Qualifier.class);
        if (bindings.size() > 0) {
            for (Annotation annotation : bindings) {
                if (annotation.annotationType().equals(Named.class)) continue;
                throw new DefinitionException("Cannot declare binding types on a stereotype " + this.getAnnotatedAnnotation());
            }
        }
    }

    private void initInterceptorBindings() {
        this.interceptorBindings = this.getAnnotatedAnnotation().getMetaAnnotations(InterceptorBinding.class);
    }

    private void initInheritedStereotypes() {
        this.inheritedSterotypes = this.getAnnotatedAnnotation().getMetaAnnotations(Stereotype.class);
    }

    private void initBeanNameDefaulted() {
        if (this.getAnnotatedAnnotation().isAnnotationPresent(Named.class)) {
            if (!"".equals(this.getAnnotatedAnnotation().getAnnotation(Named.class).value())) {
                throw new DefinitionException("Cannot specify a value for a @Named stereotype " + this.getAnnotatedAnnotation());
            }
            this.beanNameDefaulted = true;
        }
    }

    private void initDefaultScopeType() {
        HashSet<Annotation> scopeTypes = new HashSet<Annotation>();
        scopeTypes.addAll(this.getAnnotatedAnnotation().getMetaAnnotations(Scope.class));
        scopeTypes.addAll(this.getAnnotatedAnnotation().getMetaAnnotations(NormalScope.class));
        if (scopeTypes.size() > 1) {
            throw new DefinitionException("At most one scope type may be specified for " + this.getAnnotatedAnnotation());
        }
        if (scopeTypes.size() == 1) {
            this.defaultScopeType = (Annotation)scopeTypes.iterator().next();
        }
    }

    private void initPolicy() {
        if (this.getAnnotatedAnnotation().isAnnotationPresent(Alternative.class)) {
            this.policy = true;
        }
    }

    @Override
    protected void initValid() {
        super.initValid();
        if (!this.getAnnotatedAnnotation().isAnnotationPresent(Target.class)) {
            this.valid = false;
            log.debug((Object)"#0 is missing @Target annotation.", this.getAnnotatedAnnotation());
        } else if (!(Arrays2.unorderedEquals((Object[])this.getAnnotatedAnnotation().getAnnotation(Target.class).value(), new Object[]{ElementType.METHOD, ElementType.FIELD, ElementType.TYPE}) || Arrays2.unorderedEquals((Object[])this.getAnnotatedAnnotation().getAnnotation(Target.class).value(), new Object[]{ElementType.TYPE}) || Arrays2.unorderedEquals((Object[])this.getAnnotatedAnnotation().getAnnotation(Target.class).value(), new Object[]{ElementType.METHOD}) || Arrays2.unorderedEquals((Object[])this.getAnnotatedAnnotation().getAnnotation(Target.class).value(), new Object[]{ElementType.FIELD}) || Arrays2.unorderedEquals((Object[])this.getAnnotatedAnnotation().getAnnotation(Target.class).value(), new Object[]{ElementType.METHOD, ElementType.TYPE}))) {
            this.valid = false;
            log.debug((Object)"#0 is has incorrect @Target annotation. Should be @Target(METHOD, FIELD, TYPE, PARAMETER), @Target(METHOD, TYPE), @Target(METHOD), @Target(TYPE) or @Target(FIELD).", this.getAnnotatedAnnotation());
        }
    }

    public Annotation getDefaultScopeType() {
        return this.defaultScopeType;
    }

    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindings;
    }

    public boolean isBeanNameDefaulted() {
        return this.beanNameDefaulted;
    }

    @Override
    protected Set<Class<? extends Annotation>> getMetaAnnotationTypes() {
        return META_ANNOTATIONS;
    }

    public boolean isPolicy() {
        return this.policy;
    }

    public Set<Annotation> getInheritedSterotypes() {
        return this.inheritedSterotypes;
    }

    public Set<Annotation> getMetaAnnotations() {
        return this.metaAnnotations;
    }
}

