/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.jmx;

import java.lang.management.ManagementFactory;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.info.Version;
import org.apache.derby.iapi.services.jmx.ManagementService;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.mbeans.ManagementMBean;
import org.apache.derby.mbeans.VersionMBean;
import org.apache.derby.security.SystemPermission;

public final class JMXManagementService
implements ManagementService,
ModuleControl {
    private MBeanServer mbeanServer;
    private Map<ObjectName, StandardMBean> registeredMbeans;
    private ObjectName myManagementBean;
    private MBeanServer myManagementServer;
    private String systemIdentifier;
    private static final SystemPermission CONTROL = new SystemPermission("jmx", "control");

    public synchronized void boot(boolean bl, Properties properties) throws StandardException {
        this.registeredMbeans = new HashMap<ObjectName, StandardMBean>();
        this.systemIdentifier = Monitor.getMonitor().getUUIDFactory().createUUID().toString();
        this.findServer();
        this.myManagementBean = (ObjectName)this.registerMBean(this, ManagementMBean.class, "type=Management");
        this.myManagementServer = this.mbeanServer;
        this.registerMBean(new Version(Monitor.getMonitor().getEngineVersion(), "engine"), VersionMBean.class, "type=Version,jar=derby.jar");
    }

    public synchronized void stop() {
        if (this.mbeanServer == null && this.myManagementBean != null) {
            this.mbeanServer = this.myManagementServer;
            this.unregisterMBean(this.myManagementBean);
            this.mbeanServer = null;
        }
        for (ObjectName objectName : new HashSet<ObjectName>(this.registeredMbeans.keySet())) {
            this.unregisterMBean(objectName);
        }
        this.mbeanServer = null;
        this.registeredMbeans = null;
        this.myManagementServer = null;
        this.systemIdentifier = null;
    }

    private synchronized void findServer() {
        try {
            this.mbeanServer = AccessController.doPrivileged(new PrivilegedAction<MBeanServer>(){

                @Override
                public MBeanServer run() {
                    return ManagementFactory.getPlatformMBeanServer();
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public synchronized Object registerMBean(Object object, final Class clazz, String string) throws StandardException {
        try {
            ObjectName objectName = new ObjectName("org.apache.derby:" + string + ",system=" + this.systemIdentifier);
            StandardMBean standardMBean = new StandardMBean(object, clazz){

                protected String getClassName(MBeanInfo mBeanInfo) {
                    return clazz.getName();
                }
            };
            this.registeredMbeans.put(objectName, standardMBean);
            if (this.mbeanServer != null) {
                this.jmxRegister(standardMBean, objectName);
            }
            return objectName;
        }
        catch (JMException jMException) {
            throw StandardException.plainWrapException(jMException);
        }
    }

    private void jmxRegister(final StandardMBean standardMBean, final ObjectName objectName) throws JMException {
        if (this.mbeanServer.isRegistered(objectName)) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws JMException {
                    JMXManagementService.this.mbeanServer.registerMBean(standardMBean, objectName);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (JMException)privilegedActionException.getException();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void unregisterMBean(Object object) {
        if (object == null) {
            return;
        }
        this.unregisterMBean((ObjectName)object);
    }

    private synchronized void unregisterMBean(ObjectName objectName) {
        if (this.registeredMbeans == null) {
            return;
        }
        if (this.registeredMbeans.remove(objectName) == null) {
            return;
        }
        if (this.mbeanServer == null) {
            return;
        }
        this.jmxUnregister(objectName);
    }

    private void jmxUnregister(final ObjectName objectName) {
        if (!this.mbeanServer.isRegistered(objectName)) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws JMException {
                    JMXManagementService.this.mbeanServer.unregisterMBean(objectName);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public synchronized boolean isManagementActive() {
        return this.mbeanServer != null;
    }

    public synchronized void startManagement() {
        if (this.registeredMbeans == null) {
            return;
        }
        this.checkJMXControl();
        if (this.isManagementActive()) {
            return;
        }
        this.findServer();
        if (this.mbeanServer == null) {
            return;
        }
        for (ObjectName objectName : this.registeredMbeans.keySet()) {
            if (objectName.equals(this.myManagementBean) && this.mbeanServer.isRegistered(this.myManagementBean)) continue;
            try {
                this.jmxRegister(this.registeredMbeans.get(objectName), objectName);
            }
            catch (JMException jMException) {}
        }
    }

    public synchronized void stopManagement() {
        if (this.registeredMbeans == null) {
            return;
        }
        this.checkJMXControl();
        if (this.isManagementActive()) {
            for (ObjectName objectName : this.registeredMbeans.keySet()) {
                if (objectName.equals(this.myManagementBean)) continue;
                this.jmxUnregister(objectName);
            }
            this.mbeanServer = null;
        }
    }

    private void checkJMXControl() {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(CONTROL);
            }
        }
        catch (AccessControlException accessControlException) {
            throw new SecurityException(accessControlException.getMessage());
        }
    }

    public synchronized String getSystemIdentifier() {
        return this.systemIdentifier;
    }
}

