/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.jruby.JRubyGrizzlyConfigImpl;
import com.sun.grizzly.jruby.Messages;
import com.sun.grizzly.jruby.rack.AbstractRackApplication;
import com.sun.grizzly.jruby.rack.ErrorApplication;
import com.sun.grizzly.jruby.rack.RackApplicationPool;
import com.sun.grizzly.jruby.rack.RackApplicationPoolFactory;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.buf.ByteChunk;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jruby.runtime.Constants;

public class RackGrizzlyAdapter
extends GrizzlyAdapter {
    private final Logger logger;
    private final int numThreads;
    private final boolean asyncExecution;
    final JRubyVersion jrubyVersion;
    private RackApplicationPool<AbstractRackApplication> pool;
    private ErrorApplication errorApp;
    public final JRubyGrizzlyConfigImpl config;
    private FutureTask<Boolean> jrubyStartUp;
    private static final String CSS = "H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}HR {color : #525D76;}";

    public RackGrizzlyAdapter(JRubyGrizzlyConfigImpl config, boolean asyncExecution) {
        super(config.appRoot());
        this.config = config;
        this.asyncExecution = asyncExecution;
        this.logger = config.getLogger();
        this.jrubyVersion = new JRubyVersion();
        this.logger.log(Level.INFO, Messages.format("jruby.version", this.jrubyVersion));
        this.numThreads = this.jrubyVersion.compare("1.1.5") < 0 ? 1 : Math.min(Runtime.getRuntime().availableProcessors(), config.runtimeConfig().getInitRuntime());
    }

    public boolean async() {
        return this.asyncExecution;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    private void startThread() {
        ExecutorService exec = Executors.newFixedThreadPool(1);
        this.jrubyStartUp = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return RackGrizzlyAdapter.this.startJRubyRuntime();
            }
        });
        exec.execute(this.jrubyStartUp);
    }

    public void start() {
        this.startThread();
    }

    private boolean startJRubyRuntime() {
        this.pool = RackApplicationPoolFactory.getRackApplocationPool(this);
        return true;
    }

    public void destroy() {
        if (this.errorApp != null) {
            this.errorApp.destroy();
        }
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    private byte[] getHtmlPage() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head>");
        sb.append("<style><!--");
        sb.append(CSS);
        sb.append("--></style> ");
        sb.append("</head><body>");
        sb.append("");
        sb.append("<h3>");
        sb.append("Server is busy loading the application... ");
        sb.append("</h3>");
        sb.append("<hr/>");
        sb.append("<span\n style=\"font-style: italic;\">Powered by GlassFish v3</span>");
        sb.append("</body></html>");
        return sb.toString().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest req, GrizzlyResponse res) {
        this.config.jrubyHttpProbeProvider.requestStartEvent(this.config.contextRoot(), req.getServerName(), req.getServerPort());
        if (!this.jrubyStartUp.isDone()) {
            res.setStatus(503);
            byte[] bytes = this.getHtmlPage();
            ByteChunk chunk = new ByteChunk();
            chunk.setBytes(bytes, 0, bytes.length);
            res.setContentLength(bytes.length);
            res.setContentType("text/html");
            String delta = System.getProperty("jruby.http.retry-after");
            if (delta == null) {
                delta = "3";
            }
            res.setHeader("Retry-After", delta);
            try {
                res.getResponse().sendHeaders();
                res.getResponse().doWrite(chunk);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            return;
        }
        AbstractRackApplication serviceApp = null;
        try {
            serviceApp = this.pool.getApp();
            if (serviceApp == null) {
                throw new IllegalStateException(Messages.format("jruby.runtime.notavailable", new Object[0]));
            }
            this.dispatchRequest(serviceApp, req, res);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (serviceApp != null) {
                this.pool.returnApp(serviceApp);
            }
            this.config.jrubyHttpProbeProvider.requestEndEvent(this.config.contextRoot(), res.getStatus());
        }
    }

    private void dispatchRequest(AbstractRackApplication app, GrizzlyRequest req, GrizzlyResponse res) throws IOException {
        try {
            app.call(req).respond(res);
        }
        catch (Exception e) {
            res.setError();
            if (res.isCommitted()) {
                this.logger.log(Level.WARNING, "Error: Couldn't handle error: response committed", e);
                return;
            }
            res.reset();
            try {
                this.createErrorApp(app);
                req.setAttribute("rack.exception", (Object)e);
                this.logger.log(Level.WARNING, e.getMessage(), e);
                this.errorApp.call(req).respond(res);
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Error: Couldn't handle error", ex);
                res.sendError(500);
            }
        }
    }

    private synchronized void createErrorApp(AbstractRackApplication app) {
        if (this.errorApp == null) {
            this.errorApp = new ErrorApplication(app.runtime, this);
        }
    }

    static class JRubyVersion {
        private int major;
        private int minor;
        private int suffix;
        private String qualifier = "";

        public JRubyVersion() {
            this(Constants.VERSION);
        }

        private JRubyVersion(String version) {
            int i = version.lastIndexOf(46);
            if (i != -1) {
                block7: {
                    String v = version.substring(i + 1, version.length());
                    try {
                        this.suffix = Integer.parseInt(v);
                    }
                    catch (NumberFormatException e) {
                        int index = 0;
                        for (char c : v.toCharArray()) {
                            if (!Character.isDigit(c)) break;
                            ++index;
                        }
                        this.suffix = Integer.parseInt(v.substring(0, index));
                        if (index <= 0) break block7;
                        this.qualifier = v.substring(index, v.length());
                    }
                }
                int j = version.substring(0, i).lastIndexOf(46);
                if (j != -1) {
                    this.minor = Integer.parseInt(version.substring(j + 1, i));
                    this.major = j != 0 ? Integer.parseInt(version.substring(0, j)) : 0;
                } else {
                    this.minor = 0;
                    this.major = 1;
                }
            } else {
                this.suffix = 0;
                this.minor = 0;
                this.major = 0;
            }
        }

        public int compare(JRubyVersion version) {
            int result = this.major - version.major;
            if (result == 0 && (result = this.minor - version.minor) == 0) {
                result = this.suffix - version.suffix;
            }
            return result;
        }

        public int compare(String version) {
            return this.compare(new JRubyVersion(version));
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.suffix + this.qualifier;
        }
    }
}

