/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.embedded;

import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.embedded.Port;
import org.glassfish.kernel.embedded.PortsImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
@Scoped(value=PerLookup.class)
public class PortImpl
implements Port {
    @Inject
    CommandRunner runner = null;
    @Inject(name="plain")
    ActionReport report = null;
    @Inject
    PortsImpl ports;
    @Inject
    NetworkConfig config;
    @Inject
    HttpService httpService;
    String listenerName;
    int number;
    String defaultVirtualServer = "server";

    public void bind(final int portNumber) {
        this.number = portNumber;
        this.listenerName = this.getListenerName();
        try {
            ConfigSupport.apply(new SingleConfigCode<Protocols>(){

                @Override
                public Object run(Protocols param) throws TransactionFailure {
                    Protocol protocol = (Protocol)param.createChild(Protocol.class);
                    protocol.setName(PortImpl.this.listenerName);
                    param.getProtocol().add(protocol);
                    Http http = (Http)protocol.createChild(Http.class);
                    http.setDefaultVirtualServer(PortImpl.this.defaultVirtualServer);
                    protocol.setHttp(http);
                    return protocol;
                }
            }, this.config.getProtocols());
            ConfigSupport.apply(new SingleConfigCode<NetworkListeners>(){

                @Override
                public Object run(NetworkListeners param) throws TransactionFailure {
                    NetworkListener listener = (NetworkListener)param.createChild(NetworkListener.class);
                    listener.setName(PortImpl.this.listenerName);
                    listener.setAddress("127.0.0.1");
                    listener.setPort(Integer.toString(portNumber));
                    listener.setProtocol(PortImpl.this.listenerName);
                    listener.setThreadPool("http-thread-pool");
                    if (listener.findThreadPool() == null) {
                        ThreadPool pool = (ThreadPool)PortImpl.this.config.getNetworkListeners().createChild(ThreadPool.class);
                        pool.setName(PortImpl.this.listenerName);
                        listener.setThreadPool(PortImpl.this.listenerName);
                    }
                    listener.setTransport("tcp");
                    if (listener.findTransport() == null) {
                        Transport transport = (Transport)PortImpl.this.config.getTransports().createChild(Transport.class);
                        transport.setName(PortImpl.this.listenerName);
                        listener.setTransport(PortImpl.this.listenerName);
                    }
                    param.getNetworkListener().add(listener);
                    return listener;
                }
            }, this.config.getNetworkListeners());
            VirtualServer vs = this.httpService.getVirtualServerByName(this.defaultVirtualServer);
            ConfigSupport.apply(new SingleConfigCode<VirtualServer>(){

                @Override
                public Object run(VirtualServer avs) throws PropertyVetoException {
                    String DELIM = ",";
                    String lss = avs.getNetworkListeners();
                    boolean listenerShouldBeAdded = true;
                    if (lss == null || lss.length() == 0) {
                        lss = PortImpl.this.listenerName;
                    } else if (!lss.contains(PortImpl.this.listenerName)) {
                        if (!lss.endsWith(DELIM)) {
                            lss = lss + DELIM;
                        }
                        lss = lss + PortImpl.this.listenerName;
                    } else {
                        listenerShouldBeAdded = false;
                    }
                    if (listenerShouldBeAdded) {
                        avs.setNetworkListeners(lss);
                    }
                    return avs;
                }
            }, vs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getListenerName() {
        int i = 1;
        String name = "embedded-listener";
        while (this.existsListener(name)) {
            name = "embedded-listener-" + i++;
        }
        return name;
    }

    private boolean existsListener(String listenerName) {
        return false;
    }

    public void close() {
        List list = this.config.getNetworkListeners().getNetworkListener();
        for (NetworkListener listener : list) {
            if (!listener.getName().equals(this.listenerName)) continue;
            list.remove(listener);
            break;
        }
        this.ports.remove(this);
    }

    public int getPortNumber() {
        return this.number;
    }
}

