/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JarHelper {
    private static final Logger logger = Logger.getLogger(JarHelper.class.getPackage().getName());

    public static void accept(JarInputStream jis, Visitor visitor) throws IOException {
        JarEntry je;
        while ((je = jis.getNextJarEntry()) != null) {
            logger.logp(Level.FINE, "JarWriterImpl", "accept", "je = ${0}", new Object[]{je});
            visitor.visit(je);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(URLConnection con, OutputStream os, Manifest m) {
        try {
            InputStream in = con.getInputStream();
            JarInputStream jis = null;
            ZipOutputStream jos = null;
            try {
                jis = new JarInputStream(in);
                jos = new JarOutputStream(os, m);
                JarHelper.write(jis, (JarOutputStream)jos);
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (jos != null) {
                        jos.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    if (jis != null) {
                        jis.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (jos != null) {
                    jos.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                if (jis != null) {
                    jis.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                in.close();
            }
            catch (IOException ioe) {}
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void write(JarInputStream jis, JarOutputStream jos) throws IOException {
        ZipEntry ze;
        ByteBuffer byteBuffer = ByteBuffer.allocate(10240);
        while ((ze = jis.getNextEntry()) != null) {
            logger.logp(Level.FINE, "JarWriterImpl", "write", "ze = {0}", new Object[]{ze});
            jos.putNextEntry(ze);
            JarHelper.copy(jis, jos, byteBuffer);
            jos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream in, OutputStream out, ByteBuffer byteBuffer) throws IOException {
        try {
            int read;
            ReadableByteChannel inChannel = Channels.newChannel(in);
            WritableByteChannel outChannel = Channels.newChannel(out);
            do {
                if ((read = inChannel.read(byteBuffer)) <= 0) continue;
                byteBuffer.limit(byteBuffer.position());
                byteBuffer.rewind();
                outChannel.write(byteBuffer);
                logger.logp(Level.FINE, "JarHelper", "write", "Copied {0} bytes", new Object[]{read});
                byteBuffer.clear();
            } while (read != -1);
            Object var7_6 = null;
            byteBuffer.clear();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            byteBuffer.clear();
            throw throwable;
        }
    }

    public static interface Visitor {
        public void visit(JarEntry var1);
    }
}

