/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.accessor.OrmAttributeAccessor;
import org.eclipse.persistence.internal.oxm.documentpreservation.DescriptorLevelDocumentPreservationPolicy;
import org.eclipse.persistence.internal.oxm.documentpreservation.NoDocumentPreservationPolicy;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLBinder;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.XMLValidator;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.platform.SAXPlatform;
import org.eclipse.persistence.oxm.platform.XMLPlatform;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLContext {
    private List sessions;
    private Map descriptorsByQName;
    private Map descriptorsByGlobalType;
    private boolean hasDocumentPreservation = false;

    public XMLContext(String sessionNames) {
        this(sessionNames, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(XMLContext.class));
    }

    public XMLContext(String sessionNames, ClassLoader classLoader) {
        this(sessionNames, classLoader, null);
    }

    public XMLContext(String sessionNames, String xmlResource) {
        this(sessionNames, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(XMLContext.class), xmlResource);
    }

    public XMLContext(String sessionNames, ClassLoader classLoader, String xmlResource) {
        XMLSessionConfigLoader loader = null;
        loader = xmlResource != null ? new XMLSessionConfigLoader(xmlResource) : new XMLSessionConfigLoader();
        this.descriptorsByQName = new HashMap();
        this.descriptorsByGlobalType = new HashMap();
        StringTokenizer st = new StringTokenizer(sessionNames, ":");
        this.sessions = new ArrayList(st.countTokens());
        int index = 0;
        while (st.hasMoreTokens()) {
            this.sessions.add(this.buildSession(st.nextToken(), classLoader, loader));
            ++index;
        }
        for (int x = index - 1; x >= 0; --x) {
            this.storeXMLDescriptorsByQName((DatabaseSession)this.sessions.get(x));
        }
    }

    public XMLContext(Project project) {
        this(project, Thread.currentThread().getContextClassLoader());
    }

    public XMLContext(Project project, ClassLoader classLoader) {
        this(project, classLoader, null);
    }

    public XMLContext(Project project, ClassLoader classLoader, SessionEventListener sessionEventListener) {
        if (project.getDatasourceLogin() == null || !(project.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
            SAXPlatform platform = new SAXPlatform();
            platform.getConversionManager().setLoader(classLoader);
            project.setLogin(new XMLLogin(platform));
        }
        this.sessions = new ArrayList(1);
        DatabaseSession session = project.createDatabaseSession();
        if (sessionEventListener != null) {
            session.getEventManager().addListener(sessionEventListener);
        }
        session.setLogLevel(8);
        this.setupDocumentPreservationPolicy(session);
        session.login();
        this.sessions.add(session);
        this.descriptorsByQName = new HashMap();
        this.descriptorsByGlobalType = new HashMap();
        this.storeXMLDescriptorsByQName(session);
    }

    public XMLContext(Collection projects) {
        this(projects, Thread.currentThread().getContextClassLoader());
    }

    public XMLContext(Collection projects, ClassLoader classLoader) {
        Iterator iterator = projects.iterator();
        this.sessions = new ArrayList(projects.size());
        this.descriptorsByQName = new HashMap();
        this.descriptorsByGlobalType = new HashMap();
        while (iterator.hasNext()) {
            Project project = (Project)iterator.next();
            if (project.getDatasourceLogin() == null || !(project.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
                SAXPlatform platform = new SAXPlatform();
                platform.getConversionManager().setLoader(classLoader);
                project.setLogin(new XMLLogin(platform));
            }
            DatabaseSession session = project.createDatabaseSession();
            session.setLogLevel(8);
            this.setupDocumentPreservationPolicy(session);
            session.login();
            this.sessions.add(session);
            this.storeXMLDescriptorsByQName(session);
        }
    }

    private DatabaseSession buildSession(String sessionName, ClassLoader classLoader, XMLSessionConfigLoader sessionLoader) throws XMLMarshalException {
        DatabaseSession dbSession = classLoader != null ? (DatabaseSession)((Object)SessionManager.getManager().getSession(sessionLoader, sessionName, classLoader, false, true)) : (DatabaseSession)((Object)SessionManager.getManager().getSession(sessionLoader, sessionName, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(this.getClass()), false, false, false));
        if (dbSession.getDatasourceLogin() == null || !(dbSession.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
            SAXPlatform platform = new SAXPlatform();
            dbSession.setLogin(new XMLLogin(platform));
        }
        DatabaseSession session = dbSession.getProject().createDatabaseSession();
        if (dbSession.getEventManager().hasListeners()) {
            List<SessionEventListener> listeners = dbSession.getEventManager().getListeners();
            int listenersSize = listeners.size();
            for (int x = 0; x < listenersSize; ++x) {
                session.getEventManager().addListener(listeners.get(x));
            }
        }
        session.setExceptionHandler(dbSession.getExceptionHandler());
        session.setLogLevel(8);
        this.setupDocumentPreservationPolicy(session);
        session.login();
        return session;
    }

    public void addSession(DatabaseSession sessionToAdd) {
        if (sessionToAdd.getDatasourceLogin() == null || !(sessionToAdd.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
            SAXPlatform platform = new SAXPlatform();
            sessionToAdd.setLogin(new XMLLogin(platform));
        }
        DatabaseSession session = sessionToAdd.getProject().createDatabaseSession();
        if (sessionToAdd.getEventManager().hasListeners()) {
            List<SessionEventListener> listeners = sessionToAdd.getEventManager().getListeners();
            int listenersSize = listeners.size();
            for (int x = 0; x < listenersSize; ++x) {
                session.getEventManager().addListener(listeners.get(x));
            }
        }
        session.setExceptionHandler(sessionToAdd.getExceptionHandler());
        session.setLogLevel(8);
        this.setupDocumentPreservationPolicy(session);
        session.login();
        this.sessions.add(session);
        this.storeXMLDescriptorsByQName(session);
    }

    public XMLUnmarshaller createUnmarshaller() {
        return new XMLUnmarshaller(this);
    }

    public XMLUnmarshaller createUnmarshaller(Map<String, Boolean> parserFeatures) {
        return new XMLUnmarshaller(this, parserFeatures);
    }

    public XMLBinder createBinder() {
        return new XMLBinder(this);
    }

    public XMLMarshaller createMarshaller() {
        XMLMarshaller marshaller = new XMLMarshaller(this);
        return marshaller;
    }

    public XMLValidator createValidator() {
        XMLValidator validator = new XMLValidator(this);
        return validator;
    }

    public AbstractSession getReadSession(Object object) {
        if (null == object) {
            return null;
        }
        int numberOfSessions = this.sessions.size();
        for (int x = 0; x < numberOfSessions; ++x) {
            AbstractSession next = (AbstractSession)this.sessions.get(x);
            XMLDescriptor xmlDescriptor = (XMLDescriptor)next.getDescriptor(object);
            if (xmlDescriptor == null) continue;
            next = next.acquireUnitOfWork();
            return next;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
    }

    public AbstractSession getReadSession(Class clazz) {
        if (null == clazz) {
            return null;
        }
        int numberOfSessions = this.sessions.size();
        for (int x = 0; x < numberOfSessions; ++x) {
            AbstractSession next = (AbstractSession)this.sessions.get(x);
            XMLDescriptor xmlDescriptor = (XMLDescriptor)next.getDescriptor(clazz);
            if (xmlDescriptor == null) continue;
            next = next.acquireUnitOfWork();
            return next;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
    }

    public AbstractSession getReadSession(XMLDescriptor xmlDescriptor) {
        if (null == xmlDescriptor) {
            return null;
        }
        int numberOfSessions = this.sessions.size();
        for (int x = 0; x < numberOfSessions; ++x) {
            AbstractSession next = (AbstractSession)this.sessions.get(x);
            if (!next.getProject().getOrderedDescriptors().contains(xmlDescriptor)) continue;
            next = next.acquireUnitOfWork();
            return next;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(xmlDescriptor.getJavaClass().getName());
    }

    public List getSessions() {
        return this.sessions;
    }

    public DatabaseSession getSession(int index) {
        if (null == this.sessions) {
            return null;
        }
        return (DatabaseSession)this.sessions.get(index);
    }

    public AbstractSession getSession(Object object) {
        if (null == object) {
            return null;
        }
        int numberOfSessions = this.sessions.size();
        for (int x = 0; x < numberOfSessions; ++x) {
            AbstractSession next = (AbstractSession)this.sessions.get(x);
            if (next.getDescriptor(object) == null) continue;
            return next;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
    }

    public AbstractSession getSession(Class clazz) {
        if (null == clazz) {
            return null;
        }
        int numberOfSessions = this.sessions.size();
        for (int x = 0; x < numberOfSessions; ++x) {
            AbstractSession next = (AbstractSession)this.sessions.get(x);
            if (next.getDescriptor(clazz) == null) continue;
            return next;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
    }

    public AbstractSession getSession(XMLDescriptor xmlDescriptor) {
        if (null == xmlDescriptor) {
            return null;
        }
        int numberOfSessions = this.sessions.size();
        for (int x = 0; x < numberOfSessions; ++x) {
            AbstractSession next = (AbstractSession)this.sessions.get(x);
            if (!next.getProject().getOrderedDescriptors().contains(xmlDescriptor)) continue;
            return next;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(xmlDescriptor.getJavaClass().getName());
    }

    private void storeXMLDescriptorsByQName(DatabaseSession session) {
        for (XMLDescriptor xmlDescriptor : session.getProject().getOrderedDescriptors()) {
            this.storeXMLDescriptorByQName(xmlDescriptor);
        }
    }

    public void storeXMLDescriptorByQName(XMLDescriptor xmlDescriptor) {
        Vector tableNames = xmlDescriptor.getTableNames();
        for (int i = 0; i < tableNames.size(); ++i) {
            QName descriptorQName;
            String defaultRootName = (String)tableNames.get(i);
            if (null == defaultRootName) continue;
            int index = defaultRootName.indexOf(58);
            String defaultRootLocalName = defaultRootName.substring(index + 1);
            if (index > -1) {
                String defaultRootPrefix = defaultRootName.substring(0, index);
                String defaultRootNamespaceURI = xmlDescriptor.getNamespaceResolver().resolveNamespacePrefix(defaultRootPrefix);
                descriptorQName = new QName(defaultRootNamespaceURI, defaultRootLocalName);
            } else {
                descriptorQName = xmlDescriptor.getNamespaceResolver() != null ? new QName(xmlDescriptor.getNamespaceResolver().getDefaultNamespaceURI(), defaultRootLocalName) : new QName(defaultRootLocalName);
            }
            if (!xmlDescriptor.hasInheritance() || xmlDescriptor.getInheritancePolicy().isRootParentDescriptor()) {
                this.descriptorsByQName.put(descriptorQName, xmlDescriptor);
                continue;
            }
            XMLDescriptor existingDescriptor = (XMLDescriptor)this.descriptorsByQName.get(descriptorQName);
            if (existingDescriptor != null) continue;
            this.descriptorsByQName.put(descriptorQName, xmlDescriptor);
        }
        XMLSchemaReference xmlSchemaReference = xmlDescriptor.getSchemaReference();
        if (null != xmlSchemaReference) {
            String schemaContext = xmlSchemaReference.getSchemaContext();
            if (xmlSchemaReference.getType() == 1 || xmlSchemaReference.getType() == 2) {
                if (null != schemaContext && schemaContext.lastIndexOf(47) == 0) {
                    schemaContext = schemaContext.substring(1, schemaContext.length());
                    XPathFragment typeFragment = new XPathFragment(schemaContext);
                    if (null != xmlDescriptor.getNamespaceResolver()) {
                        typeFragment.setNamespaceURI(xmlDescriptor.getNamespaceResolver().resolveNamespacePrefix(typeFragment.getPrefix()));
                    }
                    this.descriptorsByGlobalType.put(typeFragment, xmlDescriptor);
                } else {
                    QName qname = xmlSchemaReference.getSchemaContextAsQName();
                    if (qname != null) {
                        if (xmlDescriptor.isWrapper() && xmlDescriptor.getJavaClassName().contains("ObjectWrapper")) {
                            return;
                        }
                        XPathFragment typeFragment = new XPathFragment();
                        typeFragment.setLocalName(qname.getLocalPart());
                        typeFragment.setNamespaceURI(qname.getNamespaceURI());
                        this.descriptorsByGlobalType.put(typeFragment, xmlDescriptor);
                    }
                }
            }
        }
    }

    public XMLDescriptor getDescriptor(QName qName) {
        return (XMLDescriptor)this.descriptorsByQName.get(qName);
    }

    public void addDescriptorByQName(QName qName, XMLDescriptor descriptor) {
        this.descriptorsByQName.put(qName, descriptor);
    }

    public XMLDescriptor getDescriptorByGlobalType(XPathFragment xPathFragment) {
        return (XMLDescriptor)this.descriptorsByGlobalType.get(xPathFragment);
    }

    public DocumentPreservationPolicy getDocumentPreservationPolicy(AbstractSession session) {
        if (session == null) {
            return null;
        }
        XMLLogin login = (XMLLogin)session.getDatasourceLogin();
        return login.getDocumentPreservationPolicy();
    }

    public void setupDocumentPreservationPolicy(DatabaseSession session) {
        XMLLogin login = (XMLLogin)session.getDatasourceLogin();
        if (login.getDocumentPreservationPolicy() == null) {
            for (XMLDescriptor xmlDescriptor : session.getProject().getOrderedDescriptors()) {
                if (!xmlDescriptor.shouldPreserveDocument()) continue;
                login.setDocumentPreservationPolicy(new DescriptorLevelDocumentPreservationPolicy());
                break;
            }
        }
        if (login.getDocumentPreservationPolicy() == null) {
            login.setDocumentPreservationPolicy(new NoDocumentPreservationPolicy());
        }
        login.getDocumentPreservationPolicy().initialize(this);
        if (login.getDocumentPreservationPolicy().shouldPreserveDocument() && !this.hasDocumentPreservation) {
            this.hasDocumentPreservation = true;
        }
    }

    public boolean hasDocumentPreservation() {
        return this.hasDocumentPreservation;
    }

    public void applyORMMetadata(AbstractSession ormSession) {
        for (ClassDescriptor ormDescriptor : ormSession.getDescriptors().values()) {
            Class javaClass = ormDescriptor.getJavaClass();
            AbstractSession oxmSession = null;
            try {
                oxmSession = this.getSession(javaClass);
            }
            catch (XMLMarshalException ex) {
                // empty catch block
            }
            if (oxmSession == null) continue;
            ClassDescriptor oxmDescriptor = oxmSession.getDescriptor(javaClass);
            for (DatabaseMapping ormMapping : ormDescriptor.getMappings()) {
                DatabaseMapping ormContainerMapping;
                ClassDescriptor containerDescriptor;
                DatabaseMapping oxmMapping = oxmDescriptor.getMappingForAttributeName(ormMapping.getAttributeName());
                if (oxmMapping == null) continue;
                AttributeAccessor oxmAccessor = oxmMapping.getAttributeAccessor();
                OrmAttributeAccessor newAccessor = new OrmAttributeAccessor(ormMapping.getAttributeAccessor(), oxmAccessor);
                if (ormMapping.isOneToOneMapping() && ((OneToOneMapping)ormMapping).usesIndirection()) {
                    newAccessor.setValueHolderProperty(true);
                }
                newAccessor.setChangeTracking(ormDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy());
                oxmMapping.setAttributeAccessor(newAccessor);
                AttributeAccessor containerAccessor = null;
                Class containerClass = null;
                if (oxmMapping instanceof XMLCompositeObjectMapping) {
                    containerAccessor = ((XMLCompositeObjectMapping)oxmMapping).getContainerAccessor();
                    containerClass = ((XMLCompositeObjectMapping)oxmMapping).getReferenceClass();
                } else if (oxmMapping instanceof XMLCompositeCollectionMapping) {
                    containerAccessor = ((XMLCompositeCollectionMapping)oxmMapping).getContainerAccessor();
                    containerClass = ((XMLCompositeCollectionMapping)oxmMapping).getReferenceClass();
                }
                if (containerAccessor == null || (containerDescriptor = ormSession.getDescriptor(containerClass)) == null || (ormContainerMapping = containerDescriptor.getMappingForAttributeName(containerAccessor.getAttributeName())) == null) continue;
                OrmAttributeAccessor ormAccessor = new OrmAttributeAccessor(ormContainerMapping.getAttributeAccessor(), containerAccessor);
                ormAccessor.setChangeTracking(containerDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy());
                ormAccessor.setValueHolderProperty(ormContainerMapping instanceof OneToOneMapping && ((OneToOneMapping)ormContainerMapping).usesIndirection());
                if (oxmMapping instanceof XMLCompositeObjectMapping) {
                    ((XMLCompositeObjectMapping)oxmMapping).setContainerAccessor(ormAccessor);
                    continue;
                }
                if (!(oxmMapping instanceof XMLCompositeCollectionMapping)) continue;
                ((XMLCompositeCollectionMapping)oxmMapping).setContainerAccessor(ormAccessor);
            }
        }
    }

    public <T> T getValueByXPath(Object object, String xPath, NamespaceResolver namespaceResolver, Class<T> returnType) {
        if (null == xPath) {
            return null;
        }
        if (".".equals(xPath)) {
            return (T)object;
        }
        AbstractSession session = this.getSession(object);
        XMLDescriptor xmlDescriptor = (XMLDescriptor)session.getDescriptor(object);
        StringTokenizer stringTokenizer = new StringTokenizer(xPath, "/");
        return this.getValueByXPath(object, xmlDescriptor.getObjectBuilder(), stringTokenizer, namespaceResolver, returnType);
    }

    private <T> T getValueByXPath(Object object, ObjectBuilder objectBuilder, StringTokenizer stringTokenizer, NamespaceResolver namespaceResolver, Class<T> returnType) {
        if (null == object) {
            return null;
        }
        String xPath = "";
        XMLField xmlField = new XMLField();
        xmlField.setNamespaceResolver(namespaceResolver);
        while (stringTokenizer.hasMoreElements()) {
            String nextToken = stringTokenizer.nextToken();
            xmlField.setXPath(xPath + nextToken);
            xmlField.initialize();
            DatabaseMapping mapping = objectBuilder.getMappingForField(xmlField);
            if (null == mapping) {
                XPathFragment xPathFragment = new XPathFragment(nextToken);
                if (xPathFragment.getIndexValue() > 0) {
                    xmlField.setXPath(xPath + nextToken.substring(0, nextToken.indexOf(91)));
                    xmlField.initialize();
                    mapping = objectBuilder.getMappingForField(xmlField);
                    if (null != mapping && mapping.isCollectionMapping() && mapping.getContainerPolicy().isListPolicy()) {
                        Object childObject = ((ListContainerPolicy)mapping.getContainerPolicy()).get(xPathFragment.getIndexValue() - 1, mapping.getAttributeValueFromObject(object), null);
                        if (stringTokenizer.hasMoreElements()) {
                            ObjectBuilder childObjectBuilder = mapping.getReferenceDescriptor().getObjectBuilder();
                            return this.getValueByXPath(childObject, childObjectBuilder, stringTokenizer, namespaceResolver, returnType);
                        }
                        return (T)childObject;
                    }
                }
            } else {
                if (stringTokenizer.hasMoreElements()) {
                    Object childObject = mapping.getAttributeValueFromObject(object);
                    ObjectBuilder childObjectBuilder = mapping.getReferenceDescriptor().getObjectBuilder();
                    return this.getValueByXPath(childObject, childObjectBuilder, stringTokenizer, namespaceResolver, returnType);
                }
                return (T)mapping.getAttributeValueFromObject(object);
            }
            xPath = xPath + nextToken + "/";
        }
        return null;
    }

    public void setValueByXPath(Object object, String xPath, NamespaceResolver namespaceResolver, Object value) {
        AbstractSession session = this.getSession(object);
        XMLDescriptor xmlDescriptor = (XMLDescriptor)session.getDescriptor(object);
        StringTokenizer stringTokenizer = new StringTokenizer(xPath, "/");
        this.setValueByXPath(object, xmlDescriptor.getObjectBuilder(), stringTokenizer, namespaceResolver, value);
    }

    private void setValueByXPath(Object object, ObjectBuilder objectBuilder, StringTokenizer stringTokenizer, NamespaceResolver namespaceResolver, Object value) {
        String xPath = "";
        XMLField xmlField = new XMLField();
        xmlField.setNamespaceResolver(namespaceResolver);
        while (stringTokenizer.hasMoreElements()) {
            String nextToken = stringTokenizer.nextToken();
            xmlField.setXPath(xPath + nextToken);
            xmlField.initialize();
            DatabaseMapping mapping = objectBuilder.getMappingForField(xmlField);
            if (null == mapping) {
                XPathFragment xPathFragment = new XPathFragment(nextToken);
                if (xPathFragment.getIndexValue() > 0) {
                    xmlField.setXPath(xPath + nextToken.substring(0, nextToken.indexOf(91)));
                    xmlField.initialize();
                    mapping = objectBuilder.getMappingForField(xmlField);
                    if (null != mapping && mapping.isCollectionMapping() && mapping.getContainerPolicy().isListPolicy()) {
                        if (stringTokenizer.hasMoreElements()) {
                            Object childObject = ((ListContainerPolicy)mapping.getContainerPolicy()).get(xPathFragment.getIndexValue() - 1, mapping.getAttributeValueFromObject(object), null);
                            ObjectBuilder childObjectBuilder = mapping.getReferenceDescriptor().getObjectBuilder();
                            this.setValueByXPath(childObject, childObjectBuilder, stringTokenizer, namespaceResolver, value);
                            return;
                        }
                        List list = (List)mapping.getAttributeValueFromObject(object);
                        list.add(xPathFragment.getIndexValue() - 1, value);
                        return;
                    }
                }
            } else {
                if (stringTokenizer.hasMoreElements()) {
                    Object childObject = mapping.getAttributeValueFromObject(object);
                    ObjectBuilder childObjectBuilder = mapping.getReferenceDescriptor().getObjectBuilder();
                    this.setValueByXPath(childObject, childObjectBuilder, stringTokenizer, namespaceResolver, value);
                    return;
                }
                mapping.setAttributeValueInObject(object, value);
                return;
            }
            xPath = xPath + nextToken + "/";
        }
    }
}

