/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.WebServiceEndpoint;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.NotNull;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
@RestRedirects(value={@RestRedirect(opType=RestRedirect.OpType.DELETE, commandName="undeploy"), @RestRedirect(opType=RestRedirect.OpType.POST, commandName="redeploy")})
public interface Application
extends ConfigBeanProxy,
Injectable,
Named,
PropertyBag {
    @Attribute
    public String getContextRoot();

    public void setContextRoot(String var1) throws PropertyVetoException;

    @Attribute
    @NotNull
    public String getLocation();

    public void setLocation(String var1) throws PropertyVetoException;

    @Attribute(required=true)
    @NotNull
    public String getObjectType();

    public void setObjectType(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getEnabled();

    public void setEnabled(String var1) throws PropertyVetoException;

    @Attribute
    public String getLibraries();

    public void setLibraries(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getAvailabilityEnabled();

    public void setAvailabilityEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getDirectoryDeployed();

    public void setDirectoryDeployed(String var1) throws PropertyVetoException;

    @Attribute
    public String getDescription();

    public void setDescription(String var1) throws PropertyVetoException;

    @Element
    public List<Module> getModule();

    @Element
    public List<Engine> getEngine();

    @Element
    public List<WebServiceEndpoint> getWebServiceEndpoint();

    @DuckTyped
    public Module getModule(String var1);

    @DuckTyped
    public Properties getDeployProperties();

    @DuckTyped
    public DeployCommandParameters getDeployParameters(ApplicationRef var1);

    @DuckTyped
    public Map<String, Properties> getModulePropertiesMap();

    @DuckTyped
    public boolean isStandaloneModule();

    @DuckTyped
    public boolean containsSnifferType(String var1);

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Duck {
        public static Module getModule(Application instance, String name) {
            for (Module module : instance.getModule()) {
                if (!module.getName().equals(name)) continue;
                return module;
            }
            return null;
        }

        public static Properties getDeployProperties(Application instance) {
            Properties deploymentProps = new Properties();
            for (Property prop : instance.getProperty()) {
                deploymentProps.put(prop.getName(), prop.getValue());
            }
            deploymentProps.setProperty("object-type", instance.getObjectType());
            if (instance.getContextRoot() != null) {
                deploymentProps.setProperty("context-root", instance.getContextRoot());
            }
            return deploymentProps;
        }

        public static DeployCommandParameters getDeployParameters(Application app, ApplicationRef appRef) {
            if (appRef == null) {
                throw new IllegalArgumentException("Null appRef passed");
            }
            URI uri = null;
            try {
                uri = new URI(app.getLocation());
            }
            catch (URISyntaxException e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, e.getMessage(), e);
            }
            if (uri == null) {
                return null;
            }
            DeployCommandParameters deploymentParams = new DeployCommandParameters(new File(uri));
            deploymentParams.name = app.getName();
            deploymentParams.description = app.getDescription();
            deploymentParams.enabled = Boolean.parseBoolean(app.getEnabled());
            deploymentParams.contextroot = app.getContextRoot();
            deploymentParams.libraries = app.getLibraries();
            deploymentParams.virtualservers = appRef.getVirtualServers();
            return deploymentParams;
        }

        public static Map<String, Properties> getModulePropertiesMap(Application me) {
            HashMap<String, Properties> modulePropertiesMap = new HashMap<String, Properties>();
            for (Module module : me.getModule()) {
                if (module.getProperty() == null) continue;
                Properties moduleProps = new Properties();
                for (Property property : module.getProperty()) {
                    moduleProps.put(property.getName(), property.getValue());
                }
                modulePropertiesMap.put(module.getName(), moduleProps);
            }
            return modulePropertiesMap;
        }

        public static boolean isStandaloneModule(Application me) {
            return Boolean.valueOf(me.getDeployProperties().getProperty("isComposite")) == false;
        }

        public static boolean containsSnifferType(Application app, String snifferType) {
            ArrayList<Engine> engineList = new ArrayList<Engine>();
            engineList.addAll(app.getEngine());
            for (Module module : app.getModule()) {
                engineList.addAll(module.getEngines());
            }
            for (Engine engine : engineList) {
                if (!engine.getSniffer().equals(snifferType)) continue;
                return true;
            }
            return false;
        }
    }
}

