/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.LayoutViewHandler;
import com.sun.jsftemplating.layout.descriptors.ComponentType;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.FileUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.plugin.ConsolePluginService;
import org.glassfish.admingui.plugin.IntegrationPoint;
import org.glassfish.admingui.plugin.IntegrationPointComparator;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginHandlers {
    protected PluginHandlers() {
    }

    public static ConsolePluginService getPluginService(FacesContext ctx) {
        ServletContext servletCtx = (ServletContext)ctx.getExternalContext().getContext();
        Habitat habitat = (Habitat)servletCtx.getAttribute("org.glassfish.servlet.habitat");
        return (ConsolePluginService)habitat.getByType(ConsolePluginService.class);
    }

    public static void getPluginResources(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        ConsolePluginService cps = PluginHandlers.getPluginService(handlerCtx.getFacesContext());
        handlerCtx.setOutputValue("resources", (Object)cps.getResources(name));
    }

    public static void getIntegrationPoints(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        List<IntegrationPoint> value = PluginHandlers.getIntegrationPoints(handlerCtx.getFacesContext(), type);
        handlerCtx.setOutputValue("points", value);
    }

    public static List<IntegrationPoint> getIntegrationPoints(FacesContext context, String type) {
        return PluginHandlers.getPluginService(context).getIntegrationPoints(type);
    }

    public static void includeIntegrations(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        UIComponent root = (UIComponent)handlerCtx.getInputValue("root");
        FacesContext ctx = handlerCtx.getFacesContext();
        List<IntegrationPoint> points = PluginHandlers.getIntegrationPoints(ctx, type);
        PluginHandlers.includeIntegrationPoints(ctx, root, PluginHandlers.getSortedIntegrationPoints(points));
    }

    public static void includeFirstIntegrationPoint(HandlerContext handlerCtx) throws IOException {
        Iterator<IntegrationPoint> it;
        String type = (String)handlerCtx.getInputValue("type");
        UIComponent root = (UIComponent)handlerCtx.getInputValue("root");
        FacesContext ctx = handlerCtx.getFacesContext();
        Set<IntegrationPoint> points = PluginHandlers.getSortedIntegrationPoints(PluginHandlers.getIntegrationPoints(ctx, type));
        if (points != null && (it = points.iterator()).hasNext()) {
            IntegrationPoint point = it.next();
            root = PluginHandlers.getIntegrationPointParent(root, point);
            if (point.getContent().lastIndexOf("://", 15) != -1) {
                URL contentURL = FileUtil.searchForFile((String)point.getContent(), null);
                if (contentURL == null) {
                    throw new IOException("Unable to locate file: " + point.getContent());
                }
                String content = new String(FileUtil.readFromURL((URL)contentURL));
                LayoutComponent stDesc = new LayoutComponent(null, "externalContent", new ComponentType("tmpTextCT", "com.sun.jsftemplating.component.factory.basic.StaticTextFactory"));
                stDesc.addOption("value", (Object)content);
                ComponentUtil.getInstance((FacesContext)ctx).createChildComponent(ctx, stDesc, root);
            } else {
                PluginHandlers.includeIntegrationPoint(ctx, root, point);
            }
        }
    }

    public static void getContentOfIntegrationPoints(HandlerContext handlerCtx) throws IOException {
        String type = (String)handlerCtx.getInputValue("type");
        FacesContext ctx = handlerCtx.getFacesContext();
        Set<IntegrationPoint> points = PluginHandlers.getSortedIntegrationPoints(PluginHandlers.getIntegrationPoints(ctx, type));
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        if (points != null) {
            for (IntegrationPoint it : points) {
                String content = it.getContent();
                if (GuiUtil.isEmpty(content)) {
                    GuiUtil.getLogger().warning("No Content specified for Integration Point: " + type + " id : " + it.getId());
                    continue;
                }
                List labelsAndValues = GuiUtil.parseStringList(content, ";");
                List ll = GuiUtil.parseStringList((String)labelsAndValues.get(0), ",");
                for (String one : ll) {
                    labels.add(one);
                }
                if (labelsAndValues.size() == 2) {
                    List vv = GuiUtil.parseStringList((String)labelsAndValues.get(1), ",");
                    for (String one : vv) {
                        values.add(one);
                    }
                    continue;
                }
                for (String one : ll) {
                    values.add(one);
                }
            }
        }
        handlerCtx.setOutputValue("labels", labels);
        handlerCtx.setOutputValue("values", values);
    }

    public static void getAppEditIntegrationPoint(HandlerContext handlerCtx) throws IOException {
        String type = (String)handlerCtx.getInputValue("type");
        FacesContext ctx = handlerCtx.getFacesContext();
        Set<IntegrationPoint> points = PluginHandlers.getSortedIntegrationPoints(PluginHandlers.getIntegrationPoints(ctx, type));
        HashMap result = new HashMap();
        if (points != null) {
            for (IntegrationPoint it : points) {
                String content = it.getContent();
                if (GuiUtil.isEmpty(content)) {
                    GuiUtil.getLogger().warning("No Content specified for Integration Point: " + type + " id : " + it.getId());
                    continue;
                }
                List vv = GuiUtil.parseStringList(content, ":");
                if (vv.size() != 2) {
                    GuiUtil.getLogger().warning("Invalid content specified for Integration Point: " + type + " id : " + it.getId());
                    continue;
                }
                result.put(vv.get(0), vv.get(1));
            }
        }
        handlerCtx.setOutputValue("appEditPageMap", result);
    }

    public static Set<IntegrationPoint> getSortedIntegrationPoints(List<IntegrationPoint> points) {
        if (points == null) {
            return null;
        }
        TreeSet<IntegrationPoint> sortedSet = new TreeSet<IntegrationPoint>((Comparator<IntegrationPoint>)IntegrationPointComparator.getInstance());
        sortedSet.addAll(points);
        return sortedSet;
    }

    public static void includeIntegrationPoints(FacesContext ctx, UIComponent root, Set<IntegrationPoint> points) {
        if (points == null) {
            return;
        }
        if (root == null) {
            root = ctx.getViewRoot();
        }
        Iterator<IntegrationPoint> it = null;
        int lastSize = 0;
        int currSize = points.size();
        String parentId = null;
        String lastParentId = null;
        while (currSize != lastSize) {
            lastSize = currSize;
            it = points.iterator();
            lastParentId = "";
            UIComponent parent = root;
            while (it.hasNext()) {
                IntegrationPoint point = it.next();
                parentId = point.getParentId();
                if (parentId == null || !parentId.equals(lastParentId)) {
                    parent = PluginHandlers.getIntegrationPointParent(root, point);
                }
                if (parent == null) {
                    lastParentId = null;
                    continue;
                }
                lastParentId = parent.getId();
                PluginHandlers.includeIntegrationPoint(ctx, parent, point);
                it.remove();
            }
            currSize = points.size();
        }
    }

    public static UIComponent getIntegrationPointParent(UIComponent root, IntegrationPoint point) {
        UIComponent parent = null;
        String parentId = point.getParentId();
        if (parentId == null) {
            parentId = root.getId();
            parent = root;
        } else {
            parent = PluginHandlers.findComponentById(root, parentId);
        }
        return parent;
    }

    public static void includeIntegrationPoint(FacesContext ctx, UIComponent parent, IntegrationPoint point) {
        String content = point.getContent();
        while (content.startsWith("/")) {
            content = content.substring(1);
        }
        String key = content;
        if (!key.contains("://")) {
            key = "/" + point.getConsoleConfigId() + "/" + content;
        }
        LayoutDefinition def = LayoutDefinitionManager.getLayoutDefinition((FacesContext)ctx, (String)key);
        LayoutViewHandler.buildUIComponentTree((FacesContext)ctx, (UIComponent)parent, (LayoutElement)def);
    }

    private static UIComponent findComponentById(UIComponent base, String id) {
        if (id.equals(base.getId())) {
            return base;
        }
        Iterator<UIComponent> it = base.getFacetsAndChildren();
        UIComponent comp = null;
        while (it.hasNext()) {
            comp = PluginHandlers.findComponentById(it.next(), id);
            if (comp == null) continue;
            return comp;
        }
        return null;
    }

    public static void retrievePluginPageContents(HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("compId");
        UIComponent comp = handlerCtx.getFacesContext().getViewRoot().findComponent(id);
        String urlContents = "";
        if (comp != null) {
            String url = (String)comp.getAttributes().get("realUrl");
            try {
                URL contentUrl = FileUtil.searchForFile((String)url, null);
                if (contentUrl == null) {
                    throw new IOException("Unable to locate file: " + url);
                }
                urlContents = new String(FileUtil.readFromURL((URL)contentUrl));
            }
            catch (IOException ex) {
                Logger.getLogger(PluginHandlers.class.getName()).log(Level.SEVERE, "Unable to read url: " + url, ex);
            }
        }
        handlerCtx.setOutputValue("pluginPage", (Object)urlContents);
    }

    public static void getPluginIdFromViewId(HandlerContext handlerCtx) {
        String viewId = (String)handlerCtx.getInputValue("viewId");
        if (viewId == null) {
            return;
        }
        ConsolePluginService cps = PluginHandlers.getPluginService(handlerCtx.getFacesContext());
        String pluginId = "";
        int next = viewId.indexOf("/", 1);
        if (next > -1) {
            pluginId = viewId.substring(0, next);
            String resource = viewId.substring(next);
            if (pluginId.startsWith("/")) {
                pluginId = pluginId.substring(1);
            }
            ClassLoader cl = cps.getModuleClassLoader(pluginId);
            URL url = null;
            if (cl != null) {
                url = cl.getResource(resource);
            }
        }
        handlerCtx.setOutputValue("pluginId", (Object)pluginId);
    }
}

