/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigParser;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.scripting.jruby.JRubyDeployer;
import org.glassfish.scripting.jruby.Messages;
import org.glassfish.scripting.jruby.config.JrubyContainer;
import org.glassfish.scripting.jruby.monitor.JRubyProbeStatsProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="org.glassfish.scripting.jruby.JRubyContainer")
@Scoped(value=Singleton.class)
public class JRubyContainer
implements Container,
PostConstruct,
PreDestroy {
    @Inject(optional=true)
    JrubyContainer container;
    @Inject
    Habitat habitat;
    @Inject
    ConfigParser parser;
    @Inject
    MonitoringService monitoringService;
    private final Logger logger = Logger.getLogger(JRubyContainer.class.getName());
    JRubyProbeStatsProvider jrubyStatsProvider;

    @Override
    public void postConstruct() {
        if (this.container == null) {
            URL xml = Thread.currentThread().getContextClassLoader().getResource("org/glassfish/scripting/jruby/config/jruby-container-config.xml");
            String home = System.getProperty("com.sun.aas.installRoot") + File.separator + "jruby";
            if (!new File(home).exists()) {
                home = "";
            }
            try {
                this.container = (JrubyContainer)this.parser.parseContainerConfig(this.habitat, xml, JrubyContainer.class);
                final String home1 = home;
                ConfigSupport.apply(new SingleConfigCode<JrubyContainer>(){

                    @Override
                    public Object run(JrubyContainer param) throws PropertyVetoException, TransactionFailure {
                        param.setJrubyHome(home1);
                        return null;
                    }
                }, this.container);
            }
            catch (TransactionFailure e) {
                this.logger.log(Level.SEVERE, Messages.format("jrubycontainer.jrubyconfig.failed", new Object[0]), e);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, Messages.format("jrubycontainer.jrubyconfig.failed", new Object[0]), e);
            }
        }
        this.jrubyStatsProvider = new JRubyProbeStatsProvider();
        this.logger.fine("Registering JRubyStatsProvider()");
        StatsProviderManager.register((String)"jruby-container", (PluginPoint)PluginPoint.SERVER, (String)"containers/jruby/applications", (Object)this.jrubyStatsProvider);
    }

    public URL getInfoSite() {
        try {
            return new URL("http://glassfish-scripting.dev.java.net");
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public Class<? extends Deployer> getDeployer() {
        return JRubyDeployer.class;
    }

    public String getName() {
        return "JRubyContainer";
    }

    @Override
    public void preDestroy() {
        StatsProviderManager.unregister((Object)this.jrubyStatsProvider);
    }
}

