/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.constraints.impl;

import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Min;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinValidatorForString
implements ConstraintValidator<Min, String> {
    private long minValue;

    @Override
    public void initialize(Min minValue) {
        this.minValue = minValue.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        try {
            return new BigDecimal(value).compareTo(BigDecimal.valueOf(this.minValue)) != -1;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

