/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.monitoring.stats.EjbMethodStatsProvider;
import com.sun.ejb.monitoring.stats.EjbMonitoringUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;

public abstract class EjbMonitoringStatsProvider {
    Map<Method, EjbMethodStatsProvider> methodMonitorMap;
    String appName = null;
    String moduleName = null;
    String beanName = null;
    boolean registered = false;
    protected long beanId;
    private CountStatisticImpl createStat = new CountStatisticImpl("CreateCount", "count", "Number of times EJB create method is called");
    private CountStatisticImpl removeStat = new CountStatisticImpl("RemoveCount", "count", "Number of times EJB remove method is called");
    static final Logger _logger = EjbContainerUtilImpl.getInstance().getLogger();

    public EjbMonitoringStatsProvider(long beanId, String appName, String moduleName, String beanName) {
        this.beanId = beanId;
        this.appName = appName;
        this.moduleName = moduleName;
        this.beanName = beanName;
    }

    public void addMethods(long beanId, String appName, String moduleName, String beanName, Method[] methods) {
        HashMap<String, EjbMethodStatsProvider> tempMap = new HashMap<String, EjbMethodStatsProvider>();
        int bucketSz = methods.length == 0 ? 16 : methods.length << 1;
        this.methodMonitorMap = new HashMap<Method, EjbMethodStatsProvider>(bucketSz);
        if (this.beanId == beanId) {
            for (Method m : methods) {
                String mname = EjbMonitoringUtils.stringify(m);
                EjbMethodStatsProvider monitor = (EjbMethodStatsProvider)tempMap.get(mname);
                if (monitor == null) {
                    monitor = new EjbMethodStatsProvider(mname);
                    tempMap.put(mname, monitor);
                }
                this.methodMonitorMap.put(m, monitor);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[EJBMonitoringStatsProvider] : " + appName + ":" + moduleName + ":" + beanName + ":" + this.methodMonitorMap.size());
            }
        }
    }

    public void register() {
        String beanSubTreeNode = EjbMonitoringUtils.registerComponent(this.appName, this.moduleName, this.beanName, this);
        if (beanSubTreeNode != null) {
            this.registered = true;
            for (Method m : this.methodMonitorMap.keySet()) {
                String node;
                EjbMethodStatsProvider monitor = this.methodMonitorMap.get(m);
                if (monitor.isRegistered() || (node = EjbMonitoringUtils.registerMethod(beanSubTreeNode, monitor.getStringifiedMethodName(), monitor)) == null) continue;
                monitor.registered();
            }
        }
    }

    public void unregister() {
        boolean debug = _logger.isLoggable(Level.FINE);
        if (this.registered) {
            if (debug) {
                _logger.log(Level.FINE, "[EJBMonitoringStatsProvider] unregister: " + this.appName + ":" + this.moduleName + ":" + this.beanName);
            }
            this.registered = false;
            StatsProviderManager.unregister((Object)this);
            for (EjbMethodStatsProvider monitor : this.methodMonitorMap.values()) {
                if (!monitor.isRegistered()) continue;
                if (debug) {
                    _logger.log(Level.FINE, "[EJBMonitoringStatsProvider] unregister method: " + monitor.getStringifiedMethodName());
                }
                monitor.unregistered();
                StatsProviderManager.unregister((Object)monitor);
            }
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:methodStartEvent")
    public void ejbMethodStartEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName, @ProbeParam(value="method") Method method) {
        if (this.beanId == beanId) {
            this.log("ejbMethodStartEvent", method);
            EjbMethodStatsProvider monitor = this.methodMonitorMap.get(method);
            if (monitor != null) {
                monitor.methodStart();
            }
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:methodEndEvent")
    public void ejbMethodEndEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName, @ProbeParam(value="exception") Throwable exception, @ProbeParam(value="method") Method method) {
        if (this.beanId == beanId) {
            this.log("ejbMethodEndEvent", method);
            EjbMethodStatsProvider monitor = this.methodMonitorMap.get(method);
            if (monitor != null) {
                monitor.methodEnd(exception == null);
            }
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:beanCreatedEvent")
    public void ejbBeanCreatedEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.beanId == beanId) {
            this.log("ejbBeanCreatedEvent");
            this.createStat.increment();
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:beanDestroyedEvent")
    public void ejbBeanDestroyedEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.beanId == beanId) {
            this.log("ejbBeanDestroyedEvent");
            this.removeStat.increment();
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:beanActivatedEvent")
    public void ejbBeanActivatedEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.beanId == beanId) {
            this.log("ejbBeanActivatedEvent");
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:beanPassivatedEvent")
    public void ejbBeanPassivatedEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.beanId == beanId) {
            this.log("ejbBeanPassivatedEvent");
        }
    }

    @ManagedAttribute(id="createcount")
    @Description(value="Number of times EJB create method is called")
    public CountStatistic getCreateCount() {
        return this.createStat.getStatistic();
    }

    @ManagedAttribute(id="removecount")
    @Description(value="Number of times EJB remove method is called")
    public CountStatistic getRemoveCount() {
        return this.removeStat.getStatistic();
    }

    void log(String mname, String provider) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("===> In " + provider + " for: [" + mname + "] " + this.appName + "::" + this.moduleName + "::" + this.beanName);
        }
    }

    private void log(String mname) {
        this.log(mname, "EjbMonitoringStatsProvider");
    }

    private void log(String mname, Method m) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("===> In EjbMonitoringStatsProvider for: [" + mname + "] " + this.appName + "::" + this.moduleName + "::" + this.beanName + "::" + EjbMonitoringUtils.stringify(m));
        }
    }
}

