/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.io.Serializable;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;

public class SerializedMetadata
extends MetadataConverter {
    public SerializedMetadata() {
    }

    public SerializedMetadata(MetadataAccessibleObject accessibleObject) {
        super(accessibleObject);
    }

    public SerializedMetadata(MetadataAnnotation converter, MetadataAccessibleObject accessibleObject) {
        super(converter, accessibleObject);
    }

    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        if (accessor.getReferenceClass().extendsInterface(Serializable.class) || accessor.getReferenceClass().isArray() || accessor.getReferenceClass().isInterface()) {
            this.setConverter(mapping, (Converter)new SerializedObjectConverter(mapping), isForMapKey);
        } else if (!accessor.getClassAccessor().isMappedSuperclass()) {
            throw ValidationException.invalidTypeForSerializedAttribute((String)mapping.getAttributeName(), (Object)accessor.getReferenceClass(), (Object)accessor.getJavaClass());
        }
    }

    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, MetadataClass classification, boolean isForMapKey) {
        this.process(mapping, accessor, referenceClass, isForMapKey);
        if (classification != null) {
            this.setFieldClassification(mapping, this.getJavaClass(classification), isForMapKey);
        }
    }
}

