/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;

public class EjbMonitoringUtils {
    private static final Logger _logger = EjbContainerUtilImpl.getInstance().getLogger();
    static final String NODE = "/";
    static final String SEP = "-";
    static final String APPLICATION_NODE = "applications/";
    static final String EJB_MONITORING_NODE = "ejb-container";
    static final String METHOD_NODE = "/bean-methods/";

    static String registerComponent(String appName, String moduleName, String beanName, Object listener) {
        String beanSubTreeNode = EjbMonitoringUtils.getBeanNode(appName, moduleName, beanName);
        try {
            StatsProviderManager.register((String)EJB_MONITORING_NODE, (PluginPoint)PluginPoint.APPLICATIONS, (String)beanSubTreeNode, (Object)listener);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "[**EjbMonitoringUtils**] Could not register listener for appName: " + appName + "; modName: " + moduleName + "; beanName: " + beanName, ex);
            return null;
        }
        return beanSubTreeNode;
    }

    static String registerSubComponent(String appName, String moduleName, String beanName, String subNode, Object listener) {
        String subTreeNode = EjbMonitoringUtils.getBeanNode(appName, moduleName, beanName) + NODE + subNode;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("SUB-NODE NAME: " + subTreeNode);
        }
        try {
            StatsProviderManager.register((String)EJB_MONITORING_NODE, (PluginPoint)PluginPoint.APPLICATIONS, (String)subTreeNode, (Object)listener);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "[**EjbMonitoringUtils**] Could not register subnode [" + subNode + "] listener for appName: " + appName + "; modName: " + moduleName + "; beanName: " + beanName, ex);
            return null;
        }
        return subTreeNode;
    }

    static String registerMethod(String parentNode, String mname, Object listener) {
        String subTreeNode = parentNode + METHOD_NODE + mname;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("METHOD NODE NAME: " + subTreeNode);
        }
        try {
            StatsProviderManager.register((String)EJB_MONITORING_NODE, (PluginPoint)PluginPoint.APPLICATIONS, (String)subTreeNode, (Object)listener);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "[**EjbMonitoringUtils**] Could not register method listener for " + subTreeNode, ex);
            return null;
        }
        return subTreeNode;
    }

    static String stringify(Method m) {
        Class<?>[] args;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("==> Converting method to String: " + m);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(m.getName());
        for (Class<?> c : args = m.getParameterTypes()) {
            sb.append(SEP).append(c.getName());
        }
        return sb.toString().replaceAll("\\.", "\\\\.").replaceAll("_", "\\\\.");
    }

    static String getBeanNode(String appName, String moduleName, String beanName) {
        StringBuffer sb = new StringBuffer();
        if (appName != null) {
            sb.append(appName).append(NODE);
        }
        sb.append(moduleName).append(NODE).append(beanName);
        String beanSubTreeNode = sb.toString().replaceAll("\\.", "\\\\.").replaceAll("_jar", "\\\\.jar").replaceAll("_war", "\\\\.war");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("BEAN NODE NAME: " + beanSubTreeNode);
        }
        return beanSubTreeNode;
    }
}

