/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-descriptors", metadata="mode=debug")
@Scoped(value=PerLookup.class)
@I18n(value="list.commands")
public class ListCommandDescriptorsCommand
implements AdminCommand {
    @Inject
    Habitat habitat;
    private List<AdminCommand> adminCmds;
    private List<CLICommand> cliCmds = new LinkedList<CLICommand>();
    private static final String EOL = "%%%EOL%%%";

    public void execute(AdminCommandContext context) {
        this.setAdminCommands();
        this.sort();
        for (AdminCommand cmd : this.adminCmds) {
            this.cliCmds.add(this.reflect(cmd));
        }
        ActionReport report = context.getActionReport();
        String s = "ALL COMMANDS: %%%EOL%%%";
        for (CLICommand cli : this.cliCmds) {
            s = s + cli.toString() + EOL;
        }
        report.setMessage(s);
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private CLICommand reflect(AdminCommand cmd) {
        CLICommand cliCmd = new CLICommand(cmd);
        for (Field f : cmd.getClass().getDeclaredFields()) {
            Param param = f.getAnnotation(Param.class);
            if (param == null) continue;
            Option option = new Option(param, f);
            cliCmd.options.add(option);
        }
        return cliCmd;
    }

    private void setAdminCommands() {
        this.adminCmds = new ArrayList<AdminCommand>();
        for (AdminCommand command : this.habitat.getAllByContract(AdminCommand.class)) {
            this.adminCmds.add(command);
        }
    }

    private void sort() {
        Collections.sort(this.adminCmds, new Comparator<AdminCommand>(){

            @Override
            public int compare(AdminCommand c1, AdminCommand c2) {
                String name1 = c1.getClass().getAnnotation(Service.class).name();
                String name2 = c2.getClass().getAnnotation(Service.class).name();
                return name1.compareTo(name2);
            }
        });
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0 && !s.equals("null");
    }

    private static class CLICommand {
        AdminCommand adminCommand;
        String name;
        List<Option> options = new LinkedList<Option>();

        CLICommand(AdminCommand adminCommand) {
            this.adminCommand = adminCommand;
            this.name = adminCommand.getClass().getAnnotation(Service.class).name();
        }

        public String toString() {
            String s = "CLI Command: name=" + this.name + " class=" + this.adminCommand.getClass().getName();
            for (Option opt : this.options) {
                s = s + opt.toString() + ListCommandDescriptorsCommand.EOL;
            }
            return s;
        }
    }

    private static class Option {
        private boolean required;
        private boolean operand;
        private String name;
        private String defaultValue;
        private Class<?> type;

        Option(Param p, Field f) {
            Class<?> ftype = f.getType();
            this.name = p.name();
            if (!ListCommandDescriptorsCommand.ok(this.name)) {
                this.name = f.getName();
            }
            this.required = !p.optional();
            this.operand = p.primary();
            this.defaultValue = p.defaultValue();
            this.type = ftype;
        }

        public String toString() {
            String s = "   Option: name=" + this.name + " required=" + this.required + " operand=" + this.operand + " defaultValue=" + this.defaultValue + " type=" + this.type.getName();
            return s;
        }
    }
}

