/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.BtreeDictCompactor;
import com.sun.java.help.search.BtreeDictParameters;
import com.sun.java.help.search.ConceptLocation;
import com.sun.java.help.search.DocumentCompressor;
import com.sun.java.help.search.DocumentLists;
import com.sun.java.help.search.FullBtreeDict;
import com.sun.java.help.search.Schema;
import com.sun.java.help.search.Utilities;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.help.search.IndexBuilder;

public class DefaultIndexBuilder
extends IndexBuilder {
    private static int InitSize = 4096;
    private FullBtreeDict dict;
    protected Hashtable cache = new Hashtable(15000);
    private DocumentCompressor compr;
    private int free = 0;
    private int size = InitSize;
    private ConceptLocation[] locations = new ConceptLocation[this.size];
    private int freeID;
    private int currentDocID = 0;
    private Schema _schema;
    private BtreeDictParameters _tmapParams;
    private int _title = 0;
    private Hashtable tmpstopWords = new Hashtable();
    private boolean debug = false;

    public DefaultIndexBuilder(String indexDir) throws Exception {
        super(indexDir);
        this.removeExistingFiles(indexDir);
        this._schema = new Schema(null, indexDir, true);
        this._tmapParams = new BtreeDictParameters(this._schema, "TMAP");
        if (!this._tmapParams.readState()) {
            this._tmapParams.setBlockSize(2048);
            this._tmapParams.setRoot(0);
            this._tmapParams.setFreeID(1);
        }
        URL url = new URL("file", "", indexDir);
        this.dict = new FullBtreeDict(this._tmapParams, true);
        this.freeID = this._tmapParams.getFreeID();
        this.compr = new DocumentCompressor(url);
    }

    public void storeStopWords(Enumeration stopWords) {
        while (stopWords.hasMoreElements()) {
            String word = (String)stopWords.nextElement();
            this.tmpstopWords.put(word, word);
        }
    }

    public Enumeration getStopWords() {
        return null;
    }

    private boolean isStopWord(String word) {
        return this.tmpstopWords.get(word) != null;
    }

    public void close() throws Exception {
        this.dict.close(this.freeID);
        this._tmapParams.setFreeID(this.freeID);
        this._tmapParams.updateSchema();
        this.debug("compacting...");
        BtreeDictCompactor source = new BtreeDictCompactor(this._tmapParams, false);
        URL url = new URL("file", "", this.indexDir + "compacted");
        BtreeDictParameters params = new BtreeDictParameters(url, this._tmapParams.getBlockSize(), 0, this.freeID);
        source.compact(params);
        URL tmapURL = new URL("file", "", this.indexDir + "TMAP");
        File tmap = new File(Utilities.URLDecoder(tmapURL.getFile()));
        tmap.delete();
        File compacted = new File(Utilities.URLDecoder(url.getFile()));
        compacted.renameTo(tmap);
        this._tmapParams.setRoot(params.getRootPosition());
        this._tmapParams.updateSchema();
        this.debug("freeID is " + this.freeID);
        this.compr.close(this.indexDir + "OFFSETS");
        this.debug("inverting index");
        DocumentLists.invert(this.indexDir);
        this._schema.save();
    }

    public void openDocument(String name) throws Exception {
        if (this.currentDocID != 0) {
            throw new Exception("document already open");
        }
        this.currentDocID = this.intern(name);
    }

    public void closeDocument() throws Exception {
        if (this.currentDocID == 0) {
            throw new Exception("no document open");
        }
        this.compr.compress(this.currentDocID, this._title, this.locations, this.free, null, 0);
        this.free = 0;
        this.currentDocID = 0;
        this._title = 0;
    }

    public void storeLocation(String text, int position) throws Exception {
        if (this.isStopWord(text)) {
            return;
        }
        if (this.free == this.size) {
            ConceptLocation[] newArray = new ConceptLocation[this.size *= 2];
            System.arraycopy(this.locations, 0, newArray, 0, this.free);
            this.locations = newArray;
        }
        this.locations[this.free++] = new ConceptLocation(this.intern(text), position, position + text.length());
    }

    public void storeTitle(String title) throws Exception {
        this._title = this.intern(title);
    }

    private int intern(String name) throws Exception {
        Integer cached = (Integer)this.cache.get(name);
        if (cached != null) {
            return cached;
        }
        int id = this.dict.fetch(name);
        if (id == 0) {
            id = this.freeID++;
            this.dict.store(name, id);
        }
        this.cache.put(name, new Integer(id));
        return id;
    }

    private void removeExistingFiles(String indexDir) {
        block14: {
            File test = new File(indexDir);
            try {
                if (!test.exists()) break block14;
                try {
                    File tmap = new File(test, "TMAP");
                    tmap.delete();
                }
                catch (NullPointerException te) {
                    // empty catch block
                }
                try {
                    File docs = new File(test, "DOCS");
                    docs.delete();
                }
                catch (NullPointerException de) {
                    // empty catch block
                }
                try {
                    File docstab = new File(test, "DOCS.TAB");
                    docstab.delete();
                }
                catch (NullPointerException dte) {
                    // empty catch block
                }
                try {
                    File offsets = new File(test, "OFFSETS");
                    offsets.delete();
                }
                catch (NullPointerException oe) {
                    // empty catch block
                }
                try {
                    File positions = new File(test, "POSITIONS");
                    positions.delete();
                }
                catch (NullPointerException pe) {
                    // empty catch block
                }
                try {
                    File schema = new File(test, "SCHEMA");
                    schema.delete();
                }
                catch (NullPointerException se) {}
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private void debug(String msg) {
        if (this.debug) {
            System.err.println("DefaultIndexBuilder: " + msg);
        }
    }
}

