/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import com.sun.java.help.impl.LangElement;
import com.sun.java.help.impl.Parser;
import com.sun.java.help.impl.ParserEvent;
import com.sun.java.help.impl.ParserListener;
import com.sun.java.help.impl.Tag;
import com.sun.java.help.impl.TagProperties;
import com.sun.java.help.impl.XmlReader;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import javax.help.BadIDException;
import javax.help.FlatMap;
import javax.help.HelpAction;
import javax.help.HelpBroker;
import javax.help.HelpSetException;
import javax.help.HelpSetFactory;
import javax.help.HelpUtilities;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TryMap;
import javax.help.event.EventListenerList;
import javax.help.event.HelpSetEvent;
import javax.help.event.HelpSetListener;
import javax.swing.ImageIcon;

public class HelpSet
implements Serializable {
    private static String errorMsg = null;
    protected EventListenerList listenerList = new EventListenerList();
    public static final String publicIDString = "-//Sun Microsystems Inc.//DTD JavaHelp HelpSet Version 1.0//EN";
    public static final String publicIDString_V2 = "-//Sun Microsystems Inc.//DTD JavaHelp HelpSet Version 2.0//EN";
    public static final Object implRegistry = new StringBuffer("HelpSet.implRegistry");
    public static final String helpBrokerClass = "helpBroker/class";
    public static final String helpBrokerLoader = "helpBroker/loader";
    public static final Object kitTypeRegistry = new StringBuffer("JHelpViewer.kitTypeRegistry");
    public static final Object kitLoaderRegistry = new StringBuffer("JHelpViewer.kitLoaderRegistry");
    private String title;
    private Map map;
    private TryMap combinedMap;
    private URL helpset;
    private String homeID;
    private Locale locale = Locale.getDefault();
    private transient ClassLoader loader;
    private Vector views = new Vector();
    private Vector presentations = new Vector();
    private Presentation defaultPresentation = null;
    private Vector helpsets;
    private static HelpBroker defaultHelpBroker;
    private Vector subHelpSets = new Vector();
    private static Hashtable defaultKeys;
    private Hashtable localKeys = new Hashtable();
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private static final boolean debug = false;
    static /* synthetic */ Class class$java$lang$Object;

    public HelpSet(ClassLoader loader) {
        this.helpsets = new Vector();
        this.loader = loader;
    }

    public HelpSet() {
        this.helpsets = new Vector();
        this.loader = null;
    }

    public HelpSet(ClassLoader loader, URL helpset) throws HelpSetException {
        this(loader);
        this.helpset = helpset;
        DefaultHelpSetFactory factory = new DefaultHelpSetFactory();
        this.parseInto(helpset, factory);
        HelpSet x = factory.parsingEnded(this);
        if (x == null) {
            throw new HelpSetException("Could not parse\n" + errorMsg);
        }
    }

    public static URL findHelpSet(ClassLoader cl, String shortName, String extension, Locale locale) {
        return HelpUtilities.getLocalizedResource(cl, shortName, extension, locale, true);
    }

    public static URL findHelpSet(ClassLoader cl, String name, Locale locale) {
        String extension;
        String shortName;
        if (name.endsWith(".hs")) {
            shortName = name.substring(0, name.length() - 3);
            extension = ".hs";
        } else {
            shortName = name;
            extension = ".hs";
        }
        return HelpSet.findHelpSet(cl, shortName, extension, locale);
    }

    public static URL findHelpSet(ClassLoader cl, String name) {
        return HelpSet.findHelpSet(cl, name, Locale.getDefault());
    }

    public HelpBroker createHelpBroker() {
        return this.createHelpBroker(null);
    }

    public HelpBroker createHelpBroker(String presentationName) {
        HelpBroker back = null;
        String classname = (String)this.getKeyData(implRegistry, helpBrokerClass);
        ClassLoader loader = (ClassLoader)this.getKeyData(implRegistry, helpBrokerLoader);
        if (loader == null) {
            loader = this.getLoader();
        }
        try {
            Class<?> c = loader != null ? loader.loadClass(classname) : Class.forName(classname);
            back = (HelpBroker)c.newInstance();
        }
        catch (Throwable e) {
            back = null;
        }
        if (back != null) {
            back.setHelpSet(this);
            Presentation hsPres = null;
            hsPres = presentationName != null ? this.getPresentation(presentationName) : this.getDefaultPresentation();
            if (hsPres != null) {
                back.setHelpSetPresentation(hsPres);
            }
        }
        return back;
    }

    public void add(HelpSet hs) {
        HelpSet.debug("add(" + hs + ")");
        this.helpsets.addElement(hs);
        this.fireHelpSetAdded(this, hs);
        this.combinedMap = null;
    }

    public boolean remove(HelpSet hs) {
        if (this.helpsets.removeElement(hs)) {
            this.fireHelpSetRemoved(this, hs);
            this.combinedMap = null;
            return true;
        }
        return false;
    }

    public Enumeration getHelpSets() {
        return this.helpsets.elements();
    }

    public boolean contains(HelpSet hs) {
        if (hs == this) {
            return true;
        }
        Enumeration e = this.helpsets.elements();
        while (e.hasMoreElements()) {
            HelpSet child = (HelpSet)e.nextElement();
            if (!child.contains(hs)) continue;
            return true;
        }
        return false;
    }

    public void addHelpSetListener(HelpSetListener l) {
        HelpSet.debug("addHelpSetListener(" + l + ")");
        this.listenerList.add(HelpSetListener.class, l);
    }

    public void removeHelpSetListener(HelpSetListener l) {
        this.listenerList.remove(HelpSetListener.class, l);
    }

    protected void fireHelpSetAdded(Object source, HelpSet helpset) {
        Object[] listeners = this.listenerList.getListenerList();
        HelpSetEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$help$event$HelpSetListener == null ? HelpSet.class$("javax.help.event.HelpSetListener") : class$javax$help$event$HelpSetListener)) continue;
            if (e == null) {
                e = new HelpSetEvent(this, helpset, 0);
            }
            ((HelpSetListener)listeners[i + 1]).helpSetAdded(e);
        }
    }

    protected void fireHelpSetRemoved(Object source, HelpSet helpset) {
        Object[] listeners = this.listenerList.getListenerList();
        HelpSetEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$help$event$HelpSetListener == null ? HelpSet.class$("javax.help.event.HelpSetListener") : class$javax$help$event$HelpSetListener)) continue;
            if (e == null) {
                e = new HelpSetEvent(this, helpset, 1);
            }
            ((HelpSetListener)listeners[i + 1]).helpSetRemoved(e);
        }
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.changes.firePropertyChange("title", oldTitle, title);
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setLocale(Locale l) {
        Locale oldLocale = this.locale;
        this.locale = l;
        this.changes.firePropertyChange("locale", oldLocale, this.locale);
    }

    public Map.ID getHomeID() {
        if (this.homeID == null) {
            return null;
        }
        try {
            return Map.ID.create(this.homeID, this);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setHomeID(String homeID) {
        String oldID = homeID;
        this.homeID = homeID;
        this.changes.firePropertyChange("homeID", oldID, homeID);
    }

    public Map getCombinedMap() {
        if (this.combinedMap == null) {
            this.combinedMap = new TryMap();
            if (this.map != null) {
                this.combinedMap.add(this.map);
            }
            Enumeration e = this.helpsets.elements();
            while (e.hasMoreElements()) {
                HelpSet hs = (HelpSet)e.nextElement();
                this.combinedMap.add(hs.getCombinedMap());
            }
        }
        return this.combinedMap;
    }

    public Map getLocalMap() {
        return this.map;
    }

    public void setLocalMap(Map map) {
        this.map = map;
    }

    public URL getHelpSetURL() {
        return this.helpset;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public NavigatorView[] getNavigatorViews() {
        Object[] back = new NavigatorView[this.views.size()];
        this.views.copyInto(back);
        return back;
    }

    public NavigatorView getNavigatorView(String name) {
        HelpSet.debug("getNavigatorView(" + name + ")");
        for (int i = 0; i < this.views.size(); ++i) {
            NavigatorView view = (NavigatorView)this.views.elementAt(i);
            if (!view.getName().equals(name)) continue;
            HelpSet.debug("  = " + view);
            return view;
        }
        HelpSet.debug("  = null");
        return null;
    }

    public Presentation[] getPresentations() {
        Object[] back = new Presentation[this.presentations.size()];
        this.presentations.copyInto(back);
        return back;
    }

    public Presentation getPresentation(String name) {
        HelpSet.debug("getPresentation(" + name + ")");
        for (int i = 0; i < this.presentations.size(); ++i) {
            Presentation pres = (Presentation)this.presentations.elementAt(i);
            if (!pres.getName().equals(name)) continue;
            HelpSet.debug("  = " + pres);
            return pres;
        }
        HelpSet.debug("  = null");
        return null;
    }

    public Presentation getDefaultPresentation() {
        return this.defaultPresentation;
    }

    public String toString() {
        return this.getTitle();
    }

    public static HelpSet parse(URL url, ClassLoader loader, HelpSetFactory factory) {
        HelpSet hs = new HelpSet(loader);
        hs.helpset = url;
        hs.parseInto(url, factory);
        return factory.parsingEnded(hs);
    }

    public void parseInto(URL url, HelpSetFactory factory) {
        try {
            URLConnection uc = url.openConnection();
            Reader src = XmlReader.createReader(uc);
            factory.parsingStarted(url);
            new HelpSetParser(factory).parseInto(src, this);
            src.close();
        }
        catch (Exception ex) {
            factory.reportMessage("Got an IOException (" + ex.getMessage() + ")", false);
        }
        for (int i = 0; i < this.subHelpSets.size(); ++i) {
            HelpSet subHS = (HelpSet)this.subHelpSets.elementAt(i);
            this.add(subHS);
        }
    }

    protected void addView(NavigatorView view) {
        this.views.addElement(view);
    }

    protected void addSubHelpSet(HelpSet hs) {
        this.subHelpSets.addElement(hs);
    }

    protected void addPresentation(Presentation presentation, boolean defaultPres) {
        this.presentations.addElement(presentation);
        if (defaultPres) {
            this.defaultPresentation = presentation;
        }
    }

    public Object getKeyData(Object context, String key) {
        Object back = null;
        Hashtable h = (Hashtable)this.localKeys.get(context);
        if (h != null) {
            back = h.get(key);
        }
        if (back == null && (h = (Hashtable)defaultKeys.get(context)) != null) {
            back = h.get(key);
        }
        return back;
    }

    public void setKeyData(Object context, String key, Object data) {
        Hashtable<String, Object> h = (Hashtable<String, Object>)this.localKeys.get(context);
        if (h == null) {
            h = new Hashtable<String, Object>();
            this.localKeys.put(context, h);
        }
        h.put(key, data);
    }

    private static void setDefaultKeyData(Object context, String key, Object data) {
        Hashtable<String, Object> h;
        if (defaultKeys == null) {
            defaultKeys = new Hashtable();
        }
        if ((h = (Hashtable<String, Object>)defaultKeys.get(context)) == null) {
            h = new Hashtable<String, Object>();
            defaultKeys.put(context, h);
        }
        h.put(key, data);
    }

    private static void debug(String str) {
    }

    static {
        HelpSet.setDefaultKeyData(implRegistry, helpBrokerClass, "javax.help.DefaultHelpBroker");
        HelpSet.setDefaultKeyData(kitTypeRegistry, "text/html", "com.sun.java.help.impl.CustomKit");
        ClassLoader cl = HelpSet.class.getClassLoader();
        if (cl != null) {
            HelpSet.setDefaultKeyData(implRegistry, helpBrokerLoader, cl);
            HelpSet.setDefaultKeyData(kitLoaderRegistry, "text/html", cl);
        }
        defaultHelpBroker = null;
    }

    private static class HelpSetParser
    implements ParserListener {
        private Stack tagStack;
        private Locale defaultLocale;
        private Locale lastLocale;
        private HelpSet myHS;
        private Locale myHSLocale;
        private HelpSetFactory factory;
        private String tagName;
        private String viewLabel;
        private String viewType;
        private String viewEngine;
        private String tagImage;
        private String helpActionImage;
        private String viewData;
        private String viewMergeType;
        private Hashtable htData;
        private boolean defaultPresentation = false;
        private boolean displayViews = true;
        private boolean displayViewImages = true;
        private Dimension size;
        private Point location;
        private String presentationTitle;
        private boolean toolbar;
        private Vector helpActions;
        private String helpAction;

        HelpSetParser(HelpSetFactory factory) {
            this.factory = factory;
        }

        synchronized void parseInto(Reader src, HelpSet hs) throws IOException {
            this.tagStack = new Stack();
            this.lastLocale = this.defaultLocale = hs.getLocale();
            this.myHS = hs;
            this.myHSLocale = hs.getLocale();
            Parser parser = new Parser(src);
            parser.addParserListener(this);
            parser.parse();
        }

        public void tagFound(ParserEvent e) {
            Hashtable ht;
            HelpSet.debug("tagFound " + e.getTag().name);
            Locale locale = null;
            Tag tag = e.getTag();
            String name = tag.name;
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            TagProperties attr = tag.atts;
            Hashtable hashtable = ht = attr == null ? null : attr.getHashtable();
            if (attr != null) {
                String lang = attr.getProperty("xml:lang");
                locale = HelpUtilities.localeFromLang(lang);
                this.viewMergeType = attr.getProperty("mergetype");
                this.helpActionImage = attr.getProperty("image");
                String value = null;
                value = attr.getProperty("width");
                if (value != null) {
                    width = Integer.parseInt(value);
                }
                value = null;
                value = attr.getProperty("height");
                if (value != null) {
                    height = Integer.parseInt(value);
                }
                value = null;
                value = attr.getProperty("x");
                if (value != null) {
                    x = Integer.parseInt(value);
                }
                value = null;
                value = attr.getProperty("y");
                if (value != null) {
                    y = Integer.parseInt(value);
                }
                value = null;
                value = attr.getProperty("default");
                if (value != null && value.equals("true")) {
                    this.defaultPresentation = true;
                }
                value = null;
                value = attr.getProperty("displayviews");
                if (value != null && value.equals("false")) {
                    this.displayViews = false;
                }
                value = null;
                value = attr.getProperty("displayviewimages");
                if (value != null && value.equals("false")) {
                    this.displayViewImages = false;
                }
            }
            if (locale == null) {
                locale = this.lastLocale;
            }
            if (name.equals("helpset")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    String version;
                    if (!locale.equals(this.defaultLocale) && !locale.equals(this.myHSLocale) && locale != null) {
                        this.myHS.setLocale(locale);
                        this.defaultLocale = locale;
                    }
                    if (attr != null && (version = attr.getProperty("version")) != null && version.compareTo("1.0") != 0 && version.compareTo("2.0") != 0) {
                        this.parsingError("helpset.unknownVersion", version);
                    }
                    this.addTag(tag, locale);
                }
                return;
            }
            if (this.tagStack.empty()) {
                this.parsingError("helpset.wrongTopLevel", name);
            }
            LangElement le = (LangElement)this.tagStack.peek();
            String pname = le.getTag().name;
            if (name.equals("title")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!pname.equals("helpset") && !pname.equals("presentation")) {
                        this.wrongParent(name, pname);
                    }
                    if (!locale.equals(this.defaultLocale) && !locale.equals(this.myHSLocale)) {
                        this.wrongLocale(locale, this.defaultLocale, this.myHSLocale);
                    }
                    this.addTag(tag, locale);
                }
            } else if (name.equals("homeID")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!pname.equals("maps")) {
                        this.wrongParent(name, pname);
                    }
                    this.addTag(tag, locale);
                }
            } else if (name.equals("mapref")) {
                if (tag.isEnd && !tag.isEmpty) {
                    this.removeTag(tag);
                } else {
                    if (!pname.equals("maps")) {
                        this.wrongParent(name, pname);
                    }
                    if (!tag.isEmpty) {
                        this.addTag(tag, locale);
                    }
                    this.factory.processMapRef(this.myHS, ht);
                }
            } else if (name.equals("data")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!pname.equals("view")) {
                        this.wrongParent(name, pname);
                    } else {
                        this.addTag(tag, locale);
                    }
                    this.htData = ht;
                }
            } else if (name.equals("name") || name.equals("type") || name.equals("image")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if (!pname.equals("view") && !pname.equals("presentation")) {
                    this.wrongParent(name, pname);
                } else {
                    this.addTag(tag, locale);
                }
            } else if (name.equals("label")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if (!pname.equals("view")) {
                    this.wrongParent(name, pname);
                } else {
                    if (!locale.equals(this.defaultLocale) && !locale.equals(this.myHSLocale)) {
                        this.wrongLocale(locale, this.defaultLocale, this.myHSLocale);
                    }
                    this.addTag(tag, locale);
                }
            } else if (name.equals("view")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                    if (this.tagImage != null) {
                        if (this.htData == null) {
                            this.htData = new Hashtable();
                        }
                        this.htData.put("imageID", this.tagImage);
                    }
                    if (this.viewMergeType != null) {
                        if (this.htData == null) {
                            this.htData = new Hashtable();
                        }
                        this.htData.put("mergetype", this.viewMergeType);
                    }
                    this.factory.processView(this.myHS, this.tagName, this.viewLabel, this.viewType, ht, this.viewData, this.htData, locale);
                    this.tagName = null;
                    this.viewLabel = null;
                    this.viewType = null;
                    this.tagImage = null;
                    this.viewData = null;
                    this.htData = null;
                    this.viewMergeType = null;
                } else if (!pname.equals("helpset")) {
                    this.wrongParent(name, pname);
                } else {
                    this.addTag(tag, locale);
                }
            } else if (name.equals("presentation")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                    this.factory.processPresentation(this.myHS, this.tagName, this.defaultPresentation, this.displayViews, this.displayViewImages, this.size, this.location, this.presentationTitle, this.tagImage, this.toolbar, this.helpActions);
                    this.tagName = null;
                    this.defaultPresentation = false;
                    this.displayViews = true;
                    this.displayViewImages = true;
                    this.size = null;
                    this.location = null;
                    this.presentationTitle = null;
                    this.tagImage = null;
                    this.toolbar = false;
                    this.helpActions = null;
                } else if (!pname.equals("helpset")) {
                    this.wrongParent(name, pname);
                } else {
                    this.addTag(tag, locale);
                }
            } else if (name.equals("size")) {
                if (tag.isEnd) {
                    if (this.size == null) {
                        this.size = new Dimension(width, height);
                    } else {
                        this.size.setSize(width, height);
                    }
                    width = 0;
                    height = 0;
                    if (!tag.isEmpty) {
                        this.removeTag(tag);
                    }
                } else if (!pname.equals("presentation")) {
                    this.wrongParent(name, pname);
                } else {
                    this.addTag(tag, locale);
                    this.size = new Dimension();
                }
            } else if (name.equals("location")) {
                if (tag.isEnd) {
                    if (this.location == null) {
                        this.location = new Point(x, y);
                    } else {
                        this.location.setLocation(x, y);
                    }
                    x = 0;
                    y = 0;
                    if (!tag.isEmpty) {
                        this.removeTag(tag);
                    }
                } else if (!pname.equals("presentation")) {
                    this.wrongParent(name, pname);
                } else {
                    this.addTag(tag, locale);
                    this.location = new Point();
                }
            } else if (name.equals("toolbar")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if (!pname.equals("presentation")) {
                    this.wrongParent(name, pname);
                } else {
                    this.addTag(tag, locale);
                    this.helpActions = new Vector();
                    this.toolbar = true;
                }
            } else if (name.equals("helpaction")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                    if (this.helpAction != null) {
                        Hashtable<String, String> tmp = new Hashtable<String, String>();
                        this.helpActions.add(new HelpSetFactory.HelpAction(this.helpAction, tmp));
                        if (this.helpActionImage != null) {
                            tmp.put("image", this.helpActionImage);
                            this.helpActionImage = null;
                        }
                        this.helpAction = null;
                    }
                } else if (!pname.equals("toolbar")) {
                    this.wrongParent(name, pname);
                } else {
                    this.addTag(tag, locale);
                }
            } else if (name.equals("maps")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if (!pname.equals("helpset")) {
                    this.wrongParent(name, pname);
                } else {
                    this.addTag(tag, locale);
                }
            } else if (name.equals("subhelpset")) {
                if (tag.isEnd && !tag.isEmpty) {
                    this.removeTag(tag);
                } else {
                    if (!tag.isEmpty) {
                        this.addTag(tag, locale);
                    }
                    this.factory.processSubHelpSet(this.myHS, ht);
                }
            } else if (name.equals("impl")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if (!pname.equals("helpset")) {
                    this.wrongParent(name, pname);
                } else {
                    this.addTag(tag, locale);
                }
            } else if (name.equals("helpsetregistry")) {
                if (tag.isEnd && !tag.isEmpty) {
                    this.removeTag(tag);
                } else if (!pname.equals("impl")) {
                    this.wrongParent(name, pname);
                } else {
                    String hbClass;
                    if (!tag.isEnd) {
                        this.addTag(tag, locale);
                    }
                    if (attr != null && (hbClass = attr.getProperty("helpbrokerclass")) != null) {
                        this.myHS.setKeyData(implRegistry, HelpSet.helpBrokerClass, hbClass);
                    }
                }
            } else if (name.equals("viewerregistry")) {
                if (tag.isEnd && !tag.isEmpty) {
                    this.removeTag(tag);
                } else if (!pname.equals("impl")) {
                    this.wrongParent(name, pname);
                } else {
                    if (!tag.isEnd) {
                        this.addTag(tag, locale);
                    }
                    if (attr != null) {
                        String viewerType = attr.getProperty("viewertype");
                        String viewerClass = attr.getProperty("viewerclass");
                        if (viewerType != null && viewerClass != null) {
                            ClassLoader cl = (class$javax$help$HelpSet == null ? (class$javax$help$HelpSet = HelpSet.class$("javax.help.HelpSet")) : class$javax$help$HelpSet).getClassLoader();
                            this.myHS.setKeyData(kitTypeRegistry, viewerType, viewerClass);
                            this.myHS.setKeyData(kitLoaderRegistry, viewerType, cl);
                        }
                    }
                }
            }
        }

        public void piFound(ParserEvent e) {
            this.factory.processPI(this.myHS, e.getTarget(), e.getData());
        }

        public void doctypeFound(ParserEvent e) {
            this.factory.processDOCTYPE(e.getRoot(), e.getPublicId(), e.getSystemId());
        }

        private void checkNull(String name, String t) {
            if (!t.equals("")) {
                this.parsingError("helpset.wrongText", name, t);
            }
        }

        public void textFound(ParserEvent e) {
            HelpSet.debug("textFound: ");
            HelpSet.debug("  text: " + e.getText());
            if (this.tagStack.empty()) {
                return;
            }
            LangElement le = (LangElement)this.tagStack.peek();
            Tag tag = le.getTag();
            TagProperties attr = tag.atts;
            Hashtable ht = attr == null ? null : attr.getHashtable();
            String text = e.getText().trim();
            String name = tag.name;
            if (name.equals("helpset")) {
                this.checkNull("helpset", text);
                return;
            }
            int depth = this.tagStack.size();
            String pname = "";
            if (depth >= 2) {
                le = (LangElement)this.tagStack.elementAt(depth - 2);
                pname = le.getTag().name;
            }
            if (name.equals("title")) {
                if (pname.equals("helpset")) {
                    this.factory.processTitle(this.myHS, text);
                } else {
                    this.presentationTitle = text.trim();
                }
            } else if (name.equals("homeID")) {
                this.factory.processHomeID(this.myHS, text);
            } else if (name.equals("mapref")) {
                this.checkNull("mapref", text);
            } else if (name.equals("subhelpset")) {
                this.checkNull("subhelpset", text);
            } else if (name.equals("data")) {
                this.viewData = text.trim();
            } else if (name.equals("label")) {
                this.viewLabel = text.trim();
            } else if (name.equals("name")) {
                this.tagName = text.trim();
            } else if (name.equals("helpaction")) {
                this.helpAction = text.trim();
            } else if (name.equals("type")) {
                this.viewType = text.trim();
            } else if (name.equals("image")) {
                this.tagImage = text.trim();
            } else if (name.equals("view")) {
                this.checkNull("view", text);
            } else if (name.equals("maps")) {
                this.checkNull("maps", text);
            } else if (name.equals("mergetype")) {
                this.checkNull("mergetype", text);
            }
        }

        public void errorFound(ParserEvent e) {
        }

        public void commentFound(ParserEvent e) {
        }

        protected void addTag(Tag tag, Locale locale) {
            LangElement el = new LangElement(tag, locale);
            this.tagStack.push(el);
            if (this.lastLocale == null) {
                this.lastLocale = locale;
                return;
            }
            if (locale == null) {
                this.lastLocale = locale;
                return;
            }
            if (!this.lastLocale.equals(locale)) {
                this.lastLocale = locale;
            }
        }

        protected void removeTag(Tag tag) {
            LangElement el;
            String name = tag.name;
            Locale newLocale = null;
            do {
                if (this.tagStack.empty()) {
                    this.unbalanced(name);
                }
                el = (LangElement)this.tagStack.pop();
            } while (!el.getTag().name.equals(name));
            if (this.tagStack.empty()) {
                newLocale = this.defaultLocale;
            } else {
                el = (LangElement)this.tagStack.peek();
                newLocale = el.getLocale();
            }
            if (this.lastLocale == null) {
                this.lastLocale = newLocale;
                return;
            }
            if (newLocale == null) {
                this.lastLocale = newLocale;
                return;
            }
            if (!this.lastLocale.equals(newLocale)) {
                this.lastLocale = newLocale;
            }
        }

        private void parsingError(String key) {
            String s = HelpUtilities.getText(key);
            this.factory.reportMessage(s, false);
        }

        private void parsingError(String key, String s) {
            String msg = HelpUtilities.getText(key, s);
            this.factory.reportMessage(msg, false);
        }

        private void parsingError(String key, String s1, String s2) {
            String msg = HelpUtilities.getText(key, s1, s2);
            this.factory.reportMessage(msg, false);
        }

        private void wrongParent(String name, String pname) {
            this.parsingError("helpset.wrongParent", name, pname);
        }

        private void unbalanced(String name) {
            this.parsingError("helpset.unbalanced", name);
        }

        private void wrongLocale(Locale found, Locale l1, Locale l2) {
            String msg = HelpUtilities.getText("helpset.wrongLocale", found.toString(), l1.toString(), l2.toString());
            this.factory.reportMessage(msg, true);
        }
    }

    public static class Presentation {
        private String name;
        private boolean displayViews;
        private boolean displayViewImages;
        private Dimension size;
        private Point location;
        private String title;
        private boolean toolbar;
        private Vector helpActions;
        private Map.ID imageID;

        public Presentation(String name, boolean displayViews, boolean displayViewImages, Dimension size, Point location, String title, Map.ID imageID, boolean toolbar, Vector helpActions) {
            this.name = name;
            this.displayViews = displayViews;
            this.displayViewImages = displayViewImages;
            this.size = size;
            this.location = location;
            this.title = title;
            this.imageID = imageID;
            this.toolbar = toolbar;
            this.helpActions = helpActions;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public Map.ID getImageID() {
            return this.imageID;
        }

        public boolean isViewDisplayed() {
            return this.displayViews;
        }

        public boolean isViewImagesDisplayed() {
            return this.displayViewImages;
        }

        public Dimension getSize() {
            return this.size;
        }

        public Point getLocation() {
            return this.location;
        }

        public boolean isToolbar() {
            return this.toolbar;
        }

        public Enumeration getHelpActions(HelpSet hs, Object control) {
            Vector<HelpAction> actions = new Vector<HelpAction>();
            ClassLoader loader = hs.getLoader();
            if (this.helpActions == null) {
                return actions.elements();
            }
            Enumeration actionEnum = this.helpActions.elements();
            while (actionEnum.hasMoreElements()) {
                HelpSetFactory.HelpAction act = (HelpSetFactory.HelpAction)actionEnum.nextElement();
                try {
                    Class[] types = new Class[]{class$java$lang$Object == null ? HelpSet.class$("java.lang.Object") : class$java$lang$Object};
                    Object[] args = new Object[]{control};
                    Class<?> klass = loader == null ? Class.forName(act.className) : loader.loadClass(act.className);
                    Constructor<?> konstructor = klass.getConstructor(types);
                    HelpAction action = (HelpAction)konstructor.newInstance(args);
                    if (act.attr.containsKey("image")) {
                        String imageID = (String)act.attr.get("image");
                        try {
                            Map.ID id = Map.ID.create(imageID, hs);
                            ImageIcon icon = null;
                            Map map = hs.getCombinedMap();
                            URL url = map.getURLFromID(id);
                            icon = new ImageIcon(url);
                            action.putValue("icon", icon);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    actions.add(action);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Could not create HelpAction " + act.className);
                }
            }
            return actions.elements();
        }
    }

    public static class DefaultHelpSetFactory
    implements HelpSetFactory {
        private Vector messages = new Vector();
        private URL source;
        private boolean validParse = true;

        public void parsingStarted(URL source) {
            if (source == null) {
                throw new NullPointerException("source");
            }
            this.source = source;
        }

        public void processDOCTYPE(String root, String publicID, String systemID) {
            if (publicID == null || publicID.compareTo(HelpSet.publicIDString) != 0 && publicID.compareTo(HelpSet.publicIDString_V2) != 0) {
                this.parsingError("helpset.wrongPublicID", publicID);
            }
        }

        public void processPI(HelpSet hs, String target, String data) {
        }

        public void processTitle(HelpSet hs, String value) {
            String title = hs.getTitle();
            if (title != null && !title.equals("")) {
                this.parsingWarning("helpset.wrongTitle", value, title);
            }
            hs.setTitle(value);
        }

        public void processHomeID(HelpSet hs, String value) {
            Map.ID homeID = hs.getHomeID();
            if (homeID == null || homeID.equals("")) {
                hs.setHomeID(value);
            } else {
                this.parsingError("helpset.wrongHomeID", value, homeID.id);
            }
        }

        public void processMapRef(HelpSet hs, Hashtable attributes) {
            String spec = (String)attributes.get("location");
            URL hsURL = hs.getHelpSetURL();
            try {
                FlatMap map = new FlatMap(new URL(hsURL, spec), hs);
                Map omap = hs.getLocalMap();
                if (omap == null) {
                    HelpSet.debug("map is null");
                    hs.setLocalMap(map);
                } else if (omap instanceof TryMap) {
                    HelpSet.debug("map is TryMap");
                    ((TryMap)omap).add(map);
                    hs.setLocalMap(omap);
                } else {
                    HelpSet.debug("map is not TryMap");
                    TryMap tmap = new TryMap();
                    tmap.add(omap);
                    tmap.add(map);
                    hs.setLocalMap(tmap);
                }
            }
            catch (MalformedURLException ee) {
                this.parsingError("helpset.malformedURL", spec);
            }
            catch (IOException ee) {
                this.parsingError("helpset.incorrectURL", spec);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }

        public void processView(HelpSet hs, String name, String label, String type, Hashtable viewAttributes, String data, Hashtable dataAttributes, Locale locale) {
            try {
                NavigatorView view;
                if (data != null) {
                    if (dataAttributes == null) {
                        dataAttributes = new Hashtable<String, String>();
                    }
                    dataAttributes.put("data", data);
                }
                if ((view = NavigatorView.create(hs, name, label, locale, type, dataAttributes)) != null) {
                    hs.addView(view);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }

        public void processPresentation(HelpSet hs, String name, boolean defaultPresentation, boolean displayViews, boolean displayViewImages, Dimension size, Point location, String title, String imageID, boolean toolbar, Vector helpActions) {
            Map.ID imageMapID = null;
            try {
                imageMapID = Map.ID.create(imageID, hs);
            }
            catch (BadIDException bex2) {
                // empty catch block
            }
            try {
                Presentation presentation = new Presentation(name, displayViews, displayViewImages, size, location, title, imageMapID, toolbar, helpActions);
                if (presentation != null) {
                    hs.addPresentation(presentation, defaultPresentation);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }

        public void processSubHelpSet(HelpSet hs, Hashtable attributes) {
            HelpSet.debug("createSubHelpSet");
            String spec = (String)attributes.get("location");
            URL base = hs.getHelpSetURL();
            HelpSet.debug("  location: " + spec);
            HelpSet.debug("  base helpset: " + base);
            URL u = null;
            HelpSet subHS = null;
            try {
                u = new URL(base, spec);
                InputStream is = u.openStream();
                if (is != null && (subHS = new HelpSet(hs.getLoader(), u)) != null) {
                    hs.addSubHelpSet(subHS);
                }
            }
            catch (MalformedURLException ex) {
            }
            catch (IOException ex) {
            }
            catch (HelpSetException ex) {
                this.parsingError("helpset.subHelpSetTrouble", spec);
            }
        }

        public void reportMessage(String msg, boolean validParse) {
            this.messages.addElement(msg);
            this.validParse = this.validParse && validParse;
        }

        public Enumeration listMessages() {
            return this.messages.elements();
        }

        public HelpSet parsingEnded(HelpSet hs) {
            HelpSet back = hs;
            if (!this.validParse) {
                back = null;
                String errMsg = "Parsing failed for " + this.source;
                this.messages.addElement(errMsg);
                Enumeration e = this.messages.elements();
                while (e.hasMoreElements()) {
                    String msg = (String)e.nextElement();
                    if (errorMsg == null) {
                        errorMsg = msg;
                        continue;
                    }
                    errorMsg = errorMsg + "\n";
                    errorMsg = errorMsg + msg;
                }
            }
            return back;
        }

        private void parsingError(String key) {
            String s = HelpUtilities.getText(key);
            this.reportMessage(s, false);
        }

        private void parsingError(String key, String s) {
            String msg = HelpUtilities.getText(key, s);
            this.reportMessage(msg, false);
        }

        private void parsingError(String key, String s1, String s2) {
            String msg = HelpUtilities.getText(key, s1, s2);
            this.reportMessage(msg, false);
        }

        private void parsingWarning(String key, String s1, String s2) {
            String msg = HelpUtilities.getText(key, s1, s2);
            this.reportMessage(msg, true);
        }
    }
}

