/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.openmbean.TabularData;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.intf.config.Application;
import org.glassfish.admin.amx.intf.config.ApplicationRef;
import org.glassfish.admin.amx.intf.config.Applications;
import org.glassfish.admin.amx.intf.config.Property;
import org.glassfish.admin.amx.monitoring.ServerMon;
import org.glassfish.admingui.common.handlers.SecurityHandler;
import org.glassfish.admingui.common.util.AppUtil;
import org.glassfish.admingui.common.util.DeployUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;
import org.glassfish.admingui.common.util.V3AMXUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppHandlers {
    private static List skipLifecyclePropsList = new ArrayList();

    public static void getApplicationEnabled(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        boolean enable = AppUtil.isApplicationEnabled(objectNameStr);
        handlerCtx.setOutputValue("enabled", (Object)Boolean.toString(enable));
    }

    public static void showContextRoot(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        String isEar = V3AMX.getPropValue(V3AMX.objectNameToProxy(objectNameStr), "isComposite");
        if (isEar == null || !isEar.equals("true")) {
            handlerCtx.setOutputValue("value", (Object)Boolean.TRUE);
        } else {
            handlerCtx.setOutputValue("value", (Object)Boolean.FALSE);
        }
    }

    public static void saveApplicationInfo(HandlerContext handlerCtx) {
        Map appAttr = (Map)handlerCtx.getInputValue("appAttr");
        Map appRefAttr = (Map)handlerCtx.getInputValue("appRefAttr");
        String appObjectName = (String)handlerCtx.getInputValue("appObjectName");
        String appRefObjectName = (String)handlerCtx.getInputValue("appRefObjectName");
        V3AMX.setAttribute(appObjectName, new Attribute("ContextRoot", appAttr.get("ContextRoot")));
        V3AMX.setAttribute(appObjectName, new Attribute("Description", appAttr.get("Description")));
        String enStr = (String)appAttr.get("Enabled");
        if (enStr == null) {
            enStr = "false";
        }
        V3AMX.setAttribute(appRefObjectName, new Attribute("Enabled", enStr));
        V3AMX.setAttribute(appRefObjectName, new Attribute("VirtualServers", appRefAttr.get("VirtualServers")));
    }

    public static void getSubComponents(HandlerContext handlerCtx) {
        ArrayList<Map> result = new ArrayList<Map>();
        String appName = (String)handlerCtx.getInputValue("appName");
        Map modules = V3AMX.getInstance().getApplication(appName).childrenMap("module");
        for (AMXProxy oneModule : modules.values()) {
            String jwEnabled;
            String launchLink;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            List<String> snifferList = AppUtil.getSnifferListOfModule(oneModule);
            String moduleName = oneModule.getName();
            oneRow.put("moduleName", moduleName);
            oneRow.put("name", " ----------- ");
            oneRow.put("type", " ----------- ");
            oneRow.put("hasEndpoint", false);
            oneRow.put("hasLaunch", false);
            oneRow.put("hasAppClientLaunch", false);
            oneRow.put("sniffers", snifferList.toString());
            Application application = V3AMX.getInstance().getApplication(appName);
            if (snifferList.contains("web") && AppUtil.isApplicationEnabled((AMXProxy)application) && !GuiUtil.isEmpty(launchLink = V3AMXUtil.getLaunchLink((String)GuiUtil.getSessionValue("serverName"), appName))) {
                oneRow.put("hasLaunch", true);
                String ctxRoot = WebAppHandlers.calContextRoot(V3AMX.getInstance().getRuntime().getContextRoot(appName, moduleName));
                oneRow.put("launchLink", launchLink + ctxRoot);
            }
            if (snifferList.contains("appclient") && !GuiUtil.isEmpty(jwEnabled = V3AMX.getPropValue((AMXProxy)V3AMX.getInstance().getApplication(appName), "javaWebStartEnabled")) && jwEnabled.equals("true")) {
                String appClientLaunch = V3AMX.getInstance().getRuntime().getRelativeJWSURI(appName, moduleName);
                oneRow.put("hasAppClientLaunch", !GuiUtil.isEmpty(appClientLaunch));
            }
            result.add(oneRow);
            WebAppHandlers.getSubComponentDetail(appName, moduleName, snifferList, result);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getAppclinetLaunchURL(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String moduleName = (String)handlerCtx.getInputValue("moduleName");
        String appClientLaunch = V3AMX.getInstance().getRuntime().getRelativeJWSURI(appName, moduleName);
        if (!GuiUtil.isEmpty(appClientLaunch)) {
            String httpLink = V3AMXUtil.getLaunchLink((String)GuiUtil.getSessionValue("serverName"), appName);
            handlerCtx.setOutputValue("url", (Object)(httpLink + appClientLaunch));
        }
    }

    public static void getEndpointInfo(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String moduleName = (String)handlerCtx.getInputValue("moduleName");
        String componentName = (String)handlerCtx.getInputValue("subComponentName");
        String type = (String)handlerCtx.getInputValue("type");
        HashMap<String, Object> result = new HashMap<String, Object>();
        TabularData endpointMap = WebAppHandlers.getEndpointMap(appName, moduleName, componentName, type);
        if (endpointMap.isEmpty()) {
            handlerCtx.setOutputValue("result", result);
        }
        result.put("appName", (String)endpointMap.get(new Object[]{"appName"}).get("value"));
        result.put("endpointName", (String)endpointMap.get(new Object[]{"endpointName"}).get("value"));
        result.put("namespace", (String)endpointMap.get(new Object[]{"implClass"}).get("value"));
        result.put("serviceName", (String)endpointMap.get(new Object[]{"namespace"}).get("value"));
        result.put("portName", (String)endpointMap.get(new Object[]{"portName"}).get("value"));
        result.put("implClass", (String)endpointMap.get(new Object[]{"implClass"}).get("value"));
        result.put("address", (String)endpointMap.get(new Object[]{"address"}).get("value"));
        result.put("wsdl", (String)endpointMap.get(new Object[]{"wsdl"}).get("value"));
        result.put("tester", (String)endpointMap.get(new Object[]{"tester"}).get("value"));
        result.put("implType", (String)endpointMap.get(new Object[]{"implType"}).get("value"));
        result.put("deploymentType", (String)endpointMap.get(new Object[]{"deploymentType"}).get("value"));
        String launchLink = V3AMXUtil.getLaunchLink((String)GuiUtil.getSessionValue("serverName"), appName);
        if (GuiUtil.isEmpty(launchLink)) {
            result.put("disableTester", "true");
            result.put("hasWsdlLink", false);
        } else {
            result.put("disableTester", "false");
            result.put("hasWsdlLink", true);
            result.put("testLink", launchLink + result.get("tester"));
            result.put("wsdlLink", launchLink + result.get("wsdl"));
        }
        GuiUtil.getLogger().fine("Endpoint Info for " + appName + "#" + componentName + " : " + result);
        handlerCtx.setOutputValue("result", result);
    }

    private static List<Map> getSubComponentDetail(String appName, String moduleName, List<String> snifferList, List<Map> result) {
        Map sMap = V3AMX.getInstance().getRuntime().getSubComponentsOfModule(appName, moduleName);
        for (String cName : sMap.keySet()) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("moduleName", moduleName);
            oneRow.put("name", cName);
            oneRow.put("type", sMap.get(cName));
            oneRow.put("hasLaunch", false);
            oneRow.put("sniffers", "");
            oneRow.put("hasEndpoint", false);
            oneRow.put("hasAppClientLaunch", false);
            if (snifferList.contains("webservices") && !WebAppHandlers.getEndpointMap(appName, moduleName, cName, (String)sMap.get(cName)).isEmpty()) {
                oneRow.put("hasEndpoint", true);
            }
            result.add(oneRow);
        }
        return result;
    }

    private static TabularData getEndpointMap(String appName, String moduleName, String componentName, String type) {
        ServerMon serverMon = (ServerMon)((ServerMon)V3AMX.getInstance().getDomainRoot().getMonitoringRoot().getServerMon().get("server")).as(ServerMon.class);
        AMXConfigProxy webDeployment = (AMXConfigProxy)((AMXProxy)serverMon.childrenMap("web-service-mon").get("webservices-deployment")).as(AMXConfigProxy.class);
        Object[] params = new String[]{appName, moduleName, componentName};
        String[] sig = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        TabularData endpointMap = null;
        endpointMap = type.equalsIgnoreCase("Servlet") ? (TabularData)webDeployment.invokeOp("getServlet109Endpoint", params, sig) : (TabularData)webDeployment.invokeOp("getEjb109Endpoint", params, sig);
        return endpointMap;
    }

    public static void getDeployedAppsInfo(HandlerContext handlerCtx) {
        String serverName = (String)handlerCtx.getInputValue("serverName");
        String filterValue = (String)handlerCtx.getInputValue("filterValue");
        TreeSet<String> filters = new TreeSet<String>();
        filters.add("");
        if (GuiUtil.isEmpty(filterValue)) {
            filterValue = null;
        }
        ArrayList result = new ArrayList();
        Map application = V3AMX.getInstance().getApplications().childrenMap("application");
        for (AMXProxy oneApp : application.values()) {
            if (V3AMX.getPropValue(oneApp, "isLifecycle") != null) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("name", oneApp.getName());
            oneRow.put("selected", false);
            boolean enable = AppUtil.isApplicationEnabled(oneApp);
            String enableURL = enable ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
            oneRow.put("enableURL", enableURL);
            List sniffersList = AppUtil.getAllSniffers(oneApp);
            oneRow.put("sniffersList", sniffersList);
            oneRow.put("sniffers", sniffersList.toString());
            for (int ix = 0; ix < sniffersList.size(); ++ix) {
                filters.add((String)sniffersList.get(ix));
            }
            if (filterValue != null && !sniffersList.contains(filterValue)) continue;
            WebAppHandlers.getLaunchInfo(serverName, oneApp, oneRow);
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("filters", new ArrayList(filters));
    }

    public static void getApplicationType(HandlerContext handlerCtx) {
        List sniffersList;
        String appName = (String)handlerCtx.getInputValue("appName");
        Application application = V3AMX.getInstance().getApplication(appName);
        String appType = V3AMX.getPropValue((AMXProxy)application, "isComposite");
        appType = "true".equals(appType) ? "ear" : ((sniffersList = AppUtil.getAllSniffers((AMXProxy)application)).contains("connector") ? "rar" : (sniffersList.contains("web") ? "war" : (sniffersList.contains("appclient") ? "appclient" : (String)sniffersList.get(0))));
        handlerCtx.setOutputValue("appType", (Object)appType);
    }

    public static void getLifecyclesInfo(HandlerContext handlerCtx) {
        ArrayList result = new ArrayList();
        Map application = V3AMX.getInstance().getApplications().childrenMap("application");
        for (AMXProxy oneApp : application.values()) {
            if (V3AMX.getPropValue(oneApp, "isLifecycle") == null) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("Name", oneApp.getName());
            oneRow.put("selected", false);
            boolean enable = AppUtil.isApplicationEnabled(oneApp);
            String enableURL = enable ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
            oneRow.put("enableURL", enableURL);
            String className = V3AMX.getPropValue(oneApp, "class-name");
            oneRow.put("className", className == null ? "" : className);
            String order = V3AMX.getPropValue(oneApp, "load-order");
            oneRow.put("loadOrder", order == null ? "" : order);
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getLifecycleAttrEdit(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("Name");
        Application app = V3AMX.getInstance().getApplication(appName);
        Map origProps = app.getProperty();
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put("Name", appName);
        attrMap.put("class-name", WebAppHandlers.getA(origProps, "class-name"));
        attrMap.put("classpath", WebAppHandlers.getA(origProps, "classpath"));
        attrMap.put("load-order", WebAppHandlers.getA(origProps, "load-order"));
        String fatal = WebAppHandlers.getA(origProps, "is-failure-fatal");
        attrMap.put("is-failure-fatal", fatal.equals("") ? "false" : "true");
        List props = V3AMX.getChildrenMapForTableList((AMXProxy)app, "property", skipLifecyclePropsList);
        handlerCtx.setOutputValue("attrMap", attrMap);
        handlerCtx.setOutputValue("properties", (Object)props);
    }

    public static void saveLifecycle(HandlerContext handlerCtx) {
        String edit = (String)handlerCtx.getInputValue("edit");
        Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
        Map attrMap2 = (Map)handlerCtx.getInputValue("attrMap2");
        List propList = (List)handlerCtx.getInputValue("propList");
        String name = (String)attrMap.get("Name");
        HashMap<String, Object> aMap = new HashMap<String, Object>();
        aMap.put("Name", name);
        aMap.put("Enabled", attrMap2.get("Enabled") == null ? "false" : "true");
        aMap.put("Description", attrMap.get("Description"));
        try {
            attrMap.put("isLifecycle", "true");
            SecurityHandler.putOptional(attrMap, propList, "isLifecycle", "isLifecycle");
            SecurityHandler.putOptional(attrMap, propList, "class-name", "class-name");
            SecurityHandler.putOptional(attrMap, propList, "classpath", "classpath");
            SecurityHandler.putOptional(attrMap, propList, "load-order", "load-order");
            if (attrMap2.get("is-failure-fatal") != null) {
                SecurityHandler.putOptional(attrMap, propList, "is-failure-fatal", "is-failure-fatal");
            }
            Attribute vsAttr = null;
            String[] vs = (String[])attrMap2.get("selectedVS");
            if (vs != null && vs.length > 0 && !vs[0].equals("")) {
                if (!GuiUtil.isEmpty(vs[0])) {
                    String vsTargets = GuiUtil.arrayToString(vs, ",");
                    vsAttr = new Attribute("VirtualServers", vsTargets);
                }
            } else {
                Set vsSet = V3AMX.getInstance().getDomainRoot().getQueryMgr().queryType("virtual-server");
                ArrayList<String> vsList = new ArrayList<String>();
                for (AMXProxy oneVs : vsSet) {
                    vsList.add(oneVs.getName());
                }
                vsList.remove("__asadmin");
                vsAttr = new Attribute("VirtualServers", GuiUtil.listToString(vsList, ","));
            }
            if (edit.equals("true")) {
                Application app = V3AMX.getInstance().getApplication(name);
                V3AMX.setAttributes((Object)app.objectName(), aMap);
                V3AMX.setProperties(app.objectName().toString(), propList, false);
                ApplicationRef appRef = V3AMX.getInstance().getApplicationRef("server", name);
                V3AMX.setAttribute(appRef.objectName(), vsAttr);
                String enable = (String)attrMap2.get("Enabled");
                V3AMX.setAttribute(appRef.objectName(), new Attribute("Enabled", enable == null ? "false" : "true"));
            } else {
                Applications apps = V3AMX.getInstance().getApplications();
                List pList = V3AMX.verifyPropertyList(propList);
                Map[] propMaps = pList.toArray(new Map[pList.size()]);
                aMap.put("object-type", "user");
                aMap.put(Util.deduceType(Property.class), propMaps);
                apps.createChild("application", aMap);
                AMXConfigProxy server = (AMXConfigProxy)V3AMX.getInstance().getDomain().getServers().getServer().get("server");
                attrMap2.put("Name", name);
                if (attrMap2.get("Enabled") == null) {
                    attrMap2.put("Enabled", "false");
                }
                attrMap2.remove("selectedVS");
                attrMap2.put("VirtualServers", vsAttr.getValue());
                server.createChild("application-ref", attrMap2);
                attrMap2.put("selectedVS", vs);
            }
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("saveLifecycle failed.");
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void changeLifecycleStatus(HandlerContext handlerCtx) {
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        String status = enabled ? "true" : "false";
        List selectedRows = obj;
        try {
            for (int i = 0; i < selectedRows.size(); ++i) {
                Map oneRow = (Map)selectedRows.get(i);
                String appName = (String)oneRow.get("Name");
                V3AMX.getInstance().getApplicationRef("server", appName).setEnabled(status);
                V3AMX.getInstance().getApplication(appName).setEnabled(status);
                String msg = GuiUtil.getMessage(enabled ? "msg.enableSuccessfulLifecycle" : "msg.disableSuccessfulLifecycle");
                GuiUtil.prepareAlert(handlerCtx, "success", msg, null);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static String getA(Map<String, Property> attrs, String key) {
        Property val = attrs.get(key);
        return val == null ? "" : val.getValue();
    }

    private static void getLaunchInfo(String serverName, AMXProxy oneApp, Map oneRow) {
        Map attrs = oneApp.attributesMap();
        String contextRoot = (String)attrs.get("ContextRoot");
        String appName = (String)attrs.get("Name");
        if (contextRoot == null) {
            contextRoot = "";
        }
        boolean enabled = AppUtil.isApplicationEnabled(oneApp);
        oneRow.put("contextRoot", contextRoot);
        oneRow.put("hasLaunch", false);
        if (!enabled || contextRoot.equals("")) {
            return;
        }
        String launchLink = V3AMXUtil.getLaunchLink(serverName, appName);
        if (!GuiUtil.isEmpty(launchLink)) {
            oneRow.put("hasLaunch", true);
            oneRow.put("launchLink", launchLink + WebAppHandlers.calContextRoot(contextRoot));
        }
    }

    public static void restartApplication(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        if (DeployUtil.restartApplication(appName, handlerCtx)) {
            GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("org.glassfish.web.admingui.Strings", "restart.successPE"), null);
        }
    }

    public static void EnsureDefaultWebModule(HandlerContext handlerCtx) {
        ApplicationRef appRef;
        String vsStr;
        List vsList;
        String vsObjStr = (String)handlerCtx.getInputValue("vsObjStr");
        String webModule = (String)V3AMX.getAttribute(vsObjStr, "DefaultWebModule");
        String vsName = (String)V3AMX.getAttribute(vsObjStr, "Name");
        if (GuiUtil.isEmpty(webModule)) {
            return;
        }
        String appName = webModule;
        int index = webModule.indexOf("#");
        if (index != -1) {
            appName = webModule.substring(0, index);
        }
        if ((vsList = GuiUtil.parseStringList(vsStr = (appRef = V3AMX.getInstance().getApplicationRef("server", appName)).getVirtualServers(), ",")).contains(vsName)) {
            return;
        }
        vsStr = vsStr + "," + vsName;
        appRef.setVirtualServers(vsStr);
        DeployUtil.restartApplication(appName, handlerCtx);
    }

    public static void getVsForDeployment(HandlerContext handlerCtx) {
        Set vsSet = V3AMX.getInstance().getConfig("server-config").getHttpService().getVirtualServer().keySet();
        vsSet.remove("__asadmin");
        handlerCtx.setOutputValue("result", new ArrayList(vsSet));
    }

    public static void checkVsOfAppRef(HandlerContext handlerCtx) {
        Map appRefMap = V3AMX.getInstance().getServer("server").getApplicationRef();
        Map vsMap = V3AMX.getInstance().getConfig("server-config").getHttpService().getVirtualServer();
        for (ApplicationRef appRef : appRefMap.values()) {
            String vsStr = appRef.getVirtualServers();
            List vsList = GuiUtil.parseStringList(vsStr, ",");
            boolean changed = false;
            String newVS = "";
            for (String oneVs : vsList) {
                if (!vsMap.containsKey(oneVs)) {
                    changed = true;
                    continue;
                }
                newVS = newVS + "," + oneVs;
            }
            if (!changed) continue;
            newVS = newVS.substring(1);
            appRef.setVirtualServers(newVS);
        }
    }

    private static String calContextRoot(String contextRoot) {
        String ctxRoot = "";
        ctxRoot = contextRoot == null || contextRoot.equals("") || contextRoot.equals("/") ? "/" : (contextRoot.startsWith("/") ? contextRoot : "/" + contextRoot);
        return ctxRoot;
    }

    static {
        skipLifecyclePropsList.add("class-name");
        skipLifecyclePropsList.add("classpath");
        skipLifecyclePropsList.add("load-order");
        skipLifecyclePropsList.add("is-failure-fatal");
        skipLifecyclePropsList.add("isLifecycle");
    }
}

