/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebConnector;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.WebModuleContextConfig;
import com.sun.enterprise.web.WebModuleDecorator;
import com.sun.enterprise.web.WebModuleListener;
import com.sun.enterprise.web.logger.FileLoggerHandler;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.logging.LogDomains;
import com.sun.web.server.WebContainerListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Connector;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Embedded;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.component.Habitat;

public final class EmbeddedWebContainer
extends Embedded {
    protected static final Logger _logger = LogDomains.getLogger(EmbeddedWebContainer.class, (String)"javax.enterprise.system.container.web");
    protected static final ResourceBundle rb = _logger.getResourceBundle();
    private WebContainerFeatureFactory webContainerFeatureFactory;
    private WebContainer webContainer;
    private ServerContext serverContext;
    private InvocationManager invocationManager;
    private InjectionManager injectionManager;
    private final Habitat habitat;
    private String logServiceFile;
    private String logLevel;
    private FileLoggerHandler logHandler;

    public EmbeddedWebContainer(WebContainer webContainer, String logServiceFile, String logLevel, FileLoggerHandler logHandler) {
        this.webContainer = webContainer;
        this.logServiceFile = logServiceFile;
        this.logLevel = logLevel;
        this.logHandler = logHandler;
        this.serverContext = webContainer.getServerContext();
        this.habitat = this.serverContext.getDefaultHabitat();
        this.webContainerFeatureFactory = (WebContainerFeatureFactory)this.habitat.getByContract(WebContainerFeatureFactory.class);
        this.invocationManager = (InvocationManager)this.habitat.getByContract(InvocationManager.class);
        this.injectionManager = (InjectionManager)this.habitat.getByContract(InjectionManager.class);
    }

    public Host createHost(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String vsDocroot, String vsLogFile, MimeMap vsMimeMap) {
        VirtualServer vs = new VirtualServer();
        vs.configure(vsID, vsBean, vsDocroot, vsLogFile, vsMimeMap, this.logServiceFile, this.logLevel, this.logHandler);
        ContainerListener listener = this.loadListener("com.sun.enterprise.web.connector.extension.CatalinaListener");
        if (listener != null) {
            vs.addContainerListener(listener);
        }
        return vs;
    }

    public Context createContext(String id, String ctxPath, File location, String defaultContextXmlLocation, String defaultWebXmlLocation, boolean useDOLforDeployment, WebModuleConfig wmInfo) {
        WebModuleContextConfig config;
        File configFile = null;
        configFile = ctxPath.equals("") ? new File(this.getCatalinaHome() + "/config", "ROOT.xml") : new File(this.getCatalinaHome() + "/config", ctxPath + ".xml");
        if (!configFile.exists()) {
            configFile = new File(location, "META-INF/context.xml");
        }
        WebModule context = new WebModule();
        context.setID(id);
        context.setWebContainer(this.webContainer);
        context.setDebug(this.debug);
        context.setPath(ctxPath);
        context.setDocBase(location.getAbsolutePath());
        context.setCrossContext(true);
        context.setUseNaming(this.isUseNaming());
        context.setHasWebXml(wmInfo.getDescriptor() != null);
        context.setWebBundleDescriptor(wmInfo.getDescriptor());
        context.setManagerChecksFrequency(1);
        context.setServerContext(this.serverContext);
        context.setWebModuleConfig(wmInfo);
        if (configFile.exists()) {
            context.setConfigFile(configFile.getAbsolutePath());
        }
        if (useDOLforDeployment) {
            config = new WebModuleContextConfig();
            config.setDescriptor(wmInfo.getDescriptor());
            config.setHabitat(this.habitat);
        } else {
            config = new ContextConfig();
        }
        config.setDefaultContextXml(defaultContextXmlLocation);
        config.setDefaultWebXml(defaultWebXmlLocation);
        context.addLifecycleListener((LifecycleListener)config);
        context.addLifecycleListener(new WebModuleListener(this.webContainer, location, wmInfo.getDescriptor()));
        context.addContainerListener(new WebContainerListener(this.invocationManager, this.injectionManager));
        for (WebModuleDecorator d : this.habitat.getAllByContract(WebModuleDecorator.class)) {
            d.decorate(context);
        }
        return context;
    }

    private ContainerListener loadListener(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (ContainerListener)clazz.newInstance();
        }
        catch (Throwable ex) {
            String msg = rb.getString("embedded.loadListener");
            msg = MessageFormat.format(msg, className);
            _logger.log(Level.SEVERE, msg, ex);
            return null;
        }
    }

    public Engine[] getEngines() {
        return this.engines;
    }

    public Connector[] getConnectors() {
        return this.connectors;
    }

    public Connector createConnector(String address, int port, String protocol) {
        int index;
        if (address != null && (index = address.indexOf(47)) != -1) {
            address = address.substring(index + 1);
        }
        _logger.log(Level.FINE, "Creating connector for address='" + (address == null ? "ALL" : address) + "' port='" + port + "' protocol='" + protocol + "'");
        WebConnector connector = new WebConnector(this.webContainer);
        if (address != null) {
            connector.setAddress(address);
        }
        connector.setPort(port);
        if (protocol.equals("ajp")) {
            connector.setProtocolHandlerClassName("org.apache.jk.server.JkCoyoteHandler");
        } else if (protocol.equals("memory")) {
            connector.setProtocolHandlerClassName("org.apache.coyote.memory.MemoryProtocolHandler");
        } else if (protocol.equals("https")) {
            connector.setScheme("https");
            connector.setSecure(true);
        }
        return connector;
    }

    public Engine createEngine() {
        WebEngine engine = new WebEngine(this.webContainer);
        engine.setDebug(this.debug);
        engine.setLogger(this.logger);
        engine.setRealm(null);
        return engine;
    }

    static class WebEngine
    extends StandardEngine {
        private WebContainer webContainer;

        public WebEngine(WebContainer webContainer) {
            this.webContainer = webContainer;
        }

        public Realm getRealm() {
            return null;
        }
    }
}

