/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime.jsf.event;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.jsf.ComponentSupport;
import java.io.IOException;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import jmaki.runtime.jsf.event.JMakiEvent;
import jmaki.runtime.jsf.event.JMakiEventListener;
import jmaki.runtime.jsf.event.JMakiEventListenerBase;
import jmaki.runtime.jsf.event.JMakiEventSource;

public class JMakiEventListenerHandler
extends TagHandler {
    private TagAttribute type = this.getAttribute("type");
    private TagAttribute binding = this.getAttribute("binding");
    private TagAttribute publish = this.getAttribute("publish");
    private TagAttribute subscribe = this.getAttribute("subscribe");
    private TagAttribute immediate = this.getAttribute("immediate");
    private TagAttribute render = this.getAttribute("render");
    private TagAttribute execute = this.getAttribute("execute");

    public JMakiEventListenerHandler(TagConfig tagConfig) {
        super(tagConfig);
    }

    public void apply(FaceletContext faceletContext, UIComponent uIComponent) throws IOException, FacesException, FaceletException, ELException {
        if (uIComponent == null) {
            throw new FaceletException("JMakiEventListenerHandler parent does not have an assigned UIComponent");
        }
        if (!(uIComponent instanceof JMakiEventSource)) {
            throw new FaceletException("JMakiEventListenerHandler parent component is not an instance of JMakiEventSource");
        }
        if (ComponentSupport.isNew((UIComponent)uIComponent)) {
            JMakiEventListener jMakiEventListener = null;
            if (this.binding == null && this.type != null && this.type.isLiteral()) {
                try {
                    jMakiEventListener = (JMakiEventListener)Class.forName(this.type.getValue(faceletContext)).newInstance();
                }
                catch (Exception exception) {
                    throw new FaceletException(exception.getMessage(), exception.getCause());
                }
            } else {
                jMakiEventListener = new BindingActionListener(this.type == null ? null : this.type.getValueExpression(faceletContext, String.class), this.binding == null ? null : this.binding.getValueExpression(faceletContext, JMakiEventListener.class));
            }
            if (this.immediate != null) {
                jMakiEventListener.setImmediate(this.immediate.getBoolean(faceletContext));
            }
            if (this.publish != null) {
                jMakiEventListener.setPublish(this.publish.getValue(faceletContext));
            }
            if (this.subscribe != null) {
                jMakiEventListener.setSubscribe(JMakiEventListenerBase.parseTopics(this.subscribe.getValue(faceletContext)));
            }
            if (this.render != null) {
                jMakiEventListener.setRender(this.render.getValue(faceletContext));
            }
            if (this.execute != null) {
                jMakiEventListener.setExecute(this.execute.getValue(faceletContext));
            }
            ((JMakiEventSource)uIComponent).addJMakiEventListener(jMakiEventListener);
        }
    }

    private static final class BindingActionListener
    extends JMakiEventListenerBase
    implements JMakiEventListener,
    Serializable {
        private static final long serialVersionUID = 8196459659823649293L;
        private ValueExpression type;
        private ValueExpression binding;

        public BindingActionListener(ValueExpression valueExpression, ValueExpression valueExpression2) {
            this.type = valueExpression;
            this.binding = valueExpression2;
        }

        public void processJMakiEvent(JMakiEvent jMakiEvent) throws AbortProcessingException {
            JMakiEventListener jMakiEventListener;
            ELContext eLContext = FacesContext.getCurrentInstance().getELContext();
            if (this.binding != null) {
                jMakiEventListener = (JMakiEventListener)this.binding.getValue(eLContext);
            } else {
                try {
                    jMakiEventListener = (JMakiEventListener)Class.forName((String)this.type.getValue(eLContext)).newInstance();
                }
                catch (Exception exception) {
                    throw new AbortProcessingException((Throwable)exception);
                }
            }
            if (jMakiEventListener != null) {
                jMakiEventListener.processJMakiEvent(jMakiEvent);
            }
        }
    }
}

