/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.http.KeepAliveStats;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.ThreadAttachment;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KeepAliveThreadAttachment
extends ThreadAttachment {
    protected static final Logger logger = SelectorThread.logger();
    private int keepAliveCount;
    private KeepAliveStats keepAliveStats;

    public void setKeepAliveStats(KeepAliveStats keepAliveStats) {
        this.keepAliveStats = keepAliveStats;
    }

    public int increaseKeepAliveCount() {
        if (this.keepAliveCount == 0 && this.keepAliveStats != null) {
            this.keepAliveStats.incrementCountConnections();
        }
        ++this.keepAliveCount;
        if (this.keepAliveStats != null) {
            this.keepAliveStats.incrementCountHits();
        }
        return this.keepAliveCount;
    }

    public void resetKeepAliveCount() {
        if (this.keepAliveStats != null && this.keepAliveCount > 0) {
            this.keepAliveStats.decrementCountConnections();
        }
        this.keepAliveCount = 0;
    }

    public void release(SelectionKey selectionKey) {
        super.release(selectionKey);
        this.resetKeepAliveCount();
    }

    public boolean timedOut(SelectionKey selectionKey) {
        Thread t = this.activeThread();
        if (t != null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Interrupting idle Thread: " + t.getName());
            }
            t.interrupt();
        }
        return true;
    }
}

