/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.grizzly.config.dom.NetworkListener;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

public class DynamicConfigListener
implements ConfigListener {
    private GrizzlyService grizzlyService;
    private Logger logger;

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        UnprocessedChangeEvents unp = ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                if (DynamicConfigListener.this.logger.isLoggable(Level.FINE)) {
                    DynamicConfigListener.this.logger.log(Level.FINE, "NetworkConfig changed " + type + " " + tClass + " " + t);
                }
                if (t instanceof NetworkListener) {
                    NetworkListener listener = (NetworkListener)t;
                    int listenerPort = -1;
                    try {
                        listenerPort = Integer.parseInt(listener.getPort());
                    }
                    catch (NumberFormatException e) {
                        DynamicConfigListener.this.logger.log(Level.WARNING, "Can not parse network-listener port number: " + listener.getPort());
                    }
                    if (type == Changed.TYPE.ADD) {
                        DynamicConfigListener.this.grizzlyService.createNetworkProxy(listener);
                        DynamicConfigListener.this.grizzlyService.registerNetworkProxy(listenerPort);
                    } else if (type == Changed.TYPE.REMOVE) {
                        DynamicConfigListener.this.grizzlyService.removeNetworkProxy(listenerPort);
                    } else if (type == Changed.TYPE.CHANGE) {
                        boolean isRemovedOld = DynamicConfigListener.this.grizzlyService.removeNetworkProxy(listenerPort) || DynamicConfigListener.this.grizzlyService.removeNetworkProxy(listener.getName());
                        DynamicConfigListener.this.grizzlyService.createNetworkProxy(listener);
                        DynamicConfigListener.this.grizzlyService.registerNetworkProxy(listenerPort);
                    }
                    return null;
                }
                return null;
            }
        }, (Logger)this.logger);
        return unp;
    }

    public void setGrizzlyService(GrizzlyService grizzlyService) {
        this.grizzlyService = grizzlyService;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

