/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.naming;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ConnectionManagerImpl;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import org.glassfish.api.naming.NamingObjectProxy;

public class ConnectorObjectFactory
implements NamingObjectProxy {
    private ConnectorRuntime runtime;
    private String jndiName;
    private String poolName;
    private String moduleName;
    private String connectionFactoryName;
    private static Logger _logger = LogDomains.getLogger(ConnectorObjectFactory.class, (String)"javax.enterprise.system.core.naming");

    public ConnectorObjectFactory(String jndiName, String connectionFactoryName, String moduleName, String poolName) {
        this.jndiName = jndiName;
        this.moduleName = moduleName;
        this.poolName = poolName;
        this.connectionFactoryName = connectionFactoryName;
        this.runtime = ConnectorRuntime.getRuntime();
    }

    public boolean isCreateResultCacheable() {
        return false;
    }

    public Object create(Context ic) throws NamingException {
        ClassLoader loader;
        if (this.runtime.getEnviron() == 2) {
            ConnectorDescriptor connectorDescriptor = null;
            String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(this.moduleName);
            connectorDescriptor = (ConnectorDescriptor)ic.lookup(descriptorJNDIName);
            try {
                this.runtime.createActiveResourceAdapter(connectorDescriptor, this.moduleName, null);
            }
            catch (ConnectorRuntimeException e) {
                _logger.log(Level.FINE, "Failed to look up ConnectorDescriptor from JNDI", this.moduleName);
                NamingException ne = new NamingException("Failed to look up ConnectorDescriptor from JNDI");
                ne.setRootCause(e);
                throw ne;
            }
        }
        if (!this.runtime.checkAccessibility(this.moduleName, loader = Thread.currentThread().getContextClassLoader())) {
            throw new NamingException("Only the application that has the embedded resourceadapter can access the resource adapter");
        }
        Object cf = null;
        try {
            ManagedConnectionFactory mcf = this.getRuntime().obtainManagedConnectionFactory(this.poolName);
            if (mcf == null) {
                _logger.log(Level.FINE, "Failed to create MCF ", this.poolName);
                throw new ConnectorRuntimeException("Failed to create MCF");
            }
            boolean forceNoLazyAssoc = false;
            if (this.jndiName.endsWith("__pm")) {
                forceNoLazyAssoc = true;
            }
            String derivedJndiName = ConnectorsUtil.deriveJndiName((String)this.jndiName, ic.getEnvironment());
            ConnectionManagerImpl mgr = (ConnectionManagerImpl)((Object)this.getRuntime().obtainConnectionManager(this.poolName, forceNoLazyAssoc));
            mgr.setJndiName(derivedJndiName);
            mgr.setRarName(this.moduleName);
            mgr.initialize();
            cf = mcf.createConnectionFactory((ConnectionManager)((Object)mgr));
            if (cf == null) {
                String msg = "No resource adapter found";
                throw new RuntimeException(new ConfigurationException(msg));
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Connection Factory:" + cf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cf;
    }

    private ConnectorRuntime getRuntime() {
        return this.runtime;
    }
}

