/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientNotificationHandler;
import com.sun.jdmk.comm.ClientNotificationHandlerInternal;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.RemoteNotification;
import com.sun.jdmk.internal.ClassLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

class ClientNotificationDispatcher
implements ClientNotificationHandler {
    public static final int HANDLE_NOTIFICATION = 0;
    public static final int CONNECTOR_TEST = 1;
    private static final ClassLogger jobLogger = new ClassLogger("com.sun.jdmk.notification", "JobOfGetNotif");
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.notification", "ClientNotificationDispatcher");
    private static int DEFAULT_TIME = 1000;
    private ClientNotificationHandlerInternal connector;
    private ConnectorAddress clientAddress = null;
    private Long remoteID;
    private int forwardPeriod = DEFAULT_TIME;
    private HashMap listenerList = new HashMap();
    private JobOfGetNotif jobOfGet = null;
    private ForwardNotifs forwardNotifs = new ForwardNotifs();
    private int forwardMode = 0;
    private int discardMode = 10;
    private int cacheSize = -1;
    private boolean isConnected = false;

    public ClientNotificationDispatcher(ClientNotificationHandlerInternal connector) throws IllegalArgumentException {
        if (connector == null) {
            throw new IllegalArgumentException("A connector should be specified.");
        }
        if (logger.finerOn()) {
            logger.finer("Constructor", "Create a new ClientNotificationDispatcher object.");
        }
        this.connector = connector;
        this.setMode(0);
    }

    public Long getNotificationClientId() {
        if (this.isConnected) {
            return this.remoteID;
        }
        return null;
    }

    public synchronized void stopListening() {
        this.stopListening(false);
    }

    public synchronized void stopListening(boolean local) {
        if (logger.finerOn()) {
            logger.finer("stopListening", "This object is stopping listening...");
        }
        this.listenerList.clear();
        try {
            this.disconnect(local);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMode() {
        return this.forwardMode;
    }

    public synchronized void setMode(int mode) throws IllegalArgumentException {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("The mode is illegal.");
        }
        if (logger.finerOn()) {
            logger.finer("setMode", "A user asks to set mode to " + mode);
        }
        if (this.forwardMode != mode) {
            this.forwardMode = mode;
            if (this.isConnected) {
                this.internalSetMode(this.forwardMode);
            }
        }
    }

    public void addNotificationListener(ObjectName mbean, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null listener"), "Null listener");
        }
        this.connect();
        if (logger.finerOn()) {
            logger.finer("addNotificationListener", "Ask the server to add a listener.");
        }
        Object[] ret = null;
        Object[] params = new Object[]{this.remoteID, mbean, filter};
        try {
            ret = this.connector.remoteRequest(2, params);
        }
        catch (RuntimeOperationsException roe) {
            throw roe;
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (CommunicationException ce) {
            throw ce;
        }
        catch (JMRuntimeException jmre) {
            throw jmre;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Long listenerID = (Long)ret[0];
        this.listenerList.put(listenerID, new ListenerInfo(mbean, listener, filter, handback, listenerID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName mbean, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        block22: {
            ListenerInfo li;
            if (logger.finerOn()) {
                logger.finer("removeNotificationListener", "Ask the server to remove a listener.");
            }
            if (mbean == null) {
                throw new InstanceNotFoundException("The MBean name doesn't correspond to a registered MBean.");
            }
            ArrayList<ListenerInfo> removed = new ArrayList<ListenerInfo>(1);
            HashMap hashMap = this.listenerList;
            synchronized (hashMap) {
                Iterator iter = this.listenerList.values().iterator();
                while (iter.hasNext()) {
                    li = (ListenerInfo)iter.next();
                    if (!mbean.equals(li.mbean) || listener != li.listener) continue;
                    removed.add(li);
                }
                if (removed.size() != 0) {
                    for (int i = 0; i < removed.size(); ++i) {
                        li = (ListenerInfo)removed.get(i);
                        this.listenerList.remove(li.id);
                    }
                } else {
                    throw new ListenerNotFoundException("Do not know your listener.");
                }
            }
            if (removed.size() != 0 && this.isConnected) {
                while (removed.size() > 0) {
                    li = (ListenerInfo)removed.remove(0);
                    Object[] params = new Object[]{this.remoteID, li.id};
                    try {
                        this.connector.remoteRequest(3, params);
                    }
                    catch (Exception e) {
                        if (e instanceof InstanceNotFoundException) {
                            throw (InstanceNotFoundException)e;
                        }
                        if (e instanceof ListenerNotFoundException) {
                            throw (ListenerNotFoundException)e;
                        }
                        if (e instanceof CommunicationException) {
                            throw (CommunicationException)e;
                        }
                        if (e instanceof JMRuntimeException) {
                            throw (JMRuntimeException)e;
                        }
                        if (!logger.finestOn()) continue;
                        logger.finest("removeNotificationListener exception:", e);
                    }
                }
            }
            if (this.listenerList.size() == 0) {
                try {
                    if (System.getProperty("com.sun.jdmk.notification.termination") == null) {
                        this.disconnect(false);
                    } else {
                        this.disconnect(true);
                    }
                }
                catch (Exception e) {
                    if (!logger.finerOn()) break block22;
                    logger.finer("removeNotificationListener", e);
                }
            }
        }
    }

    public void setPeriod(int period) {
        if (logger.finerOn()) {
            logger.finer("setPullPeriod", "A user asks to set pull period to " + period);
        }
        this.forwardPeriod = period;
        try {
            this.jobOfGet.terminate();
            this.jobOfGet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (period > 0 && this.isConnected && this.forwardMode == 1) {
            this.jobOfGet = new JobOfGetNotif();
            this.jobOfGet.start();
        }
    }

    public int getPeriod() {
        return this.forwardPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNotifications() {
        Object[] ret;
        block14: {
            if (logger.finerOn()) {
                logger.finer("getNotification", "A user asks to get all notifications.");
            }
            if (!this.isConnected || this.forwardMode == 0) {
                return;
            }
            ret = null;
            try {
                Object[] params = new Object[]{this.remoteID};
                ret = this.connector.remoteRequest(4, params);
            }
            catch (CommunicationException ce) {
                throw ce;
            }
            catch (JMRuntimeException jmre) {
                throw jmre;
            }
            catch (Exception e) {
                if (!logger.finestOn()) break block14;
                logger.finest("getNotifications", e);
            }
        }
        if (ret != null) {
            for (int i = 0; i < ret.length; ++i) {
                RemoteNotification ne = (RemoteNotification)ret[i];
                HashMap hashMap = this.listenerList;
                synchronized (hashMap) {
                    ListenerInfo li = (ListenerInfo)this.listenerList.get(ne.id);
                    if (li != null) {
                        try {
                            li.listener.handleNotification(ne.notif, li.handback);
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                    }
                    continue;
                }
            }
        }
    }

    public void clearCache() {
        block4: {
            if (logger.finerOn()) {
                logger.finer("clearCache", "Ask the server to clear the notification cache.");
            }
            if (!this.isConnected || this.forwardMode == 0) {
                return;
            }
            Object[] params = new Object[]{this.remoteID};
            try {
                this.connector.remoteRequest(5, params);
            }
            catch (Exception e) {
                if (!logger.finestOn()) break block4;
                logger.finest("clearNotifications", e);
            }
        }
    }

    public int setCacheSize(int size, boolean discardOverflow) {
        if (logger.finerOn()) {
            logger.finer("setCacheSize", "Ask the server to set size of the cache.");
        }
        if (this.isConnected) {
            Object[] ret;
            block7: {
                Object[] params = new Object[]{this.remoteID, new Integer(size), new Boolean(discardOverflow)};
                ret = null;
                try {
                    ret = this.connector.remoteRequest(9, params);
                }
                catch (CommunicationException e) {
                    throw e;
                }
                catch (JMRuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!logger.finestOn()) break block7;
                    logger.finest("setCacheSize", e);
                }
            }
            this.cacheSize = (Integer)ret[0];
        } else {
            this.cacheSize = size;
        }
        return this.cacheSize;
    }

    public int getCacheSize() {
        if (logger.finerOn()) {
            logger.finer("getCacheSize", "Ask the server to return the size of the cache.");
        }
        return this.cacheSize;
    }

    public void setOverflowCount(int count) {
        block6: {
            if (logger.finerOn()) {
                logger.finer("setOverflowCount", "Set the overflow count.");
            }
            if (this.isConnected) {
                Object[] params = new Object[]{this.remoteID, new Integer(count)};
                try {
                    this.connector.remoteRequest(11, params);
                }
                catch (CommunicationException e) {
                    throw e;
                }
                catch (JMRuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!logger.finestOn()) break block6;
                    logger.finest("setOverflowCount", e);
                }
            }
        }
    }

    public int getOverflowCount() {
        if (logger.finerOn()) {
            logger.finer("getOverflowCount", "Get the overflow count.");
        }
        int count = 0;
        if (this.isConnected) {
            Object[] ret;
            block6: {
                Object[] params = new Object[]{this.remoteID};
                ret = null;
                try {
                    ret = this.connector.remoteRequest(12, params);
                }
                catch (CommunicationException e) {
                    throw e;
                }
                catch (JMRuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!logger.finestOn()) break block6;
                    logger.finest("getOverflowCount", e);
                }
            }
            count = (Integer)ret[0];
        }
        return count;
    }

    public void setOverflowMode(int of) throws IllegalArgumentException {
        block7: {
            if (logger.finerOn()) {
                logger.finer("setOverflowMode", "Set overflow mode.");
            }
            if (of != 11 && of != 10) {
                throw new IllegalArgumentException("Illegal overflow mode.");
            }
            if (this.isConnected) {
                Object[] params = new Object[]{this.remoteID, new Integer(of)};
                try {
                    this.connector.remoteRequest(7, params);
                }
                catch (CommunicationException e) {
                    throw e;
                }
                catch (JMRuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!logger.finestOn()) break block7;
                    logger.finest("setOverflowMode", e);
                }
            }
        }
        this.discardMode = of;
    }

    public int getOverflowMode() {
        if (logger.finerOn()) {
            logger.finer("getOverflowMode", "Get the overflow mode.");
        }
        return this.discardMode;
    }

    public Object[] remoteRequest(int opType, Object[] params) throws Exception {
        Object[] ret = null;
        switch (opType) {
            case 0: {
                this.forwardNotifs.addNotifs(params);
                ret = new Object[]{};
                break;
            }
            case 1: {
                ret = this.backConnectorTest();
                break;
            }
            default: {
                throw new JMRuntimeException("The request is unknown.");
            }
        }
        return ret;
    }

    protected void finalize() throws Throwable {
        this.listenerList.clear();
        this.disconnect(true);
        this.listenerList = null;
        super.finalize();
    }

    protected Object[] backConnectorTest() {
        return new Object[0];
    }

    protected synchronized void connect() {
        block7: {
            if (this.isConnected) {
                return;
            }
            if (logger.finerOn()) {
                logger.finer("connect", "Connecting to the server ...");
            }
            Object[] params = new Object[]{new Integer(this.discardMode), new Integer(this.cacheSize)};
            Object[] ret = null;
            try {
                ret = this.connector.remoteRequest(0, params);
                this.remoteID = (Long)ret[0];
                if (logger.finestOn()) {
                    logger.finest("connect", "Id=" + this.remoteID);
                }
            }
            catch (CommunicationException ce) {
                throw ce;
            }
            catch (JMRuntimeException jmre) {
                throw jmre;
            }
            catch (Exception e) {
                if (!logger.finestOn()) break block7;
                logger.finest("connect", e);
            }
        }
        this.internalSetMode(this.forwardMode);
        this.isConnected = true;
    }

    protected synchronized void internalSetMode(int mode) {
        block12: {
            Object[] params = null;
            if (mode == 0) {
                this.clientAddress = this.connector.startPush();
                Object[] pushP = new Object[]{this.remoteID, new Integer(0), this.clientAddress};
                params = pushP;
            } else if (mode == 1) {
                Object[] pullP;
                params = pullP = new Object[]{this.remoteID, new Integer(1), null};
            }
            try {
                this.connector.remoteRequest(6, params);
            }
            catch (CommunicationException ce) {
                throw ce;
            }
            catch (JMRuntimeException jmre) {
                throw jmre;
            }
            catch (Exception e) {
                if (!logger.finestOn()) break block12;
                logger.finest("internalSetMode", e);
            }
        }
        if (mode == 1 && this.forwardMode == 0) {
            this.connector.stopPush(this.clientAddress);
        }
        if (mode == 0) {
            try {
                this.jobOfGet.terminate();
                this.jobOfGet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(mode != 1 || this.forwardPeriod <= 0 || this.jobOfGet != null && this.jobOfGet.isAlive())) {
            this.jobOfGet = new JobOfGetNotif();
            this.jobOfGet.start();
        }
        this.forwardMode = mode;
    }

    protected synchronized void disconnect() {
        this.disconnect(false);
    }

    protected synchronized void disconnect(boolean local) {
        block9: {
            if (!this.isConnected) {
                return;
            }
            if (logger.finerOn()) {
                logger.finer("disconnect", "Disconnecting with the server...");
            }
            if (!local) {
                if (logger.finerOn()) {
                    logger.finer("disconnect", "Send Request to the server...");
                }
                Object[] params = new Object[]{this.remoteID};
                try {
                    this.connector.remoteRequest(1, params);
                }
                catch (Exception e) {
                    if (!logger.finerOn()) break block9;
                    logger.finer("disconnect", e);
                }
            }
        }
        if (this.forwardMode == 0) {
            this.connector.stopPush(this.clientAddress);
        }
        try {
            this.jobOfGet.terminate();
            this.jobOfGet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listenerList.clear();
        this.isConnected = false;
    }

    private ListenerInfo findListenerInfo(ObjectName mbean, NotificationListener listener) {
        ListenerInfo li = null;
        Iterator iter = this.listenerList.values().iterator();
        while (iter.hasNext()) {
            ListenerInfo lis = (ListenerInfo)iter.next();
            if (!mbean.equals(lis.mbean) || listener != lis.listener) continue;
            li = lis;
            break;
        }
        return li;
    }

    static /* synthetic */ int access$500() {
        return DEFAULT_TIME;
    }

    private class ForwardNotifs {
        private TaskThread taskThread = null;
        private List notifList = Collections.synchronizedList(new ArrayList());

        public synchronized void addNotifs(Object[] notifs) {
            this.notifList.add((RemoteNotification[])notifs);
            if (this.taskThread == null) {
                this.taskThread = new TaskThread();
                this.taskThread.start();
            }
        }

        public void terminate() {
            if (this.taskThread != null) {
                this.taskThread.toBeTerminated = true;
            }
        }

        private class TaskThread
        extends Thread {
            boolean toBeTerminated;

            public TaskThread() {
                super("taskThread");
                this.toBeTerminated = false;
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!this.toBeTerminated) {
                    RemoteNotification[] notifs = null;
                    Object object = ForwardNotifs.this.notifList;
                    synchronized (object) {
                        if (ForwardNotifs.this.notifList.isEmpty()) {
                            break;
                        }
                        notifs = (RemoteNotification[])ForwardNotifs.this.notifList.remove(0);
                    }
                    if (notifs == null) continue;
                    object = ClientNotificationDispatcher.this.listenerList;
                    synchronized (object) {
                        for (int i = 0; i < notifs.length; ++i) {
                            ListenerInfo li = (ListenerInfo)ClientNotificationDispatcher.this.listenerList.get(notifs[i].id);
                            if (li == null) {
                                if (!logger.finestOn()) continue;
                                logger.finest("forwardNotif", "Receive a notification not waited.");
                                continue;
                            }
                            try {
                                li.listener.handleNotification(notifs[i].notif, li.handback);
                                continue;
                            }
                            catch (Exception e) {
                                if (!logger.finestOn()) continue;
                                logger.finest("forwardNotif", e);
                            }
                        }
                    }
                }
                ForwardNotifs.this.taskThread = null;
            }
        }
    }

    private class JobOfGetNotif
    extends Thread {
        boolean tobeTerminated = false;

        public JobOfGetNotif() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (jobLogger.finerOn()) {
                jobLogger.finer("run", "Start pulling...");
            }
            while (!this.tobeTerminated && ClientNotificationDispatcher.this.forwardPeriod > 0) {
                RemoteNotification[] ret = null;
                try {
                    JobOfGetNotif.sleep(ClientNotificationDispatcher.this.forwardPeriod);
                    if (this.tobeTerminated || ClientNotificationDispatcher.this.forwardPeriod <= 0) break;
                    Object[] params = new Object[]{ClientNotificationDispatcher.this.remoteID};
                    ret = (RemoteNotification[])ClientNotificationDispatcher.this.connector.remoteRequest(4, params);
                }
                catch (Exception e) {
                    if (this.tobeTerminated) {
                        if (!jobLogger.finestOn()) break;
                        jobLogger.finest("run", "Disconnected");
                        break;
                    }
                    if (!jobLogger.finestOn()) continue;
                    jobLogger.finest("run", e);
                    continue;
                }
                if (ret == null) continue;
                for (int i = 0; i < ret.length; ++i) {
                    RemoteNotification ne = ret[i];
                    HashMap hashMap = ClientNotificationDispatcher.this.listenerList;
                    synchronized (hashMap) {
                        block11: {
                            try {
                                ListenerInfo li = (ListenerInfo)ClientNotificationDispatcher.this.listenerList.get(ne.id);
                                li.listener.handleNotification(ne.notif, li.handback);
                            }
                            catch (Exception ee) {
                                if (!jobLogger.finestOn()) break block11;
                                jobLogger.finest("run", ee);
                            }
                        }
                        continue;
                    }
                }
            }
        }

        public void terminate() {
            if (jobLogger.finerOn()) {
                jobLogger.finer("terminate", "Stop pulling...");
            }
            this.tobeTerminated = true;
        }
    }

    private class ListenerInfo {
        public ObjectName mbean;
        public NotificationListener listener = null;
        public NotificationFilter filter;
        public Object handback;
        public int time = ClientNotificationDispatcher.access$500();
        public Long id;

        public ListenerInfo(ObjectName mbean, NotificationListener listener, NotificationFilter filter, Object handback, Long id) {
            this.mbean = mbean;
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
            this.id = id;
        }
    }
}

