/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal.snmp;

import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.internal.BackupFileHandler;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpLcd;
import com.sun.management.snmp.SnmpEngineId;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

public class SnmpJdmkLcd
extends SnmpLcd {
    String engineId = null;
    File file = null;
    int engineBoots = -1;
    private String header = "\n# #####APPENDED PROPERTY####\n";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpJdmkLcd");
    String dbgTag = "SnmpJdmkLcd";

    public SnmpJdmkLcd(String lcdFile) throws IllegalArgumentException {
        this.handleSecurityFileLocation(lcdFile);
    }

    private void handleSecurityFileLocation(String securityFile) throws IllegalArgumentException {
        String lcdFile = null;
        if (securityFile == null) {
            lcdFile = System.getProperty("jdmk.security.file");
            if (lcdFile == null) {
                if (logger.finestOn()) {
                    logger.finest("constructor", "Security file not found. Use default one.");
                }
                lcdFile = DefaultPaths.getEtcDir("conf" + File.separator + "jdmk.security");
                this.file = new File(lcdFile);
                if (!this.file.exists()) {
                    this.file = null;
                    if (logger.finerOn()) {
                        logger.finer("SnmpJdmkLcd", "The default file [" + lcdFile + "] doesn't exist.");
                    }
                    return;
                }
            } else {
                this.file = new File(lcdFile);
                if (!this.file.exists() && logger.finerOn()) {
                    logger.finer("handleSecurityFileLocation", "The specified file [" + this.file + "] doesn't exist, no configuration loaded");
                    throw new IllegalArgumentException("The specified file [" + this.file + "] doesn't exist, no configuration loaded");
                }
            }
        } else {
            this.file = new File(securityFile);
            if (!this.file.exists() && logger.finerOn()) {
                logger.finer("handleSecurityFileLocation", "The specified file [" + this.file + "] doesn't exist, no configuration loaded");
                throw new IllegalArgumentException("The specified file [" + this.file + "] doesn't exist, no configuration loaded");
            }
        }
    }

    File getFile() {
        return this.file;
    }

    public void storeEngineBoots(int i) {
        if (this.getFile() == null) {
            return;
        }
        String s = "localEngineBoots";
        this.flushProperty(s, String.valueOf(i));
    }

    public void storeEngineId(SnmpEngineId id) {
        if (this.getFile() == null) {
            return;
        }
        String s = "localEngineID";
        this.flushProperty(s, id.getReadableId() == null ? id.toString() : id.getReadableId());
    }

    public int getEngineBoots() {
        String s;
        if (this.getFile() == null) {
            return -1;
        }
        if (this.engineBoots == -1 && (s = this.getProperty("localEngineBoots")) != null) {
            this.engineBoots = Integer.parseInt(s);
        }
        return this.engineBoots;
    }

    public String getEngineId() {
        if (this.getFile() == null) {
            return null;
        }
        if (this.engineId == null) {
            this.engineId = this.getProperty("localEngineID");
        }
        return this.engineId;
    }

    private String getProperty(String property) {
        String row = null;
        FileReader in = null;
        BufferedReader reader = null;
        if (!this.file.exists()) {
            if (logger.finerOn()) {
                logger.finer("getProperty", "The specified file [" + this.file + "] doesn't exist, the property " + property + "] can't be loaded.");
            }
            return null;
        }
        try {
            in = new FileReader(this.file);
            reader = new BufferedReader(in);
        }
        catch (IOException e) {
            if (logger.finestOn()) {
                logger.finest("getProperty", "The specified file was not found, no configuration loaded");
            }
            return null;
        }
        try {
            row = reader.readLine();
        }
        catch (IOException ex) {
            if (logger.finerOn()) {
                logger.finer("getProperty", ex.toString());
            }
            return null;
        }
        while (row != null) {
            try {
                if (row.startsWith(property + "=")) {
                    reader.close();
                    int size = row.indexOf("=");
                    if (size == row.length() - 1) {
                        return null;
                    }
                    return row.substring(size + 1);
                }
                row = reader.readLine();
            }
            catch (IOException e) {
                if (!logger.finestOn()) continue;
                logger.finest("getProperty", e);
            }
        }
        try {
            reader.close();
            in.close();
        }
        catch (IOException e2) {
            if (logger.finestOn()) {
                logger.finest("getProperty", e2);
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeFile(File backupFile, String property, String value) throws Exception {
        block49: {
            Exception e222222;
            InputStreamReader in;
            FileWriter out;
            BufferedReader reader;
            BufferedWriter writer;
            block41: {
                block40: {
                    block39: {
                        block38: {
                            String toFlush;
                            String row = null;
                            boolean patched = false;
                            boolean found = false;
                            writer = null;
                            reader = null;
                            out = null;
                            in = null;
                            out = new FileWriter(this.file);
                            writer = new BufferedWriter(out);
                            in = new FileReader(backupFile);
                            reader = new BufferedReader(in);
                            row = reader.readLine();
                            while (row != null) {
                                toFlush = row;
                                if (!found && row.startsWith(property + "=")) {
                                    if (logger.finestOn()) {
                                        logger.finest("flushProperty", "Found property [" + property + "], new value [" + value + "]");
                                    }
                                    toFlush = property + "=" + value;
                                    found = true;
                                }
                                writer.write(toFlush, 0, toFlush.length());
                                writer.newLine();
                                row = reader.readLine();
                            }
                            if (found) break block38;
                            toFlush = property + "=" + value;
                            if (logger.finestOn()) {
                                logger.finest("flushProperty", "Property not found!");
                            }
                            writer.write(this.header, 0, this.header.length());
                            writer.write(toFlush, 0, toFlush.length());
                        }
                        Object var13_13 = null;
                        if (writer == null) break block39;
                        try {
                            writer.close();
                        }
                        catch (Exception e222222) {
                            if (!logger.finestOn()) break block39;
                            logger.finest("flushProperty", e222222);
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e222222) {
                            if (!logger.finestOn()) break block40;
                            logger.finest("flushProperty", e222222);
                        }
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e222222) {
                        if (!logger.finestOn()) break block41;
                        logger.finest("flushProperty", e222222);
                    }
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e222222) {
                    if (logger.finestOn()) {
                        logger.finest("flushProperty", e222222);
                    }
                }
            }
            break block49;
            {
                catch (Exception e3) {
                    Exception e222222;
                    block44: {
                        block43: {
                            block42: {
                                if (logger.finestOn()) {
                                    logger.finest("flushProperty", e3);
                                }
                                Object var13_14 = null;
                                if (writer != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (Exception e222222) {
                                        if (!logger.finestOn()) break block42;
                                        logger.finest("flushProperty", e222222);
                                    }
                                }
                            }
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Exception e222222) {
                                    if (!logger.finestOn()) break block43;
                                    logger.finest("flushProperty", e222222);
                                }
                            }
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e222222) {
                                if (!logger.finestOn()) break block44;
                                logger.finest("flushProperty", e222222);
                            }
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e222222) {
                            if (logger.finestOn()) {
                                logger.finest("flushProperty", e222222);
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block48: {
                    Exception e222222;
                    block47: {
                        block46: {
                            block45: {
                                Object var13_15 = null;
                                if (writer != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (Exception e222222) {
                                        if (!logger.finestOn()) break block45;
                                        logger.finest("flushProperty", e222222);
                                    }
                                }
                            }
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Exception e222222) {
                                    if (!logger.finestOn()) break block46;
                                    logger.finest("flushProperty", e222222);
                                }
                            }
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e222222) {
                                if (!logger.finestOn()) break block47;
                                logger.finest("flushProperty", e222222);
                            }
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e222222) {
                            if (!logger.finestOn()) break block48;
                            logger.finest("flushProperty", e222222);
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    private void resetFile() throws Exception {
        try {
            this.file.delete();
            this.file.createNewFile();
        }
        catch (Exception e) {
            if (logger.finestOn()) {
                logger.finest("resetFile", e);
            }
            if (logger.finestOn()) {
                logger.finest("resetFile", "File reset failed.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushProperty(String property, String value) {
        File backupFile = BackupFileHandler.createBackupFile(this.file, null);
        if (backupFile == null) {
            if (logger.finestOn()) {
                logger.finest("flushProperty", "Unable to create backup file for " + this.file + "Property " + property + " not flushed");
            }
            return;
        }
        if (logger.finestOn()) {
            logger.finest("flushProperty", this.file + " backup file created : " + backupFile + ".");
        }
        try {
            this.writeFile(backupFile, property, value);
        }
        catch (Exception e) {
            if (logger.finestOn()) {
                logger.finest("resetFile", e);
            }
            if (logger.finestOn()) {
                logger.finest("resetFile", "File reset failed.Check " + backupFile + " file.");
            }
        }
        finally {
            BackupFileHandler.deleteBackupFile(backupFile);
        }
    }
}

