/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.management.snmp.SnmpOidDatabase;
import com.sun.management.snmp.SnmpOidRecord;
import com.sun.management.snmp.SnmpOidTable;
import com.sun.management.snmp.SnmpStatusException;
import java.util.Vector;

public class SnmpOidDatabaseSupport
implements SnmpOidDatabase {
    private Vector tables = new Vector();

    public SnmpOidDatabaseSupport() {
    }

    public SnmpOidDatabaseSupport(SnmpOidTable table) {
        this.tables.addElement(table);
    }

    public void add(SnmpOidTable table) {
        if (!this.tables.contains(table)) {
            this.tables.addElement(table);
        }
    }

    public void remove(SnmpOidTable table) throws SnmpStatusException {
        if (!this.tables.contains(table)) {
            throw new SnmpStatusException("The specified SnmpOidTable does not exist in this SnmpOidDatabase");
        }
        this.tables.removeElement(table);
    }

    public SnmpOidRecord resolveVarName(String name) throws SnmpStatusException {
        for (int i = 0; i < this.tables.size(); ++i) {
            try {
                return ((SnmpOidTable)this.tables.elementAt(i)).resolveVarName(name);
            }
            catch (SnmpStatusException e) {
                if (i != this.tables.size() - 1) continue;
                throw new SnmpStatusException(e, e.getErrorIndex());
            }
        }
        return null;
    }

    public SnmpOidRecord resolveVarOid(String oid) throws SnmpStatusException {
        for (int i = 0; i < this.tables.size(); ++i) {
            try {
                return ((SnmpOidTable)this.tables.elementAt(i)).resolveVarOid(oid);
            }
            catch (SnmpStatusException e) {
                if (i != this.tables.size() - 1) continue;
                throw new SnmpStatusException(e, e.getErrorIndex());
            }
        }
        return null;
    }

    public Vector getAllEntries() {
        Vector res = new Vector();
        for (int i = 0; i < this.tables.size(); ++i) {
            Vector tmp = ((SnmpOidTable)this.tables.elementAt(i)).getAllEntries();
            if (tmp == null) continue;
            for (int ii = 0; ii < tmp.size(); ++ii) {
                res.addElement(tmp.elementAt(ii));
            }
        }
        return res;
    }

    public void removeAll() {
        this.tables.removeAllElements();
    }
}

