/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpIncomingRequest;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.snmp.JdmkEngineFactory;
import com.sun.management.snmp.SnmpAckPdu;
import com.sun.management.snmp.SnmpBadSecurityLevelException;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineFactory;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpEngineParameters;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduFactoryBER;
import com.sun.management.snmp.SnmpPduRequestType;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpUnknownMsgProcModelException;
import com.sun.management.snmp.SnmpUnknownSecModelException;
import com.sun.management.snmp.manager.SnmpEventReportHandler;
import com.sun.management.snmp.manager.SnmpInformListener;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpTrapListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SnmpEventReportDispatcher
implements Runnable {
    private int snmpInTraps = 0;
    private int snmpInInforms = 0;
    private int snmpInPkts = 0;
    private int snmpInASNParseErrs = 0;
    private int snmpInBadVersions = 0;
    private int snmpInvalidMsgs = 0;
    private int snmpUnknownSecurityModels = 0;
    private int port = 162;
    private final DatagramSocket dSocket;
    private final ObjectList trapListeners = new ObjectList();
    private final ObjectList informListeners = new ObjectList();
    private SnmpPduFactory pduFactory = new SnmpPduFactoryBER();
    private SnmpEngineImpl engine = null;
    private boolean enabled = true;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    String dbgTag = "SnmpEventReportDispatcher";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", SnmpEventReportDispatcher.class.getName());

    public SnmpEventReportDispatcher() throws SocketException, IllegalArgumentException {
        this(new SnmpEngineParameters(), new JdmkEngineFactory(), 162, null);
    }

    public SnmpEventReportDispatcher(int portNumber) throws SocketException, IllegalArgumentException {
        this(new SnmpEngineParameters(), new JdmkEngineFactory(), portNumber, null);
    }

    public SnmpEventReportDispatcher(SnmpEngineParameters parameters, SnmpEngineFactory factory, int portNumber) throws SocketException, IllegalArgumentException {
        this(SnmpEventReportDispatcher.createEngine(parameters, factory), portNumber, null);
    }

    public SnmpEventReportDispatcher(SnmpEngineParameters parameters, SnmpEngineFactory factory, int portNumber, InetAddress address) throws SocketException, IllegalArgumentException {
        this(SnmpEventReportDispatcher.createEngine(parameters, factory), portNumber, address);
    }

    public SnmpEventReportDispatcher(SnmpEngine engine, int portNumber) throws SocketException, IllegalArgumentException {
        this(engine, portNumber, null);
    }

    public SnmpEventReportDispatcher(SnmpEngine engine, int portNumber, InetAddress address) throws SocketException, IllegalArgumentException {
        if (engine == null) {
            throw new IllegalArgumentException("Engine can't be null");
        }
        this.engine = (SnmpEngineImpl)engine;
        this.port = portNumber;
        this.dSocket = address != null ? new DatagramSocket(this.port, address) : new DatagramSocket(this.port);
    }

    public Long getSnmpInTraps() {
        return new Long(this.snmpInTraps);
    }

    public Long getSnmpInInforms() {
        return new Long(this.snmpInInforms);
    }

    public Long getSnmpInPkts() {
        return new Long(this.snmpInPkts);
    }

    public Long getSnmpInASNParseErrs() {
        return new Long(this.snmpInASNParseErrs);
    }

    public Long getSnmpInBadVersions() {
        return new Long(this.snmpInBadVersions);
    }

    public Long getSnmpInvalidMsgs() {
        return new Long(this.snmpInvalidMsgs);
    }

    public Long getSnmpUnknownSecurityModels() {
        return new Long(this.snmpUnknownSecurityModels);
    }

    public SnmpEngine getEngine() {
        return this.engine;
    }

    public SnmpEngineId getEngineId() {
        return this.engine.getEngineId();
    }

    public void close() throws IOException {
        this.enabled(false);
        if (this.dSocket != null) {
            this.dSocket.close();
        }
    }

    private synchronized void incSnmpInBadVersions(int n) {
        this.snmpInBadVersions += n;
    }

    private synchronized void incSnmpInASNParseErrs(int n) {
        this.snmpInASNParseErrs += n;
    }

    private synchronized void incSnmpInPkts(int n) {
        this.snmpInPkts += n;
    }

    private synchronized void incSnmpInInforms(int n) {
        this.snmpInInforms += n;
    }

    private synchronized void incSnmpInTraps(int n) {
        this.snmpInTraps += n;
    }

    private synchronized void incSnmpInvalidMsgs(int n) {
        this.snmpInvalidMsgs += n;
    }

    private synchronized void incSnmpUnknownSecurityModels(int n) {
        this.snmpUnknownSecurityModels += n;
    }

    private synchronized boolean enabled() {
        return this.enabled;
    }

    private synchronized boolean enabled(boolean enabled) {
        this.enabled = enabled;
        return enabled;
    }

    private static SnmpEngine createEngine(SnmpEngineParameters parameters, SnmpEngineFactory factory) throws IllegalArgumentException {
        SnmpEngine engine;
        if (factory == null) {
            factory = new JdmkEngineFactory();
        }
        if (parameters == null) {
            parameters = new SnmpEngineParameters();
        }
        if ((engine = factory.createEngine(parameters)) == null) {
            throw new IllegalArgumentException("The factory returned a null lengine. SnmpEventReportDispatcher initilization failed");
        }
        return engine;
    }

    private final SnmpIncomingRequest getIncomingReq(int version, DatagramPacket packet) throws SnmpStatusException, SnmpUnknownMsgProcModelException {
        SnmpMsgProcessingSubSystem msgsys = this.engine.getMsgProcessingSubSystem();
        return msgsys.getIncomingRequest(version, this.pduFactory);
    }

    private final SnmpPdu decodePdu(int version, SnmpIncomingRequest req, DatagramPacket packet) throws SnmpStatusException, SnmpUnknownSecModelException, SnmpBadSecurityLevelException {
        req.decodeMessage(packet.getData(), packet.getLength(), packet.getAddress(), packet.getPort());
        SnmpPdu pdu = null;
        if (!req.isReport()) {
            pdu = req.decodeSnmpPdu();
        }
        return pdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleTrap(int version, SnmpIncomingRequest req, DatagramPacket packet, SnmpPdu pdu) {
        SnmpPdu trapPdu = pdu;
        this.incSnmpInTraps(1);
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            int size = this.trapListeners.size;
            Object[] list = this.trapListeners.list;
            for (int i = 0; i < size; ++i) {
                SnmpTrapListener listener = (SnmpTrapListener)list[i];
                SnmpEventReportHandler handler = new SnmpEventReportHandler(listener, trapPdu);
                this.handleCallback(handler);
            }
        }
    }

    private final void acknowledgeInform(int version, SnmpIncomingRequest req, DatagramPacket packet, SnmpPdu informPdu) {
        DatagramPacket respPacket = this.makeResponsePacket(req, packet, informPdu);
        if (respPacket == null) {
            return;
        }
        this.sendPacket(respPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleInform(int version, SnmpIncomingRequest req, DatagramPacket packet, SnmpPdu pdu) {
        SnmpPdu informPdu = pdu;
        this.incSnmpInInforms(1);
        this.acknowledgeInform(version, req, packet, pdu);
        informPdu.type = 166;
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            int size = this.informListeners.size;
            Object[] list = this.informListeners.list;
            for (int i = 0; i < size; ++i) {
                SnmpInformListener listener = (SnmpInformListener)list[i];
                SnmpEventReportHandler handler = new SnmpEventReportHandler(listener, informPdu);
                this.handleCallback(handler);
            }
        }
    }

    private final void sendPacket(DatagramPacket respPacket) {
        block10: {
            if (respPacket == null) {
                return;
            }
            try {
                if (logger.finerOn()) {
                    logger.finer("run", "Response packet to be sent:\n" + SnmpMsg.dumpHexBuffer(respPacket.getData(), 0, respPacket.getLength()));
                }
                this.dSocket.send(respPacket);
            }
            catch (SocketException e) {
                if (logger.finestOn()) {
                    if (e.getMessage().equals(InterruptSysCallMsg)) {
                        logger.finest("run", "interrupted");
                    } else {
                        logger.finest("run", "i/o exception");
                        logger.finest("run", e);
                    }
                }
            }
            catch (InterruptedIOException e) {
                if (logger.finestOn()) {
                    logger.finest("run", "interrupted");
                }
            }
            catch (Exception e) {
                if (!logger.finestOn()) break block10;
                logger.finest("run", "failure when sending response");
                logger.finest("run", e);
            }
        }
    }

    private final void handleV3GetRequest(int version, SnmpIncomingRequest req, DatagramPacket packet, SnmpPdu pdu) {
        DatagramPacket respPacket;
        if (!req.isReport() && logger.finestOn()) {
            logger.finest("run", "trashed the packet:  no report to send back to received request.");
        }
        if (logger.finestOn()) {
            logger.finest("run", "Received a getRequest, send back the report");
        }
        if ((respPacket = this.makeResponsePacket(req, packet, pdu)) == null) {
            return;
        }
        this.sendPacket(respPacket);
    }

    protected void handleCallback(Runnable callbackHandler) {
        callbackHandler.run();
    }

    protected void handlePacket(Runnable packetHandler) {
        new Thread(packetHandler).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doHandlePacket(int version, DatagramPacket packet) {
        boolean finest = logger.finestOn();
        boolean finer = finest ? true : logger.finerOn();
        try {
            SnmpPdu pdu;
            SnmpIncomingRequest req;
            block26: {
                block25: {
                    req = this.getIncomingReq(version, packet);
                    try {
                        pdu = this.decodePdu(version, req, packet);
                    }
                    catch (SnmpStatusException e) {
                        if (finest) {
                            logger.finest("handlePacket", "Rejecting trap : " + e);
                        }
                        this.incSnmpInASNParseErrs(1);
                        return;
                    }
                    if (req.isReport()) {
                        DatagramPacket respPacket;
                        if (finest) {
                            logger.finest("handlePacket", "Report to send back");
                        }
                        if ((respPacket = this.makeResponsePacket(req, packet, null)) == null) {
                            return;
                        }
                        this.sendPacket(respPacket);
                        return;
                    }
                    if (pdu.type == 164) break block25;
                    if (pdu.type != 167) break block26;
                }
                if (finer) {
                    if (pdu.type == 164) {
                        logger.finer("run", "Received an SNMP trap V1");
                    } else {
                        logger.finer("run", "Received an SNMP trap V2 or V3");
                    }
                }
                this.handleTrap(version, req, packet, pdu);
                return;
            }
            if (pdu.type == 166) {
                if (finer) {
                    logger.finer("run", "Received an Inform Request");
                }
                this.handleInform(version, req, packet, pdu);
                return;
            }
            if (pdu.type == 160 && version == 3) {
                if (finer) {
                    logger.finer("run", "Received a V3 Get Request (timeliness discovery)");
                }
                this.handleV3GetRequest(version, req, packet, pdu);
                return;
            }
            if (finer) {
                logger.finer("run", "trashed the packet: bad PDU type.");
            }
            if (!finest) return;
            logger.finest("run", "trashed the packet because it's not an SNMP event report or get request (timeliness discovery)");
            return;
        }
        catch (SnmpStatusException e) {
            if (!finest) return;
            logger.finest("run", "Response packet encoding failed " + e);
            return;
        }
        catch (SnmpUnknownSecModelException e) {
            if (finest) {
                logger.finest("run", "packet decoding failed " + e);
            }
            this.incSnmpUnknownSecurityModels(1);
            return;
        }
        catch (SnmpUnknownMsgProcModelException e) {
            if (finest) {
                logger.finest("run", "Unknown Msg processing model " + e);
            }
            this.incSnmpInBadVersions(1);
            return;
        }
        catch (SnmpBadSecurityLevelException e) {
            if (finest) {
                logger.finest("run", "Invalid msg, bad security level " + e);
            }
            this.incSnmpInvalidMsgs(1);
        }
    }

    public void run() {
        while (this.enabled()) {
            try {
                byte[] dBuffer = new byte[SnmpPeer.defaultSnmpRequestPktSize];
                DatagramPacket packet = new DatagramPacket(dBuffer, SnmpPeer.defaultSnmpRequestPktSize);
                this.dSocket.setSoTimeout(0);
                if (logger.finerOn()) {
                    logger.finer("run", "Now waiting for event reports...");
                }
                this.dSocket.receive(packet);
                if (logger.finerOn()) {
                    logger.finer("run", "Received a packet from : " + packet.getAddress().toString() + ", Length = " + packet.getLength());
                }
                this.incSnmpInPkts(1);
                int version = SnmpMsg.getProtocolVersion(packet.getData());
                this.handlePacket(new PacketHandler(version, packet));
            }
            catch (SnmpStatusException e) {
                if (logger.finestOn()) {
                    logger.finest("run", "packet decoding failed");
                }
                this.incSnmpInASNParseErrs(1);
            }
            catch (Exception e) {
                if (!logger.finestOn()) continue;
                logger.finest("run", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrapListener(SnmpTrapListener handler) {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            this.trapListeners.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInformListener(SnmpInformListener handler) {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            this.informListeners.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrapListener(SnmpTrapListener handler) {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            this.trapListeners.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInformListener(SnmpInformListener handler) {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            this.informListeners.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTrapListener(SnmpTrapListener handler) {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            return this.trapListeners.contains(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsInformListener(SnmpInformListener handler) {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            return this.informListeners.contains(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getTrapListeners() {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            return this.trapListeners.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getInformListeners() {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            return this.informListeners.elements();
        }
    }

    public SnmpPduFactory getPduFactory() {
        return this.pduFactory;
    }

    public void setPduFactory(SnmpPduFactory factory) {
        if (factory == null) {
            factory = new SnmpPduFactoryBER();
        }
        this.pduFactory = factory;
    }

    private DatagramPacket makeResponsePacket(SnmpIncomingRequest req, DatagramPacket reqPacket, SnmpPdu reqPdu) {
        DatagramPacket respPacket;
        block7: {
            respPacket = null;
            SnmpMsg respMsg = this.makeResponseMessage(req, reqPacket, reqPdu);
            try {
                if (req.isReport() || respMsg != null) {
                    reqPacket.setLength(req.encodeMessage(reqPacket.getData()));
                    respPacket = reqPacket;
                }
            }
            catch (SnmpTooBigException e) {
                if (logger.finestOn()) {
                    logger.finest("makeResponsePacket", "response message is too big");
                }
                try {
                    SnmpPdu respPdu = this.newTooBigPdu(reqPdu);
                    respMsg = req.encodeSnmpPdu(respPdu, reqPacket.getData().length);
                    reqPacket.setLength(req.encodeMessage(reqPacket.getData()));
                    respPacket = reqPacket;
                }
                catch (SnmpStatusException ee) {
                    throw new InternalError();
                }
                catch (SnmpTooBigException ee) {
                    if (!logger.finestOn()) break block7;
                    logger.finest("makeResponsePacket", "'too big' is 'too big' !!!");
                }
            }
        }
        return respPacket;
    }

    private SnmpMsg makeResponseMessage(SnmpIncomingRequest req, DatagramPacket reqPacket, SnmpPdu reqPdu) {
        SnmpMsg respMsg = null;
        SnmpPdu respPdu = null;
        if (!req.isReport() && reqPdu != null) {
            respPdu = this.makeResponsePdu(reqPdu);
        }
        if (respPdu != null) {
            try {
                respMsg = req.encodeSnmpPdu(respPdu, reqPacket.getData().length);
            }
            catch (SnmpStatusException e) {
                if (logger.finestOn()) {
                    logger.finest("makeResponseMessage", "failure when encoding the response message");
                    logger.finest("makeResponseMessage", e);
                }
                respMsg = null;
            }
            catch (SnmpTooBigException e) {
                if (logger.finestOn()) {
                    logger.finest("makeResponseMessage", "response message is too big");
                }
                try {
                    respPdu = this.newTooBigPdu(reqPdu);
                    respMsg = req.encodeSnmpPdu(respPdu, reqPacket.getData().length);
                }
                catch (SnmpTooBigException ee) {
                    if (logger.finestOn()) {
                        logger.finest("makeResponseMessage", "'too big' is 'too big' !!!");
                    }
                    respMsg = null;
                }
                catch (Exception ee) {
                    respMsg = null;
                }
            }
        }
        return respMsg;
    }

    private SnmpPdu makeResponsePdu(SnmpPdu reqPdu) {
        SnmpPdu respPdu = null;
        if (this.checkPduType(reqPdu)) {
            respPdu = reqPdu;
            respPdu.type = 162;
        }
        return respPdu;
    }

    private boolean checkPduType(SnmpPdu reqPdu) {
        if (reqPdu.type == 166) {
            return true;
        }
        if (logger.finestOn()) {
            logger.finest("checkPduType", "cannot respond to this kind of PDU");
        }
        return false;
    }

    private SnmpPdu newTooBigPdu(SnmpPdu reqPdu) {
        SnmpAckPdu ackpdu = (SnmpAckPdu)((Object)reqPdu);
        SnmpPdu pdu = ackpdu.getResponsePdu();
        pdu.varBindList = null;
        SnmpPduRequestType result = (SnmpPduRequestType)((Object)pdu);
        result.setErrorStatus(1);
        result.setErrorIndex(0);
        return pdu;
    }

    private static class ObjectList {
        public static int DEFAULT_CAPACITY = 10;
        public static int DEFAULT_INCREMENT = 10;
        private final int DELTA;
        private int size = 0;
        public Object[] list;

        ObjectList() {
            this(DEFAULT_CAPACITY, DEFAULT_INCREMENT);
        }

        ObjectList(int initialCapacity) {
            this(initialCapacity, DEFAULT_INCREMENT);
        }

        ObjectList(int initialCapacity, int delta) {
            this.DELTA = delta;
            this.list = this.allocate(initialCapacity);
        }

        public final int size() {
            return this.size;
        }

        public final boolean add(Object o) {
            if (o == null) {
                return false;
            }
            if (this.size >= this.list.length) {
                this.resize();
            }
            this.list[this.size++] = o;
            return true;
        }

        public final void add(int index, Object o) {
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            if (index >= this.list.length) {
                this.resize();
            }
            if (index == this.size) {
                this.list[this.size++] = o;
                return;
            }
            System.arraycopy(this.list, index, this.list, index + 1, this.size - index);
            this.list[index] = o;
            ++this.size;
        }

        public final boolean remove(Object o) {
            if (o == null) {
                return false;
            }
            int len = this.size;
            Object[] l = this.list;
            for (int i = 0; i < len; ++i) {
                if (l[i] != o) continue;
                this.remove(i);
                return true;
            }
            return false;
        }

        public final Object remove(int index) {
            if (index >= this.size) {
                return null;
            }
            Object o = this.list[index];
            this.list[index] = null;
            if (index == --this.size) {
                return o;
            }
            System.arraycopy(this.list, index + 1, this.list, index, this.size - index);
            return o;
        }

        public final int indexOf(Object o) {
            if (o == null) {
                return -1;
            }
            int len = this.size;
            Object[] l = this.list;
            for (int i = 0; i < len; ++i) {
                if (l[i] != o) continue;
                return i;
            }
            return -1;
        }

        public final boolean contains(Object o) {
            return this.indexOf(o) > -1;
        }

        public final java.util.Enumeration elements() {
            return new Enumeration();
        }

        private final void resize() {
            Object[] newlist = this.allocate(this.list.length + this.DELTA);
            System.arraycopy(this.list, 0, newlist, 0, this.size);
            this.list = newlist;
        }

        private final Object[] allocate(int length) {
            return new Object[length];
        }

        private final class Enumeration
        implements java.util.Enumeration {
            private int next = 0;

            private Enumeration() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasMoreElements() {
                ObjectList objectList = ObjectList.this;
                synchronized (objectList) {
                    return this.next < ObjectList.this.size();
                }
            }

            public Object nextElement() {
                ObjectList objectList = ObjectList.this;
                synchronized (objectList) {
                    if (this.next < ObjectList.this.size()) {
                        return ObjectList.this.list[this.next++];
                    }
                    throw new NoSuchElementException();
                }
            }
        }
    }

    private final class PacketHandler
    implements Runnable {
        private final int version;
        private final DatagramPacket packet;

        PacketHandler(int version, DatagramPacket packet) {
            this.version = version;
            this.packet = packet;
        }

        public void run() {
            block2: {
                try {
                    SnmpEventReportDispatcher.this.doHandlePacket(this.version, this.packet);
                }
                catch (Exception e) {
                    if (!logger.finestOn()) break block2;
                    logger.finest("Unexpected exception, failed to handle packet: ", e);
                }
            }
        }
    }
}

