/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.management.snmp.BerDecoder;
import com.sun.management.snmp.BerEncoder;
import com.sun.management.snmp.BerException;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.usm.SnmpUsmSecurityParameters;

class SnmpUsmSecurityParametersImpl
implements SnmpUsmSecurityParameters {
    private SnmpEngineId authoritativeEngineId = null;
    private int authoritativeEngineBoots = 0;
    private int authoritativeEngineTime = 0;
    private String userName = null;
    private byte[] authParameters = null;
    private byte[] privParameters = null;

    public String getPrincipal() {
        return this.getUserName();
    }

    public SnmpEngineId getAuthoritativeEngineId() {
        return this.authoritativeEngineId;
    }

    public void setAuthoritativeEngineId(SnmpEngineId authoritativeEngineId) {
        this.authoritativeEngineId = authoritativeEngineId;
    }

    public int getAuthoritativeEngineBoots() {
        return this.authoritativeEngineBoots;
    }

    public void setAuthoritativeEngineBoots(int authoritativeEngineBoots) {
        this.authoritativeEngineBoots = authoritativeEngineBoots;
    }

    public int getAuthoritativeEngineTime() {
        return this.authoritativeEngineTime;
    }

    public void setAuthoritativeEngineTime(int authoritativeEngineTime) {
        this.authoritativeEngineTime = authoritativeEngineTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public byte[] getAuthParameters() {
        return this.authParameters;
    }

    public void setAuthParameters(byte[] authParameters) {
        this.authParameters = authParameters;
    }

    public byte[] getPrivParameters() {
        return this.privParameters;
    }

    public void setPrivParameters(byte[] privParameters) {
        this.privParameters = privParameters;
    }

    public SnmpUsmSecurityParametersImpl() {
    }

    public SnmpUsmSecurityParametersImpl(SnmpEngineId authoritativeEngineId, int authoritativeEngineBoots, int authoritativeEngineTime, String userName, byte[] authParameters, byte[] privParameters) {
        this.authoritativeEngineId = authoritativeEngineId;
        this.authoritativeEngineBoots = authoritativeEngineBoots;
        this.authoritativeEngineTime = authoritativeEngineTime;
        this.userName = userName;
        this.authParameters = authParameters;
        this.privParameters = privParameters;
    }

    public SnmpUsmSecurityParametersImpl(SnmpUsmSecurityParameters impl) {
        this.authoritativeEngineId = impl.getAuthoritativeEngineId();
        this.authoritativeEngineBoots = impl.getAuthoritativeEngineBoots();
        this.authoritativeEngineTime = impl.getAuthoritativeEngineTime();
        this.userName = impl.getUserName();
    }

    public void decode(byte[] params) throws SnmpStatusException {
        try {
            BerDecoder bdec = new BerDecoder(params);
            bdec.openSequence();
            this.authoritativeEngineId = SnmpEngineId.createEngineId(bdec.fetchOctetString());
            this.authoritativeEngineBoots = bdec.fetchInteger();
            this.authoritativeEngineTime = bdec.fetchInteger();
            this.userName = new String(bdec.fetchOctetString());
            this.authParameters = bdec.fetchOctetString();
            this.privParameters = bdec.fetchOctetString();
            bdec.closeSequence();
        }
        catch (BerException e) {
            throw new SnmpStatusException("Invalid security parameters Ber encoding.");
        }
    }

    public String toString() {
        return (this.authoritativeEngineId != null ? this.authoritativeEngineId.toString() : "<unknown engine id>") + " : " + (this.userName != null ? this.userName : "<unknown user>") + ":" + this.authoritativeEngineBoots + ":" + this.authoritativeEngineTime + ":" + this.authParameters + ":" + this.privParameters;
    }

    public int encode(byte[] outputBytes) throws SnmpTooBigException {
        int len = 0;
        try {
            BerEncoder bdec = new BerEncoder(outputBytes);
            bdec.openSequence();
            bdec.putOctetString(this.privParameters != null ? this.privParameters : new byte[]{});
            bdec.putOctetString(this.authParameters != null ? this.authParameters : new byte[]{});
            bdec.putOctetString(this.userName != null ? this.userName.getBytes() : new byte[]{});
            bdec.putInteger(this.authoritativeEngineTime);
            bdec.putInteger(this.authoritativeEngineBoots);
            if (this.authoritativeEngineId != null) {
                bdec.putOctetString(this.authoritativeEngineId.getBytes() != null ? this.authoritativeEngineId.getBytes() : new byte[]{});
            } else {
                bdec.putOctetString(new byte[0]);
            }
            bdec.closeSequence();
            len = bdec.trim();
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new SnmpTooBigException();
        }
        return len;
    }
}

