/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.encoding.CachedCodeBase;
import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.orbutil.newtimer.generated.TimingPoints;
import com.sun.corba.ee.impl.protocol.CorbaMessageMediatorImpl;
import com.sun.corba.ee.impl.protocol.MessageParserImpl;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.CancelRequestMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.impl.transport.CorbaResponseWaitingRoomImpl;
import com.sun.corba.ee.impl.transport.EventHandlerBase;
import com.sun.corba.ee.impl.transport.TemporarySelector;
import com.sun.corba.ee.pept.encoding.InputObject;
import com.sun.corba.ee.pept.encoding.OutputObject;
import com.sun.corba.ee.pept.protocol.MessageMediator;
import com.sun.corba.ee.pept.transport.Acceptor;
import com.sun.corba.ee.pept.transport.Connection;
import com.sun.corba.ee.pept.transport.ConnectionCache;
import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.pept.transport.EventHandler;
import com.sun.corba.ee.pept.transport.InboundConnectionCache;
import com.sun.corba.ee.pept.transport.OutboundConnectionCache;
import com.sun.corba.ee.pept.transport.ResponseWaitingRoom;
import com.sun.corba.ee.pept.transport.Selector;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.protocol.CorbaRequestId;
import com.sun.corba.ee.spi.protocol.MessageParser;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaResponseWaitingRoom;
import com.sun.corba.ee.spi.transport.TcpTimeouts;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.OutputStream;

public class SocketOrChannelConnectionImpl
extends EventHandlerBase
implements CorbaConnection,
Work {
    private static final boolean dprintWriteLocks = false;
    protected SocketChannel socketChannel;
    protected ByteBuffer byteBuffer = null;
    protected long enqueueTime;
    protected CorbaContactInfo contactInfo;
    protected Acceptor acceptor;
    protected ConnectionCache connectionCache;
    protected Socket socket;
    protected long timeStamp = 0L;
    protected boolean isServer = false;
    protected AtomicInteger requestId = new AtomicInteger(5);
    protected CorbaResponseWaitingRoom responseWaitingRoom;
    protected int state;
    protected Object stateEvent = new Object();
    protected Object writeEvent = new Object();
    protected boolean writeLocked;
    protected int serverRequestCount = 0;
    Map<Integer, CorbaMessageMediator> serverRequestMap = null;
    protected boolean postInitialContexts = false;
    protected IOR codeBaseServerIOR;
    protected CachedCodeBase cachedCodeBase = new CachedCodeBase(this);
    protected ORBUtilSystemException wrapper;
    protected TcpTimeouts tcpTimeouts;
    protected TemporarySelector tmpReadSelector;
    protected Object tmpReadSelectorLock = new Object();
    protected TemporarySelector tmpWriteSelector;
    protected Object tmpWriteSelectorLock = new Object();
    protected ConcurrentHashMap<CorbaRequestId, Queue> fragmentMap;
    private TimingPoints tp;
    protected CodeSetComponentInfo.CodeSetContext codeSetContext = null;
    protected MessageMediator clientReply_1_1;
    protected MessageMediator serverRequest_1_1;

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    protected SocketOrChannelConnectionImpl(ORB orb) {
        this.orb = orb;
        this.tp = (TimingPoints)orb.getTimerManager().points();
        this.wrapper = orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
        this.setWork(this);
        this.responseWaitingRoom = new CorbaResponseWaitingRoomImpl(orb, this);
        this.setTcpTimeouts(orb.getORBData().getTransportTcpTimeouts());
    }

    protected SocketOrChannelConnectionImpl(ORB orb, boolean useSelectThreadToWait, boolean useWorkerThread) {
        this(orb);
        this.setUseSelectThreadToWait(useSelectThreadToWait);
        this.setUseWorkerThreadForEvent(useWorkerThread);
        if (useSelectThreadToWait) {
            this.fragmentMap = new ConcurrentHashMap();
        }
    }

    public SocketOrChannelConnectionImpl(ORB orb, CorbaContactInfo contactInfo, boolean useSelectThreadToWait, boolean useWorkerThread, String socketType, String hostname, int port) {
        this(orb, useSelectThreadToWait, useWorkerThread);
        this.contactInfo = contactInfo;
        try {
            this.socket = orb.getORBData().getSocketFactory().createSocket(socketType, new InetSocketAddress(hostname, port));
            this.socketChannel = this.socket.getChannel();
            if (this.socketChannel != null) {
                boolean isBlocking = !useSelectThreadToWait;
                this.socketChannel.configureBlocking(isBlocking);
            } else {
                this.setUseSelectThreadToWait(false);
            }
            if (orb.transportDebugFlag) {
                this.dprint(".initialize: connection created: " + this.socket);
            }
        }
        catch (Throwable t) {
            throw this.wrapper.connectFailure(t, (Object)socketType, (Object)hostname, (Object)Integer.toString(port));
        }
        this.state = 1;
    }

    public SocketOrChannelConnectionImpl(ORB orb, CorbaContactInfo contactInfo, String socketType, String hostname, int port) {
        this(orb, contactInfo, orb.getORBData().connectionSocketUseSelectThreadToWait(), orb.getORBData().connectionSocketUseWorkerThreadForEvent(), socketType, hostname, port);
    }

    public SocketOrChannelConnectionImpl(ORB orb, Acceptor acceptor, Socket socket, boolean useSelectThreadToWait, boolean useWorkerThread) {
        this(orb, useSelectThreadToWait, useWorkerThread);
        this.socket = socket;
        this.socketChannel = socket.getChannel();
        if (this.socketChannel != null) {
            try {
                boolean isBlocking = !useSelectThreadToWait;
                this.socketChannel.configureBlocking(isBlocking);
            }
            catch (IOException e) {
                RuntimeException rte = new RuntimeException();
                rte.initCause(e);
                throw rte;
            }
        }
        this.acceptor = acceptor;
        this.serverRequestMap = Collections.synchronizedMap(new HashMap());
        this.isServer = true;
        this.state = 2;
    }

    public SocketOrChannelConnectionImpl(ORB orb, Acceptor acceptor, Socket socket) {
        this(orb, acceptor, socket, socket.getChannel() == null ? false : orb.getORBData().connectionSocketUseSelectThreadToWait(), socket.getChannel() == null ? false : orb.getORBData().connectionSocketUseWorkerThreadForEvent());
    }

    @Override
    public boolean shouldRegisterReadEvent() {
        return true;
    }

    @Override
    public boolean shouldRegisterServerReadEvent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean read() {
        try {
            CorbaMessageMediator messageMediator;
            if (this.orb.transportDebugFlag) {
                this.dprint(".read->: " + this);
            }
            if ((messageMediator = this.readBits()) != null) {
                boolean bl = messageMediator.dispatch();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".read<-: " + this);
            }
        }
    }

    private void unregisterForEventAndPurgeCalls(SystemException ex) {
        this.orb.getTransportManager().getSelector(0).unregisterForEvent(this);
        this.purgeCalls(ex, true, false);
    }

    protected CorbaMessageMediator readBits() {
        try {
            MessageMediator messageMediator;
            this.tp.enter_connectionReadBits();
            if (this.orb.transportDebugFlag) {
                this.dprint(".readBits->: " + this);
            }
            if (this.contactInfo != null) {
                messageMediator = this.contactInfo.createMessageMediator(this.orb, this);
            } else if (this.acceptor != null) {
                messageMediator = this.acceptor.createMessageMediator(this.orb, this);
            } else {
                throw new RuntimeException("SocketOrChannelConnectionImpl.readBits");
            }
            CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
            return corbaMessageMediator;
        }
        catch (ThreadDeath td) {
            block21: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".readBits: " + this + ": ThreadDeath: " + td, td);
                }
                try {
                    this.purgeCalls((SystemException)((Object)this.wrapper.connectionAbort(td)), false, false);
                }
                catch (Throwable t) {
                    if (!this.orb.transportDebugFlag) break block21;
                    this.dprint(".readBits: " + this + ": purgeCalls: Throwable: " + t, t);
                }
            }
            throw td;
        }
        catch (Throwable ex) {
            block22: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".readBits: " + this + ": Throwable: " + ex, ex);
                }
                if (ex instanceof SystemException) {
                    SystemException se = (SystemException)ex;
                    if (se.minor == 1398079697) {
                        this.unregisterForEventAndPurgeCalls(se);
                        throw se;
                    }
                    try {
                        if (se instanceof INTERNAL) {
                            this.sendMessageError(GIOPVersion.DEFAULT_VERSION);
                        }
                    }
                    catch (IOException e) {
                        if (!this.orb.transportDebugFlag) break block22;
                        this.dprint(".readBits: " + this + ": sendMessageError: IOException: " + e, e);
                    }
                }
            }
            this.unregisterForEventAndPurgeCalls((SystemException)((Object)this.wrapper.connectionAbort(ex)));
            throw this.wrapper.throwableInReadBits(ex);
        }
        finally {
            this.tp.exit_connectionReadBits();
            if (this.orb.transportDebugFlag) {
                this.dprint(".readBits<-: " + this);
            }
        }
    }

    @Override
    public boolean shouldUseDirectByteBuffers() {
        return this.getSocketChannel() != null;
    }

    @Override
    public ByteBuffer read(int size, int offset, int length) throws IOException {
        try {
            this.tp.enter_connectionRead1();
            if (this.shouldUseDirectByteBuffers()) {
                ByteBuffer byteBuffer = this.orb.getByteBufferPool().getByteBuffer(size);
                if (this.orb.transportDebugFlag) {
                    int bbAddress = System.identityHashCode(byteBuffer);
                    StringBuffer sb = new StringBuffer(80);
                    sb.append(".read: got ByteBuffer id (");
                    sb.append(bbAddress).append(") from ByteBufferPool.");
                    String msgStr = sb.toString();
                    this.dprint(msgStr);
                }
                byteBuffer.position(offset);
                byteBuffer.limit(size);
                this.readFully(byteBuffer, length);
                return byteBuffer;
            }
            byte[] buf = new byte[size];
            this.readFully(this.getSocket().getInputStream(), buf, offset, length);
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf);
            byteBuffer.limit(size);
            return byteBuffer;
        }
        catch (IOException ioe) {
            this.tp.exit_connectionRead1();
            if (this.state == 4) {
                throw this.wrapper.connectionRebind(ioe);
            }
            throw ioe;
        }
    }

    @Override
    public ByteBuffer read(ByteBuffer byteBuffer, int offset, int length) throws IOException {
        try {
            this.tp.enter_connectionRead2();
            int size = offset + length;
            if (this.shouldUseDirectByteBuffers()) {
                if (size > byteBuffer.capacity()) {
                    if (this.orb.transportDebugFlag) {
                        int bbAddress = System.identityHashCode(byteBuffer);
                        StringBuffer bbsb = new StringBuffer(80);
                        bbsb.append(".read: releasing ByteBuffer id (").append(bbAddress).append(") to ByteBufferPool.");
                        String bbmsg = bbsb.toString();
                        this.dprint(bbmsg);
                    }
                    this.orb.getByteBufferPool().releaseByteBuffer(byteBuffer);
                    byteBuffer = this.orb.getByteBufferPool().getByteBuffer(size);
                }
                byteBuffer.position(offset);
                byteBuffer.limit(size);
                this.readFully(byteBuffer, length);
                byteBuffer.position(0);
                byteBuffer.limit(size);
                return byteBuffer;
            }
            if (byteBuffer.isDirect()) {
                throw this.wrapper.unexpectedDirectByteBufferWithNonChannelSocket();
            }
            byte[] buf = new byte[size];
            this.readFully(this.getSocket().getInputStream(), buf, offset, length);
            return ByteBuffer.wrap(buf);
        }
        catch (IOException ioe) {
            this.tp.exit_connectionRead2();
            if (this.state == 4) {
                throw this.wrapper.connectionRebind(ioe);
            }
            throw ioe;
        }
    }

    private void readFully(ByteBuffer byteBuffer, int size) throws IOException {
        int n = 0;
        int bytecount = 0;
        TcpTimeouts.Waiter waiter = this.tcpTimeouts.waiter();
        do {
            bytecount = this.getSocketChannel().read(byteBuffer);
            if (this.orb.giopReadDebugFlag) {
                this.dprint("readFully() read " + bytecount + " bytes from channel");
            }
            if (bytecount < 0) {
                throw new IOException("End-of-stream");
            }
            if (bytecount == 0) {
                block15: {
                    TemporarySelector tmpSelector = null;
                    SelectionKey sk = null;
                    try {
                        tmpSelector = this.getTemporaryReadSelector();
                        sk = tmpSelector.registerChannel(this.getSocketChannel(), 1);
                        do {
                            int nsel;
                            if ((nsel = tmpSelector.select(waiter.getTimeForSleep())) > 0) {
                                tmpSelector.removeSelectedKey(sk);
                                bytecount = this.getSocketChannel().read(byteBuffer);
                                if (this.orb.giopReadDebugFlag) {
                                    this.dprint("readFully() read " + bytecount + " bytes from channel");
                                }
                                if (bytecount < 0) {
                                    throw new IOException("End-of-stream");
                                }
                                n += bytecount;
                            }
                            if (n >= size) continue;
                            waiter.advance();
                        } while (n < size && !waiter.isExpired());
                        if (tmpSelector == null) break block15;
                    }
                    catch (IOException ioe) {
                        try {
                            throw this.wrapper.exceptionWhenReadingWithTemporarySelector(ioe, (Object)n, (Object)size, (Object)waiter.timeWaiting(), (Object)this.tcpTimeouts.get_max_time_to_wait());
                        }
                        catch (Throwable throwable) {
                            if (tmpSelector != null) {
                                tmpSelector.cancelAndFlushSelector(sk);
                            }
                            if (this.orb.transportDebugFlag) {
                                this.dprint("readFully(): done with TemporarySelector on : " + this.toString());
                            }
                            throw throwable;
                        }
                    }
                    tmpSelector.cancelAndFlushSelector(sk);
                }
                if (!this.orb.transportDebugFlag) continue;
                this.dprint("readFully(): done with TemporarySelector on : " + this.toString());
                continue;
            }
            n += bytecount;
        } while (n < size && !waiter.isExpired());
        if (n < size && waiter.isExpired()) {
            throw this.wrapper.transportReadTimeoutExceeded(size, n, this.tcpTimeouts.get_max_time_to_wait(), waiter.timeWaiting());
        }
    }

    public void readFully(InputStream is, byte[] buf, int offset, int size) throws IOException {
        int n = 0;
        int bytecount = 0;
        TcpTimeouts.Waiter waiter = this.tcpTimeouts.waiter();
        do {
            bytecount = is.read(buf, offset + n, size - n);
            if (this.orb.giopReadDebugFlag) {
                this.dprint("readFully() read " + bytecount + " bytes from socket");
            }
            if (bytecount < 0) {
                throw new IOException("End-of-stream");
            }
            if (bytecount == 0) {
                if (this.orb.giopReadDebugFlag) {
                    this.dprint("readFully() will sleep for " + waiter.getTime() + " milliseconds");
                }
                waiter.sleepTime();
                waiter.advance();
                continue;
            }
            n += bytecount;
        } while (n < size && !waiter.isExpired());
        if (n < size && waiter.isExpired()) {
            throw this.wrapper.transportReadTimeoutExceeded(size, n, this.tcpTimeouts.get_max_time_to_wait(), waiter.timeWaiting());
        }
    }

    @Override
    public void write(ByteBuffer byteBuffer) throws IOException {
        this.tp.enter_connectionWrite();
        try {
            block21: {
                block20: {
                    TcpTimeouts.Waiter waiter;
                    block18: {
                        if (!this.shouldUseDirectByteBuffers()) break block20;
                        int nbytes = this.getSocketChannel().write(byteBuffer);
                        if (!byteBuffer.hasRemaining()) break block21;
                        waiter = this.tcpTimeouts.waiter();
                        SelectionKey sk = null;
                        TemporarySelector tmpSelector = null;
                        try {
                            tmpSelector = this.getTemporaryWriteSelector();
                            sk = tmpSelector.registerChannel(this.getSocketChannel(), 4);
                            while (byteBuffer.hasRemaining() && !waiter.isExpired()) {
                                int nsel = tmpSelector.select(waiter.getTimeForSleep());
                                if (nsel > 0) {
                                    tmpSelector.removeSelectedKey(sk);
                                    while ((nbytes = this.getSocketChannel().write(byteBuffer)) > 0 && byteBuffer.hasRemaining()) {
                                    }
                                }
                                if (nsel != 0 && nbytes != 0) continue;
                                waiter.advance();
                            }
                            if (tmpSelector == null) break block18;
                        }
                        catch (IOException ioe) {
                            try {
                                throw this.wrapper.exceptionWhenWritingWithTemporarySelector(ioe, (Object)byteBuffer.position(), (Object)byteBuffer.limit(), (Object)waiter.timeWaiting(), (Object)this.tcpTimeouts.get_max_time_to_wait());
                            }
                            catch (Throwable throwable) {
                                if (tmpSelector != null) {
                                    tmpSelector.cancelAndFlushSelector(sk);
                                }
                                if (this.orb.transportDebugFlag) {
                                    this.dprint("write: done with TemporarySelector on : " + this.toString());
                                }
                                throw throwable;
                            }
                        }
                        tmpSelector.cancelAndFlushSelector(sk);
                    }
                    if (this.orb.transportDebugFlag) {
                        this.dprint("write: done with TemporarySelector on : " + this.toString());
                    }
                    if (byteBuffer.hasRemaining() && waiter.isExpired()) {
                        throw this.wrapper.transportWriteTimeoutExceeded(this.tcpTimeouts.get_max_time_to_wait(), waiter.timeWaiting());
                    }
                    break block21;
                }
                if (!byteBuffer.hasArray()) {
                    throw this.wrapper.unexpectedDirectByteBufferWithNonChannelSocket();
                }
                byte[] tmpBuf = new byte[byteBuffer.limit()];
                System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), tmpBuf, 0, tmpBuf.length);
                this.getSocket().getOutputStream().write(tmpBuf, 0, tmpBuf.length);
                this.getSocket().getOutputStream().flush();
            }
            this.getConnectionCache().stampTime(this);
        }
        catch (IOException ioe) {
            if (this.state == 4) {
                throw this.wrapper.connectionRebind(ioe);
            }
            throw ioe;
        }
        finally {
            this.tp.exit_connectionWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            block15: {
                this.tp.enter_connectionClose();
                if (this.orb.transportDebugFlag) {
                    this.dprint(".close->: " + this);
                }
                this.writeLock();
                if (this.isBusy()) {
                    this.writeUnlock();
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".close: isBusy so no close: " + this);
                    }
                    return;
                }
                try {
                    try {
                        this.sendCloseConnection(GIOPVersion.V1_0);
                    }
                    catch (Throwable t) {
                        this.wrapper.exceptionWhenSendingCloseConnection(t);
                    }
                    Object t = this.stateEvent;
                    synchronized (t) {
                        this.state = 3;
                        this.stateEvent.notifyAll();
                    }
                    this.purgeCalls((SystemException)((Object)this.wrapper.connectionRebind()), false, true);
                }
                catch (Exception ex) {
                    if (!this.orb.transportDebugFlag) break block15;
                    this.dprint(".close: exception: " + this, ex);
                }
            }
            this.closeConnectionResources();
        }
        finally {
            this.tp.exit_connectionClose();
            if (this.orb.transportDebugFlag) {
                this.dprint(".close<-: " + this);
            }
        }
    }

    @Override
    public void closeConnectionResources() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".closeConnectionResources->: " + this);
        }
        Selector selector = this.orb.getTransportManager().getSelector(0);
        selector.unregisterForEvent(this);
        this.closeSocketAndTemporarySelectors();
        if (this.orb.transportDebugFlag) {
            this.dprint(".closeConnectionResources<-: " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSocketAndTemporarySelectors() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".closeSocketAndTemporarySelectors->: " + this);
            }
            if (this.socketChannel != null) {
                this.closeTemporarySelectors();
                if (!this.socketChannel.socket().isInputShutdown()) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint("closeSocketAndTemporarySelectors: shutting down Connection socket input stream : " + this);
                    }
                    this.socketChannel.socket().shutdownInput();
                }
                if (!this.socketChannel.socket().isOutputShutdown()) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint("closeSocketAndTemporarySelectors: shutting down Connection socket output stream : " + this);
                    }
                    this.socketChannel.socket().shutdownOutput();
                }
                if (!this.socketChannel.socket().isClosed()) {
                    this.socketChannel.socket().close();
                }
            }
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".closeSocketAndTemporarySelectors: " + this, e);
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".closeSocketAndTemporarySelectors<-: " + this);
            }
        }
    }

    @Override
    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    @Override
    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    @Override
    public EventHandler getEventHandler() {
        return this;
    }

    public OutputObject createOutputObject(MessageMediator messageMediator) {
        throw new RuntimeException("*****SocketOrChannelConnectionImpl.createOutputObject - should not be called.");
    }

    @Override
    public boolean isServer() {
        return this.isServer;
    }

    @Override
    public boolean isClosed() {
        boolean result = true;
        if (this.socketChannel != null) {
            result = !this.socketChannel.isOpen();
        } else if (this.socket != null) {
            result = this.socket.isClosed();
        }
        return result;
    }

    @Override
    public boolean isBusy() {
        return this.serverRequestCount > 0 || this.getResponseWaitingRoom().numberRegistered() > 0;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void setTimeStamp(long time) {
        this.timeStamp = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(String stateString) {
        Object object = this.stateEvent;
        synchronized (object) {
            if (stateString.equals("ESTABLISHED")) {
                this.state = 2;
                this.stateEvent.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void writeLock() {
        try {
            this.tp.enter_connectionWriteLock();
            block25: while (true) {
                var2_2 = this.stateEvent;
                // MONITORENTER : var2_2
                localState = this.state;
                // MONITOREXIT : var2_2
                switch (localState) {
                    case 1: {
                        var2_2 = this.stateEvent;
                        // MONITORENTER : var2_2
                        if (this.state != 1) {
                            // MONITOREXIT : var2_2
                            continue block25;
                        }
                        try {
                            this.stateEvent.wait();
                        }
                        catch (InterruptedException ie) {
                            if (!this.orb.transportDebugFlag) ** GOTO lbl21
                            this.dprint(".writeLock: OPENING InterruptedException: " + this);
                        }
lbl21:
                        // 3 sources

                        continue block25;
                    }
                    case 2: {
                        var2_2 = this.writeEvent;
                        // MONITORENTER : var2_2
                        if (!this.writeLocked) {
                            this.writeLocked = true;
                            // MONITOREXIT : var2_2
                            return;
                        }
                        try {
                            while (this.state == 2 && this.writeLocked) {
                                this.writeEvent.wait(100L);
                            }
                        }
                        catch (InterruptedException ie) {
                            if (!this.orb.transportDebugFlag) ** GOTO lbl38
                            this.dprint(".writeLock: ESTABLISHED InterruptedException: " + this);
                        }
lbl38:
                        // 3 sources

                        continue block25;
                    }
                    case 5: {
                        var2_2 = this.stateEvent;
                        // MONITORENTER : var2_2
                        if (this.state == 5) throw this.wrapper.writeErrorSend();
                        // MONITOREXIT : var2_2
                        continue block25;
                    }
                    case 4: {
                        var2_2 = this.stateEvent;
                        // MONITORENTER : var2_2
                        if (this.state == 4) throw this.wrapper.connectionRebind();
                        // MONITOREXIT : var2_2
                        continue block25;
                    }
                }
                if (this.orb.transportDebugFlag == false) throw new RuntimeException(".writeLock: bad state");
                this.dprint(".writeLock: default: " + this);
                throw new RuntimeException(".writeLock: bad state");
            }
        }
        finally {
            this.tp.exit_connectionWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeUnlock() {
        Object object = this.writeEvent;
        synchronized (object) {
            this.writeLocked = false;
            this.writeEvent.notify();
        }
    }

    @Override
    public void sendWithoutLock(OutputObject outputObject) {
        try {
            CDROutputObject cdrOutputObject = (CDROutputObject)outputObject;
            cdrOutputObject.writeTo(this);
        }
        catch (IOException exc) {
            COMM_FAILURE sysexc = this.state == 4 ? this.wrapper.connectionRebind(CompletionStatus.COMPLETED_MAYBE, exc) : this.wrapper.writeErrorSend(CompletionStatus.COMPLETED_MAYBE, exc);
            this.purgeCalls((SystemException)((Object)sysexc), false, true);
            throw sysexc;
        }
    }

    @Override
    public void registerWaiter(MessageMediator messageMediator) {
        this.responseWaitingRoom.registerWaiter(messageMediator);
    }

    @Override
    public void unregisterWaiter(MessageMediator messageMediator) {
        this.responseWaitingRoom.unregisterWaiter(messageMediator);
    }

    @Override
    public InputObject waitForResponse(MessageMediator messageMediator) {
        return this.responseWaitingRoom.waitForResponse(messageMediator);
    }

    @Override
    public void setConnectionCache(ConnectionCache connectionCache) {
        this.connectionCache = connectionCache;
    }

    @Override
    public ConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    @Override
    public void setUseSelectThreadToWait(boolean x) {
        this.useSelectThreadToWait = x;
    }

    @Override
    public SelectableChannel getChannel() {
        return this.socketChannel;
    }

    @Override
    public int getInterestOps() {
        return 1;
    }

    @Override
    public Connection getConnection() {
        return this;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() {
        try {
            this.tp.enter_connectionEventHandler();
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork->: " + this);
            }
            if (!this.shouldUseSelectThreadToWait()) {
                this.read();
            } else {
                this.doOptimizedReadStrategy();
            }
        }
        catch (Throwable t) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring Throwable: " + t + " " + this);
            }
        }
        finally {
            this.tp.exit_connectionEventHandler();
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork<-: " + this);
            }
        }
    }

    @Override
    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    @Override
    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    @Override
    public ResponseWaitingRoom getResponseWaitingRoom() {
        return this.responseWaitingRoom;
    }

    @Override
    public void serverRequestMapPut(int reqId, CorbaMessageMediator messageMediator) {
        this.serverRequestMap.put(reqId, messageMediator);
    }

    @Override
    public CorbaMessageMediator serverRequestMapGet(int reqId) {
        return this.serverRequestMap.get(reqId);
    }

    @Override
    public void serverRequestMapRemove(int reqId) {
        this.serverRequestMap.remove(reqId);
    }

    @Override
    public Queue<CorbaMessageMediator> getFragmentList(CorbaRequestId corbaRequestId) {
        return this.fragmentMap.get(corbaRequestId);
    }

    @Override
    public void removeFragmentList(CorbaRequestId corbaRequestId) {
        this.fragmentMap.remove(corbaRequestId);
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public synchronized void serverRequestProcessingBegins() {
        ++this.serverRequestCount;
    }

    @Override
    public synchronized void serverRequestProcessingEnds() {
        --this.serverRequestCount;
    }

    @Override
    public int getNextRequestId() {
        return this.requestId.getAndIncrement();
    }

    @Override
    public ORB getBroker() {
        return this.orb;
    }

    @Override
    public synchronized CodeSetComponentInfo.CodeSetContext getCodeSetContext() {
        return this.codeSetContext;
    }

    @Override
    public synchronized void setCodeSetContext(CodeSetComponentInfo.CodeSetContext csc) {
        if (this.codeSetContext == null) {
            if (OSFCodeSetRegistry.lookupEntry(csc.getCharCodeSet()) == null || OSFCodeSetRegistry.lookupEntry(csc.getWCharCodeSet()) == null) {
                throw this.wrapper.badCodesetsFromClient();
            }
            this.codeSetContext = csc;
        }
    }

    @Override
    public MessageMediator clientRequestMapGet(int requestId) {
        return this.responseWaitingRoom.getMessageMediator(requestId);
    }

    @Override
    public void clientReply_1_1_Put(MessageMediator x) {
        this.clientReply_1_1 = x;
    }

    @Override
    public MessageMediator clientReply_1_1_Get() {
        return this.clientReply_1_1;
    }

    @Override
    public void clientReply_1_1_Remove() {
        this.clientReply_1_1 = null;
    }

    @Override
    public void serverRequest_1_1_Put(MessageMediator x) {
        this.serverRequest_1_1 = x;
    }

    @Override
    public MessageMediator serverRequest_1_1_Get() {
        return this.serverRequest_1_1;
    }

    @Override
    public void serverRequest_1_1_Remove() {
        this.serverRequest_1_1 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStateString(int state) {
        Object object = this.stateEvent;
        synchronized (object) {
            switch (state) {
                case 1: {
                    return "OPENING";
                }
                case 2: {
                    return "ESTABLISHED";
                }
                case 3: {
                    return "CLOSE_SENT";
                }
                case 4: {
                    return "CLOSE_RECVD";
                }
                case 5: {
                    return "ABORT";
                }
            }
            return "???";
        }
    }

    @Override
    public synchronized boolean isPostInitialContexts() {
        return this.postInitialContexts;
    }

    @Override
    public synchronized void setPostInitialContexts() {
        this.postInitialContexts = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void purgeCalls(SystemException systemException, boolean die, boolean lockHeld) {
        int minor_code = systemException.minor;
        try {
            block23: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".purgeCalls->: " + minor_code + "/" + die + "/" + lockHeld + " " + this);
                }
                Object object = this.stateEvent;
                synchronized (object) {
                    if (this.state == 5 || this.state == 4) {
                        if (!this.orb.transportDebugFlag) return;
                        this.dprint(".purgeCalls: exiting since state is: " + this.getStateString(this.state) + " " + this);
                        return;
                    }
                }
                try {
                    if (!lockHeld) {
                        this.writeLock();
                    }
                }
                catch (SystemException ex) {
                    if (!this.orb.transportDebugFlag) break block23;
                    this.dprint(".purgeCalls: SystemException" + (Object)((Object)ex) + "; continuing " + this);
                }
            }
            Object object = this.stateEvent;
            synchronized (object) {
                if (minor_code == 1398079697) {
                    this.state = 4;
                    systemException.completed = CompletionStatus.COMPLETED_NO;
                } else {
                    this.state = 5;
                    systemException.completed = CompletionStatus.COMPLETED_MAYBE;
                }
                this.stateEvent.notifyAll();
            }
            this.closeSocketAndTemporarySelectors();
            if (this.serverRequest_1_1 != null) {
                ((CorbaMessageMediator)this.serverRequest_1_1).cancelRequest();
            }
            if (this.serverRequestMap != null) {
                for (CorbaMessageMediator mm : this.serverRequestMap.values()) {
                    mm.cancelRequest();
                }
            }
            this.responseWaitingRoom.signalExceptionToAllWaiters(systemException);
            if (this.contactInfo != null) {
                ((OutboundConnectionCache)this.getConnectionCache()).remove(this.contactInfo);
            } else if (this.acceptor != null) {
                ((InboundConnectionCache)this.getConnectionCache()).remove(this);
            }
            this.writeUnlock();
            return;
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".purgeCalls<-: " + minor_code + "/" + die + "/" + lockHeld + " " + this);
            }
        }
    }

    @Override
    public void sendCloseConnection(GIOPVersion giopVersion) throws IOException {
        Message msg = MessageBase.createCloseConnection(giopVersion);
        this.sendHelper(giopVersion, msg);
    }

    @Override
    public void sendMessageError(GIOPVersion giopVersion) throws IOException {
        Message msg = MessageBase.createMessageError(giopVersion);
        this.sendHelper(giopVersion, msg);
    }

    @Override
    public void sendCancelRequest(GIOPVersion giopVersion, int requestId) throws IOException {
        CancelRequestMessage msg = MessageBase.createCancelRequest(giopVersion, requestId);
        this.sendHelper(giopVersion, msg);
    }

    protected void sendHelper(GIOPVersion giopVersion, Message msg) throws IOException {
        CDROutputObject outputObject = new CDROutputObject(this.orb, null, giopVersion, this, msg, 1);
        msg.write((OutputStream)outputObject);
        outputObject.writeTo(this);
    }

    @Override
    public void sendCancelRequestWithLock(GIOPVersion giopVersion, int requestId) throws IOException {
        this.writeLock();
        try {
            this.sendCancelRequest(giopVersion, requestId);
        }
        catch (IOException ioe) {
            if (this.state == 4) {
                throw this.wrapper.connectionRebind(ioe);
            }
            throw ioe;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public final void setCodeBaseIOR(IOR ior) {
        this.codeBaseServerIOR = ior;
    }

    @Override
    public final IOR getCodeBaseIOR() {
        return this.codeBaseServerIOR;
    }

    @Override
    public final CodeBase getCodeBase() {
        return this.cachedCodeBase;
    }

    protected void setTcpTimeouts(TcpTimeouts tcpTimeouts) {
        this.tcpTimeouts = tcpTimeouts;
    }

    protected void doOptimizedReadStrategy() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doOptimizedReadStrategy->: " + this);
            }
            if (this.byteBuffer == null || !this.byteBuffer.hasRemaining()) {
                this.byteBuffer = this.orb.getByteBufferPool().getByteBuffer(this.orb.getORBData().getReadByteBufferSize());
            }
            MessageParserImpl messageParser = new MessageParserImpl(this.orb);
            messageParser.setNextMessageStartPosition(this.byteBuffer.position());
            int bytesRead = 0;
            do {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".doOptimizedReadStrategy: byteBuffer=" + this.byteBuffer + ": MessageParser starting message position: " + messageParser.getNextMessageStartPosition());
                }
                if ((bytesRead = this.nonBlockingRead()) <= 0) continue;
                this.byteBuffer.limit(this.byteBuffer.position()).position(messageParser.getNextMessageStartPosition());
                this.parseBytesAndDispatchMessages(messageParser);
                if (!messageParser.isExpectingMoreData() || this.byteBuffer.position() != this.byteBuffer.capacity()) continue;
                this.byteBuffer = this.getNewBufferAndCopyOld(messageParser);
            } while (this.nonBlockingReadWhileLoopConditionIsTrue(messageParser, bytesRead));
            if (this.orb.getORBData().alwaysEnterBlockingRead() || messageParser.isExpectingMoreData()) {
                this.blockingRead(messageParser);
            }
            this.byteBuffer.position(messageParser.getNextMessageStartPosition());
            if (this.orb.transportDebugFlag) {
                this.dprint(".doOptimizedReadStrategy: read event handling done, byteBuffer=" + this.byteBuffer);
            }
            this.resumeSelectOnMainSelector();
        }
        catch (ThreadDeath td) {
            block23: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".doOptimizedReadStrategy: " + this + ": ThreadDeath: " + td, td);
                }
                try {
                    this.purgeCalls((SystemException)((Object)this.wrapper.connectionAbort(td)), false, false);
                }
                catch (Throwable t) {
                    if (!this.orb.transportDebugFlag) break block23;
                    this.dprint(".doOptimizedReadStrategy: " + this + ": purgeCalls: Throwable: " + t, t);
                }
            }
            throw td;
        }
        catch (Throwable ex) {
            block24: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".doOptimizedReadStrategy: " + this + ": Throwable: " + ex, ex);
                }
                if (ex instanceof SystemException) {
                    SystemException se = (SystemException)ex;
                    if (se.minor == 1398079697) {
                        this.unregisterForEventAndPurgeCalls(se);
                        throw se;
                    }
                    try {
                        if (se instanceof INTERNAL) {
                            this.sendMessageError(GIOPVersion.DEFAULT_VERSION);
                        }
                    }
                    catch (IOException e) {
                        if (!this.orb.transportDebugFlag) break block24;
                        this.dprint(".doOptimizedReadStrategy: " + this + ": sendMessageError: IOException: " + e, e);
                    }
                }
            }
            this.unregisterForEventAndPurgeCalls((SystemException)((Object)this.wrapper.connectionAbort(ex)));
            throw this.wrapper.throwableInDoOptimizedReadStrategy(ex);
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doOptimizedReadStrategy<-: " + this);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void blockingRead(MessageParser messageParser) {
        block17: {
            if (this.orb.transportDebugFlag) {
                this.dprint(".blockingRead->: " + this);
                this.dprint(".blockingRead: byteBuffer=" + this.byteBuffer);
            }
            TcpTimeouts.Waiter waiter = this.tcpTimeouts.waiter();
            TemporarySelector tmpSelector = null;
            SelectionKey sk = null;
            try {
                this.getConnectionCache().stampTime(this);
                tmpSelector = this.getTemporaryReadSelector();
                sk = tmpSelector.registerChannel(this.getSocketChannel(), 1);
                do {
                    int nsel;
                    if ((nsel = tmpSelector.select(waiter.getTimeForSleep())) > 0) {
                        tmpSelector.removeSelectedKey(sk);
                        int bytesRead = this.getSocketChannel().read(this.byteBuffer);
                        if (this.orb.transportDebugFlag) {
                            this.dprint("blockingRead: read " + bytesRead + " bytes from channel");
                        }
                        if (bytesRead > 0) {
                            this.byteBuffer.limit(this.byteBuffer.position()).position(messageParser.getNextMessageStartPosition());
                            this.parseBytesAndDispatchMessages(messageParser);
                            if (messageParser.isExpectingMoreData() && this.byteBuffer.position() == this.byteBuffer.capacity()) {
                                this.byteBuffer = this.getNewBufferAndCopyOld(messageParser);
                            }
                            waiter = this.tcpTimeouts.waiter();
                            continue;
                        }
                        if (bytesRead < 0) {
                            throw this.wrapper.blockingReadEndOfStream(new IOException("End-of-Stream"), this.toString());
                        }
                        waiter.advance();
                        continue;
                    }
                    waiter.advance();
                } while (this.blockingReadWhileLoopConditionIsTrue(messageParser, waiter));
                if (messageParser.isExpectingMoreData()) {
                    throw this.wrapper.blockingReadTimeout(this.tcpTimeouts.get_max_time_to_wait(), waiter.timeWaiting());
                }
                if (tmpSelector == null) break block17;
            }
            catch (IOException ioe) {
                try {
                    throw this.wrapper.exceptionBlockingReadWithTemporarySelector(ioe, (Object)this);
                }
                catch (Throwable throwable) {
                    if (tmpSelector != null) {
                        try {
                            tmpSelector.cancelAndFlushSelector(sk);
                        }
                        catch (IOException ex) {
                            this.wrapper.unexpectedExceptionCancelAndFlushTempSelector(ex);
                        }
                    }
                    if (!this.orb.transportDebugFlag) throw throwable;
                    this.dprint(".blockingRead: byteBuffer=" + this.byteBuffer);
                    this.dprint(".blockingRead<-: " + this);
                    throw throwable;
                }
            }
            try {
                tmpSelector.cancelAndFlushSelector(sk);
            }
            catch (IOException ex) {
                this.wrapper.unexpectedExceptionCancelAndFlushTempSelector(ex);
            }
        }
        if (!this.orb.transportDebugFlag) return;
        this.dprint(".blockingRead: byteBuffer=" + this.byteBuffer);
        this.dprint(".blockingRead<-: " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseBytesAndDispatchMessages(MessageParser messageParser) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".parseBytesAndDispatchMessages->: byteBuffer=" + this.byteBuffer + " : " + messageParser);
        }
        try {
            do {
                Message message;
                if ((message = messageParser.parseBytes(this.byteBuffer, this)) == null) continue;
                ByteBuffer msgBuffer = message.getByteBuffer();
                CorbaMessageMediatorImpl messageMediator = new CorbaMessageMediatorImpl(this.orb, this, message, msgBuffer);
                boolean addToWorkerThreadQueue = true;
                if (MessageBase.messageSupportsFragments(message)) {
                    CorbaRequestId corbaRequestId;
                    if (message.getType() != 7) {
                        if (message.moreFragmentsToFollow()) {
                            corbaRequestId = MessageBase.getRequestIdFromMessageBytes(message);
                            this.fragmentMap.put(corbaRequestId, new LinkedList());
                            if (this.orb.transportDebugFlag) {
                                this.dprint(".parseBytesAndDispatchMessages: added entry to fragmentMap for request id/" + corbaRequestId);
                            }
                        }
                    } else {
                        corbaRequestId = MessageBase.getRequestIdFromMessageBytes(message);
                        Queue queue = this.fragmentMap.get(corbaRequestId);
                        if (queue != null) {
                            Queue queue2 = queue;
                            synchronized (queue2) {
                                queue.add(messageMediator);
                                if (this.orb.transportDebugFlag) {
                                    this.dprint(".parseBytesAndDispatchMessages: queued a message fragment to fragmentMap for request id/" + corbaRequestId);
                                }
                                queue.notifyAll();
                            }
                            addToWorkerThreadQueue = false;
                        } else {
                            this.wrapper.noFragmentQueueForRequestId(corbaRequestId.toString());
                        }
                    }
                }
                message.setByteBuffer(null);
                if (!addToWorkerThreadQueue) continue;
                this.addMessageMediatorToWorkQueue(messageMediator);
            } while (messageParser.hasMoreBytesToParse());
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".parseBytesAndDispatchMessages<-: byteBuffer=" + this.byteBuffer + " : " + messageParser);
            }
        }
    }

    protected int nonBlockingRead() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".nonBlockingRead->: " + this);
            this.dprint(".nonBlockingRead: byteBuffer=" + this.byteBuffer);
        }
        int bytesRead = 0;
        SocketChannel socketChannel = this.getSocketChannel();
        try {
            if (socketChannel == null || socketChannel.isBlocking()) {
                throw this.wrapper.nonBlockingReadOnBlockingSocketChannel(this);
            }
            bytesRead = socketChannel.read(this.byteBuffer);
            if (bytesRead < 0) {
                throw new IOException("End-of-stream");
            }
            if (this.orb.transportDebugFlag) {
                this.dprint(".nonBlockingRead: read " + bytesRead + " bytes from channel");
            }
            this.getConnectionCache().stampTime(this);
        }
        catch (IOException ioe) {
            if (this.state == 4) {
                throw this.wrapper.connectionRebind(ioe);
            }
            throw this.wrapper.ioexceptionWhenReadingConnection(ioe, (Object)this);
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".nonBlockingRead: byteBuffer=" + this.byteBuffer);
                this.dprint(".nonBlockingRead<-: " + this);
            }
        }
        return bytesRead;
    }

    private boolean blockingReadWhileLoopConditionIsTrue(MessageParser messageParser, TcpTimeouts.Waiter waiter) {
        boolean checkMessageParser = this.orb.getORBData().blockingReadCheckMessageParser();
        if (checkMessageParser) {
            return messageParser.isExpectingMoreData() && !waiter.isExpired();
        }
        return !waiter.isExpired();
    }

    private boolean nonBlockingReadWhileLoopConditionIsTrue(MessageParser messageParser, int bytesRead) {
        boolean checkBothConditions = this.orb.getORBData().nonBlockingReadCheckMessageParser();
        if (checkBothConditions) {
            return bytesRead > 0 && messageParser.isExpectingMoreData();
        }
        return bytesRead > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getNewBufferAndCopyOld(MessageParser messageParser) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".getNewBufferAndCopyOld->: " + this.byteBuffer + ": " + messageParser.toString());
        }
        ByteBuffer newByteBuffer = null;
        try {
            this.byteBuffer.position(messageParser.getNextMessageStartPosition());
            newByteBuffer = this.orb.getByteBufferPool().reAllocate(this.byteBuffer, messageParser.getSizeNeeded());
            messageParser.setNextMessageStartPosition(0);
        }
        finally {
            if (this.orb.transportDebugFlag) {
                String s = newByteBuffer == null ? "null" : newByteBuffer.toString();
                this.dprint(".getNewBufferAndCopyOld<-: " + s + ": " + messageParser.toString());
            }
        }
        return newByteBuffer;
    }

    private void addMessageMediatorToWorkQueue(CorbaMessageMediatorImpl messageMediator) {
        Exception throwable = null;
        try {
            int poolToUse = messageMediator.getThreadPoolToUse();
            if (this.orb.transportDebugFlag) {
                this.dprint(".addMessageMediatorToWorkQueue: add Work to pool: " + poolToUse);
            }
            this.orb.getThreadPoolManager().getThreadPool(poolToUse).getWorkQueue(0).addWork(messageMediator);
        }
        catch (NoSuchThreadPoolException e) {
            throwable = e;
        }
        catch (NoSuchWorkQueueException e) {
            throwable = e;
        }
        if (throwable != null) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".addMessageMeditorToWorkQueue: " + throwable);
            }
            throw this.wrapper.noSuchThreadpoolOrQueue(throwable);
        }
    }

    private void resumeSelectOnMainSelector() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".resumeSelectOnMainSelector:->");
        }
        this.orb.getTransportManager().getSelector(0).registerInterestOps(this);
        if (this.orb.transportDebugFlag) {
            this.dprint(".resumeSelectOnMainSelector:<-");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TemporarySelector getTemporaryReadSelector() throws IOException {
        if (this.orb.transportDebugFlag) {
            this.dprint(".getTemporaryReadSelector->: " + this);
        }
        if (this.getSocketChannel() == null || this.getSocketChannel().isBlocking()) {
            throw this.wrapper.temporaryReadSelectorWithBlockingConnection(this);
        }
        Object object = this.tmpReadSelectorLock;
        synchronized (object) {
            if (this.tmpReadSelector == null) {
                this.tmpReadSelector = new TemporarySelector(this.orb, this.getSocketChannel());
            }
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".getTemporaryReadSelector<-: selector: " + this.tmpReadSelector + ", connection: " + this);
        }
        return this.tmpReadSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TemporarySelector getTemporaryWriteSelector() throws IOException {
        if (this.orb.transportDebugFlag) {
            this.dprint(".getTemporaryWriteSelector->: " + this);
        }
        if (this.getSocketChannel() == null || this.getSocketChannel().isBlocking()) {
            throw this.wrapper.temporaryWriteSelectorWithBlockingConnection(this);
        }
        Object object = this.tmpWriteSelectorLock;
        synchronized (object) {
            if (this.tmpWriteSelector == null) {
                this.tmpWriteSelector = new TemporarySelector(this.orb, this.getSocketChannel());
            }
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".getTemporaryWriteSelector<-: selector: " + this.tmpWriteSelector + ", connection: " + this);
        }
        return this.tmpWriteSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeTemporarySelectors() throws IOException {
        if (this.orb.transportDebugFlag) {
            this.dprint(".closeTemporarySelectors->: " + this);
        }
        Object object = this.tmpReadSelectorLock;
        synchronized (object) {
            if (this.tmpReadSelector != null) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".closeTemporarySelectors: closing read selector : " + this.tmpReadSelector);
                }
                try {
                    this.tmpReadSelector.close();
                }
                catch (IOException ex) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".closeTemporarySelectors: exception closing read selector: " + ex);
                    }
                    throw ex;
                }
            }
        }
        object = this.tmpWriteSelectorLock;
        synchronized (object) {
            if (this.tmpWriteSelector != null) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".closeTemporarySelectors: closing write selector : " + this.tmpWriteSelector);
                }
                try {
                    this.tmpWriteSelector.close();
                }
                catch (IOException ex) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".closeTemporarySelectors: exception closing write selector: " + ex);
                    }
                    throw ex;
                }
            }
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".closeTemporarySelectors<-: " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.stateEvent;
        synchronized (object) {
            return "SocketOrChannelConnectionImpl[ " + (this.socketChannel == null ? this.socket.toString() : this.socketChannel.toString()) + " " + this.getStateString(this.state) + " " + this.shouldUseSelectThreadToWait() + " " + this.shouldUseWorkerThreadForEvent() + "]";
        }
    }

    @Override
    public void dprint(String msg) {
        ORBUtility.dprint("SocketOrChannelConnectionImpl", msg);
    }

    protected void dprint(String msg, Throwable t) {
        this.dprint(msg);
        t.printStackTrace(System.out);
    }
}

