/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.cache.BundleArchive;
import org.apache.felix.framework.ext.SecurityProvider;
import org.apache.felix.framework.searchpolicy.ModuleImpl;
import org.apache.felix.moduleloader.IModule;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

class BundleImpl
implements Bundle {
    private final Felix __m_felix;
    private final BundleArchive m_archive;
    private IModule[] m_modules = new IModule[0];
    private volatile int m_state;
    private BundleActivator m_activator = null;
    private BundleContext m_context = null;
    private final Map m_cachedHeaders = new HashMap();
    private long m_cachedHeadersTimestamp;
    private boolean m_removalPending = false;
    private boolean m_stale = false;
    private int m_lockCount = 0;
    private Thread m_lockThread = null;

    BundleImpl() {
        this.__m_felix = null;
        this.m_archive = null;
        this.m_state = 2;
        this.m_stale = false;
        this.m_activator = null;
        this.m_context = null;
    }

    BundleImpl(Felix felix, BundleArchive archive) throws Exception {
        this.__m_felix = felix;
        this.m_archive = archive;
        this.m_state = 2;
        this.m_stale = false;
        this.m_activator = null;
        this.m_context = null;
        IModule module = this.createModule();
        this.addModule(module);
    }

    Felix getFramework() {
        return this.__m_felix;
    }

    synchronized void dispose() {
        for (int i = 0; i < this.m_modules.length; ++i) {
            this.getFramework().getResolverState().removeModule(this.m_modules[i]);
            ((ModuleImpl)this.m_modules[i]).close();
        }
    }

    synchronized void refresh() throws Exception {
        if (this.isExtension() && this.getFramework().getState() != 16) {
            this.getFramework().getLogger().log(2, "Framework restart on extension bundle refresh not implemented.");
        } else {
            this.dispose();
            this.m_archive.purge();
            this.m_modules = new IModule[0];
            IModule module = this.createModule();
            this.addModule(module);
            this.m_state = 2;
            this.m_stale = false;
            this.m_cachedHeaders.clear();
            this.m_cachedHeadersTimestamp = 0L;
            this.m_removalPending = false;
        }
    }

    synchronized BundleActivator getActivator() {
        return this.m_activator;
    }

    synchronized void setActivator(BundleActivator activator) {
        this.m_activator = activator;
    }

    public synchronized BundleContext getBundleContext() {
        return this.m_context;
    }

    synchronized void setBundleContext(BundleContext context) {
        this.m_context = context;
    }

    public long getBundleId() {
        try {
            return this.m_archive.getId();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error getting the identifier from bundle archive.", ex);
            return -1L;
        }
    }

    public URL getEntry(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().getBundleEntry(this, name);
    }

    public Enumeration getEntryPaths(String path) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().getBundleEntryPaths(this, path);
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().findBundleEntries(this, path, filePattern, recurse);
    }

    public Dictionary getHeaders() {
        return this.getHeaders(Locale.getDefault().toString());
    }

    public Dictionary getHeaders(String locale) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "metadata"));
        }
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        return this.getFramework().getBundleHeaders(this, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getCurrentLocalizedHeader(String locale) {
        Map map = this.m_cachedHeaders;
        synchronized (map) {
            if (this.getLastModified() > this.m_cachedHeadersTimestamp) {
                this.m_cachedHeaders.clear();
            } else if (this.m_cachedHeaders.containsKey(locale)) {
                return (Map)this.m_cachedHeaders.get(locale);
            }
        }
        Map rawHeaders = this.getCurrentModule().getHeaders();
        HashMap headers = new HashMap(rawHeaders.size());
        headers.putAll(rawHeaders);
        boolean needsLocalization = false;
        Iterator it = headers.values().iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).startsWith("%")) continue;
            needsLocalization = true;
            break;
        }
        if (!needsLocalization) {
            this.updateHeaderCache(locale, headers);
            return headers;
        }
        String basename = (String)headers.get("Bundle-Localization");
        if (basename == null) {
            basename = "OSGI-INF/l10n/bundle";
        }
        List resourceList = this.createResourceList(basename, locale);
        Properties mergedProperties = new Properties();
        Iterator<Object> it2 = resourceList.iterator();
        while (it2.hasNext()) {
            URL temp = this.getCurrentModule().getResourceByDelegation(it2.next() + ".properties");
            if (temp == null) continue;
            try {
                mergedProperties.load(temp.openConnection().getInputStream());
            }
            catch (IOException ex) {}
        }
        it2 = headers.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry = (Map.Entry)it2.next();
            String value = (String)entry.getValue();
            if (!value.startsWith("%")) continue;
            String key = value.substring(value.indexOf("%") + 1);
            String newvalue = mergedProperties.getProperty(key);
            if (newvalue == null) {
                newvalue = key;
            }
            entry.setValue(newvalue);
        }
        this.updateHeaderCache(locale, headers);
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHeaderCache(String locale, Map localizedHeaders) {
        Map map = this.m_cachedHeaders;
        synchronized (map) {
            this.m_cachedHeaders.put(locale, localizedHeaders);
            this.m_cachedHeadersTimestamp = System.currentTimeMillis();
        }
    }

    private List createResourceList(String basename, String locale) {
        ArrayList<String> result = new ArrayList<String>(4);
        StringBuffer tempLocale = new StringBuffer(basename);
        result.add(tempLocale.toString());
        if (locale.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(locale, "_");
            while (tokens.hasMoreTokens()) {
                tempLocale.append("_").append(tokens.nextToken());
                result.add(tempLocale.toString());
            }
        }
        return result;
    }

    public long getLastModified() {
        try {
            return this.m_archive.getLastModified();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error reading last modification time from bundle archive.", ex);
            return 0L;
        }
    }

    void setLastModified(long l) {
        try {
            this.m_archive.setLastModified(l);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error writing last modification time to bundle archive.", ex);
        }
    }

    public String getLocation() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "metadata"));
        }
        return this._getLocation();
    }

    String _getLocation() {
        try {
            return this.m_archive.getLocation();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error getting location from bundle archive.", ex);
            return null;
        }
    }

    public URL getResource(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().getBundleResource(this, name);
    }

    public Enumeration getResources(String name) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().getBundleResources(this, name);
    }

    public ServiceReference[] getRegisteredServices() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ServiceReference[] refs = this.getFramework().getBundleRegisteredServices(this);
            if (refs == null) {
                return refs;
            }
            ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
            block2: for (int i = 0; i < refs.length; ++i) {
                String[] objectClass = (String[])refs[i].getProperty("objectClass");
                if (objectClass == null) continue;
                for (int j = 0; j < objectClass.length; ++j) {
                    try {
                        sm.checkPermission(new ServicePermission(objectClass[j], "get"));
                        result.add(refs[i]);
                        continue block2;
                    }
                    catch (Exception ex) {
                        continue;
                    }
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new ServiceReference[result.size()]);
        }
        return this.getFramework().getBundleRegisteredServices(this);
    }

    public ServiceReference[] getServicesInUse() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ServiceReference[] refs = this.getFramework().getBundleServicesInUse(this);
            if (refs == null) {
                return refs;
            }
            ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
            block2: for (int i = 0; i < refs.length; ++i) {
                String[] objectClass = (String[])refs[i].getProperty("objectClass");
                if (objectClass == null) continue;
                for (int j = 0; j < objectClass.length; ++j) {
                    try {
                        sm.checkPermission(new ServicePermission(objectClass[j], "get"));
                        result.add(refs[i]);
                        continue block2;
                    }
                    catch (Exception ex) {
                        continue;
                    }
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new ServiceReference[result.size()]);
        }
        return this.getFramework().getBundleServicesInUse(this);
    }

    public int getState() {
        return this.m_state;
    }

    void __setState(int i) {
        this.m_state = i;
    }

    int getPersistentState() {
        try {
            return this.m_archive.getPersistentState();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error reading persistent state from bundle archive.", ex);
            return 2;
        }
    }

    void setPersistentStateInactive() {
        try {
            this.m_archive.setPersistentState(2);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error writing persistent state to bundle archive.", ex);
        }
    }

    void setPersistentStateActive() {
        try {
            this.m_archive.setPersistentState(32);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error writing persistent state to bundle archive.", ex);
        }
    }

    void setPersistentStateUninstalled() {
        try {
            this.m_archive.setPersistentState(1);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error writing persistent state to bundle archive.", ex);
        }
    }

    int getStartLevel(int defaultLevel) {
        try {
            return this.m_archive.getStartLevel();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error reading start level from bundle archive.", ex);
            return defaultLevel;
        }
    }

    void setStartLevel(int i) {
        try {
            this.m_archive.setStartLevel(i);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error writing start level to bundle archive.", ex);
        }
    }

    synchronized boolean isStale() {
        return this.m_stale;
    }

    synchronized void setStale() {
        this.m_stale = true;
    }

    synchronized boolean isExtension() {
        for (int i = this.m_modules.length - 1; i > -1; --i) {
            if (!this.m_modules[i].isExtension()) continue;
            return true;
        }
        return false;
    }

    public String getSymbolicName() {
        return this.getCurrentModule().getSymbolicName();
    }

    public boolean hasPermission(Object obj) {
        return this.getFramework().bundleHasPermission(this, obj);
    }

    Object getSignerMatcher() {
        return this.getFramework().getSignerMatcher(this);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "class"));
            }
            catch (Exception ex) {
                throw new ClassNotFoundException("No permission.", ex);
            }
        }
        return this.getFramework().loadBundleClass(this, name);
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void start(int options) throws BundleException {
        if ((options & 2) > 0) {
            throw new UnsupportedOperationException("The activation policy feature has not yet been implemented.");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        this.getFramework().startBundle(this, (options & 1) == 0);
    }

    public void update() throws BundleException {
        this.update(null);
    }

    public void update(InputStream is) throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "lifecycle"));
        }
        this.getFramework().updateBundle(this, is);
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public void stop(int options) throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        this.getFramework().stopBundle(this, (options & 1) == 0);
    }

    public void uninstall() throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "lifecycle"));
        }
        this.getFramework().uninstallBundle(this);
    }

    public String toString() {
        String sym = this.getCurrentModule().getSymbolicName();
        if (sym != null) {
            return sym + " [" + this.getBundleId() + "]";
        }
        return "[" + this.getBundleId() + "]";
    }

    synchronized boolean isRemovalPending() {
        return this.m_removalPending;
    }

    synchronized void setRemovalPending(boolean removalPending) {
        this.m_removalPending = removalPending;
    }

    synchronized IModule[] getModules() {
        return this.m_modules;
    }

    synchronized boolean hasModule(IModule module) {
        for (int i = 0; i < this.m_modules.length; ++i) {
            if (this.m_modules[i] != module) continue;
            return true;
        }
        return false;
    }

    synchronized IModule getCurrentModule() {
        return this.m_modules[this.m_modules.length - 1];
    }

    synchronized boolean isUsed() {
        boolean used = false;
        for (int i = 0; !used && i < this.m_modules.length; ++i) {
            IModule[] dependents = ((ModuleImpl)this.m_modules[i]).getDependents();
            for (int j = 0; dependents != null && j < dependents.length && !used; ++j) {
                if (dependents[j] == this.m_modules[i]) continue;
                used = true;
            }
        }
        return used;
    }

    synchronized void revise(String location, InputStream is) throws Exception {
        this.m_archive.revise(location, is);
        IModule module = this.createModule();
        this.addModule(module);
    }

    synchronized boolean rollbackRevise() throws Exception {
        return this.m_archive.rollbackRevise();
    }

    synchronized void addModule(IModule module) throws Exception {
        SecurityProvider sp = this.getFramework().getSecurityProvider();
        if (sp != null) {
            // empty if block
        }
        module.setSecurityContext(new BundleProtectionDomain(this.getFramework(), this));
        IModule[] dest = new IModule[this.m_modules.length + 1];
        System.arraycopy(this.m_modules, 0, dest, 0, this.m_modules.length);
        dest[this.m_modules.length] = module;
        this.m_modules = dest;
        if (!this.isExtension()) {
            this.getFramework().getResolverState().addModule(module);
        }
    }

    private IModule createModule() throws Exception {
        Map headerMap = this.m_archive.getRevision(this.m_archive.getRevisionCount() - 1).getManifestHeader();
        int revision = this.m_archive.getRevisionCount() - 1;
        ModuleImpl module = new ModuleImpl(this.getFramework().getLogger(), this.getFramework().getConfig(), this.getFramework().getResolver(), this, Long.toString(this.getBundleId()) + "." + Integer.toString(revision), headerMap, this.m_archive.getRevision(revision).getContent(), this.getFramework().getBundleStreamHandler(), this.getFramework().getBootPackages(), this.getFramework().getBootPackageWildcards());
        if (module.getManifestVersion().equals("2")) {
            Version bundleVersion = module.getVersion();
            bundleVersion = bundleVersion == null ? Version.emptyVersion : bundleVersion;
            String symName = module.getSymbolicName();
            Bundle[] bundles = this.getFramework().getBundles();
            for (int i = 0; bundles != null && i < bundles.length; ++i) {
                long id = ((BundleImpl)bundles[i]).getBundleId();
                if (id == this.getBundleId()) continue;
                String sym = bundles[i].getSymbolicName();
                Version ver = ((ModuleImpl)((BundleImpl)bundles[i]).getCurrentModule()).getVersion();
                if (symName == null || sym == null || !symName.equals(sym) || !bundleVersion.equals(ver)) continue;
                throw new BundleException("Bundle symbolic name and version are not unique: " + sym + ':' + ver);
            }
        }
        return module;
    }

    void setProtectionDomain(ProtectionDomain pd) {
        this.getCurrentModule().setSecurityContext(pd);
    }

    synchronized ProtectionDomain getProtectionDomain() {
        ProtectionDomain pd = null;
        for (int i = this.m_modules.length - 1; i >= 0 && pd == null; --i) {
            pd = (ProtectionDomain)this.m_modules[i].getSecurityContext();
        }
        return pd;
    }

    synchronized boolean isLockable() {
        return this.m_lockCount == 0 || this.m_lockThread == Thread.currentThread();
    }

    synchronized Thread getLockingThread() {
        return this.m_lockThread;
    }

    synchronized void lock() {
        if (this.m_lockCount > 0 && this.m_lockThread != Thread.currentThread()) {
            throw new IllegalStateException("Bundle is locked by another thread.");
        }
        ++this.m_lockCount;
        this.m_lockThread = Thread.currentThread();
    }

    synchronized void unlock() {
        if (this.m_lockCount == 0) {
            throw new IllegalStateException("Bundle is not locked.");
        }
        if (this.m_lockCount > 0 && this.m_lockThread != Thread.currentThread()) {
            throw new IllegalStateException("Bundle is locked by another thread.");
        }
        --this.m_lockCount;
        if (this.m_lockCount == 0) {
            this.m_lockThread = null;
        }
    }
}

