/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.threadpool;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.threadpool.ThreadPoolImpl;
import com.sun.corba.ee.impl.orbutil.threadpool.WorkerThreadNotNeededException;
import com.sun.corba.ee.spi.monitoring.LongMonitoredAttributeBase;
import com.sun.corba.ee.spi.monitoring.MonitoredObject;
import com.sun.corba.ee.spi.monitoring.MonitoringFactories;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.orbutil.threadpool.WorkQueue;
import java.util.LinkedList;
import java.util.Queue;

public class WorkQueueImpl
implements WorkQueue {
    private static final ORBUtilSystemException wrapper = ORB.getStaticLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
    private final Queue<Work> queue;
    private ThreadPool workerThreadPool;
    private long workItemsAdded = 0L;
    private long workItemsDequeued = 0L;
    private long totalTimeInQueue = 0L;
    private final String name;
    private final MonitoredObject workqueueMonitoredObject;

    public WorkQueueImpl() {
        this.name = "default-workqueue";
        this.queue = new LinkedList<Work>();
        this.workqueueMonitoredObject = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(this.name, "Monitoring for a Work Queue");
        this.initializeMonitoring();
    }

    public WorkQueueImpl(ThreadPool workerThreadPool) {
        this(workerThreadPool, "default-workqueue");
    }

    public WorkQueueImpl(ThreadPool workerThreadPool, String name) {
        this.workerThreadPool = workerThreadPool;
        this.name = name;
        this.queue = new LinkedList<Work>();
        this.workqueueMonitoredObject = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(name, "Monitoring for a Work Queue");
        this.initializeMonitoring();
    }

    private void initializeMonitoring() {
        LongMonitoredAttributeBase b1 = new LongMonitoredAttributeBase("totalWorkItemsAdded", "Total number of Work items added to the Queue"){

            @Override
            public Object getValue() {
                return WorkQueueImpl.this.totalWorkItemsAdded();
            }
        };
        this.workqueueMonitoredObject.addAttribute(b1);
        LongMonitoredAttributeBase b2 = new LongMonitoredAttributeBase("workItemsInQueue", "Number of Work items in the Queue to be processed"){

            @Override
            public Object getValue() {
                return (long)WorkQueueImpl.this.workItemsInQueue();
            }
        };
        this.workqueueMonitoredObject.addAttribute(b2);
        LongMonitoredAttributeBase b3 = new LongMonitoredAttributeBase("averageTimeInQueue", "Average time a work item waits in the work queue"){

            @Override
            public Object getValue() {
                return WorkQueueImpl.this.averageTimeInQueue();
            }
        };
        this.workqueueMonitoredObject.addAttribute(b3);
    }

    MonitoredObject getMonitoredObject() {
        return this.workqueueMonitoredObject;
    }

    private synchronized int getWorkQueueSize() {
        return this.queue.size();
    }

    @Override
    public synchronized void addWork(Work work) {
        ++this.workItemsAdded;
        work.setEnqueueTime(System.currentTimeMillis());
        this.queue.offer(work);
        this.notify();
        int waitingThreads = this.workerThreadPool.numberOfAvailableThreads();
        int threadCount = this.workerThreadPool.currentNumberOfThreads();
        int maxThreads = this.workerThreadPool.maximumNumberOfThreads();
        if (threadCount < maxThreads && waitingThreads < this.getWorkQueueSize()) {
            ((ThreadPoolImpl)this.workerThreadPool).createWorkerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Work requestWork(long waitTime) throws WorkerThreadNotNeededException, InterruptedException {
        if (this.isQueueEmpty()) {
            try {
                ((ThreadPoolImpl)this.workerThreadPool).incrementNumberOfAvailableThreads();
                long timeOutTime = System.currentTimeMillis() + waitTime;
                this.wait(waitTime);
                if (System.currentTimeMillis() >= timeOutTime) {
                    int minThreads;
                    int availableThreads = this.workerThreadPool.numberOfAvailableThreads();
                    if (availableThreads > (minThreads = this.workerThreadPool.minimumNumberOfThreads())) {
                        ((ThreadPoolImpl)this.workerThreadPool).decrementCurrentNumberOfThreads();
                        throw new WorkerThreadNotNeededException();
                    }
                    Work work = null;
                    return work;
                }
            }
            finally {
                ((ThreadPoolImpl)this.workerThreadPool).decrementNumberOfAvailableThreads();
            }
        }
        Work work = this.queue.poll();
        ++this.workItemsDequeued;
        this.totalTimeInQueue += System.currentTimeMillis() - work.getEnqueueTime();
        return work;
    }

    private synchronized boolean isQueueEmpty() {
        int waitingThreads = this.workerThreadPool.numberOfAvailableThreads();
        return this.queue.size() - waitingThreads <= 0;
    }

    @Override
    public synchronized void setThreadPool(ThreadPool workerThreadPool) {
        this.workerThreadPool = workerThreadPool;
    }

    @Override
    public synchronized ThreadPool getThreadPool() {
        return this.workerThreadPool;
    }

    @Override
    public synchronized long totalWorkItemsAdded() {
        return this.workItemsAdded;
    }

    @Override
    public synchronized int workItemsInQueue() {
        return this.queue.size();
    }

    @Override
    public synchronized long averageTimeInQueue() {
        if (this.workItemsDequeued == 0L) {
            return 0L;
        }
        return this.totalTimeInQueue / this.workItemsDequeued;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

