/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.jmx;

import com.sun.corba.ee.impl.orbutil.jmx.AnnotationUtil;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import com.sun.corba.ee.spi.orbutil.jmx.IncludeSubclass;
import com.sun.corba.ee.spi.orbutil.jmx.InheritedAttribute;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedAttribute;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedObject;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedObjectManager;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedOperation;
import com.sun.corba.ee.spi.orbutil.jmx.TypeConverter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;

class DynamicMBeanSkeleton {
    private String type;
    private final MBeanInfo mbInfo;
    private final ManagedObjectManager mom;
    private final Map<String, AnnotationUtil.Setter> setterFunctions;
    private final Map<String, AnnotationUtil.Getter> getterFunctions;
    private final Map<String, Map<List<String>, AnnotationUtil.Operation>> operationFunctions;
    private final List<OpenMBeanAttributeInfo> mbeanAttributeInfoList;
    private final List<OpenMBeanOperationInfo> mbeanOperationInfoList;

    public void processAttribute(List<OpenMBeanAttributeInfo> list, AnnotationUtil.MethodInfo getter, AnnotationUtil.MethodInfo setter) {
        String name = getter.id();
        if (setter != null && getter != null && !setter.type().equals(getter.type())) {
            throw new IllegalArgumentException("Getter and setter types do not match for inherited attribute " + name);
        }
        TypeConverter tc = this.mom.getTypeConverter(getter.type());
        OpenMBeanAttributeInfoSupport ainfo = new OpenMBeanAttributeInfoSupport(name, getter.description(), tc.getManagedType(), getter != null, setter != null, false);
        if (setter != null) {
            AnnotationUtil.Setter setterFunction = AnnotationUtil.makeSetter(setter.method(), tc);
            this.setterFunctions.put(name, setterFunction);
        }
        if (getter != null) {
            AnnotationUtil.Getter getterFunction = AnnotationUtil.makeGetter(getter.method(), tc);
            this.getterFunctions.put(name, getterFunction);
        }
        list.add(ainfo);
    }

    public Pair<AnnotationUtil.Operation, OpenMBeanOperationInfo> makeOperation(final Method m) {
        ManagedOperation mo = m.getAnnotation(ManagedOperation.class);
        String desc = mo.description();
        Type rtype = m.getGenericReturnType();
        final TypeConverter rtc = rtype == null ? null : this.mom.getTypeConverter(rtype);
        Type[] atypes = m.getGenericParameterTypes();
        final ArrayList<TypeConverter> atcs = new ArrayList<TypeConverter>();
        for (Type type : atypes) {
            atcs.add(this.mom.getTypeConverter(type));
        }
        AnnotationUtil.Operation oper = new AnnotationUtil.Operation(){

            @Override
            public Object evaluate(Object target, List<Object> args) {
                try {
                    Object[] margs = new Object[args.size()];
                    Iterator<Object> argsIterator = args.iterator();
                    Iterator tcIterator = atcs.iterator();
                    int ctr = 0;
                    while (argsIterator.hasNext() && tcIterator.hasNext()) {
                        Object arg = argsIterator.next();
                        TypeConverter tc = (TypeConverter)tcIterator.next();
                        margs[ctr++] = tc.fromManagedEntity(arg);
                    }
                    Object result = m.invoke(target, margs);
                    if (rtc == null) {
                        return null;
                    }
                    return rtc.toManagedEntity(result);
                }
                catch (Exception exc) {
                    throw new AnnotationUtil.WrappedException(exc);
                }
            }
        };
        OpenMBeanParameterInfo[] paramInfo = new OpenMBeanParameterInfo[atcs.size()];
        int ctr = 0;
        for (TypeConverter tc : atcs) {
            paramInfo[ctr++] = new OpenMBeanParameterInfoSupport("arg" + ctr, desc, tc.getManagedType());
        }
        OpenMBeanOperationInfoSupport operInfo = new OpenMBeanOperationInfoSupport(m.getName(), desc, paramInfo, rtc.getManagedType(), 2);
        return new Pair<AnnotationUtil.Operation, OpenMBeanOperationInfo>(oper, operInfo);
    }

    public void processOperation(List<OpenMBeanOperationInfo> list, Method m) {
        Pair<AnnotationUtil.Operation, OpenMBeanOperationInfo> data = this.makeOperation(m);
        OpenMBeanOperationInfo info = data.second();
        ArrayList<String> dataTypes = new ArrayList<String>();
        for (MBeanParameterInfo pi : info.getSignature()) {
            dataTypes.add(pi.getType());
        }
        Map<List<String>, AnnotationUtil.Operation> map = this.operationFunctions.get(m.getName());
        if (map == null) {
            map = new HashMap<List<String>, AnnotationUtil.Operation>();
            this.operationFunctions.put(m.getName(), map);
        }
        map.put(dataTypes, data.first());
        list.add(info);
    }

    public DynamicMBeanSkeleton(Class<?> cls, ManagedObjectManager mom) {
        this.mom = mom;
        ManagedObject mo = cls.getAnnotation(ManagedObject.class);
        if (mo == null) {
            throw new IllegalArgumentException("Class " + cls + " does not have an @ManagedObject annotation: cannot construct dynamic MBean");
        }
        this.type = mo.type();
        if (this.type.equals("")) {
            this.type = cls.getName();
        }
        this.setterFunctions = new HashMap<String, AnnotationUtil.Setter>();
        this.getterFunctions = new HashMap<String, AnnotationUtil.Getter>();
        this.operationFunctions = new HashMap<String, Map<List<String>, AnnotationUtil.Operation>>();
        this.mbeanAttributeInfoList = new ArrayList<OpenMBeanAttributeInfo>();
        this.mbeanOperationInfoList = new ArrayList<OpenMBeanOperationInfo>();
        this.analyzeClass(cls);
        OpenMBeanAttributeInfo[] attrInfos = this.mbeanAttributeInfoList.toArray(new OpenMBeanAttributeInfo[this.mbeanAttributeInfoList.size()]);
        OpenMBeanOperationInfo[] operInfos = this.mbeanOperationInfoList.toArray(new OpenMBeanOperationInfo[this.mbeanOperationInfoList.size()]);
        this.mbInfo = new OpenMBeanInfoSupport(cls.getName(), mo.description(), attrInfos, null, operInfos, null);
    }

    private void analyzeClass(Class<?> cls) {
        IncludeSubclass is;
        InheritedAttribute[] iaa = AnnotationUtil.getInheritedAttributes(cls);
        if (iaa != null) {
            for (InheritedAttribute attr : iaa) {
                String name = attr.id();
                String desc = attr.description();
                Method setter = AnnotationUtil.getSetterMethod(cls.getSuperclass(), name);
                AnnotationUtil.MethodInfo setterInfo = new AnnotationUtil.MethodInfo(this.mom, setter, name, desc);
                Method getter = AnnotationUtil.getGetterMethod(cls.getSuperclass(), name);
                AnnotationUtil.MethodInfo getterInfo = new AnnotationUtil.MethodInfo(this.mom, getter, name, desc);
                this.processAttribute(this.mbeanAttributeInfoList, getterInfo, setterInfo);
            }
        }
        if ((is = cls.getAnnotation(IncludeSubclass.class)) != null) {
            // empty if block
        }
        List<Method> attributes = AnnotationUtil.getAnnotatedMethods(cls, ManagedAttribute.class);
        HashMap<String, AnnotationUtil.MethodInfo> getters = new HashMap<String, AnnotationUtil.MethodInfo>();
        HashMap<String, AnnotationUtil.MethodInfo> setters = new HashMap<String, AnnotationUtil.MethodInfo>();
        for (Method m : attributes) {
            AnnotationUtil.MethodInfo minfo = new AnnotationUtil.MethodInfo(this.mom, m);
            if (minfo.atype() == AnnotationUtil.AttributeType.GETTER) {
                getters.put(minfo.id(), minfo);
                continue;
            }
            setters.put(minfo.id(), minfo);
        }
        HashSet setterNames = new HashSet(setters.keySet());
        for (String str : getters.keySet()) {
            this.processAttribute(this.mbeanAttributeInfoList, (AnnotationUtil.MethodInfo)getters.get(str), (AnnotationUtil.MethodInfo)setters.get(str));
            setterNames.remove(str);
        }
        for (String str : setterNames) {
            this.processAttribute(this.mbeanAttributeInfoList, null, (AnnotationUtil.MethodInfo)setters.get(str));
        }
        List<Method> operations = AnnotationUtil.getAnnotatedMethods(cls, ManagedOperation.class);
        for (Method m : operations) {
            this.processOperation(this.mbeanOperationInfoList, m);
        }
    }

    public String getType() {
        return this.type;
    }

    public Object getAttribute(Object obj, String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        AnnotationUtil.Getter getter = this.getterFunctions.get(name);
        if (getter == null) {
            throw new AttributeNotFoundException("Could not find attribute " + name);
        }
        try {
            return getter.evaluate(obj);
        }
        catch (AnnotationUtil.WrappedException exc) {
            throw new ReflectionException(exc.getCause());
        }
    }

    public void setAttribute(Object obj, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String name = attribute.getName();
        Object value = attribute.getValue();
        AnnotationUtil.Setter setter = this.setterFunctions.get(name);
        if (setter == null) {
            throw new AttributeNotFoundException("Could not find writable attribute " + name);
        }
        try {
            setter.evaluate(obj, value);
        }
        catch (AnnotationUtil.WrappedException exc) {
            throw new ReflectionException(exc.getCause());
        }
    }

    public AttributeList getAttributes(Object obj, String[] attributes) {
        AttributeList result = new AttributeList();
        for (String str : attributes) {
            Object value = null;
            try {
                value = this.getAttribute(obj, str);
            }
            catch (Exception exc) {
                throw new IllegalArgumentException(exc);
            }
            Attribute attr = new Attribute(str, value);
            result.add(attr);
        }
        return result;
    }

    public AttributeList setAttributes(Object obj, AttributeList attributes) {
        for (Object attr : attributes) {
            try {
                this.setAttribute(obj, (Attribute)attr);
            }
            catch (Exception exc) {
                throw new IllegalArgumentException(exc);
            }
        }
        return attributes;
    }

    public Object invoke(Object obj, String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Map<List<String>, AnnotationUtil.Operation> opMap = this.operationFunctions.get(actionName);
        if (opMap == null) {
            throw new IllegalArgumentException("Could not find operation named " + actionName);
        }
        List<String> sig = Arrays.asList(signature);
        AnnotationUtil.Operation op = opMap.get(sig);
        if (op == null) {
            throw new IllegalArgumentException("Could not find operation named " + actionName + " with signature " + sig);
        }
        try {
            return op.evaluate(obj, Arrays.asList(params));
        }
        catch (AnnotationUtil.WrappedException exc) {
            throw new ReflectionException(exc.getCause());
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbInfo;
    }
}

