/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.AnnotationScanner;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DbfFactory;
import com.sun.faces.config.DocumentOrderingWrapper;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.configprovider.ConfigurationResourceProvider;
import com.sun.faces.config.configprovider.MetaInfFaceletTaglibraryConfigProvider;
import com.sun.faces.config.configprovider.MetaInfFacesConfigResourceProvider;
import com.sun.faces.config.configprovider.MojarraFacesConfigResourceProvider;
import com.sun.faces.config.configprovider.WebFaceletTaglibResourceProvider;
import com.sun.faces.config.configprovider.WebFacesConfigResourceProvider;
import com.sun.faces.config.processor.ApplicationConfigProcessor;
import com.sun.faces.config.processor.ComponentConfigProcessor;
import com.sun.faces.config.processor.ConfigProcessor;
import com.sun.faces.config.processor.ConverterConfigProcessor;
import com.sun.faces.config.processor.FaceletTaglibConfigProcessor;
import com.sun.faces.config.processor.FactoryConfigProcessor;
import com.sun.faces.config.processor.LifecycleConfigProcessor;
import com.sun.faces.config.processor.ManagedBeanConfigProcessor;
import com.sun.faces.config.processor.NavigationConfigProcessor;
import com.sun.faces.config.processor.RenderKitConfigProcessor;
import com.sun.faces.config.processor.ValidatorConfigProcessor;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.event.ApplicationPostConstructEvent;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigManager {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final List<ConfigurationResourceProvider> FACES_CONFIG_RESOURCE_PROVIDERS;
    private static final List<ConfigurationResourceProvider> FACELET_TAGLIBRARY_RESOURCE_PROVIDERS;
    private static final int NUMBER_OF_TASK_THREADS = 5;
    private static final ConfigManager CONFIG_MANAGER;
    private static final String ANNOTATIONS_SCAN_TASK_KEY;
    private static final String WEB_INF_MARKER = "com.sun.faces.webinf";
    private List<ServletContext> initializedContexts = new CopyOnWriteArrayList<ServletContext>();
    private static final ConfigProcessor FACES_CONFIG_PROCESSOR_CHAIN;
    private static final ConfigProcessor FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN;
    private static final String FACES_TO_1_1_PRIVATE_XSL = "/com/sun/faces/jsf1_0-1_1toSchema.xsl";
    private static final String FACELETS_TO_2_0_XSL = "/com/sun/faces/facelets1_0-2_0toSchema.xsl";
    private static final String FACES_CONFIG_1_X_DEFAULT_NS = "http://java.sun.com/JSF/Configuration";
    private static final String FACELETS_1_0_DEFAULT_NS = "http://java.sun.com/JSF/Facelet";

    public static ConfigManager getInstance() {
        return CONFIG_MANAGER;
    }

    public void initialize(ServletContext sc) {
        if (!this.hasBeenInitialized(sc)) {
            this.initializedContexts.add(sc);
            try {
                WebConfiguration webConfig = WebConfiguration.getInstance(sc);
                boolean validating = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ValidateFacesConfigFiles);
                ExecutorService executor = ConfigManager.createExecutorService();
                Document[] facesDocuments = ConfigManager.getConfigDocuments(sc, FACES_CONFIG_RESOURCE_PROVIDERS, executor, validating);
                Document webinfFacesConfig = facesDocuments[facesDocuments.length - 1];
                boolean isFaceletsDisabled = this.isFaceletsDisabled(webConfig, webinfFacesConfig);
                if (!this.isMetadataComplete(webinfFacesConfig)) {
                    Future<Map<Class<? extends Annotation>, Set<Class<?>>>> annotationScan = executor.submit(new AnnotationScanTask(sc));
                    this.pushTaskToContext(sc, annotationScan);
                }
                this.sortDocuments(facesDocuments);
                FACES_CONFIG_PROCESSOR_CHAIN.process(facesDocuments);
                if (!isFaceletsDisabled) {
                    FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN.process(ConfigManager.getConfigDocuments(sc, FACELET_TAGLIBRARY_RESOURCE_PROVIDERS, executor, validating));
                }
                executor.shutdown();
                this.publishPostConfigEvent();
            }
            catch (Exception e) {
                this.releaseFactories();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Unsanitized stacktrace from failed start...", e);
                }
                Throwable t = this.unwind(e);
                throw new ConfigurationException("CONFIGURATION FAILED! " + t.getMessage(), t);
            }
            finally {
                sc.removeAttribute(ANNOTATIONS_SCAN_TASK_KEY);
            }
        }
    }

    public void destory(ServletContext sc) {
        this.releaseFactories();
        this.initializedContexts.remove(sc);
    }

    public boolean hasBeenInitialized(ServletContext sc) {
        return this.initializedContexts.contains(sc);
    }

    public static Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(FacesContext ctx) {
        Map appMap = ctx.getExternalContext().getApplicationMap();
        Future scanTask = (Future)appMap.get(ANNOTATIONS_SCAN_TASK_KEY);
        try {
            return scanTask != null ? (Map)scanTask.get() : Collections.emptyMap();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    private void sortDocuments(Document[] facesDocuments) {
        int len;
        int n = len = this.isWebinfFacesConfig(facesDocuments[facesDocuments.length - 1]) ? facesDocuments.length - 1 : facesDocuments.length;
        if (len > 1) {
            ArrayList<DocumentOrderingWrapper> list = new ArrayList<DocumentOrderingWrapper>();
            for (int i = 1; i < len; ++i) {
                list.add(new DocumentOrderingWrapper(facesDocuments[i]));
            }
            DocumentOrderingWrapper[] ordering = list.toArray(new DocumentOrderingWrapper[list.size()]);
            DocumentOrderingWrapper.sort(ordering);
            for (int i = 1; i < len; ++i) {
                facesDocuments[i] = ordering[i - 1].getDocument();
            }
        }
    }

    private boolean isFaceletsDisabled(WebConfiguration webconfig, Document webinfFacesConfig) {
        boolean isFaceletsDisabled = webconfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler);
        if (!isFaceletsDisabled) {
            isFaceletsDisabled = !this.isFacesApp20(webinfFacesConfig);
            webconfig.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler, isFaceletsDisabled);
        }
        return isFaceletsDisabled;
    }

    private boolean isMetadataComplete(Document webinfFacesConfig) {
        if (this.isWebinfFacesConfig(webinfFacesConfig)) {
            if (this.isFacesApp20(webinfFacesConfig)) {
                String metadataComplete = webinfFacesConfig.getDocumentElement().getAttributeNS(webinfFacesConfig.getNamespaceURI(), "metadata-complete");
                return metadataComplete != null ? Boolean.valueOf(metadataComplete) : false;
            }
            return true;
        }
        return false;
    }

    private void pushTaskToContext(ServletContext sc, Future<Map<Class<? extends Annotation>, Set<Class<?>>>> scanTask) {
        sc.setAttribute(ANNOTATIONS_SCAN_TASK_KEY, scanTask);
    }

    private void publishPostConfigEvent() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        Application app = ctx.getApplication();
        app.publishEvent(ApplicationPostConstructEvent.class, Application.class, (Object)app);
    }

    private static Document[] getConfigDocuments(ServletContext sc, List<ConfigurationResourceProvider> providers, ExecutorService executor, boolean validating) {
        ArrayList<FutureTask> urlTasks = new ArrayList<FutureTask>(providers.size());
        for (ConfigurationResourceProvider p : providers) {
            FutureTask t = new FutureTask(new URLTask(p, sc));
            urlTasks.add(t);
            executor.execute(t);
        }
        ArrayList<FutureTask<Document>> docTasks = new ArrayList<FutureTask<Document>>(providers.size() << 1);
        for (FutureTask t : urlTasks) {
            try {
                Collection collection = (Collection)t.get();
                for (URL u : collection) {
                    FutureTask<Document> d = new FutureTask<Document>(new ParseTask(validating, u));
                    docTasks.add(d);
                    executor.execute(d);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
        }
        ArrayList docs = new ArrayList(docTasks.size());
        for (FutureTask futureTask : docTasks) {
            try {
                docs.add(futureTask.get());
            }
            catch (ExecutionException e) {
                throw new ConfigurationException(e);
            }
            catch (InterruptedException ignored) {
            }
        }
        return docs.toArray(new Document[docs.size()]);
    }

    private static ExecutorService createExecutorService() {
        return Executors.newFixedThreadPool(5);
    }

    private Throwable unwind(Throwable throwable) {
        Throwable t = null;
        if (throwable != null && (t = this.unwind(throwable.getCause())) == null) {
            t = throwable;
        }
        return t;
    }

    private void releaseFactories() {
        block2: {
            try {
                FactoryFinder.releaseFactories();
            }
            catch (FacesException ignored) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, "Exception thrown from FactoryFinder.releaseFactories()", ignored);
            }
        }
    }

    private boolean isFacesApp20(Document document) {
        if (this.isWebinfFacesConfig(document)) {
            String version = document.getDocumentElement().getAttributeNS(document.getNamespaceURI(), "version");
            if (version != null && version.length() > 0) {
                Double twoOh;
                Double v = Double.parseDouble(version);
                return v.compareTo(twoOh = Double.valueOf(2.0)) >= 0;
            }
            return false;
        }
        return true;
    }

    private boolean isWebinfFacesConfig(Document document) {
        return document.getDocumentElement().getAttribute(WEB_INF_MARKER) != null;
    }

    static {
        CONFIG_MANAGER = new ConfigManager();
        ANNOTATIONS_SCAN_TASK_KEY = ConfigManager.class.getName() + "_ANNOTATION_SCAN_TASK";
        ArrayList<ConfigurationResourceProvider> facesConfigProviders = new ArrayList<ConfigurationResourceProvider>(3);
        facesConfigProviders.add(new MojarraFacesConfigResourceProvider());
        facesConfigProviders.add(new MetaInfFacesConfigResourceProvider());
        facesConfigProviders.add(new WebFacesConfigResourceProvider());
        FACES_CONFIG_RESOURCE_PROVIDERS = Collections.unmodifiableList(facesConfigProviders);
        ArrayList<ConfigurationResourceProvider> faceletTaglibProviders = new ArrayList<ConfigurationResourceProvider>(3);
        faceletTaglibProviders.add(new MetaInfFaceletTaglibraryConfigProvider());
        faceletTaglibProviders.add(new WebFaceletTaglibResourceProvider());
        FACELET_TAGLIBRARY_RESOURCE_PROVIDERS = Collections.unmodifiableList(faceletTaglibProviders);
        ConfigProcessor[] configProcessors = new ConfigProcessor[]{new FactoryConfigProcessor(), new LifecycleConfigProcessor(), new ApplicationConfigProcessor(), new ComponentConfigProcessor(), new ConverterConfigProcessor(), new ValidatorConfigProcessor(), new ManagedBeanConfigProcessor(), new RenderKitConfigProcessor(), new NavigationConfigProcessor()};
        for (int i = 0; i < configProcessors.length; ++i) {
            ConfigProcessor p = configProcessors[i];
            if (i + 1 >= configProcessors.length) continue;
            p.setNext(configProcessors[i + 1]);
        }
        FACES_CONFIG_PROCESSOR_CHAIN = configProcessors[0];
        FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN = new FaceletTaglibConfigProcessor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationScanTask
    implements Callable<Map<Class<? extends Annotation>, Set<Class<?>>>> {
        private ServletContext sc;

        public AnnotationScanTask(ServletContext sc) {
            this.sc = sc;
        }

        @Override
        public Map<Class<? extends Annotation>, Set<Class<?>>> call() throws Exception {
            Timer t = Timer.getInstance();
            if (t != null) {
                t.startTiming();
            }
            AnnotationScanner scanner = new AnnotationScanner(this.sc);
            Map<Class<? extends Annotation>, Set<Class<?>>> annotatedClasses = scanner.getAnnotatedClasses();
            if (t != null) {
                t.stopTiming();
                t.logResult("Configuration annotation scan complete.");
            }
            return annotatedClasses;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParseTask
    implements Callable<Document> {
        private static final String JAVAEE_SCHEMA_DEFAULT_NS = "http://java.sun.com/xml/ns/javaee";
        private URL documentURL;
        private DocumentBuilderFactory factory;
        private boolean validating;

        public ParseTask(boolean validating, URL documentURL) throws Exception {
            this.documentURL = documentURL;
            this.factory = DbfFactory.getFactory();
            this.validating = validating;
        }

        @Override
        public Document call() throws Exception {
            try {
                Timer timer = Timer.getInstance();
                if (timer != null) {
                    timer.startTiming();
                }
                Document d = this.getDocument();
                if (timer != null) {
                    timer.stopTiming();
                    timer.logResult("Parse " + this.documentURL.toExternalForm());
                }
                return d;
            }
            catch (Exception e) {
                throw new ConfigurationException(MessageFormat.format("Unable to parse document ''{0}'': {1}", this.documentURL.toExternalForm(), e.getMessage()), e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Document getDocument() throws Exception {
            Document returnDoc;
            if (this.validating) {
                DocumentBuilder db = this.getNonValidatingBuilder();
                DOMSource domSource = new DOMSource(db.parse(ParseTask.getInputStream(this.documentURL), this.documentURL.toExternalForm()));
                Element documentElement = ((Document)domSource.getNode()).getDocumentElement();
                String documentNS = documentElement.getNamespaceURI();
                if (JAVAEE_SCHEMA_DEFAULT_NS.equals(documentNS)) {
                    DbfFactory.FacesSchema schema;
                    Attr version = (Attr)documentElement.getAttributes().getNamedItem("version");
                    if (version == null) throw new ConfigurationException("No document version available.");
                    String versionStr = version.getValue();
                    if ("2.0".equals(versionStr)) {
                        schema = "facelet-taglib".equals(documentElement.getLocalName()) ? DbfFactory.FacesSchema.FACELET_TAGLIB_20 : DbfFactory.FacesSchema.FACES_20;
                    } else {
                        if (!"1.2".equals(versionStr)) throw new ConfigurationException("Unknown Schema version: " + versionStr);
                        schema = DbfFactory.FacesSchema.FACES_12;
                    }
                    DocumentBuilder builder = this.getBuilderForSchema(schema);
                    builder.getSchema().newValidator().validate(domSource);
                    returnDoc = (Document)domSource.getNode();
                } else {
                    DbfFactory.FacesSchema schemaToApply;
                    DOMResult domResult = new DOMResult();
                    Transformer transformer = ParseTask.getTransformer(documentNS);
                    transformer.transform(domSource, domResult);
                    ((Document)domResult.getNode()).setDocumentURI(((Document)domSource.getNode()).getDocumentURI());
                    if (documentNS.equals(ConfigManager.FACES_CONFIG_1_X_DEFAULT_NS)) {
                        schemaToApply = DbfFactory.FacesSchema.FACES_11;
                    } else {
                        if (!documentNS.equals(ConfigManager.FACELETS_1_0_DEFAULT_NS)) throw new IllegalStateException();
                        schemaToApply = DbfFactory.FacesSchema.FACELET_TAGLIB_20;
                    }
                    DocumentBuilder builder = this.getBuilderForSchema(schemaToApply);
                    builder.getSchema().newValidator().validate(new DOMSource(domResult.getNode()));
                    returnDoc = (Document)domResult.getNode();
                }
            } else {
                DocumentBuilder builder = this.getNonValidatingBuilder();
                InputSource is = new InputSource(ParseTask.getInputStream(this.documentURL));
                is.setSystemId(this.documentURL.toExternalForm());
                returnDoc = builder.parse(is);
            }
            if (!this.documentURL.toExternalForm().contains("/WEB-INF/faces-config.xml")) return returnDoc;
            Attr webInf = returnDoc.createAttribute(ConfigManager.WEB_INF_MARKER);
            webInf.setValue("true");
            returnDoc.getDocumentElement().getAttributes().setNamedItem(webInf);
            return returnDoc;
        }

        private static Transformer getTransformer(String documentNS) throws Exception {
            String xslToApply;
            TransformerFactory factory = TransformerFactory.newInstance();
            if (documentNS.equals(ConfigManager.FACES_CONFIG_1_X_DEFAULT_NS)) {
                xslToApply = ConfigManager.FACES_TO_1_1_PRIVATE_XSL;
            } else if (documentNS.equals(ConfigManager.FACELETS_1_0_DEFAULT_NS)) {
                xslToApply = ConfigManager.FACELETS_TO_2_0_XSL;
            } else {
                throw new IllegalStateException();
            }
            return factory.newTransformer(new StreamSource(ParseTask.getInputStream(ConfigManager.class.getResource(xslToApply))));
        }

        private static InputStream getInputStream(URL url) throws IOException {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            return new BufferedInputStream(conn.getInputStream());
        }

        private DocumentBuilder getNonValidatingBuilder() throws Exception {
            DocumentBuilderFactory tFactory = DbfFactory.getFactory();
            tFactory.setValidating(false);
            DocumentBuilder tBuilder = tFactory.newDocumentBuilder();
            tBuilder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            tBuilder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
            return tBuilder;
        }

        private DocumentBuilder getBuilderForSchema(DbfFactory.FacesSchema schema) throws Exception {
            this.factory.setSchema(schema.getSchema());
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            builder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            builder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
            return builder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URLTask
    implements Callable<Collection<URL>> {
        private ConfigurationResourceProvider provider;
        private ServletContext sc;

        public URLTask(ConfigurationResourceProvider provider, ServletContext sc) {
            this.provider = provider;
            this.sc = sc;
        }

        @Override
        public Collection<URL> call() throws Exception {
            return this.provider.getResources(this.sc);
        }
    }
}

