/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public class ConversionException
extends EclipseLinkException {
    protected Class classToConvertTo;
    protected transient Object sourceObject;
    public static final int COULD_NOT_BE_CONVERTED = 3001;
    public static final int COULD_NOT_BE_CONVERTED_EXTENDED = 3002;
    public static final int INCORRECT_DATE_FORMAT = 3003;
    public static final int INCORRECT_TIME_FORMAT = 3004;
    public static final int INCORRECT_TIMESTAMP_FORMAT = 3005;
    public static final int COULD_NOT_CONVERT_TO_BYTE_ARRAY = 3006;
    public static final int COULD_NOT_BE_CONVERTED_TO_CLASS = 3007;
    public static final int INCORRECT_DATE_TIME_FORMAT = 3008;

    protected ConversionException() {
    }

    protected ConversionException(String string, Object object, Class clazz, Exception exception) {
        super(string, exception);
        this.setSourceObject(object);
        this.setClassToConvertTo(clazz);
    }

    public static ConversionException couldNotBeConverted(Object object, Object object2, ConversionException conversionException) {
        Object object3 = conversionException.getSourceObject();
        Class clazz = conversionException.getClassToConvertTo();
        Exception exception = (Exception)conversionException.getInternalException();
        Object[] objectArray = new Object[]{object3, object3.getClass(), object, object2, clazz};
        String string = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3002, objectArray);
        ConversionException conversionException2 = new ConversionException(string, object3, clazz, exception);
        conversionException2.setStackTrace(conversionException.getStackTrace());
        conversionException2.setErrorCode(3002);
        return conversionException2;
    }

    public static ConversionException couldNotBeConverted(Object object, Class clazz) {
        Object[] objectArray = new Object[]{object, object.getClass(), clazz};
        String string = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3001, objectArray);
        ConversionException conversionException = new ConversionException(string, object, clazz, null);
        conversionException.setErrorCode(3001);
        return conversionException;
    }

    public static ConversionException couldNotBeConverted(Object object, Class clazz, Exception exception) {
        Object[] objectArray = new Object[]{object, object.getClass(), clazz};
        String string = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3001, objectArray);
        ConversionException conversionException = new ConversionException(string, object, clazz, exception);
        conversionException.setErrorCode(3001);
        return conversionException;
    }

    public static ConversionException couldNotBeConvertedToClass(Object object, Class clazz, Exception exception) {
        Object[] objectArray = new Object[]{object, object.getClass(), clazz};
        String string = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3007, objectArray);
        ConversionException conversionException = new ConversionException(string, object, clazz, exception);
        conversionException.setErrorCode(3007);
        return conversionException;
    }

    public static ConversionException couldNotConvertToByteArray(Object object) {
        Object[] objectArray = new Object[]{object};
        String string = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3006, objectArray);
        ConversionException conversionException = new ConversionException(string, object, byte[].class, null);
        conversionException.setErrorCode(3006);
        return conversionException;
    }

    public static ConversionException incorrectDateFormat(String string) {
        Object[] objectArray = new Object[]{string};
        String string2 = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3003, objectArray);
        ConversionException conversionException = new ConversionException(string2, string, Date.class, null);
        conversionException.setErrorCode(3003);
        return conversionException;
    }

    public static ConversionException incorrectTimeFormat(String string) {
        Object[] objectArray = new Object[]{string};
        String string2 = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3004, objectArray);
        ConversionException conversionException = new ConversionException(string2, string, Time.class, null);
        conversionException.setErrorCode(3004);
        return conversionException;
    }

    public static ConversionException incorrectTimestampFormat(String string) {
        Object[] objectArray = new Object[]{string};
        String string2 = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3005, objectArray);
        ConversionException conversionException = new ConversionException(string2, string, Timestamp.class, null);
        conversionException.setErrorCode(3005);
        return conversionException;
    }

    public static ConversionException incorrectDateTimeFormat(String string, Class clazz) {
        Object[] objectArray = new Object[]{string};
        String string2 = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3008, objectArray);
        ConversionException conversionException = new ConversionException(string2, string, clazz, null);
        conversionException.setErrorCode(3008);
        return conversionException;
    }

    public static ConversionException incorrectDateTimeFormat(String string) {
        return ConversionException.incorrectDateTimeFormat(string, Calendar.class);
    }

    public Class getClassToConvertTo() {
        return this.classToConvertTo;
    }

    public Object getSourceObject() {
        return this.sourceObject;
    }

    public void setClassToConvertTo(Class clazz) {
        this.classToConvertTo = clazz;
    }

    public void setSourceObject(Object object) {
        this.sourceObject = object;
    }
}

