/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public class SessionLoaderException
extends EclipseLinkException {
    public static final int FINAL_EXCEPTION = 9000;
    public static final int UNKNOWN_TAG = 9001;
    public static final int UNABLE_TO_LOAD_PROJECT_CLASS = 9002;
    public static final int UNABLE_TO_PROCESS_TAG = 9003;
    public static final int COULD_NOT_FIND_PROJECT_XML = 9004;
    public static final int FAILED_TO_LOAD_PROJECT_XML = 9005;
    public static final int UNABLE_TO_PARSE_XML = 9006;
    public static final int NON_PARSE_EXCEPTION = 9007;
    public static final int UN_EXPECTED_VALUE_OF_TAG = 9008;
    public static final int UNKNOWN_ATTRIBUTE_OF_TAG = 9009;
    public static final int XML_SCHEMA_PARSING_ERROR = 9010;
    public static final int SERVER_PLATFORM_NO_LONGER_SUPPORTED = 9011;
    public static final int INVALID_SESSION_XML = 9012;
    private Vector exceptionList;

    public SessionLoaderException() {
    }

    protected SessionLoaderException(String string) {
        super(string);
    }

    protected SessionLoaderException(String string, Throwable throwable) {
        super(string);
        this.setInternalException(throwable);
    }

    public static SessionLoaderException couldNotFindProjectXml(String string) {
        Object[] objectArray = new Object[]{string};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9004, objectArray));
        sessionLoaderException.setErrorCode(9004);
        return sessionLoaderException;
    }

    public static SessionLoaderException unkownTagAtNode(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9001, objectArray), throwable);
        sessionLoaderException.setErrorCode(9001);
        return sessionLoaderException;
    }

    public static SessionLoaderException failedToLoadProjectClass(String string, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9002, objectArray), throwable);
        sessionLoaderException.setErrorCode(9002);
        return sessionLoaderException;
    }

    public static SessionLoaderException failedToLoadProjectXml(String string, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9005, objectArray), throwable);
        sessionLoaderException.setErrorCode(9005);
        return sessionLoaderException;
    }

    public static SessionLoaderException failedToLoadTag(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9003, objectArray), throwable);
        sessionLoaderException.setErrorCode(9003);
        return sessionLoaderException;
    }

    public static SessionLoaderException finalException(Vector vector) {
        Object[] objectArray = new Object[]{new Integer(vector.size())};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9000, objectArray));
        sessionLoaderException.setErrorCode(9000);
        sessionLoaderException.setExceptionList(vector);
        return sessionLoaderException;
    }

    public static SessionLoaderException failedToParseXML(String string, int n, int n2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9006, objectArray), throwable);
        sessionLoaderException.setErrorCode(9006);
        return sessionLoaderException;
    }

    public static SessionLoaderException failedToParseXML(String string, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9010, objectArray), throwable);
        sessionLoaderException.setErrorCode(9010);
        return sessionLoaderException;
    }

    public static SessionLoaderException nonParseException(Throwable throwable) {
        Object[] objectArray = new Object[]{};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9007, objectArray), throwable);
        sessionLoaderException.setErrorCode(9007);
        return sessionLoaderException;
    }

    public static SessionLoaderException unexpectedValueOfTag(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9008, objectArray));
        sessionLoaderException.setErrorCode(9008);
        return sessionLoaderException;
    }

    public static SessionLoaderException unknownAttributeOfTag(String string) {
        Object[] objectArray = new Object[]{string};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9009, objectArray));
        sessionLoaderException.setErrorCode(9009);
        return sessionLoaderException;
    }

    public static SessionLoaderException serverPlatformNoLongerSupported(String string) {
        Object[] objectArray = new Object[]{string};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9011, objectArray));
        sessionLoaderException.setErrorCode(9011);
        return sessionLoaderException;
    }

    public static SessionLoaderException InvalidSessionXML() {
        Object[] objectArray = new Object[]{};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9012, objectArray));
        sessionLoaderException.setErrorCode(9012);
        return sessionLoaderException;
    }

    public void setExceptionList(Vector vector) {
        this.exceptionList = vector;
    }

    public Vector getExceptionList() {
        return this.exceptionList;
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.getExceptionList() != null) {
            printWriter.println("SessionLoaderExceptions:");
            Iterator iterator = this.getExceptionList().iterator();
            while (iterator.hasNext()) {
                printWriter.write("***");
                printWriter.write(SessionLoaderException.cr());
                ((Throwable)iterator.next()).printStackTrace(printWriter);
                printWriter.write(SessionLoaderException.cr());
            }
        }
        printWriter.flush();
    }

    public String toString() {
        if (this.getErrorCode() == 9000) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getMessage());
            stringBuffer.append(SessionLoaderException.cr());
            Iterator iterator = this.getExceptionList().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("***");
                stringBuffer.append(SessionLoaderException.cr());
                stringBuffer.append(iterator.next().toString());
                stringBuffer.append(SessionLoaderException.cr());
            }
            return stringBuffer.toString();
        }
        return super.toString();
    }
}

