/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.codegen.CodeDefinition;
import org.eclipse.persistence.internal.codegen.CodeGenerator;

public abstract class AttributeDefinition
extends CodeDefinition {
    protected String initialValue;

    private void adjustInitialValue(Map map) {
        if (this.getInitialValue() == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(this.getInitialValue());
        Set set = AttributeDefinition.parseForTypeNames(stringBuffer.toString());
        for (String string : set) {
            String string2;
            if (string.equals(string2 = AttributeDefinition.adjustTypeName(string, map))) continue;
            int n = stringBuffer.toString().indexOf(string);
            while (n != -1) {
                stringBuffer.replace(n, n + string.length(), string2);
                n = stringBuffer.toString().indexOf(string);
            }
        }
        this.setInitialValue(stringBuffer.toString());
    }

    protected void adjustTypeNames(Map map) {
        this.adjustInitialValue(map);
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    protected abstract String getTypeName();

    protected void putTypeNamesInMap(Map map) {
        AttributeDefinition.putTypeNameInMap(this.getTypeName(), map);
        Iterator iterator = AttributeDefinition.parseForTypeNames(this.getInitialValue()).iterator();
        while (iterator.hasNext()) {
            AttributeDefinition.putTypeNameInMap((String)iterator.next(), map);
        }
    }

    public void setInitialValue(String string) {
        this.initialValue = string;
    }

    public void writeBody(CodeGenerator codeGenerator) {
        codeGenerator.writeType(this.getTypeName());
        codeGenerator.writeType(" ");
        codeGenerator.write(this.getName());
        if (this.getInitialValue() != null) {
            codeGenerator.write(" = ");
            codeGenerator.write(this.getInitialValue());
        }
        codeGenerator.write(";");
    }
}

