/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public class QueryBasedValueHolder
extends DatabaseValueHolder {
    protected transient ReadQuery query;

    public QueryBasedValueHolder(ReadQuery readQuery, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        this.row = abstractRecord;
        this.session = abstractSession;
        if (!abstractSession.isUnitOfWork()) {
            this.session = abstractSession.getRootSession(readQuery);
        }
        this.query = readQuery;
    }

    protected ReadQuery getQuery() {
        return this.query;
    }

    protected Object instantiate() throws DatabaseException {
        return this.instantiate(this.getSession());
    }

    protected Object instantiate(AbstractSession abstractSession) throws DatabaseException {
        if (abstractSession == null) {
            throw ValidationException.instantiatingValueholderWithNullSession();
        }
        return abstractSession.executeQuery((DatabaseQuery)this.getQuery(), this.getRow());
    }

    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        return this.instantiate(unitOfWorkValueHolder.getUnitOfWork());
    }

    public void releaseWrappedValueHolder() {
        AbstractSession abstractSession = this.getSession();
        if (abstractSession != null && abstractSession.isUnitOfWork()) {
            this.setSession(abstractSession.getRootSession(this.query));
        }
    }

    protected void resetFields() {
        super.resetFields();
        this.setQuery(null);
    }

    protected void setQuery(ReadQuery readQuery) {
        this.query = readQuery;
    }

    public boolean isPessimisticLockingValueHolder() {
        if (this.getQuery() == null || !this.getQuery().isObjectLevelReadQuery()) {
            return false;
        }
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
        return objectLevelReadQuery.isLockQuery(this.getSession());
    }
}

