/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;

public class QNameInheritancePolicy
extends InheritancePolicy {
    private NamespaceResolver namespaceResolver;

    public QNameInheritancePolicy() {
    }

    public QNameInheritancePolicy(ClassDescriptor classDescriptor) {
        super(classDescriptor);
    }

    public void initialize(AbstractSession abstractSession) {
        Object object;
        super.initialize(abstractSession);
        if (!this.shouldUseClassNameAsIndicator() && this.namespaceResolver != null) {
            for (XPathFragment xPathFragment : new HashMap(this.getClassIndicatorMapping()).keySet()) {
                QName qName;
                object = this.getClassIndicatorMapping().get(xPathFragment);
                if (!(xPathFragment instanceof String)) continue;
                String string = (String)((Object)xPathFragment);
                int n = string.indexOf(":");
                if (n != -1) {
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    String string4 = this.namespaceResolver.resolveNamespacePrefix(string2);
                    qName = new QName(string4, string3);
                } else {
                    qName = this.namespaceResolver != null ? new QName(this.namespaceResolver.getDefaultNamespaceURI(), string) : new QName(string);
                }
                this.getClassIndicatorMapping().put(qName, object);
            }
        }
        if (this.getClassIndicatorField() != null) {
            Object object2;
            XPathFragment xPathFragment;
            try {
                object2 = (XMLField)this.getClassIndicatorField();
            }
            catch (ClassCastException classCastException) {
                object2 = new XMLField(this.getClassIndicatorField().getName());
                this.setClassIndicatorField((DatabaseField)object2);
            }
            xPathFragment = ((XMLField)object2).getLastXPathFragment();
            if (xPathFragment != null && xPathFragment.hasNamespace() && this.namespaceResolver != null) {
                object = this.namespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
                ((XMLField)object2).getLastXPathFragment().setNamespaceURI((String)object);
            }
        }
    }

    public Class classFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) throws DescriptorException {
        Class clazz;
        ((XMLRecord)abstractRecord).setSession(abstractSession);
        if (this.hasClassExtractor() || this.shouldUseClassNameAsIndicator()) {
            return super.classFromRow(abstractRecord, abstractSession);
        }
        Object object = abstractRecord.get(this.getClassIndicatorField());
        if (object == AbstractRecord.noEntry) {
            return null;
        }
        Object object2 = abstractSession.getDatasourcePlatform().getConversionManager().convertObject(object, this.getClassIndicatorField().getType());
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof String) {
            String string = (String)object2;
            int n = string.indexOf(":");
            if (n == -1) {
                String string2 = ((XMLRecord)abstractRecord).resolveNamespacePrefix(null);
                if (string2 == null) {
                    clazz = (Class)this.classIndicatorMapping.get(object2);
                } else {
                    QName qName = new QName(string2, string);
                    clazz = (Class)this.classIndicatorMapping.get(qName);
                }
            } else {
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1);
                String string5 = ((XMLRecord)abstractRecord).resolveNamespacePrefix(string3);
                if (string5 != null) {
                    QName qName = new QName(string5, string4);
                    clazz = (Class)this.classIndicatorMapping.get(qName);
                } else {
                    clazz = (Class)this.classIndicatorMapping.get(string);
                }
            }
        } else {
            clazz = (Class)this.classIndicatorMapping.get(object2);
        }
        if (clazz == null) {
            throw DescriptorException.missingClassForIndicatorFieldValue(object2, this.getDescriptor());
        }
        return clazz;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public void setClassIndicatorFieldName(String string) {
        if (string == null) {
            this.setClassIndicatorField(null);
        } else {
            this.setClassIndicatorField(new XMLField(string));
        }
    }
}

