/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;

public class PrivilegedAccessHelper {
    private static boolean shouldCheckPrivilegedAccess = true;
    private static boolean shouldUsePrivilegedAccess = false;

    private static Field findDeclaredField(Class clazz, String string) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                throw noSuchFieldException;
            }
            return PrivilegedAccessHelper.findDeclaredField(clazz2, string);
        }
    }

    private static Method findMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                throw noSuchMethodException;
            }
            try {
                return PrivilegedAccessHelper.findMethod(clazz2, string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw noSuchMethodException;
            }
        }
    }

    public static Class getClassForName(String string) throws ClassNotFoundException {
        return Class.forName(string);
    }

    public static Class getClassForName(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(string, bl, classLoader);
    }

    public static ClassLoader getClassLoaderForClass(Class clazz) {
        return clazz.getClassLoader();
    }

    public static ClassLoader privilegedGetClassLoaderForClass(Class clazz) {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(clazz));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (RuntimeException)privilegedActionException.getCause();
        }
    }

    public static Constructor getConstructorFor(Class clazz, Class[] classArray, boolean bl) throws NoSuchMethodException {
        Constructor constructor = clazz.getConstructor(classArray);
        if (bl) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    public static ClassLoader getContextClassLoader(Thread thread) {
        return thread.getContextClassLoader();
    }

    public static Constructor getDeclaredConstructorFor(Class clazz, Class[] classArray, boolean bl) throws NoSuchMethodException {
        Constructor constructor = clazz.getDeclaredConstructor(classArray);
        if (bl) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    public static Field getField(Class clazz, String string, boolean bl) throws NoSuchFieldException {
        Field field = PrivilegedAccessHelper.findDeclaredField(clazz, string);
        if (bl) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field getDeclaredField(Class clazz, String string, boolean bl) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(string);
        if (bl) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field[] getDeclaredFields(Class clazz) {
        return clazz.getDeclaredFields();
    }

    public static Field[] getFields(Class clazz) {
        return clazz.getFields();
    }

    public static Method getDeclaredMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        return clazz.getDeclaredMethod(string, classArray);
    }

    public static Method getMethod(Class clazz, String string, Class[] classArray, boolean bl) throws NoSuchMethodException {
        Method method = PrivilegedAccessHelper.findMethod(clazz, string, classArray);
        if (bl) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method getPublicMethod(Class clazz, String string, Class[] classArray, boolean bl) throws NoSuchMethodException {
        Method method = clazz.getMethod(string, classArray);
        if (bl) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method[] getDeclaredMethods(Class clazz) {
        return clazz.getDeclaredMethods();
    }

    public static Class getFieldType(Field field) {
        return field.getType();
    }

    public static String getLineSeparator() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("file.separator");
                }
            });
        }
        return Helper.cr();
    }

    public static Class[] getMethodParameterTypes(Method method) {
        return method.getParameterTypes();
    }

    public static Class getMethodReturnType(Method method) {
        return method.getReturnType();
    }

    public static Method[] getMethods(Class clazz) {
        return clazz.getMethods();
    }

    public static Object getValueFromField(Field field, Object object) throws IllegalAccessException {
        return field.get(object);
    }

    public static Object invokeConstructor(Constructor constructor, Object[] objectArray) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return constructor.newInstance(objectArray);
    }

    public static Object invokeMethod(Method method, Object object) throws IllegalAccessException, InvocationTargetException {
        return PrivilegedAccessHelper.invokeMethod(method, object, null);
    }

    public static Object invokeMethod(Method method, Object object, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method.invoke(object, objectArray);
    }

    public static Object newInstanceFromClass(Class clazz) throws IllegalAccessException, InstantiationException {
        return clazz.newInstance();
    }

    public static void setValueInField(Field field, Object object, Object object2) throws IllegalAccessException {
        field.set(object, object2);
    }

    public static boolean shouldUsePrivilegedAccess() {
        if (shouldCheckPrivilegedAccess) {
            if (System.getSecurityManager() != null) {
                Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        String string = System.getProperty("eclipselink.security.usedoprivileged");
                        return string != null && string.equalsIgnoreCase("true");
                    }
                });
                shouldUsePrivilegedAccess = bl;
            } else {
                shouldUsePrivilegedAccess = false;
            }
            shouldCheckPrivilegedAccess = false;
        }
        return shouldUsePrivilegedAccess;
    }
}

