/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sequencing;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.sequencing.DatabaseSessionConnectionHandler;
import org.eclipse.persistence.internal.sequencing.PreallocationHandler;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingCallback;
import org.eclipse.persistence.internal.sequencing.SequencingCallbackFactory;
import org.eclipse.persistence.internal.sequencing.SequencingConnectionHandler;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sequencing.SequencingServer;
import org.eclipse.persistence.internal.sequencing.ServerSessionConnectionHandler;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.SequencingControl;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ExternalConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SequencingManager
implements SequencingHome,
SequencingServer,
SequencingControl {
    private DatabaseSessionImpl ownerSession;
    private SequencingConnectionHandler connectionHandler;
    private PreallocationHandler preallocationHandler;
    private int whenShouldAcquireValueForAll;
    private Vector connectedSequences;
    boolean atLeastOneSequenceShouldUseTransaction;
    boolean atLeastOneSequenceShouldUsePreallocation;
    private static final int NOPREALLOCATION = 0;
    private static final int PREALLOCATION_NOTRANSACTION = 1;
    private static final int PREALLOCATION_TRANSACTION_NOACCESSOR = 2;
    private static final int PREALLOCATION_TRANSACTION_ACCESSOR = 3;
    private static final int NUMBER_OF_STATES = 4;
    private State[] states;
    private Map<String, ConcurrencyManager> locks;
    private SequencingCallbackFactory callbackFactory;
    private SequencingServer server;
    private Sequencing seq;
    private boolean shouldUseSeparateConnection;
    private Login login;
    private int minPoolSize;
    private int maxPoolSize;

    public SequencingManager(DatabaseSessionImpl databaseSessionImpl) {
        this.ownerSession = databaseSessionImpl;
    }

    protected DatabaseSessionImpl getOwnerSession() {
        return this.ownerSession;
    }

    protected void createConnectionHandler() {
        Object object;
        boolean bl = this.getOwnerSession().isServerSession();
        if (this.getLogin() == null) {
            object = bl ? ((ServerSession)this.getOwnerSession()).getReadConnectionPool().getLogin() : this.getOwnerSession().getDatasourceLogin();
            this.setLogin((Login)object.clone());
        }
        if (this.getLogin() != null && this.getLogin().shouldUseExternalTransactionController()) {
            throw ValidationException.invalidSequencingLogin();
        }
        if (bl) {
            object = null;
            if (this.getLogin().shouldUseExternalConnectionPooling()) {
                object = new ExternalConnectionPool("sequencing", this.getLogin(), (ServerSession)this.getOwnerSession());
            } else {
                if (this.getMinPoolSize() == 0 && this.getMaxPoolSize() == 0) {
                    this.setMinPoolSize(2);
                    this.setMaxPoolSize(2);
                }
                object = new ConnectionPool("sequencing", this.getLogin(), this.getMinPoolSize(), this.getMaxPoolSize(), (ServerSession)this.getOwnerSession());
            }
            this.setConnectionHandler(new ServerSessionConnectionHandler((ConnectionPool)object));
        } else {
            this.setConnectionHandler(new DatabaseSessionConnectionHandler(this.getOwnerSession(), this.getLogin()));
        }
    }

    @Override
    public SequencingControl getSequencingControl() {
        return this;
    }

    protected void setSequencing(Sequencing sequencing) {
        this.seq = sequencing;
    }

    @Override
    public Sequencing getSequencing() {
        return this.seq;
    }

    protected void setSequencingServer(SequencingServer sequencingServer) {
        this.server = sequencingServer;
    }

    @Override
    public SequencingServer getSequencingServer() {
        return this.server;
    }

    protected void setSequencingCallbackFactory(SequencingCallbackFactory sequencingCallbackFactory) {
        this.callbackFactory = sequencingCallbackFactory;
    }

    @Override
    public boolean isSequencingCallbackRequired() {
        return this.callbackFactory != null;
    }

    @Override
    public boolean shouldUseSeparateConnection() {
        return this.shouldUseSeparateConnection;
    }

    @Override
    public void setShouldUseSeparateConnection(boolean bl) {
        this.shouldUseSeparateConnection = bl;
    }

    @Override
    public boolean isConnectedUsingSeparateConnection() {
        return this.isConnected() && this.getConnectionHandler() != null;
    }

    @Override
    public Login getLogin() {
        return this.login;
    }

    @Override
    public void setLogin(Login login) {
        this.login = login;
    }

    @Override
    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    @Override
    public void setMinPoolSize(int n) {
        this.minPoolSize = n;
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
    }

    @Override
    public boolean isConnected() {
        return this.states != null;
    }

    protected SequencingConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    protected void setConnectionHandler(SequencingConnectionHandler sequencingConnectionHandler) {
        this.connectionHandler = sequencingConnectionHandler;
    }

    @Override
    public ConnectionPool getConnectionPool() {
        ConnectionPool connectionPool = null;
        if (this.getConnectionHandler() != null && this.getConnectionHandler() instanceof ServerSessionConnectionHandler) {
            connectionPool = ((ServerSessionConnectionHandler)this.getConnectionHandler()).getPool();
        }
        return connectionPool;
    }

    @Override
    public Object getNextValue(Class clazz) {
        return this.getNextValue(this.getOwnerSession(), clazz);
    }

    @Override
    public void initializePreallocated() {
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().initializePreallocated();
        }
    }

    @Override
    public void initializePreallocated(String string) {
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().initializePreallocated(string);
        }
    }

    protected void setLocks(Map map) {
        this.locks = map;
    }

    protected Map<String, ConcurrencyManager> getLocks() {
        return this.locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireLock(String string) {
        ConcurrencyManager concurrencyManager = this.getLocks().get(string);
        if (concurrencyManager == null) {
            Map<String, ConcurrencyManager> map = this.getLocks();
            synchronized (map) {
                concurrencyManager = this.getLocks().get(string);
                if (concurrencyManager == null) {
                    concurrencyManager = new ConcurrencyManager();
                    this.getLocks().put(string, concurrencyManager);
                }
            }
        }
        concurrencyManager.acquire();
    }

    protected void releaseLock(String string) {
        ConcurrencyManager concurrencyManager = this.getLocks().get(string);
        concurrencyManager.release();
    }

    protected Sequence getSequence(Class clazz) {
        String string = this.getOwnerSession().getDescriptor(clazz).getSequenceNumberName();
        return this.getSequence(string);
    }

    protected void logDebugPreallocation(String string, Object object, Vector vector) {
        if (this.getOwnerSession().shouldLog(1, "sequencing")) {
            Object[] objectArray = new Object[]{string, new Integer(vector.size() + 1), object, vector.lastElement()};
            this.getOwnerSession().log(1, "sequencing", "sequencing_preallocation", objectArray);
        }
    }

    protected void logDebugLocalPreallocation(AbstractSession abstractSession, String string, Vector vector, Accessor accessor) {
        if (abstractSession.shouldLog(1, "sequencing")) {
            Object[] objectArray = new Object[]{string, new Integer(vector.size()), vector.firstElement(), vector.lastElement()};
            abstractSession.log(1, "sequencing", "sequencing_localPreallocation", objectArray, accessor);
        }
    }

    @Override
    public void resetSequencing() {
        if (this.isConnected()) {
            this.onDisconnect();
            this.onConnect();
        }
    }

    @Override
    public void onConnect() {
        if (this.isConnected()) {
            return;
        }
        if (!this.getOwnerSession().getProject().usesSequencing()) {
            return;
        }
        this.onConnectAllSequences();
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (!this.shouldUseSeparateConnection()) {
                this.setConnectionHandler(null);
            } else if (this.atLeastOneSequenceShouldUseTransaction) {
                if (this.getConnectionHandler() == null) {
                    this.createConnectionHandler();
                }
                if (this.getConnectionHandler() != null) {
                    this.getConnectionHandler().onConnect();
                    bl2 = true;
                }
            }
            if (this.atLeastOneSequenceShouldUsePreallocation) {
                if (this.getPreallocationHandler() == null) {
                    this.createPreallocationHandler();
                }
                this.getPreallocationHandler().onConnect();
                bl = true;
            }
            this.initializeStates();
        }
        catch (RuntimeException runtimeException) {
            this.onDisconnectAllSequences();
            if (this.getConnectionHandler() != null) {
                if (bl2) {
                    this.getConnectionHandler().onDisconnect();
                }
                this.setConnectionHandler(null);
            }
            if (this.getPreallocationHandler() != null) {
                if (bl) {
                    this.getPreallocationHandler().onDisconnect();
                }
                this.clearPreallocationHandler();
            }
            throw runtimeException;
        }
        if (this.atLeastOneSequenceShouldUsePreallocation) {
            this.setLocks(new ConcurrentHashMap(20));
        }
        this.createSequencingCallbackFactory();
        if (this.getOwnerSession().hasExternalTransactionController()) {
            this.getOwnerSession().getExternalTransactionController().initializeSequencingListeners();
        }
        if (this.getOwnerSession().isServerSession()) {
            this.setSequencingServer(this);
        }
        this.setSequencing(this);
        this.logDebugSequencingConnected();
    }

    @Override
    public void onDisconnect() {
        if (!this.isConnected()) {
            return;
        }
        this.setSequencing(null);
        this.setSequencingServer(null);
        this.setSequencingCallbackFactory(null);
        if (this.getOwnerSession().hasExternalTransactionController()) {
            this.getOwnerSession().getExternalTransactionController().clearSequencingListeners();
        }
        this.setLocks(null);
        this.clearStates();
        if (this.getConnectionHandler() != null) {
            this.getConnectionHandler().onDisconnect();
            this.setConnectionHandler(null);
        }
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().onDisconnect();
            this.clearPreallocationHandler();
        }
        this.onDisconnectAllSequences();
        this.getOwnerSession().log(1, "sequencing", "sequencing_disconnected");
    }

    protected PreallocationHandler getPreallocationHandler() {
        return this.preallocationHandler;
    }

    protected void createPreallocationHandler() {
        this.preallocationHandler = new PreallocationHandler();
    }

    protected void clearPreallocationHandler() {
        this.preallocationHandler = null;
    }

    protected void onConnectAllSequences() {
        this.connectedSequences = new Vector();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (ClassDescriptor classDescriptor : this.getOwnerSession().getDescriptors().values()) {
            Object object;
            Object object2 = classDescriptor;
            while (!((ClassDescriptor)object2).usesSequenceNumbers() && ((ClassDescriptor)object2).isChildDescriptor() && (object = this.getOwnerSession().getDescriptor(((ClassDescriptor)object2).getInheritancePolicy().getParentClass())) != null && object != object2) {
                object2 = object;
            }
            if (!((ClassDescriptor)object2).usesSequenceNumbers()) continue;
            object = ((ClassDescriptor)object2).getSequenceNumberName();
            Sequence sequence = this.getSequence((String)object);
            if (sequence == null) {
                sequence = new DefaultSequence((String)object);
                this.getOwnerSession().getDatasourcePlatform().addSequence(sequence);
            }
            classDescriptor.setSequence(sequence);
            if (this.connectedSequences.contains(sequence)) continue;
            try {
                if (sequence instanceof DefaultSequence && !this.connectedSequences.contains(this.getDefaultSequence())) {
                    this.getDefaultSequence().onConnect(this.getOwnerSession().getDatasourcePlatform());
                    this.connectedSequences.add(0, this.getDefaultSequence());
                    bl |= this.getDefaultSequence().shouldUseTransaction();
                    bl2 |= this.getDefaultSequence().shouldUsePreallocation();
                    bl3 |= this.getDefaultSequence().shouldAcquireValueAfterInsert();
                }
                sequence.onConnect(this.getOwnerSession().getDatasourcePlatform());
                this.connectedSequences.addElement(sequence);
                bl |= sequence.shouldUseTransaction();
                bl2 |= sequence.shouldUsePreallocation();
                bl3 |= sequence.shouldAcquireValueAfterInsert();
            }
            catch (RuntimeException runtimeException) {
                for (int i = this.connectedSequences.size() - 1; i >= 0; --i) {
                    try {
                        Sequence sequence2 = (Sequence)this.connectedSequences.elementAt(i);
                        sequence2.onDisconnect(this.getOwnerSession().getDatasourcePlatform());
                        continue;
                    }
                    catch (RuntimeException runtimeException2) {
                        // empty catch block
                    }
                }
                this.connectedSequences = null;
                throw runtimeException;
            }
        }
        if (bl3 && !bl2) {
            this.whenShouldAcquireValueForAll = 1;
        } else if (!bl3 && bl2) {
            this.whenShouldAcquireValueForAll = -1;
        }
        this.atLeastOneSequenceShouldUseTransaction = bl;
        this.atLeastOneSequenceShouldUsePreallocation = bl2;
    }

    protected void onDisconnectAllSequences() {
        RuntimeException runtimeException = null;
        for (int i = this.connectedSequences.size() - 1; i >= 0; --i) {
            try {
                Sequence sequence = (Sequence)this.connectedSequences.elementAt(i);
                sequence.onDisconnect(this.getOwnerSession().getDatasourcePlatform());
                continue;
            }
            catch (RuntimeException runtimeException2) {
                if (runtimeException != null) continue;
                runtimeException = runtimeException2;
            }
        }
        this.connectedSequences = null;
        this.whenShouldAcquireValueForAll = 0;
        this.atLeastOneSequenceShouldUseTransaction = false;
        this.atLeastOneSequenceShouldUsePreallocation = false;
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    protected void initializeStates() {
        this.states = new State[4];
        for (Sequence sequence : this.connectedSequences) {
            State state = this.getState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
            if (state != null) continue;
            this.createState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
        }
    }

    protected void clearStates() {
        this.states = null;
    }

    protected int getStateId(boolean bl, boolean bl2) {
        if (!bl) {
            return 0;
        }
        if (!bl2) {
            return 1;
        }
        if (this.getConnectionHandler() == null) {
            return 2;
        }
        return 3;
    }

    protected State getState(boolean bl, boolean bl2) {
        return this.states[this.getStateId(bl, bl2)];
    }

    protected void createState(boolean bl, boolean bl2) {
        if (!bl) {
            this.states[0] = new NoPreallocation_State();
        } else if (!bl2) {
            this.states[1] = new Preallocation_NoTransaction_State();
        } else if (this.getConnectionHandler() == null) {
            this.states[2] = new Preallocation_Transaction_NoAccessor_State();
        } else {
            this.states[3] = new Preallocation_Transaction_Accessor_State();
        }
    }

    protected void createSequencingCallbackFactory() {
        if (this.states[2] != null) {
            this.setSequencingCallbackFactory(this.states[2].getSequencingCallbackFactory());
        } else {
            this.setSequencingCallbackFactory(null);
        }
    }

    @Override
    public Object getNextValue(AbstractSession abstractSession, Class clazz) {
        Sequence sequence = this.getSequence(clazz);
        State state = this.getState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
        return state.getNextValue(sequence, abstractSession);
    }

    protected void logDebugSequencingConnected() {
        Vector[] vectorArray = new Vector[4];
        for (Sequence sequence : this.connectedSequences) {
            int n = this.getStateId(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
            Vector<Sequence> vector = vectorArray[n];
            if (vector == null) {
                vectorArray[n] = vector = new Vector<Sequence>();
            }
            vector.addElement(sequence);
        }
        for (int i = 0; i < 4; ++i) {
            Vector vector = vectorArray[i];
            if (vector == null) continue;
            this.getOwnerSession().log(1, "sequencing", "sequencing_connected", this.states[i]);
            for (int j = 0; j < vector.size(); ++j) {
                Sequence sequence = (Sequence)vector.elementAt(j);
                Object[] objectArray = new Object[]{sequence.getName(), Integer.toString(sequence.getPreallocationSize()), Integer.toString(sequence.getInitialValue())};
                this.getOwnerSession().log(1, "sequencing", "sequence_without_state", objectArray);
            }
        }
    }

    public int getPreallocationSize() {
        return this.getDefaultSequence().getPreallocationSize();
    }

    public int getInitialValue() {
        return this.getDefaultSequence().getInitialValue();
    }

    @Override
    public int whenShouldAcquireValueForAll() {
        return this.whenShouldAcquireValueForAll;
    }

    protected Sequence getDefaultSequence() {
        return this.getOwnerSession().getDatasourcePlatform().getDefaultSequence();
    }

    protected Sequence getSequence(String string) {
        return this.getOwnerSession().getDatasourcePlatform().getSequence(string);
    }

    class NoPreallocation_State
    extends State {
        NoPreallocation_State() {
        }

        public Object getNextValue(Sequence sequence, AbstractSession abstractSession) {
            return sequence.getGeneratedValue(null, abstractSession);
        }
    }

    class Preallocation_NoTransaction_State
    extends State {
        Preallocation_NoTransaction_State() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNextValue(Sequence sequence, AbstractSession abstractSession) {
            String string = sequence.getName();
            Queue queue = SequencingManager.this.getPreallocationHandler().getPreallocated(string);
            Object e = queue.poll();
            if (e != null) {
                return e;
            }
            SequencingManager.this.acquireLock(string);
            try {
                e = queue.poll();
                if (e != null) {
                    Object e2 = e;
                    return e2;
                }
                Vector vector = sequence.getGeneratedVector(null, abstractSession);
                e = vector.remove(0);
                if (!vector.isEmpty()) {
                    SequencingManager.this.getPreallocationHandler().setPreallocated(string, vector);
                    SequencingManager.this.logDebugPreallocation(string, e, vector);
                }
            }
            finally {
                SequencingManager.this.releaseLock(string);
            }
            return e;
        }
    }

    class Preallocation_Transaction_Accessor_State
    extends State {
        Preallocation_Transaction_Accessor_State() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNextValue(Sequence sequence, AbstractSession abstractSession) {
            String string = sequence.getName();
            Queue queue = SequencingManager.this.getPreallocationHandler().getPreallocated(string);
            Object e = queue.poll();
            if (e != null) {
                return e;
            }
            SequencingManager.this.acquireLock(string);
            try {
                e = queue.poll();
                if (e != null) {
                    Object e2 = e;
                    return e2;
                }
                Accessor accessor = SequencingManager.this.getConnectionHandler().acquireAccessor();
                try {
                    accessor.beginTransaction(abstractSession);
                    try {
                        Vector vector = sequence.getGeneratedVector(accessor, abstractSession);
                        accessor.commitTransaction(abstractSession);
                        e = vector.remove(0);
                        if (!vector.isEmpty()) {
                            SequencingManager.this.getPreallocationHandler().setPreallocated(string, vector);
                            SequencingManager.this.logDebugPreallocation(string, e, vector);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        try {
                            accessor.rollbackTransaction(abstractSession);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw runtimeException;
                    }
                }
                finally {
                    SequencingManager.this.getConnectionHandler().releaseAccessor(accessor);
                }
            }
            finally {
                SequencingManager.this.releaseLock(string);
            }
            return e;
        }
    }

    class Preallocation_Transaction_NoAccessor_State
    extends State
    implements SequencingCallbackFactory {
        Preallocation_Transaction_NoAccessor_State() {
        }

        SequencingCallbackFactory getSequencingCallbackFactory() {
            return this;
        }

        public SequencingCallback createSequencingCallback() {
            return new SequencingCallbackImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void afterCommitInternal(Map map, Accessor accessor) {
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                Vector vector = (Vector)entry.getValue();
                if (vector.isEmpty()) continue;
                SequencingManager.this.acquireLock(string);
                try {
                    SequencingManager.this.getPreallocationHandler().setPreallocated(string, vector);
                    vector.clear();
                }
                finally {
                    SequencingManager.this.releaseLock(string);
                }
            }
            if (accessor != null) {
                SequencingManager.this.getOwnerSession().log(1, "sequencing", "sequencing_afterTransactionCommitted", null, accessor);
            } else {
                SequencingManager.this.getOwnerSession().log(1, "sequencing", "sequencing_afterTransactionCommitted", null);
            }
        }

        SequencingCallbackImpl getCallbackImpl(AbstractSession abstractSession, Accessor accessor) {
            SequencingCallbackImpl sequencingCallbackImpl = abstractSession.hasExternalTransactionController() ? (SequencingCallbackImpl)abstractSession.getExternalTransactionController().getActiveSequencingCallback(SequencingManager.this.getOwnerSession(), this.getSequencingCallbackFactory()) : (SequencingCallbackImpl)accessor.getSequencingCallback(this.getSequencingCallbackFactory());
            return sequencingCallbackImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNextValue(Sequence sequence, AbstractSession abstractSession) {
            Vector vector;
            Object object;
            String string = sequence.getName();
            Queue queue = SequencingManager.this.getPreallocationHandler().getPreallocated(string);
            Object e = queue.poll();
            if (e != null) {
                return e;
            }
            boolean bl = false;
            SequencingManager.this.acquireLock(string);
            try {
                e = queue.poll();
                if (e != null) {
                    Object e2 = e;
                    return e2;
                }
                if (!SequencingManager.this.getOwnerSession().getDatasourceLogin().shouldUseExternalTransactionController() && sequence.getPreallocationSize() > 1 && !abstractSession.isInTransaction()) {
                    abstractSession.beginTransaction();
                    bl = true;
                }
            }
            finally {
                if (!bl) {
                    SequencingManager.this.releaseLock(string);
                }
            }
            if (!bl) {
                abstractSession.beginTransaction();
            }
            try {
                Accessor accessor = abstractSession.getAccessor();
                object = this.getCallbackImpl(abstractSession, accessor);
                Map map = ((SequencingCallbackImpl)object).getPreallocatedSequenceValues();
                vector = (Vector)map.get(string);
                if (vector == null || vector.isEmpty()) {
                    vector = sequence.getGeneratedVector(null, abstractSession);
                    map.put(string, vector);
                    SequencingManager.this.logDebugLocalPreallocation(abstractSession, string, vector, accessor);
                }
            }
            catch (RuntimeException runtimeException) {
                if (bl) {
                    SequencingManager.this.releaseLock(string);
                }
                try {
                    abstractSession.rollbackTransaction();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw runtimeException;
            }
            if (!bl) {
                SequencingManager.this.acquireLock(string);
            }
            try {
                try {
                    abstractSession.commitTransaction();
                }
                catch (DatabaseException databaseException) {
                    try {
                        abstractSession.rollbackTransaction();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw databaseException;
                }
                if (!vector.isEmpty()) {
                    e = vector.remove(0);
                    object = e;
                    return object;
                }
                e = queue.poll();
                if (e != null) {
                    object = e;
                    return object;
                }
                object = this.getNextValue(sequence, abstractSession);
                return object;
            }
            finally {
                SequencingManager.this.releaseLock(string);
            }
        }

        public class SequencingCallbackImpl
        implements SequencingCallback {
            Map localSequences = new HashMap();

            public void afterCommit(Accessor accessor) {
                Preallocation_Transaction_NoAccessor_State.this.afterCommitInternal(this.localSequences, accessor);
            }

            public Map getPreallocatedSequenceValues() {
                return this.localSequences;
            }
        }
    }

    static abstract class State {
        State() {
        }

        abstract Object getNextValue(Sequence var1, AbstractSession var2);

        SequencingCallbackFactory getSequencingCallbackFactory() {
            return null;
        }

        public String toString() {
            String string = this.getClass().getName();
            return string.substring(string.lastIndexOf(36) + 1);
        }
    }
}

