/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sequencing;

import java.util.Iterator;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.broker.SessionBroker;

class SessionBrokerSequencing
implements Sequencing {
    protected SessionBroker broker;
    protected int whenShouldAcquireValueForAll;

    public static boolean atLeastOneSessionHasSequencing(SessionBroker sessionBroker) {
        boolean bl = false;
        Iterator iterator = sessionBroker.getSessionsByName().values().iterator();
        while (iterator.hasNext() && !bl) {
            AbstractSession abstractSession = (AbstractSession)iterator.next();
            bl = abstractSession.getSequencing() != null;
        }
        return bl;
    }

    public SessionBrokerSequencing(SessionBroker sessionBroker) {
        this.broker = sessionBroker;
        this.initialize();
    }

    protected void initialize() {
        this.whenShouldAcquireValueForAll = 0;
        boolean bl = true;
        Iterator iterator = this.broker.getSessionsByName().values().iterator();
        while ((bl || this.whenShouldAcquireValueForAll != 0) && iterator.hasNext()) {
            AbstractSession abstractSession = (AbstractSession)iterator.next();
            Sequencing sequencing = abstractSession.getSequencing();
            if (sequencing == null) continue;
            if (bl) {
                this.whenShouldAcquireValueForAll = sequencing.whenShouldAcquireValueForAll();
                bl = false;
                continue;
            }
            if (this.whenShouldAcquireValueForAll == sequencing.whenShouldAcquireValueForAll()) continue;
            this.whenShouldAcquireValueForAll = 0;
        }
    }

    protected Sequencing get(Class clazz) {
        return this.broker.getSessionForClass(clazz).getSequencing();
    }

    public int whenShouldAcquireValueForAll() {
        return this.whenShouldAcquireValueForAll;
    }

    public Object getNextValue(Class clazz) {
        return this.get(clazz).getNextValue(clazz);
    }
}

