/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.WriteLockManager;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.InMemoryQueryIndirectionPolicy;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Record;

public class IdentityMapAccessor
implements org.eclipse.persistence.sessions.IdentityMapAccessor,
Serializable {
    protected IdentityMapManager identityMapManager = null;
    protected AbstractSession session = null;

    public IdentityMapAccessor(AbstractSession abstractSession, IdentityMapManager identityMapManager) {
        this.session = abstractSession;
        this.identityMapManager = identityMapManager;
    }

    public CacheKey acquireDeferredLock(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().acquireDeferredLock(vector, clazz, classDescriptor);
    }

    public CacheKey acquireLock(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        return this.acquireLock(vector, clazz, false, classDescriptor);
    }

    public CacheKey acquireLock(Vector vector, Class clazz, boolean bl, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().acquireLock(vector, clazz, bl, classDescriptor);
    }

    public CacheKey acquireLockNoWait(Vector vector, Class clazz, boolean bl, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().acquireLockNoWait(vector, clazz, bl, classDescriptor);
    }

    public CacheKey acquireLockWithWait(Vector vector, Class clazz, boolean bl, ClassDescriptor classDescriptor, int n) {
        return this.getIdentityMapManager().acquireLockWithWait(vector, clazz, bl, classDescriptor, n);
    }

    public CacheKey acquireReadLockOnCacheKey(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().acquireReadLockOnCacheKey(vector, clazz, classDescriptor);
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().acquireReadLockOnCacheKeyNoWait(vector, clazz, classDescriptor);
    }

    public boolean acquireWriteLock() {
        return this.getIdentityMapManager().acquireWriteLock();
    }

    public void clearQueryCache() {
        this.getIdentityMapManager().clearQueryCache();
    }

    public void clearQueryCache(ReadQuery readQuery) {
        this.getIdentityMapManager().clearQueryCache(readQuery);
    }

    public void clearQueryCache(String string) {
        this.getIdentityMapManager().clearQueryCache((ReadQuery)this.session.getQuery(string));
    }

    public void clearQueryCache(String string, Class clazz) {
        this.getIdentityMapManager().clearQueryCache((ReadQuery)this.session.getDescriptor(clazz).getQueryManager().getQuery(string));
    }

    public boolean containsKey(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().containsKey(vector, clazz, classDescriptor);
    }

    public boolean containsObjectInIdentityMap(Object object) {
        return this.containsObjectInIdentityMap(this.getSession().keyFromObject(object), object.getClass());
    }

    public boolean containsObjectInIdentityMap(Vector vector, Class clazz) {
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(clazz);
        return this.containsObjectInIdentityMap(vector, clazz, classDescriptor);
    }

    public boolean containsObjectInIdentityMap(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().containsKey(vector, clazz, classDescriptor);
    }

    public boolean containsObjectInIdentityMap(Record record, Class clazz) {
        return this.containsObjectInIdentityMap(this.extractPrimaryKeyFromRow(record, clazz), clazz);
    }

    protected Vector extractPrimaryKeyFromRow(Record record, Class clazz) {
        return this.session.getDescriptor(clazz).getObjectBuilder().extractPrimaryKeyFromRow((AbstractRecord)record, this.session);
    }

    public CacheKey getCacheKeyForObject(Object object, ClassDescriptor classDescriptor) {
        return this.getCacheKeyForObject(this.getSession().keyFromObject(object, classDescriptor), object.getClass(), classDescriptor);
    }

    public Vector getClassesRegistered() {
        return this.getIdentityMapManager().getClassesRegistered();
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, Record record) throws QueryException {
        return this.getAllFromIdentityMap(expression, clazz, record, 0, true);
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, Record record, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) throws QueryException {
        return this.getAllFromIdentityMap(expression, clazz, record, inMemoryQueryIndirectionPolicy, true);
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, Record record, int n) throws QueryException {
        return this.getAllFromIdentityMap(expression, clazz, record, n, true);
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, Record record, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) throws QueryException {
        int n = 0;
        if (inMemoryQueryIndirectionPolicy != null) {
            n = inMemoryQueryIndirectionPolicy.getPolicy();
        }
        return this.getAllFromIdentityMap(expression, clazz, record, n, bl);
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, Record record, int n, boolean bl) throws QueryException {
        return this.getIdentityMapManager().getAllFromIdentityMap(expression, clazz, record, n, bl);
    }

    public Object getFromIdentityMap(Object object) {
        return this.getFromIdentityMap(this.getSession().keyFromObject(object), object.getClass());
    }

    public CacheKey getCacheKeyForObject(Object object) {
        return this.getCacheKeyForObject(this.getSession().keyFromObject(object), object.getClass(), this.getSession().getDescriptor(object.getClass()));
    }

    public CacheKey getCacheKeyForObjectForLock(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().getCacheKeyForObjectForLock(vector, clazz, classDescriptor);
    }

    public CacheKey getCacheKeyForObject(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().getCacheKeyForObject(vector, clazz, classDescriptor);
    }

    public Object getFromIdentityMap(Vector vector, Class clazz) {
        return this.getFromIdentityMap(vector, clazz, true);
    }

    public Object getFromIdentityMap(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        return this.getFromIdentityMap(vector, clazz, true, classDescriptor);
    }

    public Object getFromIdentityMap(Vector vector, Class clazz, boolean bl) {
        return this.getFromIdentityMap(vector, clazz, bl, this.getSession().getDescriptor(clazz));
    }

    public Object getFromIdentityMap(Vector vector, Class clazz, boolean bl, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().getFromIdentityMap(vector, clazz, bl, classDescriptor);
    }

    public Object getFromIdentityMap(Record record, Class clazz) {
        return this.getFromIdentityMap(this.extractPrimaryKeyFromRow(record, clazz), clazz);
    }

    public Object getFromIdentityMap(Record record, Class clazz, boolean bl) {
        return this.getFromIdentityMap(this.extractPrimaryKeyFromRow(record, clazz), clazz, bl);
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, Record record) throws QueryException {
        return this.getFromIdentityMap(expression, clazz, record, 0);
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, Record record, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) throws QueryException {
        int n = 0;
        if (inMemoryQueryIndirectionPolicy != null) {
            n = inMemoryQueryIndirectionPolicy.getPolicy();
        }
        return this.getFromIdentityMap(expression, clazz, record, n, false);
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, Record record, int n) throws QueryException {
        return this.getFromIdentityMap(expression, clazz, record, n, false);
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, Record record, int n, boolean bl) {
        return this.getFromIdentityMap(expression, clazz, record, n, bl, true, this.getSession().getDescriptor(clazz));
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, Record record, int n, boolean bl, boolean bl2) {
        return this.getFromIdentityMap(expression, clazz, record, n, bl, bl2, this.getSession().getDescriptor(clazz));
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, Record record, int n, boolean bl, boolean bl2, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().getFromIdentityMap(expression, clazz, record, n, bl, bl2, classDescriptor);
    }

    public Object getFromIdentityMapWithDeferredLock(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        return this.getFromIdentityMapWithDeferredLock(vector, clazz, true, classDescriptor);
    }

    public Object getFromIdentityMapWithDeferredLock(Vector vector, Class clazz, boolean bl, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().getFromIdentityMapWithDeferredLock(vector, clazz, bl, classDescriptor);
    }

    public IdentityMapManager getIdentityMapManager() {
        if (this.session.hasBroker()) {
            return this.getSession().getBroker().getIdentityMapAccessorInstance().getIdentityMapManager();
        }
        return this.identityMapManager;
    }

    public IdentityMap getIdentityMap(Class clazz) {
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(clazz);
        if (classDescriptor == null) {
            throw ValidationException.missingDescriptor(clazz.toString());
        }
        return this.getIdentityMap(classDescriptor);
    }

    public IdentityMap getIdentityMap(ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().getIdentityMap(classDescriptor);
    }

    public Object getQueryResult(ReadQuery readQuery, Vector vector, boolean bl) {
        return this.getIdentityMapManager().getQueryResult(readQuery, vector, bl);
    }

    public long getRemainingValidTime(Object object) {
        Vector vector = this.getSession().keyFromObject(object);
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(object);
        CacheKey cacheKey = this.getCacheKeyForObjectForLock(vector, object.getClass(), classDescriptor);
        if (cacheKey == null) {
            throw QueryException.objectDoesNotExistInCache(object);
        }
        return classDescriptor.getCacheInvalidationPolicy().getRemainingValidTime(cacheKey);
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public Object getWrapper(Vector vector, Class clazz) {
        return this.getIdentityMapManager().getWrapper(vector, clazz);
    }

    public WriteLockManager getWriteLockManager() {
        return this.getIdentityMapManager().getWriteLockManager();
    }

    public Object getWriteLockValue(Object object) {
        return this.getWriteLockValue(this.getSession().keyFromObject(object), object.getClass());
    }

    public Object getWriteLockValue(Vector vector, Class clazz) {
        return this.getWriteLockValue(vector, clazz, this.getSession().getDescriptor(clazz));
    }

    public Object getWriteLockValue(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().getWriteLockValue(vector, clazz, classDescriptor);
    }

    public void initializeAllIdentityMaps() {
        this.getSession().log(2, "cache", "initialize_all_identitymaps");
        this.getIdentityMapManager().initializeIdentityMaps();
    }

    public void initializeIdentityMap(Class clazz) {
        this.getSession().log(2, "cache", "initialize_identitymap", clazz);
        this.getIdentityMapManager().initializeIdentityMap(clazz);
    }

    public void initializeIdentityMaps() {
        this.getSession().log(2, "cache", "initialize_identitymaps");
        this.getIdentityMapManager().initializeIdentityMaps();
        if (this.getSession().hasCommitManager()) {
            this.getSession().getCommitManager().reinitialize();
        }
    }

    public void invalidateObject(Object object) {
        this.invalidateObject(this.getSession().keyFromObject(object), object.getClass());
    }

    public void invalidateObject(Vector vector, Class clazz) {
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(clazz);
        CacheKey cacheKey = this.getCacheKeyForObjectForLock(vector, clazz, classDescriptor);
        if (cacheKey != null) {
            cacheKey.setInvalidationState(-1);
        }
    }

    public void invalidateObject(Record record, Class clazz) {
        this.invalidateObject(this.extractPrimaryKeyFromRow(record, clazz), clazz);
    }

    public void invalidateObjects(Expression expression) {
        this.invalidateObjects(this.getAllFromIdentityMap(expression, expression.getBuilder().getQueryClass(), new DatabaseRecord(0)));
    }

    public void invalidateObjects(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.invalidateObject(enumeration.nextElement());
        }
    }

    public void invalidateClass(Class clazz) {
        this.invalidateClass(clazz, true);
    }

    public void invalidateClass(Class clazz, boolean bl) {
        IdentityMap identityMap = this.getIdentityMap(clazz);
        Enumeration enumeration = identityMap.keys();
        while (enumeration.hasMoreElements()) {
            CacheKey cacheKey = (CacheKey)enumeration.nextElement();
            Object object = cacheKey.getObject();
            if (!bl && (object == null || !object.getClass().equals(clazz))) continue;
            cacheKey.setInvalidationState(-1);
        }
    }

    public void invalidateAll() {
        Iterator iterator = this.getIdentityMapManager().getIdentityMapClasses();
        while (iterator.hasNext()) {
            this.invalidateClass((Class)iterator.next());
        }
    }

    public boolean isValid(Object object) {
        return this.isValid(this.getSession().keyFromObject(object), object.getClass());
    }

    public boolean isValid(Vector vector, Class clazz) {
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(clazz);
        CacheKey cacheKey = this.getCacheKeyForObjectForLock(vector, clazz, classDescriptor);
        if (cacheKey == null) {
            throw QueryException.classPkDoesNotExistInCache(clazz, vector);
        }
        return !classDescriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey);
    }

    public boolean isValid(Record record, Class clazz) {
        return this.isValid(this.extractPrimaryKeyFromRow(record, clazz), clazz);
    }

    public void printIdentityMap(Class clazz) {
        if (this.getSession().shouldLog(7, "cache")) {
            this.getIdentityMapManager().printIdentityMap(clazz);
        }
    }

    public void printIdentityMaps() {
        if (this.getSession().shouldLog(7, "cache")) {
            this.getIdentityMapManager().printIdentityMaps();
        }
    }

    public void printIdentityMapLocks() {
        if (this.getSession().shouldLog(1, "cache")) {
            this.getIdentityMapManager().printLocks();
        }
    }

    public Object putInIdentityMap(Object object) {
        return this.putInIdentityMap(object, this.getSession().keyFromObject(object));
    }

    public Object putInIdentityMap(Object object, Vector vector) {
        return this.putInIdentityMap(object, vector, null);
    }

    public Object putInIdentityMap(Object object, Vector vector, Object object2) {
        return this.putInIdentityMap(object, vector, object2, 0L);
    }

    public Object putInIdentityMap(Object object, Vector vector, Object object2, long l) {
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(object);
        return this.putInIdentityMap(object, vector, object2, l, classDescriptor);
    }

    public Object putInIdentityMap(Object object, Vector vector, Object object2, long l, ClassDescriptor classDescriptor) {
        CacheKey cacheKey = this.internalPutInIdentityMap(object, vector, object2, l, classDescriptor);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getObject();
    }

    public void putQueryResult(ReadQuery readQuery, Vector vector, Object object) {
        this.getIdentityMapManager().putQueryResult(readQuery, vector, object);
    }

    public CacheKey internalPutInIdentityMap(Object object, Vector vector, Object object2, long l, ClassDescriptor classDescriptor) {
        return this.getIdentityMapManager().putInIdentityMap(object, vector, object2, l, classDescriptor);
    }

    public void releaseWriteLock() {
        this.getIdentityMapManager().releaseWriteLock();
    }

    public Object removeFromIdentityMap(Object object) {
        Class<?> clazz = object.getClass();
        return this.removeFromIdentityMap(this.getSession().keyFromObject(object), clazz, this.getSession().getDescriptor(clazz), object);
    }

    public Object removeFromIdentityMap(Vector vector, Class clazz) {
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(clazz);
        return this.removeFromIdentityMap(vector, clazz, classDescriptor, null);
    }

    public Object removeFromIdentityMap(Vector vector, Class clazz, ClassDescriptor classDescriptor, Object object) {
        return this.getIdentityMapManager().removeFromIdentityMap(vector, clazz, classDescriptor, object);
    }

    public void setIdentityMapManager(IdentityMapManager identityMapManager) {
        this.identityMapManager = identityMapManager;
    }

    public void setWrapper(Vector vector, Class clazz, Object object) {
        this.getIdentityMapManager().setWrapper(vector, clazz, object);
    }

    public void updateWriteLockValue(Object object, Object object2) {
        this.updateWriteLockValue(this.getSession().keyFromObject(object), object.getClass(), object2);
    }

    public void updateWriteLockValue(Vector vector, Class clazz, Object object) {
        this.getIdentityMapManager().setWriteLockValue(vector, clazz, object);
    }

    public void validateCache() {
        this.getSession().log(2, "cache", "validate_cache");
        DescriptorIterator descriptorIterator = new DescriptorIterator(){

            public void iterate(Object object) {
                if (!IdentityMapAccessor.this.containsObjectInIdentityMap(IdentityMapAccessor.this.session.getDescriptor(object.getClass()).getObjectBuilder().extractPrimaryKeyFromObject(object, IdentityMapAccessor.this.getSession()), object.getClass())) {
                    IdentityMapAccessor.this.session.log(1, "cache", "stack_of_visited_objects_that_refer_to_the_corrupt_object", this.getVisitedStack());
                    IdentityMapAccessor.this.session.log(2, "cache", "corrupt_object_referenced_through_mapping", this.getCurrentMapping());
                    IdentityMapAccessor.this.session.log(2, "cache", "corrupt_object", object);
                }
            }
        };
        descriptorIterator.setSession(this.getSession());
        for (ClassDescriptor classDescriptor : this.getSession().getDescriptors().values()) {
            Enumeration enumeration = this.getIdentityMap(classDescriptor).elements();
            while (enumeration.hasMoreElements()) {
                descriptorIterator.startIterationOn(enumeration.nextElement());
            }
        }
    }
}

