/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToOneMapping
extends ObjectReferenceMapping
implements RelationalMapping,
MapKeyMapping {
    protected Map<DatabaseField, DatabaseField> sourceToTargetKeyFields;
    protected Map<DatabaseField, DatabaseField> targetToSourceKeyFields;
    protected boolean shouldVerifyDelete;
    protected transient Expression privateOwnedCriteria;
    public DatabaseTable keyTableForMapKey = null;

    public OneToOneMapping() {
        this.selectionQuery = new ReadObjectQuery();
        this.sourceToTargetKeyFields = new HashMap<DatabaseField, DatabaseField>(2);
        this.targetToSourceKeyFields = new HashMap<DatabaseField, DatabaseField>(2);
        this.foreignKeyFields = NonSynchronizedVector.newInstance(1);
        this.isForeignKeyRelationship = false;
        this.shouldVerifyDelete = true;
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    @Override
    public void addAdditionalFieldsToQuery(ReadQuery readQuery, Expression expression) {
        for (DatabaseField databaseField : this.getForeignKeyFields()) {
            if (readQuery.isObjectLevelReadQuery()) {
                if (expression != null) {
                    ((ObjectLevelReadQuery)readQuery).addAdditionalField(expression.getField(databaseField));
                    continue;
                }
                ((ObjectLevelReadQuery)readQuery).addAdditionalField(databaseField);
                continue;
            }
            if (!readQuery.isDataReadQuery()) continue;
            ((SQLSelectStatement)((DataReadQuery)readQuery).getSQLStatement()).addField(databaseField);
        }
    }

    @Override
    public void addFieldsForMapKey(AbstractRecord abstractRecord) {
        Iterator<DatabaseField> iterator = this.getForeignKeyFields().iterator();
        while (iterator.hasNext()) {
            abstractRecord.put(iterator.next(), (Object)null);
        }
    }

    public void addForeignKeyField(DatabaseField databaseField, DatabaseField databaseField2) {
        this.setIsForeignKeyRelationship(true);
        this.getForeignKeyFields().addElement(databaseField);
        this.getSourceToTargetKeyFields().put(databaseField, databaseField2);
        this.getTargetToSourceKeyFields().put(databaseField2, databaseField);
    }

    public void addForeignKeyFieldName(String string, String string2) {
        this.addForeignKeyField(new DatabaseField(string), new DatabaseField(string2));
    }

    public void addTargetForeignKeyField(DatabaseField databaseField, DatabaseField databaseField2) {
        this.getSourceToTargetKeyFields().put(databaseField2, databaseField);
        this.getTargetToSourceKeyFields().put(databaseField, databaseField2);
    }

    public void addTargetForeignKeyFieldName(String string, String string2) {
        this.addTargetForeignKeyField(new DatabaseField(string), new DatabaseField(string2));
    }

    @Override
    public void addKeyToDeletedObjectsList(Object object, CommitManager commitManager) {
        commitManager.addObjectToDelete(object);
    }

    @Override
    public Object buildElementClone(Object object, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        return this.buildCloneForPartObject(object, null, null, unitOfWorkImpl, bl);
    }

    @Override
    public Expression buildObjectJoinExpression(Expression expression, Object object, AbstractSession abstractSession) {
        Expression expression2 = ((ObjectExpression)expression).getBaseExpression();
        Expression expression3 = null;
        if (object == null) {
            if (!this.isForeignKeyRelationship()) {
                throw QueryException.cannotCompareTargetForeignKeysToNull(expression2, object, this);
            }
            for (DatabaseField databaseField : this.getSourceToTargetKeyFields().keySet()) {
                Expression expression4 = null;
                expression4 = expression.isObjectExpression() && ((ObjectExpression)expression).shouldUseOuterJoin() ? expression2.getField(databaseField).equalOuterJoin(null) : expression2.getField(databaseField).equal(null);
                if (expression3 == null) {
                    expression3 = expression4;
                    continue;
                }
                expression3 = expression3.and(expression4);
            }
        } else {
            if (!this.getReferenceDescriptor().getJavaClass().isInstance(object)) {
                object = ProxyIndirectionPolicy.getValueFromProxy(object);
                if (!this.getReferenceDescriptor().getJavaClass().isInstance(object)) {
                    throw QueryException.incorrectClassForObjectComparison(expression2, object, this);
                }
            }
            Enumeration enumeration = this.extractKeyFromReferenceObject(object, abstractSession).elements();
            for (DatabaseField databaseField : this.getSourceToTargetKeyFields().keySet()) {
                Expression expression5 = null;
                expression5 = expression.isObjectExpression() && ((ObjectExpression)expression).shouldUseOuterJoin() ? expression2.getField(databaseField).equalOuterJoin(enumeration.nextElement()) : expression2.getField(databaseField).equal(enumeration.nextElement());
                if (expression3 == null) {
                    expression3 = expression5;
                    continue;
                }
                expression3 = expression3.and(expression5);
            }
        }
        return expression3;
    }

    @Override
    public Expression buildObjectJoinExpression(Expression expression, Expression expression2, AbstractSession abstractSession) {
        Expression expression3 = ((ObjectExpression)expression).getBaseExpression();
        Expression expression4 = null;
        if (expression == expression2) {
            for (DatabaseField databaseField : this.getSourceToTargetKeyFields().keySet()) {
                Expression expression5 = expression3.getField(databaseField);
                expression5 = expression.isObjectExpression() && ((ObjectExpression)expression).shouldUseOuterJoin() ? expression5.equalOuterJoin(expression5) : expression5.equal(expression5);
                if (expression4 == null) {
                    expression4 = expression5;
                    continue;
                }
                expression4 = expression4.and(expression5);
            }
        } else {
            Iterator<DatabaseField> iterator = this.getSourceToTargetKeyFields().values().iterator();
            for (DatabaseField databaseField : this.getSourceToTargetKeyFields().keySet()) {
                DatabaseField databaseField2 = iterator.next();
                Expression expression6 = null;
                expression6 = expression.isObjectExpression() && ((ObjectExpression)expression).shouldUseOuterJoin() ? expression3.getField(databaseField).equalOuterJoin(expression2.getField(databaseField2)) : expression3.getField(databaseField).equal(expression2.getField(databaseField2));
                if (expression4 == null) {
                    expression4 = expression6;
                    continue;
                }
                expression4 = expression4.and(expression6);
            }
        }
        return expression4;
    }

    @Override
    public ReadQuery buildSelectionQueryForDirectCollectionKeyMapping(ContainerPolicy containerPolicy) {
        DataReadQuery dataReadQuery = new DataReadQuery();
        dataReadQuery.setSQLStatement(new SQLSelectStatement());
        dataReadQuery.setContainerPolicy(containerPolicy);
        return dataReadQuery;
    }

    @Override
    public Object clone() {
        DatabaseField databaseField;
        DatabaseField databaseField2;
        DatabaseField databaseField3;
        OneToOneMapping oneToOneMapping = (OneToOneMapping)super.clone();
        oneToOneMapping.setForeignKeyFields(NonSynchronizedVector.newInstance(this.getForeignKeyFields().size()));
        oneToOneMapping.setSourceToTargetKeyFields(new HashMap<DatabaseField, DatabaseField>(this.getSourceToTargetKeyFields().size()));
        oneToOneMapping.setTargetToSourceKeyFields(new HashMap<DatabaseField, DatabaseField>(this.getTargetToSourceKeyFields().size()));
        Hashtable<DatabaseField, DatabaseField> hashtable = new Hashtable<DatabaseField, DatabaseField>(this.getTargetToSourceKeyFields().size());
        Iterator<DatabaseField> iterator = this.getForeignKeyFields().elements();
        while (iterator.hasMoreElements()) {
            DatabaseField databaseField4 = iterator.nextElement();
            databaseField3 = (DatabaseField)databaseField4.clone();
            hashtable.put(databaseField4, databaseField3);
            oneToOneMapping.getForeignKeyFields().addElement(databaseField3);
        }
        for (DatabaseField databaseField4 : this.getSourceToTargetKeyFields().keySet()) {
            databaseField3 = this.getSourceToTargetKeyFields().get(databaseField4);
            databaseField2 = (DatabaseField)hashtable.get(databaseField3);
            if (databaseField2 == null) {
                databaseField2 = (DatabaseField)databaseField3.clone();
                hashtable.put(databaseField3, databaseField2);
            }
            if ((databaseField = (DatabaseField)hashtable.get(databaseField4)) == null) {
                databaseField = (DatabaseField)databaseField4.clone();
                hashtable.put(databaseField4, databaseField);
            }
            oneToOneMapping.getSourceToTargetKeyFields().put(databaseField, databaseField2);
        }
        for (DatabaseField databaseField4 : this.getTargetToSourceKeyFields().keySet()) {
            databaseField3 = this.getTargetToSourceKeyFields().get(databaseField4);
            databaseField2 = (DatabaseField)hashtable.get(databaseField4);
            if (databaseField2 == null) {
                databaseField2 = (DatabaseField)databaseField4.clone();
                hashtable.put(databaseField4, databaseField2);
            }
            if ((databaseField = (DatabaseField)hashtable.get(databaseField3)) == null) {
                databaseField = (DatabaseField)databaseField3.clone();
                hashtable.put(databaseField3, databaseField);
            }
            oneToOneMapping.getTargetToSourceKeyFields().put(databaseField2, databaseField);
        }
        return oneToOneMapping;
    }

    @Override
    public Object createMapComponentFromRow(AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        return abstractSession.executeQuery((DatabaseQuery)this.getSelectionQuery(), abstractRecord);
    }

    @Override
    public Object createMapComponentFromJoinedRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        return this.valueFromRowInternalWithJoin(abstractRecord, joinedAttributeManager, objectBuildingQuery, abstractSession);
    }

    @Override
    public void deleteMapKey(Object object, AbstractSession abstractSession) {
        abstractSession.deleteObject(object);
    }

    protected Vector extractForeignKeyFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>();
        for (DatabaseField databaseField : this.getSourceToTargetKeyFields().keySet()) {
            Object object = abstractRecord.get(databaseField);
            try {
                object = abstractSession.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    @Override
    public Map extractIdentityFieldsForQuery(Object object, AbstractSession abstractSession) {
        HashMap<DatabaseField, Object> hashMap = new HashMap<DatabaseField, Object>();
        for (int i = 0; i < this.getForeignKeyFields().size(); ++i) {
            DatabaseField databaseField = this.getForeignKeyFields().elementAt(i);
            DatabaseField databaseField2 = this.getSourceToTargetKeyFields().get(databaseField);
            Object object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField2, abstractSession);
            hashMap.put(databaseField, object2);
        }
        return hashMap;
    }

    protected Vector extractKeyFromReferenceObject(Object object, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>();
        for (DatabaseField databaseField : this.getSourceToTargetKeyFields().values()) {
            if (object == null) {
                vector.addElement(null);
                continue;
            }
            vector.addElement(this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, abstractSession));
        }
        return vector;
    }

    @Override
    public Vector extractPrimaryKeysForReferenceObjectFromRow(AbstractRecord abstractRecord) {
        List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
        Vector<Object> vector = new Vector<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            DatabaseField databaseField = list.get(i);
            DatabaseField databaseField2 = this.getTargetToSourceKeyFields().get(databaseField);
            if (databaseField2 == null) {
                return new Vector(1);
            }
            vector.addElement(abstractRecord.get(databaseField2));
        }
        return vector;
    }

    @Override
    protected void postPrepareNestedBatchQuery(ReadQuery readQuery, ReadAllQuery readAllQuery) {
        if (!readAllQuery.isDistinctComputed()) {
            ((ObjectLevelReadQuery)readQuery).useDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord, AbstractSession abstractSession, AbstractRecord abstractRecord2) {
        Hashtable<CacheKey, Object> hashtable = null;
        DatabaseQuery databaseQuery2 = databaseQuery;
        synchronized (databaseQuery2) {
            hashtable = this.getBatchReadObjects(databaseQuery, abstractSession);
            if (hashtable == null) {
                Vector vector = (Vector)abstractSession.executeQuery(databaseQuery, abstractRecord2);
                hashtable = new Hashtable<CacheKey, Object>();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    CacheKey cacheKey = new CacheKey(this.extractKeyFromReferenceObject(e, abstractSession));
                    hashtable.put(cacheKey, abstractSession.wrapObject(e));
                }
                this.setBatchReadObjects(hashtable, databaseQuery, abstractSession);
            }
        }
        return hashtable.get(new CacheKey(this.extractForeignKeyFromRow(abstractRecord, abstractSession)));
    }

    @Override
    public Expression getAdditionalSelectionCriteriaForMapKey() {
        return this.buildSelectionCriteria(false, false);
    }

    @Override
    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        ArrayList<DatabaseTable> arrayList = new ArrayList<DatabaseTable>(this.getReferenceDescriptor().getTables().size() + 1);
        arrayList.addAll(this.getReferenceDescriptor().getTables());
        if (this.keyTableForMapKey != null) {
            arrayList.add(this.keyTableForMapKey);
        }
        return arrayList;
    }

    @Override
    public Class getFieldClassification(DatabaseField databaseField) throws DescriptorException {
        DatabaseField databaseField2 = this.getSourceToTargetKeyFields().get(databaseField);
        if (databaseField2 == null) {
            return null;
        }
        DatabaseMapping databaseMapping = this.getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField2);
        if (databaseMapping == null) {
            return null;
        }
        return databaseMapping.getFieldClassification(databaseField2);
    }

    public Vector getForeignKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getForeignKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    protected Map getForeignKeysToPrimaryKeys() {
        if (this.isForeignKeyRelationship()) {
            return this.getSourceToTargetKeyFields();
        }
        return this.getTargetToSourceKeyFields();
    }

    @Override
    public List<DatabaseField> getIdentityFieldsForMapKey() {
        return this.getForeignKeyFields();
    }

    @Override
    public ObjectLevelReadQuery getNestedJoinQuery(JoinedAttributeManager joinedAttributeManager, ObjectLevelReadQuery objectLevelReadQuery, AbstractSession abstractSession) {
        return this.prepareNestedJoins(joinedAttributeManager, objectLevelReadQuery, abstractSession);
    }

    @Override
    public List<DatabaseField> getAllFieldsForMapKey() {
        ArrayList<DatabaseField> arrayList = new ArrayList<DatabaseField>(this.getReferenceDescriptor().getAllFields().size() + this.getForeignKeyFields().size());
        arrayList.addAll(this.getReferenceDescriptor().getAllFields());
        arrayList.addAll(this.getForeignKeyFields());
        return arrayList;
    }

    public Vector getOrderedForeignKeyFields() {
        List<DatabaseField> list = this.getPrimaryKeyDescriptor().getPrimaryKeyFields();
        Vector<DatabaseField> vector = new Vector<DatabaseField>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            DatabaseField databaseField = list.get(i);
            boolean bl = false;
            for (DatabaseField databaseField2 : this.getForeignKeysToPrimaryKeys().keySet()) {
                if (!this.getForeignKeysToPrimaryKeys().get(databaseField2).equals(databaseField)) continue;
                bl = true;
                vector.addElement(databaseField2);
                break;
            }
            if (bl) continue;
            throw DescriptorException.missingForeignKeyTranslation(this, databaseField);
        }
        return vector;
    }

    protected ClassDescriptor getPrimaryKeyDescriptor() {
        if (this.isForeignKeyRelationship()) {
            return this.getReferenceDescriptor();
        }
        return this.getDescriptor();
    }

    public Expression getPrivateOwnedCriteria() {
        if (this.privateOwnedCriteria == null) {
            this.initializePrivateOwnedCriteria();
        }
        return this.privateOwnedCriteria;
    }

    public Vector getSourceToTargetKeyFieldAssociations() {
        Vector<Association> vector = new Vector<Association>(this.getSourceToTargetKeyFields().size());
        Iterator<DatabaseField> iterator = this.getSourceToTargetKeyFields().keySet().iterator();
        Iterator<DatabaseField> iterator2 = this.getSourceToTargetKeyFields().values().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().getQualifiedName();
            String string2 = iterator2.next().getQualifiedName();
            vector.addElement(new Association(string, string2));
        }
        return vector;
    }

    public Map<DatabaseField, DatabaseField> getSourceToTargetKeyFields() {
        return this.sourceToTargetKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getTargetToSourceKeyFields() {
        return this.targetToSourceKeyFields;
    }

    @Override
    public Object getTargetVersionOfSourceObject(Object object, MergeManager mergeManager) {
        return mergeManager.getTargetVersionOfSourceObject(object);
    }

    @Override
    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        for (int i = 0; i < this.getForeignKeyFields().size(); ++i) {
            DatabaseField databaseField = this.getForeignKeyFields().get(i);
            databaseField = this.getDescriptor().buildField(databaseField, this.keyTableForMapKey);
            this.getForeignKeyFields().set(i, databaseField);
        }
        if (!this.getTargetToSourceKeyFields().isEmpty() || !this.getSourceToTargetKeyFields().isEmpty()) {
            if (this.getTargetToSourceKeyFields().isEmpty() || this.getSourceToTargetKeyFields().isEmpty()) {
                this.initializeForeignKeysWithDefaults(abstractSession);
            } else {
                this.initializeForeignKeys(abstractSession);
            }
        }
        if (this.shouldInitializeSelectionCriteria()) {
            if (this.shouldForceInitializationOfSelectionCriteria()) {
                this.setSelectionCriteria(this.buildSelectionCriteria());
            } else {
                this.buildSelectionCriteria(true, true);
            }
        } else {
            this.setShouldVerifyDelete(false);
        }
        this.setFields(this.collectFields());
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().hasTablePerClassPolicy()) {
            this.getReferenceDescriptor().getTablePerClassPolicy().prepareChildrenSelectionQuery(this, abstractSession);
        }
    }

    protected void initializeForeignKeys(AbstractSession abstractSession) {
        HashMap<DatabaseField, DatabaseField> hashMap = new HashMap<DatabaseField, DatabaseField>(this.getSourceToTargetKeyFields().size());
        HashMap<DatabaseField, DatabaseField> hashMap2 = new HashMap<DatabaseField, DatabaseField>(this.getTargetToSourceKeyFields().size());
        for (Map.Entry<DatabaseField, DatabaseField> entry : this.getSourceToTargetKeyFields().entrySet()) {
            DatabaseField databaseField = entry.getKey();
            databaseField = this.getDescriptor().buildField(databaseField, this.keyTableForMapKey);
            DatabaseField databaseField2 = entry.getValue();
            databaseField2 = this.getReferenceDescriptor().buildField(databaseField2, this.keyTableForMapKey);
            hashMap.put(databaseField, databaseField2);
            hashMap2.put(databaseField2, databaseField);
        }
        this.setSourceToTargetKeyFields(hashMap);
        this.setTargetToSourceKeyFields(hashMap2);
    }

    protected void initializeForeignKeysWithDefaults(AbstractSession abstractSession) {
        if (this.isForeignKeyRelationship()) {
            if (this.getSourceToTargetKeyFields().size() != 1) {
                throw DescriptorException.foreignKeysDefinedIncorrectly(this);
            }
            List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
            if (list.size() != 1) {
                throw DescriptorException.sizeMismatchOfForeignKeys(this);
            }
            DatabaseField databaseField = this.getSourceToTargetKeyFields().keySet().iterator().next();
            databaseField = this.getDescriptor().buildField(databaseField);
            this.getSourceToTargetKeyFields().clear();
            this.getTargetToSourceKeyFields().clear();
            this.getSourceToTargetKeyFields().put(databaseField, list.get(0));
            this.getTargetToSourceKeyFields().put(list.get(0), databaseField);
        } else {
            if (this.getTargetToSourceKeyFields().size() != 1) {
                throw DescriptorException.foreignKeysDefinedIncorrectly(this);
            }
            List<DatabaseField> list = this.getDescriptor().getPrimaryKeyFields();
            if (list.size() != 1) {
                throw DescriptorException.sizeMismatchOfForeignKeys(this);
            }
            DatabaseField databaseField = this.getTargetToSourceKeyFields().keySet().iterator().next();
            databaseField = this.getReferenceDescriptor().buildField(databaseField);
            this.getSourceToTargetKeyFields().clear();
            this.getTargetToSourceKeyFields().clear();
            this.getTargetToSourceKeyFields().put(databaseField, list.get(0));
            this.getSourceToTargetKeyFields().put(list.get(0), databaseField);
        }
    }

    protected void initializePrivateOwnedCriteria() {
        if (!this.isForeignKeyRelationship()) {
            this.setPrivateOwnedCriteria(this.getSelectionCriteria());
        } else {
            Expression expression = this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression();
            ExpressionBuilder expressionBuilder = new ExpressionBuilder();
            Expression expression2 = expressionBuilder.getManualQueryKey(this.getAttributeName() + "-back-ref", this.getDescriptor());
            Expression expression3 = expression.rebuildOn(expression2);
            Expression expression4 = expression2.twist(this.getSelectionCriteria(), expressionBuilder);
            if (this.getDescriptor().getQueryManager().getAdditionalJoinExpression() != null) {
                Expression expression5 = this.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(expression2);
                expression4 = expression4 == null ? expression5 : expression4.and(expression5);
            }
            this.setPrivateOwnedCriteria(expression3.and(expression4));
        }
    }

    @Override
    public void preinitializeMapKey(DatabaseTable databaseTable) throws DescriptorException {
        this.keyTableForMapKey = databaseTable;
    }

    public void postInitializeMapValueSelectionQuery(ReadQuery readQuery, AbstractSession abstractSession) {
    }

    @Override
    public void prepareCascadeLockingPolicy() {
        CascadeLockingPolicy cascadeLockingPolicy = new CascadeLockingPolicy(this.getDescriptor(), this.getReferenceDescriptor());
        cascadeLockingPolicy.setQueryKeyFields(this.getSourceToTargetKeyFields(), !this.isForeignKeyRelationship());
        this.getReferenceDescriptor().addCascadeLockingPolicy(cascadeLockingPolicy);
    }

    public Expression buildSelectionCriteria() {
        return this.buildSelectionCriteria(true, false);
    }

    public Expression buildSelectionCriteria(boolean bl, boolean bl2) {
        if (this.getSourceToTargetKeyFields().isEmpty()) {
            throw DescriptorException.noForeignKeysAreSpecified(this);
        }
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        for (DatabaseField databaseField : this.getSourceToTargetKeyFields().keySet()) {
            DatabaseField databaseField2 = this.getSourceToTargetKeyFields().get(databaseField);
            Expression expression2 = null;
            expression2 = bl ? ((Expression)expressionBuilder).getField(databaseField2).equal(expressionBuilder.getParameter(databaseField)) : ((Expression)expressionBuilder).getField(databaseField2).equal(((Expression)expressionBuilder).getField(databaseField));
            if (bl2) {
                this.setSelectionCriteria(expression2.and(this.getSelectionCriteria()));
                continue;
            }
            if (expression == null) {
                expression = expression2;
                continue;
            }
            expression = expression2.and(expression);
        }
        return expression;
    }

    @Override
    public void buildShallowOriginalFromRow(AbstractRecord abstractRecord, Object object, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        DatabaseRecord databaseRecord = new DatabaseRecord();
        for (DatabaseField databaseField : this.getSourceToTargetKeyFields().keySet()) {
            DatabaseField databaseField2 = this.getSourceToTargetKeyFields().get(databaseField);
            databaseRecord.put(databaseField2, abstractRecord.get(databaseField));
        }
        Object object2 = classDescriptor.getObjectBuilder().buildNewInstance();
        classDescriptor.getObjectBuilder().buildAttributesIntoShallowObject(object2, abstractRecord, objectBuildingQuery);
        object2 = this.getIndirectionPolicy().valueFromRow(object2);
        this.setAttributeValueInObject(object, object2);
    }

    @Override
    public boolean isOneToOneMapping() {
        return true;
    }

    @Override
    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery objectLevelModifyQuery) throws DatabaseException {
        if (objectLevelModifyQuery.getSession().isUnitOfWork()) {
            return super.readPrivateOwnedForObject(objectLevelModifyQuery);
        }
        if (!this.shouldVerifyDelete()) {
            return null;
        }
        ReadObjectQuery readObjectQuery = (ReadObjectQuery)this.getSelectionQuery().clone();
        readObjectQuery.setSelectionCriteria(this.getPrivateOwnedCriteria());
        return objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)readObjectQuery, objectLevelModifyQuery.getTranslationRow());
    }

    @Override
    public void rehashFieldDependancies(AbstractSession abstractSession) {
        this.setSourceToTargetKeyFields(Helper.rehashMap(this.getSourceToTargetKeyFields()));
    }

    public void setForeignKeyFieldName(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        this.setIsForeignKeyRelationship(true);
        this.getForeignKeyFields().addElement(databaseField);
        this.getSourceToTargetKeyFields().put(databaseField, new DatabaseField());
    }

    public void setForeignKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setForeignKeyFields(nonSynchronizedVector);
    }

    protected void setPrivateOwnedCriteria(Expression expression) {
        this.privateOwnedCriteria = expression;
    }

    public void setShouldVerifyDelete(boolean bl) {
        this.shouldVerifyDelete = bl;
    }

    public void setSourceToTargetKeyFieldAssociations(Vector vector) {
        this.setSourceToTargetKeyFields(new HashMap<DatabaseField, DatabaseField>(vector.size() + 1));
        this.setTargetToSourceKeyFields(new HashMap<DatabaseField, DatabaseField>(vector.size() + 1));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            DatabaseField databaseField = new DatabaseField((String)association.getKey());
            DatabaseField databaseField2 = new DatabaseField((String)association.getValue());
            this.getSourceToTargetKeyFields().put(databaseField, databaseField2);
            this.getTargetToSourceKeyFields().put(databaseField2, databaseField);
        }
    }

    public void setSourceToTargetKeyFields(Map<DatabaseField, DatabaseField> map) {
        this.sourceToTargetKeyFields = map;
    }

    public void setTargetForeignKeyFieldName(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        this.getTargetToSourceKeyFields().put(databaseField, new DatabaseField());
    }

    public void setTargetToSourceKeyFields(Map<DatabaseField, DatabaseField> map) {
        this.targetToSourceKeyFields = map;
    }

    public boolean shouldVerifyDelete() {
        return this.shouldVerifyDelete;
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    @Override
    public Object unwrapKey(Object object, AbstractSession abstractSession) {
        return this.getDescriptor().getObjectBuilder().unwrapObject(object, abstractSession);
    }

    @Override
    public Object wrapKey(Object object, AbstractSession abstractSession) {
        return this.getDescriptor().getObjectBuilder().wrapObject(object, abstractSession);
    }

    @Override
    public void writeFromAttributeIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Enumeration<DatabaseField> enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            DatabaseField databaseField2 = this.getSourceToTargetKeyFields().get(databaseField);
            Object object2 = null;
            if (object != null) {
                object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField2, abstractSession);
            }
            abstractRecord.add(databaseField, object2);
        }
    }

    @Override
    public Object valueFromObject(Object object, DatabaseField databaseField, AbstractSession abstractSession) {
        Object object2 = this.getAttributeValueFromObject(object);
        AbstractRecord abstractRecord = this.indirectionPolicy.extractReferenceRow(object2);
        if (abstractRecord != null) {
            Object object3 = abstractRecord.get(databaseField);
            Class clazz = this.getFieldClassification(databaseField);
            if (object3 == null || object3.getClass() != clazz) {
                try {
                    object3 = abstractSession.getDatasourcePlatform().convertObject(object3, clazz);
                }
                catch (ConversionException conversionException) {
                    throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
                }
            }
            return object3;
        }
        Object object4 = this.getRealAttributeValueFromAttribute(object2, object, abstractSession);
        if (object4 == null) {
            return null;
        }
        DatabaseField databaseField2 = this.sourceToTargetKeyFields.get(databaseField);
        return this.referenceDescriptor.getObjectBuilder().extractValueFromObjectForField(object4, databaseField2, abstractSession);
    }

    @Override
    protected Object valueFromRowInternalWithJoin(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        Cloneable cloneable;
        AbstractRecord abstractRecord2 = this.trimRowForJoin(abstractRecord, joinedAttributeManager, abstractSession);
        if (joinedAttributeManager != null && joinedAttributeManager.hasOuterJoinedAttributeQuery() && !objectBuildingQuery.hasPartialAttributeExpressions() && (cloneable = this.referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromRow(abstractRecord2, abstractSession)) == null) {
            return this.indirectionPolicy.nullValueFromRow();
        }
        cloneable = this.prepareNestedJoinQueryClone(abstractRecord, null, joinedAttributeManager, objectBuildingQuery, abstractSession);
        ((DatabaseQuery)cloneable).setTranslationRow(abstractRecord2);
        Object object = this.referenceDescriptor.getObjectBuilder().buildObject((ObjectLevelReadQuery)cloneable, abstractRecord2);
        if (((DatabaseQuery)cloneable).shouldUseWrapperPolicy() && abstractSession.isUnitOfWork()) {
            object = this.referenceDescriptor.getObjectBuilder().wrapObject(object, abstractSession);
        }
        return this.indirectionPolicy.valueFromRow(object);
    }

    @Override
    protected Object valueFromRowInternal(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        int n = this.fields.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)this.fields.get(i);
            if (abstractRecord.get(databaseField) != null) continue;
            return this.indirectionPolicy.nullValueFromRow();
        }
        return super.valueFromRowInternal(abstractRecord, joinedAttributeManager, objectBuildingQuery, abstractSession);
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly || !this.isForeignKeyRelationship) {
            return;
        }
        Object object2 = this.getAttributeValueFromObject(object);
        AbstractRecord abstractRecord2 = this.indirectionPolicy.extractReferenceRow(object2);
        if (abstractRecord2 == null) {
            Object object3 = this.getRealAttributeValueFromAttribute(object2, object, abstractSession);
            Vector<DatabaseField> vector = this.getForeignKeyFields();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                DatabaseField databaseField = (DatabaseField)vector.get(i);
                Object object4 = null;
                if (object3 != null) {
                    DatabaseField databaseField2 = this.sourceToTargetKeyFields.get(databaseField);
                    object4 = this.referenceDescriptor.getObjectBuilder().extractValueFromObjectForField(object3, databaseField2, abstractSession);
                }
                abstractRecord.add(databaseField, object4);
            }
        } else {
            Vector<DatabaseField> vector = this.getForeignKeyFields();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                DatabaseField databaseField = (DatabaseField)vector.get(i);
                abstractRecord.add(databaseField, abstractRecord2.get(databaseField));
            }
        }
    }

    @Override
    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        Enumeration<DatabaseField> enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            abstractRecord.add(databaseField, null);
        }
    }

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (!this.isReadOnly && this.isPrimaryKeyMapping && !changeRecord.getOwner().isNew()) {
            throw ValidationException.primaryKeyUpdateDisallowed(changeRecord.getOwner().getClassName(), changeRecord.getAttribute());
        }
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        this.writeFromObjectIntoRow(object, abstractRecord, abstractSession);
    }

    @Override
    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        Enumeration<DatabaseField> enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            abstractRecord.add(databaseField, null);
        }
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        Enumeration<DatabaseField> enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            abstractRecord.add(databaseField, null);
        }
    }
}

