/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.structures;

import java.io.Serializable;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class NestedTableMapping
extends CollectionMapping {
    protected DatabaseMapping nestedMapping;
    protected DatabaseField field;
    protected String structureName;

    public Object clone() {
        NestedTableMapping nestedTableMapping = (NestedTableMapping)super.clone();
        return nestedTableMapping;
    }

    protected Vector collectFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        vector.addElement(this.getField());
        return vector;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    public Expression getJoinCriteria(QueryKeyExpression queryKeyExpression) {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression = expressionBuilder.ref().equal(expressionBuilder.value());
        return queryKeyExpression.getBaseExpression().twist(expression, queryKeyExpression);
    }

    public String getStructureName() {
        return this.structureName;
    }

    public boolean hasConstraintDependency() {
        return true;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        if (this.getField() == null) {
            throw DescriptorException.fieldNameNotSetInMapping(this);
        }
        ObjectRelationalDatabaseField objectRelationalDatabaseField = (ObjectRelationalDatabaseField)this.getField();
        objectRelationalDatabaseField.setSqlType(2003);
        objectRelationalDatabaseField.setSqlTypeName(this.getStructureName());
        this.setField(this.getDescriptor().buildField(this.getField()));
    }

    protected void initializeSelectionCriteria(AbstractSession abstractSession) {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression = expressionBuilder.getManualQueryKey(this.getAttributeName(), this.getDescriptor());
        Expression expression2 = expressionBuilder.ref().equal(expression.get(this.getAttributeName()).value());
        Expression expression3 = this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression().rebuildOn(expression);
        this.setSelectionCriteria(expression2.and(expression3));
    }

    public boolean isNestedTableMapping() {
        return true;
    }

    public void postInitialize(AbstractSession abstractSession) throws DescriptorException {
        this.initializeSelectionCriteria(abstractSession);
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
            deleteObjectQuery2.setIsExecutionClone(true);
            deleteObjectQuery2.setObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
            deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
            deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
        }
        if (!deleteObjectQuery.getSession().isUnitOfWork()) {
            this.verifyDeleteForUpdate(deleteObjectQuery);
        }
    }

    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            Serializable serializable;
            Object object3 = containerPolicy.next(object2, writeObjectQuery.getSession());
            if (this.isPrivateOwned()) {
                serializable = new InsertObjectQuery();
                serializable.setIsExecutionClone(true);
                serializable.setObject(object3);
                serializable.setCascadePolicy(writeObjectQuery.getCascadePolicy());
                writeObjectQuery.getSession().executeQuery((DatabaseQuery)serializable);
                continue;
            }
            if (writeObjectQuery.getSession().getCommitManager().isCommitInPreModify(object3)) continue;
            serializable = null;
            UnitOfWorkChangeSet unitOfWorkChangeSet = null;
            if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWorkImpl)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
                unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
                serializable = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object3);
            }
            WriteObjectQuery writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            writeObjectQuery2.setObject(object3);
            writeObjectQuery2.setObjectChangeSet((ObjectChangeSet)serializable);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    public void preUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        if (object2 == null) {
            object2 = this.getContainerPolicy().containerInstance(1);
        }
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    protected void setField(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public void setFieldName(String string) {
        this.setField(new ObjectRelationalDatabaseField(string));
    }

    public void setStructureName(String string) {
        this.structureName = string;
    }

    protected void verifyDeleteForUpdate(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object = this.readPrivateOwnedForObject(deleteObjectQuery);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            deleteObjectQuery.getSession().deleteObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
        }
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Array array;
        Object object2;
        if (this.isReadOnly()) {
            return;
        }
        Object object3 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object[] objectArray = new Object[containerPolicy.sizeFor(object3)];
        Object object4 = containerPolicy.iteratorFor(object3);
        for (int i = 0; i < containerPolicy.sizeFor(object3); ++i) {
            object2 = containerPolicy.next(object4, abstractSession);
            objectArray[i] = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).getRef(object2, abstractSession);
        }
        try {
            try {
                ((DatabaseAccessor)abstractSession.getAccessor()).incrementCallCount(abstractSession);
                object2 = ((DatabaseAccessor)abstractSession.getAccessor()).getConnection();
                array = abstractSession.getPlatform().createArray(this.getStructureName(), objectArray, abstractSession, (Connection)object2);
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException(sQLException, abstractSession.getAccessor(), abstractSession, false);
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            ((DatabaseAccessor)abstractSession.getAccessor()).decrementCallCount();
            throw throwable;
        }
        ((DatabaseAccessor)abstractSession.getAccessor()).decrementCallCount();
        abstractRecord.put(this.getField(), (Object)array);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Array array;
        Object object;
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        Object object3 = this.getRealAttributeValueFromObject(object2, abstractSession);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (object3 == null) {
            object3 = containerPolicy.containerInstance(1);
        }
        Object[] objectArray = new Object[containerPolicy.sizeFor(object3)];
        Object object4 = containerPolicy.iteratorFor(object3);
        for (int i = 0; i < containerPolicy.sizeFor(object3); ++i) {
            object = containerPolicy.next(object4, abstractSession);
            objectArray[i] = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).getRef(object, abstractSession);
        }
        try {
            try {
                ((DatabaseAccessor)abstractSession.getAccessor()).incrementCallCount(abstractSession);
                object = ((DatabaseAccessor)abstractSession.getAccessor()).getConnection();
                array = abstractSession.getPlatform().createArray(this.getStructureName(), objectArray, abstractSession, (Connection)object);
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException(sQLException, abstractSession.getAccessor(), abstractSession, false);
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            ((DatabaseAccessor)abstractSession.getAccessor()).decrementCallCount();
            throw throwable;
        }
        ((DatabaseAccessor)abstractSession.getAccessor()).decrementCallCount();
        abstractRecord.put(this.getField(), (Object)array);
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        abstractRecord.put(this.getField(), (Object)null);
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        abstractRecord.put(this.getField(), (Object)null);
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, AbstractRecord abstractRecord) throws DescriptorException {
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        if (writeObjectQuery.getSession().isUnitOfWork() && this.compareObjects(writeObjectQuery.getObject(), writeObjectQuery.getBackupClone(), writeObjectQuery.getSession())) {
            return;
        }
        this.writeFromObjectIntoRow(writeObjectQuery.getObject(), abstractRecord, writeObjectQuery.getSession());
    }

    public void writeInsertFieldsIntoRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        abstractRecord.put(this.getField(), (Object)null);
    }
}

