/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.transformers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethodParameterTypes;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class MethodBasedAttributeTransformer
implements AttributeTransformer {
    protected transient Method attributeTransformationMethod;
    protected AbstractTransformationMapping mapping;
    protected String methodName;

    public MethodBasedAttributeTransformer() {
    }

    public MethodBasedAttributeTransformer(String string) {
        this.methodName = string;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public Method getAttributeTransformationMethod() {
        return this.attributeTransformationMethod;
    }

    public void setAttributeTransformationMethod(Method method) {
        this.attributeTransformationMethod = method;
    }

    public void initialize(AbstractTransformationMapping abstractTransformationMapping) {
        this.mapping = abstractTransformationMapping;
        try {
            Class[] classArray = new Class[]{ClassConstants.Record_Class};
            this.attributeTransformationMethod = Helper.getDeclaredMethod(abstractTransformationMapping.getDescriptor().getJavaClass(), this.methodName, classArray);
        }
        catch (Exception exception) {
            try {
                Class[] classArray = new Class[]{ClassConstants.Record_Class};
                this.attributeTransformationMethod = Helper.getDeclaredMethod(abstractTransformationMapping.getDescriptor().getJavaClass(), this.methodName, classArray);
            }
            catch (Exception exception2) {
                try {
                    Class[] classArray = new Class[]{ClassConstants.Record_Class, ClassConstants.PublicInterfaceSession_Class};
                    this.attributeTransformationMethod = Helper.getDeclaredMethod(abstractTransformationMapping.getDescriptor().getJavaClass(), this.methodName, classArray);
                }
                catch (Exception exception3) {
                    try {
                        Class[] classArray = new Class[]{ClassConstants.Record_Class, ClassConstants.SessionsSession_Class};
                        this.attributeTransformationMethod = Helper.getDeclaredMethod(abstractTransformationMapping.getDescriptor().getJavaClass(), this.methodName, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw DescriptorException.noSuchMethodOnInitializingAttributeMethod(abstractTransformationMapping.getAttributeMethodName(), abstractTransformationMapping, noSuchMethodException);
                    }
                    catch (SecurityException securityException) {
                        throw DescriptorException.securityOnInitializingAttributeMethod(abstractTransformationMapping.getAttributeMethodName(), abstractTransformationMapping, securityException);
                    }
                }
            }
        }
        if (this.attributeTransformationMethod.getReturnType() == ClassConstants.Void_Class) {
            throw DescriptorException.returnTypeInGetAttributeAccessor(this.methodName, abstractTransformationMapping);
        }
    }

    public Object buildAttributeValue(Record record, Object object, Session session) {
        Class[] classArray = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                classArray = (Class[])AccessController.doPrivileged(new PrivilegedGetMethodParameterTypes(this.attributeTransformationMethod));
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getCause();
            }
        } else {
            classArray = PrivilegedAccessHelper.getMethodParameterTypes(this.attributeTransformationMethod);
        }
        Object[] objectArray = new Object[classArray.length];
        objectArray[0] = record;
        if (objectArray.length == 2) {
            objectArray[1] = session;
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.attributeTransformationMethod, object, objectArray));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getCause() instanceof IllegalArgumentException) {
                        throw (IllegalArgumentException)privilegedActionException.getCause();
                    }
                    if (privilegedActionException.getCause() instanceof InvocationTargetException) {
                        throw (InvocationTargetException)privilegedActionException.getCause();
                    }
                    throw (RuntimeException)privilegedActionException.getCause();
                }
            }
            return PrivilegedAccessHelper.invokeMethod(this.attributeTransformationMethod, object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileInvokingAttributeMethod(this.mapping, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DescriptorException.illegalArgumentWhileInvokingAttributeMethod(this.mapping, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileInvokingAttributeMethod(this.mapping, invocationTargetException);
        }
    }
}

